/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.setting.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.base.util.SealEncrypt;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.stamp.EnableCAEnum;
import com.kingdee.eas.cp.stamp.IPersonalSeal;
import com.kingdee.eas.cp.stamp.IPersonalSealPermission;
import com.kingdee.eas.cp.stamp.IStampLog;
import com.kingdee.eas.cp.stamp.ManageLogUtil;
import com.kingdee.eas.cp.stamp.PersonalSealCollection;
import com.kingdee.eas.cp.stamp.PersonalSealFactory;
import com.kingdee.eas.cp.stamp.PersonalSealInfo;
import com.kingdee.eas.cp.stamp.PersonalSealPermissionCollection;
import com.kingdee.eas.cp.stamp.PersonalSealPermissionFactory;
import com.kingdee.eas.cp.stamp.PersonalSealPermissionInfo;
import com.kingdee.eas.cp.stamp.SealStatus;
import com.kingdee.eas.cp.stamp.StampLogCollection;
import com.kingdee.eas.cp.stamp.StampLogFactory;
import com.kingdee.eas.cp.stamp.StoreType;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.portal.biz.common.action.BaseFileUploadAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.enums.ResponseContentTypeEnum;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.portal.plt.cp.common.util.CpServiceLocator;
import com.kingdee.portal.plt.cp.module.setting.dto.SealDTO;
import com.kingdee.portal.plt.cp.module.setting.service.PersonalSealService;
import com.kingdee.util.UuidException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;

public class PersonalSealAction
extends BaseFileUploadAction {
    private PersonalSealService personalSealService = (PersonalSealService)CpServiceLocator.getBean("personalSealService");

    public void loadPersonalSealPageList() {
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            Map<String, String> paramMap = this.buildParam();
            PagingResult<SealDTO> pagingResult = this.personalSealService.getPersonalSealPageList(ctx, paramMap, this.pagingParam);
            this.writePagingResult(pagingResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map<String, String> buildParam() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("presonalSealName", this.getRequest().getParameter("presonalSealName"));
        param.put("ownerId", this.getRequest().getParameter("ownerId"));
        return param;
    }

    public void getPersonalSealDetailById() {
        String sealId = this.getRequest().getParameter("sealId");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            IPersonalSeal iPersonalSeal = PersonalSealFactory.getLocalInstance((Context)ctx);
            PersonalSealInfo currentModel = (PersonalSealInfo)iPersonalSeal.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)sealId)));
            SealDTO sealDto = new SealDTO();
            sealDto.setId(sealId);
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            PersonInfo ownerInfo = (PersonInfo)iPerson.getValue((IObjectPK)new ObjectUuidPK(currentModel.getOwner().getId()));
            sealDto.setOwnerName(ownerInfo.getName());
            sealDto.setFileName(currentModel.getFileName());
            sealDto.setName(currentModel.getName());
            sealDto.setIsEnableCA(String.valueOf(currentModel.getIsEnableCA().getValue()));
            sealDto.setStoreType(String.valueOf(currentModel.getStoreType().getValue()));
            sealDto.setStatus(String.valueOf(currentModel.getStatus().getValue()));
            sealDto.seteKeyIndex(currentModel.getEKeySealIndex());
            sealDto.seteKeySN(currentModel.getEKeySN());
            byte[] bytesPassword = new SealEncrypt().stringToBytes(currentModel.getPassword());
            String password = new String(SealEncrypt.decode((byte[])bytesPassword));
            sealDto.setNumber(password);
            this.writeAjaxData(true, null, sealDto);
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (UuidException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
    }

    public void changePersonalSealPw() {
        String sealId = this.getRequest().getParameter("sealId");
        String newPw = this.getRequest().getParameter("newPw");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            IPersonalSeal iPersonalSeal = PersonalSealFactory.getLocalInstance((Context)ctx);
            PersonalSealInfo currentModel = (PersonalSealInfo)iPersonalSeal.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)sealId)));
            if (!this.hasPersonalSealManagePre(currentModel)) {
                this.writeAjaxData(false, null, "-1");
                return;
            }
            byte[] passwordByte = SealEncrypt.encode((byte[])newPw.getBytes());
            String Storepw = new SealEncrypt().bytesToString(passwordByte);
            currentModel.setPassword(Storepw);
            iPersonalSeal.save((CoreBaseInfo)currentModel);
            ManageLogUtil.beginLog((Context)ctx, (int)3, (CoreBaseInfo)currentModel);
            this.writeAjaxData(true, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void changePersonalSealCA() {
        String status = this.getRequest().getParameter("status");
        String ids = this.getRequest().getParameter("ids");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String[] selectId = ids.split(",");
        try {
            IPersonalSeal iPersonalSeal = PersonalSealFactory.getLocalInstance((Context)ctx);
            if (selectId.length < 0) {
                this.writeAjaxData(false, null, "0");
            } else if (selectId.length == 1) {
                String id = selectId[0];
                PersonalSealInfo currentModel = (PersonalSealInfo)iPersonalSeal.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                if (!this.hasPersonalSealManagePre(currentModel)) {
                    this.writeAjaxData(false, null, "-1");
                    return;
                }
                int operationType = 7;
                if (status.equals("enable")) {
                    if (currentModel.getIsEnableCA().equals((Object)EnableCAEnum.enableCA)) {
                        this.writeAjaxData(false, null, "1");
                        return;
                    }
                    operationType = 7;
                    currentModel.setIsEnableCA(EnableCAEnum.enableCA);
                }
                if (status.equals("disable")) {
                    if (currentModel.getIsEnableCA().equals((Object)EnableCAEnum.disableCA)) {
                        this.writeAjaxData(false, null, "2");
                        return;
                    }
                    operationType = 8;
                    currentModel.setIsEnableCA(EnableCAEnum.disableCA);
                }
                iPersonalSeal.update((IObjectPK)new ObjectUuidPK(currentModel.getId()), (CoreBaseInfo)currentModel);
                PersonalSealInfo personalSealInfo = iPersonalSeal.getPersonalSealInfo((IObjectPK)new ObjectUuidPK(id));
                ManageLogUtil.beginLog((Context)ctx, (int)operationType, (CoreBaseInfo)personalSealInfo);
                this.writeAjaxData(true, null, null);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (UuidException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deletePersonalSeal() {
        String ids = this.getRequest().getParameter("ids");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String[] selectId = ids.split(",");
        Statement ps = null;
        try {
            IPersonalSeal iPersonalSeal = PersonalSealFactory.getLocalInstance((Context)ctx);
            Connection conn = EJBFactory.getConnection((Context)ctx);
            if (selectId.length < 1) {
                this.writeAjaxData(false, null, "\u5220\u9664\u5931\u8d25\uff0c\u6240\u9009\u7684\u6570\u636eID\u4e3a\u7a7a");
                return;
            }
            if (selectId.length != 1) return;
            String id = selectId[0];
            PersonalSealInfo currentModel = (PersonalSealInfo)iPersonalSeal.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            if (!this.hasPersonalSealManagePre(currentModel)) {
                this.writeAjaxData(false, null, "\u5220\u9664\u5931\u8d25\uff0c\u6240\u9009\u7684\u79c1\u7ae0\u6ca1\u6709\u5220\u9664\u6743\u9650");
                return;
            }
            if (this.isStampUsed(id)) {
                this.writeAjaxData(false, null, "\u6539\u516c\u7ae0\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u5220\u9664");
                return;
            }
            if (currentModel.getStoreType().equals((Object)StoreType.server)) {
                String fileNameID = currentModel.getFileName();
                String sealSqlstr = "delete T_STA_SealFile where fid ='" + fileNameID + "' ";
                this.doLogForDeleteSeal(ctx, id, 2);
                conn.setAutoCommit(false);
                ps = conn.prepareStatement(sealSqlstr);
                ps.execute();
                iPersonalSeal.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                conn.commit();
            }
            this.writeAjaxData(true, null, null);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), "-1");
            return;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyPersonalSeal() {
        block20: {
            String ids = this.getRequest().getParameter("ids");
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            String[] selectId = ids.split(",");
            Statement ps = null;
            try {
                IPersonalSeal iPersonalSeal = PersonalSealFactory.getLocalInstance((Context)ctx);
                Connection conn = EJBFactory.getConnection((Context)ctx);
                if (selectId.length < 1) {
                    this.writeAjaxData(false, null, "\u9500\u6bc1\u5931\u8d25\uff0c\u6240\u9009\u7684\u6570\u636eID\u4e3a\u7a7a");
                    break block20;
                }
                int i = 0;
                while (true) {
                    if (i < selectId.length) {
                        String id = selectId[0];
                        PersonalSealInfo currentModel = (PersonalSealInfo)iPersonalSeal.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                        if (!this.hasPersonalSealManagePre(currentModel)) {
                            this.writeAjaxData(false, null, "\u9500\u6bc1\u5931\u8d25\uff0c\u6240\u9009\u7684\u79c1\u7ae0\u6ca1\u6709\u9500\u6bc1\u6743\u9650");
                            return;
                        }
                        String fileNameID = currentModel.getFileName();
                        if (currentModel.getStoreType().equals((Object)StoreType.server)) {
                            String sealSqlstr = "delete T_STA_SealFile where fid ='" + fileNameID + "' ";
                            ps = conn.prepareStatement(sealSqlstr);
                            ps.execute();
                            currentModel.setStatus(SealStatus.destroy);
                            currentModel.setFileName(null);
                            iPersonalSeal.save((CoreBaseInfo)currentModel);
                            ManageLogUtil.beginLog((Context)ctx, (int)5, (CoreBaseInfo)currentModel);
                            this.writeAjaxData(true, null, null);
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.writeAjaxData(false, this.handleErr(e), "-1");
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    public void checkPersonalSealOldPw() {
        String id = this.getRequest().getParameter("sealId");
        String oldPw = this.getRequest().getParameter("oldPw");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            IPersonalSeal iPersonalSeal = PersonalSealFactory.getLocalInstance((Context)ctx);
            PersonalSealInfo currentModel = (PersonalSealInfo)iPersonalSeal.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            String pw = currentModel.getPassword();
            byte[] bytesPassword = new SealEncrypt().stringToBytes(pw);
            String password = new String(SealEncrypt.decode((byte[])bytesPassword));
            if (password.equals(oldPw)) {
                this.writeObjectData(true, ResponseContentTypeEnum.HTML);
            } else {
                this.writeObjectData(false, ResponseContentTypeEnum.HTML);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeObjectData(false, ResponseContentTypeEnum.HTML);
        }
    }

    public void isPersonalAdmin() {
        String sealId = this.getRequest().getParameter("sealId");
        if (StringUtil.isEmpty((String)sealId)) {
            this.writeAjaxData(false, null, "0");
            return;
        }
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            IPersonalSeal iPersonalSeal = PersonalSealFactory.getLocalInstance((Context)ctx);
            PersonalSealInfo currentModel = (PersonalSealInfo)iPersonalSeal.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)sealId)));
            if (this.hasPersonalSealManagePre(currentModel)) {
                this.writeAjaxData(true, null, null);
            } else {
                this.writeAjaxData(false, null, null);
            }
        }
        catch (BOSException e) {
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
            e.printStackTrace();
        }
        catch (EASBizException e) {
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
            e.printStackTrace();
        }
        catch (UuidException e) {
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
            e.printStackTrace();
        }
    }

    private boolean hasPersonalSealManagePre(PersonalSealInfo currentModel) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String creatorID = currentModel.getCreator().getId().toString();
        String ownerID = currentModel.getOwner().getId().toString();
        return this.personalSealService.isCurrPersonSealAdmin(ctx) || this.personalSealService.isPersonalSealCreator(ctx, creatorID) || this.personalSealService.isPersonalSealOwner(ctx, ownerID);
    }

    public void getCurrentOwner() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        JSONObject obj = new JSONObject();
        obj.put((Object)"ownerId", (Object)person.getId().toString());
        obj.put((Object)"ownerName", (Object)person.getName());
        this.writeAjaxData(true, null, obj);
    }

    public void isExistPersonalSealName() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            IPersonalSeal iPersonalSeal = PersonalSealFactory.getLocalInstance((Context)ctx);
            String comSealName = this.getRequest().getParameter("comSealName");
            String sql = "select id where name = '" + comSealName + "' and status != '" + SealStatus.destroy.getValue() + "'";
            PersonalSealCollection csc = iPersonalSeal.getPersonalSealCollection(sql);
            if (csc.size() > 0) {
                this.writeAjaxData(true, null, null);
            } else {
                this.writeAjaxData(false, null, null);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(true, this.handleErr((Exception)((Object)e)), null);
        }
    }

    public void savePersonalSeal() {
        String fileNameId = this.getRequest().getParameter("fileNameId");
        String sealName = this.getRequest().getParameter("sealName");
        String ownerId = this.getRequest().getParameter("ownerId");
        String storeType = this.getRequest().getParameter("storeType");
        String isEnableCA = this.getRequest().getParameter("isEnableCA");
        String comsealPw = this.getRequest().getParameter("comsealPw");
        String ekeySN = this.getRequest().getParameter("ekeySN");
        String ekeyIndex = this.getRequest().getParameter("ekeyIndex");
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            IPersonalSeal iPersonalSeal = PersonalSealFactory.getLocalInstance((Context)ctx);
            IPerson iperson = PersonFactory.getLocalInstance((Context)ctx);
            File file = this.getUpload();
            if (file != null) {
                this.saveSealPic(storeType, fileNameId, file);
                boolean isadmin = this.personalSealService.isCurrPersonSealAdmin(ctx);
                PersonInfo person = null;
                person = !isadmin ? ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() : iperson.getPersonInfo((IObjectPK)new ObjectUuidPK(ownerId));
                PersonalSealInfo sealInfo = new PersonalSealInfo();
                sealInfo.setName(sealName);
                sealInfo.setFileName(fileNameId);
                sealInfo.setOwner(person);
                sealInfo.setStatus(SealStatus.normal);
                byte[] passwordByte = SealEncrypt.encode((byte[])comsealPw.getBytes());
                String Storepd = new SealEncrypt().bytesToString(passwordByte);
                sealInfo.setPassword(Storepd);
                if (isEnableCA.equals("1")) {
                    sealInfo.setIsEnableCA(EnableCAEnum.enableCA);
                } else {
                    sealInfo.setIsEnableCA(EnableCAEnum.disableCA);
                }
                if (storeType.equals("1")) {
                    sealInfo.setStoreType(StoreType.server);
                } else {
                    sealInfo.setStoreType(StoreType.USBKey);
                    sealInfo.setEKeySealIndex(ekeyIndex);
                    sealInfo.setEKeySN(ekeySN);
                }
                iPersonalSeal.save((CoreBaseInfo)sealInfo);
                ManageLogUtil.beginLog((Context)ctx, (int)1, (CoreBaseInfo)sealInfo);
                this.writeAjaxTextData(true, "");
            } else {
                this.deleteSealFile(fileNameId);
                this.writeAjaxTextData(false, "img file is null");
            }
        }
        catch (Exception e) {
            this.deleteSealFile(fileNameId);
            e.printStackTrace();
            this.writeAjaxTextData(false, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSealPic(String storeType, String fileName, File file) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String sql = null;
        if ("1".equals(storeType)) {
            sql = "update T_STA_SealFile set FSealPicture = ? where fid = ? ";
        } else if ("2".equals(storeType)) {
            sql = "Insert into T_STA_SealFile(FSealPicture,FID) values(?,?)";
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            PreparedStatement ps = EJBFactory.getConnection((Context)ctx).prepareStatement(sql);
            ps.setBinaryStream(1, (InputStream)is, ((InputStream)is).available());
            ps.setString(2, fileName);
            ps.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSealFile(String FID) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String sealSqlstr = "delete T_STA_SealFile where fid = ? ";
        PreparedStatement ps = null;
        try {
            ps = EJBFactory.getConnection((Context)ctx).prepareStatement(sealSqlstr);
            ps.setString(1, FID);
            ps.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private boolean isStampUsed(String id) {
        boolean flag = true;
        StampLogCollection stampLogCol = null;
        IStampLog iStampLog = null;
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            iStampLog = StampLogFactory.getLocalInstance((Context)ctx);
            stampLogCol = iStampLog.getStampLogCollection("select id where sealID='" + id + "'");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        flag = stampLogCol != null && stampLogCol.size() != 0;
        return flag;
    }

    private void doLogForDeleteSeal(Context ctx, String sealID, int sealType) {
        try {
            if (sealType == 1) {
                IPersonalSeal service = PersonalSealFactory.getLocalInstance((Context)ctx);
                PersonalSealInfo info = service.getPersonalSealInfo((IObjectPK)new ObjectUuidPK(sealID));
                IObjectPK logPK = ManageLogUtil.beginLog((Context)ctx, (int)6, (CoreBaseInfo)info);
                IPersonalSealPermission sealPermission = PersonalSealPermissionFactory.getLocalInstance((Context)ctx);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("sealName.id", (Object)sealID));
                view.setFilter(filterInfo);
                PersonalSealPermissionCollection permissionColl = sealPermission.getPersonalSealPermissionCollection(view);
                if (permissionColl != null && permissionColl.size() > 0) {
                    int j = permissionColl.size();
                    for (int i = 0; i < j; ++i) {
                        PersonalSealPermissionInfo permissionInfo = permissionColl.get(i);
                        ManageLogUtil.beginLog((Context)ctx, (int)6, (CoreBaseInfo)permissionInfo);
                    }
                }
            } else {
                IPersonalSeal service = PersonalSealFactory.getLocalInstance((Context)ctx);
                PersonalSealInfo info = service.getPersonalSealInfo((IObjectPK)new ObjectUuidPK(sealID));
                IObjectPK logPK = ManageLogUtil.beginLog((Context)ctx, (int)6, (CoreBaseInfo)info);
                IPersonalSealPermission sealPermission = PersonalSealPermissionFactory.getLocalInstance((Context)ctx);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("personalSealName.id", (Object)sealID));
                view.setFilter(filterInfo);
                PersonalSealPermissionCollection permissionColl = sealPermission.getPersonalSealPermissionCollection(view);
                if (permissionColl != null && permissionColl.size() > 0) {
                    int j = permissionColl.size();
                    for (int i = 0; i < j; ++i) {
                        PersonalSealPermissionInfo permissionInfo = permissionColl.get(i);
                        ManageLogUtil.beginLog((Context)ctx, (int)6, (CoreBaseInfo)permissionInfo);
                    }
                }
            }
        }
        catch (BOSException e) {
            this.logger.error("LogService Err:" + e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            this.logger.error("LogService Err:" + e.getMessage(), (Throwable)e);
        }
    }

    private void writeAjaxTextData(boolean success, Object result) {
        Object tempResult = result == null ? "" : result;
        HashMap<String, Object> ajaxData = new HashMap<String, Object>();
        ajaxData.put("success", success);
        ajaxData.put("result", tempResult);
        this.writeObjectData(JSONObject.fromObject(ajaxData).toString(), ResponseContentTypeEnum.HTML);
    }
}

