/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.setting.util;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExportUtil {
    public static HSSFCellStyle createCommonTitleStyle(HSSFWorkbook wb) {
        HSSFFont boldFont = wb.createFont();
        boldFont.setFontHeight((short)260);
        boldFont.setBold(true);
        HSSFCellStyle style = wb.createCellStyle();
        style.setFont(boldFont);
        return style;
    }

    public static HSSFCellStyle createCenterTitleStyle(HSSFWorkbook wb) {
        HSSFFont boldFont = wb.createFont();
        boldFont.setFontHeight((short)260);
        boldFont.setBold(true);
        HSSFCellStyle style = wb.createCellStyle();
        style.setFont(boldFont);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setAlignment(HorizontalAlignment.CENTER);
        return style;
    }

    public static HSSFCellStyle createTextStyle(HSSFWorkbook wb) {
        HSSFFont boldFont = wb.createFont();
        boldFont.setFontHeight((short)200);
        HSSFCellStyle style = wb.createCellStyle();
        style.setFont(boldFont);
        return style;
    }

    public static HSSFCellStyle createNumericStyle(HSSFWorkbook wb) {
        HSSFFont boldFont = wb.createFont();
        boldFont.setFontHeight((short)200);
        HSSFCellStyle style = wb.createCellStyle();
        HSSFDataFormat format = wb.createDataFormat();
        style.setDataFormat(format.getFormat("0.00"));
        style.setFont(boldFont);
        return style;
    }

    public static HSSFCellStyle createIntStyle(HSSFWorkbook wb) {
        HSSFFont boldFont = wb.createFont();
        boldFont.setFontHeight((short)200);
        HSSFCellStyle style = wb.createCellStyle();
        HSSFDataFormat format = wb.createDataFormat();
        style.setDataFormat(format.getFormat("0"));
        style.setFont(boldFont);
        return style;
    }

    public static void createCell(HSSFRow row, int column, HSSFCellStyle style, CellType cellType, Object value) {
        HSSFCell cell = row.createCell((int)((short)column));
        if (style != null) {
            cell.setCellStyle(style);
        }
        switch (cellType) {
            case BLANK: {
                break;
            }
            case STRING: {
                if (value != null) {
                    cell.setCellValue((RichTextString)new HSSFRichTextString(value.toString()));
                    break;
                }
                cell.setCellValue((RichTextString)new HSSFRichTextString(""));
                break;
            }
            case NUMERIC: {
                cell.setCellType(CellType.NUMERIC);
                if (value != null) {
                    try {
                        cell.setCellValue(Double.parseDouble(value.toString()));
                    }
                    catch (Exception e) {
                        cell.setCellValue((RichTextString)new HSSFRichTextString(""));
                    }
                    break;
                }
                cell.setCellValue((RichTextString)new HSSFRichTextString(""));
                break;
            }
        }
    }

    public static void createHeadCell(HSSFSheet sheet, HSSFRow row, HSSFCellStyle style, Object value) {
        HSSFCell cell = row.createCell(1);
        cell.setCellValue((RichTextString)new HSSFRichTextString(value.toString()));
        cell.setCellStyle(style);
        CellRangeAddress region = new CellRangeAddress(0, 1, 0, 4);
        sheet.addMergedRegion(region);
    }
}

