/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.wfpc.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.ext.ConfigLoader;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class IntegrationUtil {
    private static final Logger logger = Logger.getLogger(IntegrationUtil.class);
    private static String IERPHOST = ConfigLoader.getConfig4Server().getValue("ierp.host");
    private static String APPID = ConfigLoader.getConfig4Server().getValue("ierp.appId");
    private static String APPSECURET = ConfigLoader.getConfig4Server().getValue("ierp.appSecuret");
    private static String TENANTID = ConfigLoader.getConfig4Server().getValue("ierp.tenantid");
    private static String ACCOUNTID = ConfigLoader.getConfig4Server().getValue("ierp.accountId");
    private static String LANGUAGE = ConfigLoader.getConfig4Server().getValue("ierp.language");
    private static int DEFAULT_TIME_OUT = 10000;

    public static String getIErpTaskCenterURL(Context ctx) {
        Map<String, String> map = IntegrationUtil.getAccessToken(ctx);
        if (map.get("access_token") != null) {
            String accessToken = map.get("access_token");
            String rediretUrl = IERPHOST + "/#/dform?formId=wf_taskcenterhome&openType=hideNavigation&openPage=";
            ArrayList<String> result = new ArrayList<String>();
            result.add(IntegrationUtil.buildUrl(accessToken, rediretUrl + "toHandle"));
            result.add(IntegrationUtil.buildUrl(accessToken, rediretUrl + "handled"));
            result.add(IntegrationUtil.buildUrl(accessToken, rediretUrl + "applyed"));
            result.add(IntegrationUtil.buildUrl(accessToken, rediretUrl + "toApply"));
            return JSON.toJSONString(result);
        }
        return JSON.toJSONString(map);
    }

    private static String buildUrl(String accessToken, String rediretUrl) {
        StringBuilder url = new StringBuilder();
        url.append(IERPHOST).append("/accessTokenLogin.do?");
        url.append("access_token=").append(accessToken).append("&encode=true&redirect=");
        String encodeRediret = URLEncoder.encode(rediretUrl);
        url.append(encodeRediret);
        return url.toString();
    }

    public static List<Map<String, String>> getIErpToHandleTasks(Context ctx, String pageSize) {
        Map<String, String> temp = IntegrationUtil.getAccessToken(ctx);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        if (temp.get("access_token") != null) {
            try {
                int size = 5;
                try {
                    size = Integer.parseInt(pageSize);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String accessToken = temp.get("access_token");
                String param = "body=" + URLEncoder.encode("{\"start\":0,\"limit\":" + size + "}", "utf-8") + "&access_token=" + accessToken;
                JSONObject json = IntegrationUtil.doGet(IERPHOST + "/kapi/app/wf/getToHandleTasksByUserId?" + param);
                if (json != null) {
                    boolean success = json.getBoolean("success");
                    if (success) {
                        JSONArray data = json.getJSONArray("data");
                        for (JSONObject next : data) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("id", next.getString("ID"));
                            map.put("title", next.getString("SUBJECT"));
                            map.put("sender", next.getString("SENDERNAME"));
                            String createdTime = next.getString("CREATEDATE");
                            if (createdTime != null) {
                                createdTime = createdTime.substring(0, createdTime.length() - 3);
                            }
                            map.put("createdTime", createdTime);
                            map.put("type", "-1");
                            map.put("url", IntegrationUtil.buildUrl(accessToken, next.getString("URL")));
                            map.put("status", next.getString("HANDLESTATE"));
                            map.put("name", next.getString("NAME"));
                            map.put("optionType", "");
                            result.add(map);
                        }
                    } else {
                        logger.error((Object)("getIErpToHandleTasks \u51fa\u73b0\u9519\u8bef" + json.getString("message")));
                    }
                }
            }
            catch (Throwable e) {
                logger.error((Object)"getIErpToHandleTasks \u51fa\u73b0\u9519\u8bef", e);
            }
        }
        return result;
    }

    private static Map<String, String> getAppToken() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)APPID) || StringUtils.isEmpty((String)APPSECURET)) {
            result.put("error", "getAppToken\u51fa\u73b0\u9519\u8bef  appId\u6216appSecuret\u4e3a\u7a7a");
            return result;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appId", APPID);
        map.put("appSecuret", APPSECURET);
        map.put("tenantid", TENANTID);
        if (!StringUtils.isEmpty((String)ACCOUNTID)) {
            map.put("accountId", ACCOUNTID);
        }
        if (!StringUtils.isEmpty((String)LANGUAGE)) {
            map.put("language", LANGUAGE);
        }
        try {
            JSONObject json = IntegrationUtil.doPost(map, IERPHOST + "/api/getAppToken.do");
            if (json != null) {
                String state = json.getString("state");
                if ("success".equals(state)) {
                    result.put("app_token", json.getJSONObject("data").getString("app_token"));
                } else {
                    result.put("error", "getAppToken\u51fa\u73b0\u9519\u8bef" + json.getString("errorMsg"));
                }
            }
        }
        catch (IOException e) {
            result.put("error", "getAppToken\u51fa\u73b0\u9519\u8bef" + e.getMessage());
            logger.error((Object)"getAppToken\u51fa\u73b0\u9519\u8bef", (Throwable)e);
        }
        return result;
    }

    private static Map<String, String> getAccessToken(Context ctx) {
        Map<String, String> result = IntegrationUtil.getAppToken();
        if (result.containsKey("app_token")) {
            try {
                JSONObject json;
                String phone = "";
                String uid = ctx.getCaller().toString();
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)("select fcell from t_pm_user where fid='" + uid + "'"));
                if (rowSet.next()) {
                    phone = rowSet.getString("fcell");
                }
                if (StringUtils.isEmpty((String)phone)) {
                    result.put("error", "getAccessToken EAS\u4e2d\u7528\u6237\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
                    return result;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("user", phone);
                map.put("apptoken", result.get("app_token"));
                map.put("tenantid", TENANTID);
                map.put("usertype", "Mobile");
                if (!StringUtils.isEmpty((String)ACCOUNTID)) {
                    map.put("accountId", ACCOUNTID);
                }
                if ((json = IntegrationUtil.doPost(map, IERPHOST + "/api/login.do")) != null) {
                    String state = json.getString("state");
                    if ("success".equals(state)) {
                        result.put("access_token", json.getJSONObject("data").getString("access_token"));
                    } else {
                        result.put("error", "getAccessToken \u51fa\u73b0\u9519\u8bef" + json.getString("errorMsg"));
                    }
                }
            }
            catch (Exception e) {
                result.put("error", "getAccessToken \u51fa\u73b0\u9519\u8bef" + e.getMessage());
                logger.error((Object)"getAccessToken \u51fa\u73b0\u9519\u8bef", (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject doPost(Map<String, Object> map, String url) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        RequestConfig config = RequestConfig.custom().setConnectTimeout(DEFAULT_TIME_OUT).setSocketTimeout(DEFAULT_TIME_OUT).setConnectionRequestTimeout(DEFAULT_TIME_OUT).build();
        HttpPost post = new HttpPost(url);
        post.setConfig(config);
        String param = JSON.toJSONString(map);
        post.setHeader("Content-Type", "application/json;charset=UTF-8");
        try {
            StringEntity se = new StringEntity(param);
            se.setContentEncoding("utf-8");
            se.setContentType("application/json");
            post.setEntity((HttpEntity)se);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() == 200) {
                JSONObject jSONObject = JSON.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8"));
                return jSONObject;
            }
            JSONObject jSONObject = null;
            return jSONObject;
        }
        finally {
            httpClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject doGet(String url) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        RequestConfig config = RequestConfig.custom().setConnectTimeout(DEFAULT_TIME_OUT).setSocketTimeout(DEFAULT_TIME_OUT).setConnectionRequestTimeout(DEFAULT_TIME_OUT).build();
        HttpGet get = new HttpGet(url);
        get.setConfig(config);
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 200) {
                JSONObject jSONObject = JSON.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8"));
                return jSONObject;
            }
            JSONObject jSONObject = null;
            return jSONObject;
        }
        finally {
            httpClient.close();
        }
    }

    public static boolean hasDeployIErp() {
        return !StringUtils.isEmpty((String)IERPHOST);
    }

    static {
        if (StringUtils.isEmpty((String)TENANTID)) {
            TENANTID = "bos_dev_branch";
        }
    }
}

