/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.wfpc.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.IBMCMessage;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.app.msgcount.ClassificationStatCacheManager;
import com.kingdee.eas.base.message.util.JSONUtil;
import com.kingdee.eas.base.message.util.ProcessCenterUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.plt.wfpc.service.IntegrationUtil;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WorkflowPortletService {
    private static final Logger logger = Logger.getLogger(WorkflowPortletService.class);

    public static String getNoticeRecordsJsonStr(Context context, String pageSize, String bizType, String filterCondition) {
        String jsonStr = "";
        StringBuilder filterSql = new StringBuilder();
        String bizTypeStr = "";
        bizTypeStr = bizType.equalsIgnoreCase("all") ? "" : (bizType.equalsIgnoreCase("0") ? " and FBizType = 0 " : (bizType.equalsIgnoreCase("10") ? " and FBizType = 10 " : (bizType.equalsIgnoreCase("40") ? " and FBizType = 40 " : (bizType.equalsIgnoreCase("80") ? " and FBizType = 80 " : (bizType.equalsIgnoreCase("other") ? " and FBizType not in(0,10,80) " : "")))));
        filterSql.append(" where FType=0 and FStatus=0 and FReceiver=? ").append(bizTypeStr);
        if (!bizType.equalsIgnoreCase("80")) {
            filterSql.append(" and ((FSOURCEIDS not like 'PASS%' or FSOURCEIDS is null) and (ftitle_l2 not like '%\u4f20\u9605\u53cd\u9988%' or ftitle_l1 not like 'Reply%' or ftitle_l3 not like '%\u50b3\u95b1\u53cd\u994b%' or ftitle_l2 is null or ftitle_l1 is null or ftitle_l3 is null) and not exists (select 'x' from t_wfr_assign where t_wfr_assign.FASSIGNID=T_BAS_Message.FSOURCEID) and not exists (select 'x' from t_wfr_AssignDetail where t_wfr_AssignDetail.FASSIGNID=T_BAS_Message.FSOURCEID))");
        }
        if (!StringUtils.isEmpty((String)filterCondition)) {
            filterSql.append(filterCondition);
        }
        try {
            ArrayList list = new ArrayList();
            IRowSet rs = null;
            String userId = context.getCaller().toString();
            rs = DbUtil.executeQuery((Context)context, (String)("select count(*) NUM from T_BAS_Message " + filterSql.toString()), (Object[])new Object[]{userId});
            if (rs.next()) {
                HashMap<String, String> num = new HashMap<String, String>();
                num.put("num", rs.getInt("NUM") + "");
                list.add(num);
            }
            filterSql.append(" order by FReceiveTime desc ");
            pageSize = StringUtils.isEmpty((String)pageSize) ? "5" : Integer.parseInt(pageSize) + "";
            String localStr = context.getLocale().getDisplayName();
            String senderStr = "FSender_" + localStr;
            String subjectStr = "FTitle_" + localStr;
            StringBuilder selectSql = new StringBuilder();
            selectSql.append("select top ").append(pageSize).append(" FID,").append(subjectStr).append(",").append(senderStr).append(",FReceiveTime,FBizType,FSourceID from T_BAS_Message");
            rs = DbUtil.executeQuery((Context)context, (String)selectSql.append((CharSequence)filterSql).toString(), (Object[])new Object[]{userId});
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String noticeTitle = "";
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("locale", context.getLocale().getDisplayName());
                map.put("id", rs.getString(1));
                noticeTitle = rs.getString(2) == null ? "" : rs.getString(2);
                if (noticeTitle.indexOf("\"") != -1) {
                    noticeTitle = noticeTitle.replaceAll("\"(.*?)\"", "\u201c$1\u201d");
                }
                map.put("title", noticeTitle);
                map.put("sender", rs.getString(3));
                Timestamp receiveTime = rs.getTimestamp(4);
                int bizType2 = rs.getInt(5);
                if (bizType2 == 40) {
                    String assignId = WorkflowPortletService.getAssignIdByMsgId(context, rs.getString(1));
                    if (assignId == null) {
                        assignId = "";
                    }
                    map.put("assignId", assignId);
                    map.put("billId", "");
                } else if (bizType2 == 0) {
                    if (noticeTitle.startsWith("\u4f20\u9605") && rs.getString(6) != null) {
                        map.put("assignId", "");
                        map.put("billId", rs.getString(6));
                    } else {
                        map.put("assignId", "");
                        map.put("billId", "");
                    }
                } else if (bizType2 == 80) {
                    map.put("assignId", "");
                    map.put("billId", rs.getString(6));
                } else {
                    map.put("assignId", "");
                    map.put("billId", "");
                }
                map.put("receiveTime", sdf.format(receiveTime));
                list.add(map);
            }
            if (list.size() > 0) {
                jsonStr = JSONUtil.getJson4List(list, null);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return jsonStr;
    }

    public static String getAssignIdByMsgId(Context context, String msgId) {
        return ProcessCenterUtil.getAssignIdByMsgId((String)msgId, (Context)context);
    }

    public static Map<String, String> getBMCMessageDetailInfo(Context ctx, String msgId) {
        HashMap<String, String> map = new HashMap<String, String>();
        BMCMessageInfo msgInfo = null;
        try {
            IBMCMessage msgService = BMCMessageFactory.getLocalInstance((Context)ctx);
            msgInfo = msgService.getBMCMessageInfo((IObjectPK)new ObjectUuidPK(msgId));
            if (!ctx.getCaller().toString().equals(msgInfo.getReceiver())) {
                return null;
            }
            msgInfo.setStatus(MsgStatus.READED);
            msgService.save((CoreBaseInfo)msgInfo);
            ClassificationStatCacheManager manager = ClassificationStatCacheManager.get((Context)ctx);
            manager.expire(ctx.getCaller().toString());
        }
        catch (Exception e) {
            msgInfo = null;
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (msgInfo != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            map.put("title", msgInfo.getTitle(ctx.getLocale()));
            map.put("sender", msgInfo.getSender(ctx.getLocale()));
            map.put("bizType", msgInfo.getBizType().getAlias(ctx.getLocale()));
            map.put("bizTypeValue", msgInfo.getBizType().getName());
            map.put("priority", msgInfo.getPriority().getAlias(ctx.getLocale()));
            String sendTimeStr = "";
            Timestamp sendTime = msgInfo.getSendTime();
            if (sendTime != null) {
                sendTimeStr = sdf.format(sendTime);
            }
            map.put("sendTime", sendTimeStr);
            map.put("noticeContent", msgInfo.getBody(ctx.getLocale()));
        }
        return map;
    }

    public static String getAssingRecordsJsonStr(Context context, String pageSize, String filterCondition) {
        if (StringUtils.isEmpty((String)pageSize)) {
            pageSize = "5";
        }
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        try {
            IRowSet rs1;
            Integer num = 0;
            String sql = "select count(*) NUM   from T_WFR_Assign a, T_BAS_AssignRead b  where a.FSTATE in (1, 2)  and a.FASSIGNID = b.FASSIGNID  and a.FPERSONUSERID = '" + context.getCaller().toString() + "' and a.fissendmsg = '1' ";
            if (!StringUtils.isEmpty((String)filterCondition)) {
                sql = sql + "and " + filterCondition;
            }
            if ((rs1 = DbUtil.executeQuery((Context)context, (String)sql.toString())).next()) {
                num = rs1.getBigDecimal("NUM").intValue();
            }
            ret.put("num", num);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        List<HashMap<String, String>> list = new ArrayList<Map<String, String>>();
        try {
            String sql1 = "select top " + pageSize + " FASSIGNID assignId,FSUBJECT_L2 title ,FCREATEDTIME createTime,FSender_L2 sender,fid readId,fstatus status,foptionType optionType from t_wfr_assign_view where FPERSONUSERID='" + context.getCaller().toString() + "'";
            if (!StringUtils.isEmpty((String)filterCondition)) {
                String temp = filterCondition.substring(0, filterCondition.indexOf(" "));
                if ("a.FSUBJECT_L2".equals(temp)) {
                    temp = "FSUBJECT_L2";
                } else if ("b.FSENDER_L2".equals(temp)) {
                    temp = "FSender_L2";
                }
                filterCondition = temp + filterCondition.substring(filterCondition.indexOf(" "));
                sql1 = sql1 + " and " + filterCondition;
            }
            sql1 = sql1 + " order by createTime desc  ";
            IRowSet rs = DbUtil.executeQuery((Context)context, (String)sql1.toString());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("locale", context.getLocale().getDisplayName());
                map.put("id", rs.getString("assignId"));
                map.put("title", rs.getString("title") == null ? "" : rs.getString(2).toString().replaceAll("[\n\r]", "").replaceAll("\"", "\u201c"));
                map.put("sender", rs.getString("sender"));
                Timestamp createdTime = rs.getTimestamp("createTime");
                map.put("createdTime", sdf.format(createdTime));
                map.put("assignReadId", rs.getString("readId"));
                map.put("status", String.valueOf(rs.getInt("status")));
                map.put("type", "0");
                map.put("optionType", rs.getString("optionType") == null ? "" : rs.getString("optionType"));
                list.add(map);
            }
        }
        catch (Exception e) {
            logger.error((Object)("-----------------bingo-------------" + e.getMessage()), (Throwable)e);
        }
        if (IntegrationUtil.hasDeployIErp()) {
            List<Map<String, String>> ierpTasks = IntegrationUtil.getIErpToHandleTasks(context, pageSize);
            list.addAll(ierpTasks);
            Collections.sort(list, new Comparator<Map<String, String>>(){

                @Override
                public int compare(Map<String, String> o1, Map<String, String> o2) {
                    return o2.get("createdTime").compareTo(o1.get("createdTime"));
                }
            });
            int _pageSize = Integer.parseInt(pageSize);
            int realSize = _pageSize > list.size() ? list.size() : _pageSize;
            list = list.subList(0, realSize);
        }
        ret.put("list", (Serializable)((Object)list));
        return JSONUtil.getJson4Object(ret, null);
    }

    public static String getAlreadyRecordsJsonStr(Context context, String pageSize, String filterCondition) {
        String jsonStr = "";
        if (StringUtils.isEmpty((String)pageSize)) {
            pageSize = "5";
        }
        String localStr = context.getLocale().getDisplayName();
        String senderStr = "a.FInitiatorName_" + localStr;
        String subjectStr = "a.FSUBJECT_" + localStr;
        ArrayList list = new ArrayList();
        StringBuffer sql = new StringBuffer();
        sql.append("select top ").append(pageSize).append(" a.FASSIGNID,").append(subjectStr).append(",").append(senderStr).append(",a.FCREATEDTIME ").append(" from t_wfr_AssignDetail a ").append(" where a.FPERSONUSERID='").append(context.getCaller().toString()).append("'").append(" and a.fissendmsg='1'");
        if (!StringUtils.isEmpty((String)filterCondition)) {
            sql.append(filterCondition);
        }
        sql.append(" order by a.FCREATEDTIME desc ");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)context, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (rs != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                while (rs.next()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("locale", context.getLocale().getDisplayName());
                    map.put("id", rs.getString(1));
                    map.put("title", rs.getString(2) == null ? "" : rs.getString(2).toString().replaceAll("[\n\r]", "").replaceAll("\"", "\u201c"));
                    map.put("sender", rs.getString(3));
                    Timestamp createdTime = rs.getTimestamp(4);
                    map.put("createdTime", sdf.format(createdTime));
                    list.add(map);
                }
                rs.beforeFirst();
            }
            catch (SQLException e) {
                logger.error((Object)("-----------------bingo-------------" + e.getMessage()), (Throwable)e);
            }
        }
        if (list.size() > 0) {
            jsonStr = JSONUtil.getJson4List(list, null);
        }
        return jsonStr;
    }
}

