/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.shr.base.syssetting.app.cache.PermItemURLCache;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.SHRPermissionWebUtils;
import com.kingdee.shr.base.syssetting.web.dynamic.util.DynamicUtil;
import com.kingdee.shr.base.syssetting.web.util.UrlParamEncryptHelper;
import com.kingdee.shr.card.model.CardParams;
import com.kingdee.shr.common.model.RemoteCallMessage;
import com.kingdee.shr.common.util.MethodInvokeUtil;
import com.kingdee.shr.common.util.StringUtils;
import com.kingdee.shr.dataplatform.DataplatformException;
import com.kingdee.shr.dataplatform.PageConfigException;
import com.kingdee.shr.dataplatform.PageConfigFactory;
import com.kingdee.shr.dataset.service.DataPlatformServiceFactory;
import com.kingdee.shr.dataset.service.IDataPlatformService;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.pageset.util.PageSetUtils;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class DataPlatformAction {
    private DataPlatformAction() {
    }

    public static Object doPolling(HttpServletRequest request) throws Exception {
        Context ctx = SHRContext.getInstance().getContext();
        RemoteCallMessage remoteCallMessage = DataPlatformAction.initMessage(ctx, request);
        return DataPlatformAction.dispatch(ctx, remoteCallMessage);
    }

    public static RemoteCallMessage initMessage(Context ctx, HttpServletRequest request) throws EASBizException {
        String message;
        String param = request.getParameter("param");
        if (StringUtils.isEmpty((CharSequence)param)) {
            throw new DataplatformException(DataplatformException.INVOKE_MESSAGE_EXCEPTION);
        }
        try {
            message = DataPlatformAction.decode(param);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DataplatformException(DataplatformException.INVOKE_MESSAGE_EXCEPTION);
        }
        RemoteCallMessage remoteCallMessage = (RemoteCallMessage)JSONUtils.convertJsonToObject((Context)ctx, (String)message, RemoteCallMessage.class);
        if (null == remoteCallMessage || null == remoteCallMessage.getParams()) {
            throw new DataplatformException(DataplatformException.INVOKE_MESSAGE_EXCEPTION);
        }
        DataPlatformAction.initServiceParam(request, remoteCallMessage, ctx);
        return remoteCallMessage;
    }

    public static String getPremItemId(Context ctx, String uipk) {
        String permItemUrl = SHRPermissionWebUtils.doAssemblePermissionURL(null, "/dynamic.do", uipk, "initalize", null, null);
        PermItemInfo permItemInfo = PermItemURLCache.getPermItemInfoByURL((Context)ctx, (String)permItemUrl);
        if (null == permItemInfo) {
            return null;
        }
        return permItemInfo.getId().toString();
    }

    public static void setPremission(Context ctx, String uipk, String pageId, HttpServletRequest request) throws EASBizException, BOSException {
        DataPlatformAction.setSession(ctx, uipk, pageId, request);
        Map map = PageSetUtils.getPageUipkMap((Context)ctx, (String)uipk, (String)pageId);
        if (!map.isEmpty()) {
            Collection coll = map.values();
            if (!coll.contains(pageId)) {
                throw new DataplatformException(DataplatformException.INVOKE_EXCEPTION, new Object[]{"uipk does not match pageId!"});
            }
            for (Map.Entry entry : map.entrySet()) {
                if (((String)entry.getKey()).equals(uipk)) continue;
                DataPlatformAction.setSession(ctx, uipk, (String)entry.getValue(), request);
            }
        }
    }

    private static void initServiceParam(HttpServletRequest request, RemoteCallMessage remoteCallMessage, Context ctx) throws EASBizException {
        String uipk = DynamicUtil.getUIPK(request);
        if (StringUtils.isEmpty((CharSequence)uipk)) {
            throw new DataplatformException(DataplatformException.INVOKE_UIPK_EXCEPTION);
        }
        String permItemId = DataPlatformAction.getPremItemId(ctx, uipk);
        if (StringUtils.isEmpty((CharSequence)permItemId)) {
            throw new DataplatformException(DataplatformException.PAGE_NO_PERMISSION);
        }
        remoteCallMessage.addParam("uipk", (Object)uipk);
        remoteCallMessage.addParam("permItemId", (Object)permItemId);
        Boolean isProductionMode = DynamicUtil.isProductionMode(request);
        remoteCallMessage.addParam("isProductionMode", (Object)isProductionMode);
    }

    private static String decode(String messageContent) throws Exception {
        return UrlParamEncryptHelper.decodeForAes(messageContent);
    }

    private static Object dispatch(Context ctx, RemoteCallMessage clientMessage) throws Exception {
        Object obj = null;
        String serviceType = clientMessage.getServiceType();
        String methodName = clientMessage.getRemoteMethod();
        Map paras = clientMessage.getParams();
        IDataPlatformService serviceImpl = null;
        serviceImpl = DataPlatformServiceFactory.getPlateformService((String)serviceType);
        try {
            obj = MethodInvokeUtil.invoke((Object)serviceImpl, (String)methodName, (Object[])new Object[]{ctx, paras});
        }
        catch (InvocationTargetException e) {
            StringBuilder sb = new StringBuilder().append(e.getTargetException().getMessage());
            if (e.getTargetException() instanceof EASBizException) {
                if (null != clientMessage.getParams().get("cardParams")) {
                    String cardParamsJson = JSONUtils.convertObjectToJson((Context)ctx, clientMessage.getParams().get("cardParams"));
                    CardParams cardParams = (CardParams)JSONUtils.convertJsonToObject((Context)ctx, (String)cardParamsJson, CardParams.class);
                    String cardName = !StringUtils.isEmpty((CharSequence)cardParams.getCardName()) ? cardParams.getCardName() : "";
                    sb.append("\n").append(SHRServerResource.getString((String)"com.kingdee.shr.dataplatform.DataplatformResource", (String)"card_name", (Context)ctx)).append(" : \"").append(cardName).append("\"");
                }
                throw new ShrWebBizException(sb.toString(), e.getTargetException());
            }
            if (e.getTargetException() instanceof BOSException) {
                throw new SHRWebException(e.getTargetException().getMessage(), e.getTargetException());
            }
            throw new SHRWebException(e.getTargetException().getMessage(), e.getTargetException());
        }
        return obj;
    }

    private static void setSession(Context ctx, String uipk, String pageId, HttpServletRequest request) throws EASBizException, BOSException {
        String permItemId = DataPlatformAction.getPremItemId(ctx, uipk);
        try {
            if (!PageSetUtils.isVaild((String)pageId, (ICoreBase)PageConfigFactory.getLocalInstance((Context)ctx))) {
                throw new PageConfigException(PageConfigException.PARAMS_EXCEPTION, new Object[]{"pageId is illegal or Non-exist!"});
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("uipk", (Object)uipk));
            if (!PageConfigFactory.getLocalInstance((Context)ctx).exists(filter)) {
                throw new PageConfigException(PageConfigException.PARAMS_EXCEPTION, new Object[]{"uipk is illegal!"});
            }
        }
        catch (EASBizException e) {
            throw new PageConfigException(PageConfigException.PARAMS_EXCEPTION, new Object[]{"pageId or uipk is illegal!"});
        }
        catch (BOSException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        String uipkKey = MessageFormat.format("{0}{1}", uipk, pageId);
        request.getSession().setAttribute(uipkKey, (Object)permItemId);
    }
}

