/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.component.botp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.shr.base.syssetting.component.botp.adapter.IBotpNewAdapter;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.SelectItem;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class BOTPHelper {
    private static final Logger logger = Logger.getLogger(BOTPHelper.class);
    private static final String BILLTYPE = "billType";
    private static final String BILLALIAS = "billAlias";
    private static final String BILLTYPELISTANDALIASSPLITLINE = "|";
    private static final String COMMASPLIT = ",";

    public static List<SelectItem> fillSourceType(String destBillBosType) throws SHRWebException {
        String sourceBillTypeListAndAlias = BOTPHelper.getSourceBillTypeListAndAlias(destBillBosType);
        String[] sourceBillTypeArr = BOTPHelper.parseSourceBillTypeListAndAlias(sourceBillTypeListAndAlias);
        if (null == sourceBillTypeArr || sourceBillTypeArr.length < 1) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "illegal_transfer_rule"));
        }
        ArrayList<SelectItem> resultList = new ArrayList<SelectItem>();
        return resultList;
    }

    public static List<SelectItem> assembleTargetType(String destBillBosType) throws SHRWebException {
        ArrayList resultList = new ArrayList();
        return null;
    }

    public static List<SelectItem> doAssembleSoureType(String billBosType) throws SHRWebException {
        ArrayList resultList = new ArrayList();
        return null;
    }

    public static String[] parseSourceBillTypeListAndAlias(String sourceBillTypeListAndAlias) throws SHRWebException {
        String[] billTypeListAndAliasArr = StringUtil.split((String)sourceBillTypeListAndAlias, (String)BILLTYPELISTANDALIASSPLITLINE);
        assert (billTypeListAndAliasArr.length == 2);
        String billType = billTypeListAndAliasArr[0];
        String billAlias = billTypeListAndAliasArr[1];
        String[] sourceBillAliasArr = StringUtil.split((String)billAlias, (String)COMMASPLIT);
        String[] sourceBillTypeArr = StringUtil.split((String)billType, (String)COMMASPLIT);
        assert (sourceBillTypeArr.length == sourceBillAliasArr.length);
        return sourceBillTypeArr;
    }

    public static String getSourceBillTypeListAndAlias(String destBillBosType) throws SHRWebException {
        try {
            return BOTPHelper.getIBOTMapping().getSourceBillTypeListAndAlias(destBillBosType);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SHRWebException(e);
        }
    }

    public static IBOTMapping getIBOTMapping() throws SHRWebException {
        try {
            return BOTMappingFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new SHRWebException(e);
        }
    }

    public static IBotpNewAdapter getBotpNewAdapter(String botpNewAdapter) {
        if (!StringUtils.isEmpty((String)botpNewAdapter)) {
            try {
                Class<?> c = Class.forName(botpNewAdapter);
                IBotpNewAdapter iBotpNewAdapter = (IBotpNewAdapter)c.newInstance();
                return iBotpNewAdapter;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

