/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.context;

import com.kingdee.shr.base.syssetting.context.IContextProvider;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.util.BeanUtils;
import com.kingdee.shr.base.syssetting.util.CustomerInfoCollectHelper;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class ContextFactory {
    public static final String CONTEXT_PROVIDER_KEY = "shr.ContextProvider";

    public static SHRContext getContext(ServletContext context, ServletRequest request, ServletResponse response) throws SHRWebException {
        SHRContext shrContext = null;
        IContextProvider provider = (IContextProvider)context.getAttribute(CONTEXT_PROVIDER_KEY);
        try {
            if (provider == null) {
                provider = (IContextProvider)Class.forName("com.kingdee.shr.base.syssetting.WebContext.DefaultContextProvider").newInstance();
                context.setAttribute(CONTEXT_PROVIDER_KEY, (Object)provider);
                shrContext = provider.getSHRContext(context, request, response);
                CustomerInfoCollectHelper customerInfoCollectionHelper = (CustomerInfoCollectHelper)BeanUtils.getBean("customerInfoCollectHelper");
                customerInfoCollectionHelper.collectCustomerInfo(shrContext);
            } else {
                shrContext = provider.getSHRContext(context, request, response);
            }
        }
        catch (Exception e) {
            throw new SHRWebException(e.getCause());
        }
        SHRContext.setInstance(shrContext);
        return shrContext;
    }
}

