/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.context;

import com.kingdee.bos.Context;
import com.kingdee.shr.base.syssetting.context.ApplicationContext;
import com.kingdee.shr.base.syssetting.context.BaseContext;
import com.kingdee.shr.base.syssetting.context.IContext;
import com.kingdee.shr.base.syssetting.context.SessionContext;
import com.kingdee.shr.base.syssetting.service.ServiceContext;
import com.kingdee.shr.base.syssetting.servlet.ServletApplicationMap;
import com.kingdee.shr.base.syssetting.servlet.ServletRequestMap;
import com.kingdee.shr.base.syssetting.servlet.ServletRequestSessionMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class SHRContext
extends BaseContext {
    public static String KEY = SHRContext.class.getName();
    private Context context;
    private ServletRequest request;
    private ServletContext servletContext;
    private static final ThreadLocal<IContext> sessionContext = new ThreadLocal();
    private static final ThreadLocal<IContext> applicationContext = new ThreadLocal();
    private ServletResponse response;
    private ServiceContext serviceContext;
    private boolean supportMultiLang = false;
    private Map langs = null;
    static ThreadLocal<SHRContext> instance = new ThreadLocal<SHRContext>(){

        @Override
        protected SHRContext initialValue() {
            return null;
        }
    };

    public SHRContext(ServletContext servletContext, ServletRequest request, ServletResponse response) {
        super(new ServletRequestMap(request));
        this.servletContext = servletContext;
        this.request = request;
        this.response = response;
        SHRContext.setInstance(this);
    }

    public static SHRContext getInstance() {
        return instance.get();
    }

    public static void setInstance(SHRContext value) {
        instance.set(value);
        if (value != null) {
            ServletRequestSessionMap sessionMap = new ServletRequestSessionMap((HttpServletRequest)value.getRequest());
            sessionContext.set(new SessionContext(sessionMap));
            ServletApplicationMap appMap = new ServletApplicationMap(value.getServletContext());
            applicationContext.set(new ApplicationContext(appMap));
        } else {
            sessionContext.set(null);
            applicationContext.set(null);
        }
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    public void setServiceContext(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public static IContext getSessionContext() {
        return sessionContext.get();
    }

    public static IContext getApplicationContext() {
        return applicationContext.get();
    }

    public boolean isSupportMultiLang() {
        return this.supportMultiLang;
    }

    public void setSupportMultiLang(boolean supportMultiLang) {
        this.supportMultiLang = supportMultiLang;
    }

    public Map getLangs() {
        return this.langs;
    }

    public void setLangs(Map langs) {
        this.langs = langs;
    }

    public XmlWebApplicationContext getBeanFactory() {
        return (XmlWebApplicationContext)this.getServletContext().getAttribute("org.springframework.web.servlet.FrameworkServlet.CONTEXT.MVCServlet");
    }
}

