/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.action.ActionManager;
import com.kingdee.shr.base.syssetting.action.WebAction;
import com.kingdee.shr.base.syssetting.annotation.Action;
import com.kingdee.shr.base.syssetting.core.IWebPageController;
import com.kingdee.shr.base.syssetting.core.ShrCoreController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.propertyeditors.CustomBOSUuidEditor;
import com.kingdee.shr.base.syssetting.propertyeditors.CustomBigDecimalEditor;
import com.kingdee.shr.base.syssetting.propertyeditors.CustomDateEditor;
import com.kingdee.shr.base.syssetting.propertyeditors.CustomDoubleEditor;
import com.kingdee.shr.base.syssetting.propertyeditors.CustomEnumEditor;
import com.kingdee.shr.base.syssetting.propertyeditors.CustomFloatEditor;
import com.kingdee.shr.base.syssetting.propertyeditors.CustomIntegerEditor;
import com.kingdee.shr.base.syssetting.propertyeditors.CustomObjectCollectionEditor;
import com.kingdee.shr.base.syssetting.propertyeditors.CustomOrgUnitObjectEditor;
import com.kingdee.shr.base.syssetting.propertyeditors.CustomStringEditor;
import com.kingdee.shr.base.syssetting.propertyeditors.CustomTimeEditor;
import com.kingdee.shr.base.syssetting.propertyeditors.CustomTimestampEditor;
import com.kingdee.shr.base.syssetting.propertyeditors.CustomValueObjectEditor;
import com.kingdee.shr.base.syssetting.util.LicenseHelper;
import com.kingdee.shr.base.syssetting.util.PermissionHelper;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.util.enums.Enum;
import java.beans.PropertyEditor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RequestMapping;

public class WebPageController
extends ShrCoreController
implements IWebPageController {
    protected Logger logger = Logger.getLogger(this.getClass());
    protected ActionManager actionManager = null;
    public static final String PAGE_INITALIZE_ACTION = "initalize";
    public static final String PAGE_LOAD_ACTION = "load";
    public static final String PAGE_CLOSE_ACTION = "close";
    public static final String PAGE_DESTROY_ACTION = "destroy";
    private boolean conversationSupport = false;

    public boolean isConversationSupport() {
        return this.conversationSupport;
    }

    public void setConversationSupport(boolean conversationSupport) {
        this.conversationSupport = conversationSupport;
    }

    @Override
    public Map getSession() throws SHRWebException {
        if (this.getSessionManager().getSessionEntity(this.getMetadataPK().toString(), this.getConversationID()) == null) {
            this.getSessionManager().bindControllerSessionEntity(this.getMetadataPK().toString(), this.getConversationID());
        }
        return this.getSessionManager().getSessionEntity(this.getMetadataPK().toString(), this.getConversationID());
    }

    @Override
    public String initalizeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        this.getSessionManager().bindControllerSessionEntity(this.getMetadataPK().toString(), this.getConversationID());
        this.checkActionsPermission(this.getActionManager(), this.getMetadataPK(), this.getMainOrgInfo());
        modelMap.put((Object)"actionManager", (Object)this.getActionManager().getActionSet());
        return this.loadAction(request, response, modelMap);
    }

    protected void checkActionsPermission(ActionManager actionManager, IMetaDataPK metadataPK, OrgUnitInfo mainOrgInfo) throws ShrWebBizException, SHRWebException {
        try {
            PermissionHelper.checkActionsPermission(actionManager, metadataPK, mainOrgInfo);
        }
        catch (BOSException exception) {
            throw new SHRWebException(exception);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    protected void initalizeCompnentActionBind() throws SHRWebException {
    }

    @Override
    public String loadAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        return this.getContextUrl(request);
    }

    @Override
    public String closeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        return this.destroyAction(request, response, modelMap);
    }

    @Override
    public String destroyAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        this.getSessionManager().releaseControllerSession(this.getMetadataPK().toString());
        if (this.isLicenseRequired()) {
            LicenseHelper.releaseLicense(this.getClass().getName());
        }
        JSONUtils.SUCCESS("");
        return null;
    }

    @InitBinder
    protected void initDataBind(WebDataBinder binder) {
        binder.registerCustomEditor(BOSUuid.class, (PropertyEditor)new CustomBOSUuidEditor());
        binder.registerCustomEditor(String.class, (PropertyEditor)new CustomStringEditor());
        binder.registerCustomEditor(IObjectValue.class, (PropertyEditor)new CustomValueObjectEditor());
        binder.registerCustomEditor(Integer.TYPE, (PropertyEditor)new CustomIntegerEditor());
        binder.registerCustomEditor(Float.TYPE, (PropertyEditor)new CustomFloatEditor());
        binder.registerCustomEditor(Double.TYPE, (PropertyEditor)new CustomDoubleEditor());
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor());
        binder.registerCustomEditor(Time.class, (PropertyEditor)new CustomTimeEditor());
        binder.registerCustomEditor(Timestamp.class, (PropertyEditor)new CustomTimestampEditor());
        binder.registerCustomEditor(BigDecimal.class, (PropertyEditor)new CustomBigDecimalEditor());
        binder.registerCustomEditor(Enum.class, (PropertyEditor)new CustomEnumEditor());
        binder.registerCustomEditor(IObjectCollection.class, (PropertyEditor)new CustomObjectCollectionEditor());
        binder.registerCustomEditor(OrgUnitInfo.class, (PropertyEditor)new CustomOrgUnitObjectEditor());
        Object[] arrayOrgTypeInfo = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo().toArray();
        for (int i = 0; i < arrayOrgTypeInfo.length; ++i) {
            try {
                OrgTypeInfo orgTypeInfo = (OrgTypeInfo)arrayOrgTypeInfo[i];
                EntitySelect select = new EntitySelect(orgTypeInfo.getBosType());
                select.selectObjectValueClass();
                SimpleEntity entityObjectInfo = MetaDataAccessFactory.getRemoteInstance().select(select);
                String infoClz = entityObjectInfo.getObjectValueClass();
                binder.registerCustomEditor(Class.forName(infoClz).newInstance().getClass(), (PropertyEditor)new CustomOrgUnitObjectEditor(orgTypeInfo.getOrgType()));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ActionManager getActionManager() throws SHRWebException {
        if (this.actionManager == null) {
            this.actionManager = new ActionManager(this);
            this.initActionBind(this.getClass());
            this.initalizeCompnentActionBind();
        }
        return this.actionManager;
    }

    protected void initActionBind(Class currentCls) throws SHRWebException {
        if (currentCls == null) {
            return;
        }
        ArrayList actionList = new ArrayList();
        Method[] methods = currentCls.getDeclaredMethods();
        for (Method method : methods) {
            RequestMapping requestMapping;
            Action annotation = method.getAnnotation(Action.class);
            if (annotation == null || (requestMapping = method.getAnnotation(RequestMapping.class)) == null) continue;
            String methodName = method.getName();
            String actionName = methodName.substring(0, methodName.indexOf("Action"));
            WebAction action = new WebAction();
            action.setName(methodName);
            action.setPermmision(annotation.perm());
            this.getActionManager().registerAction(actionName, action);
        }
        this.initActionBind(currentCls.getSuperclass());
        for (GenericDeclaration genericDeclaration : currentCls.getInterfaces()) {
            this.initActionBind((Class)genericDeclaration);
        }
    }

    @Override
    public boolean isLicenseRequired() {
        return true;
    }
}

