/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.interceptor;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.MD5Util;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.core.IWafController;
import com.kingdee.shr.base.syssetting.core.IWebComponentController;
import com.kingdee.shr.base.syssetting.core.IWebController;
import com.kingdee.shr.base.syssetting.core.IWebPageController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.interceptor.InterceptorHelper;
import com.kingdee.shr.base.syssetting.permission.CheckFunctionPermissionUtil;
import com.kingdee.shr.base.syssetting.permission.button.SHRButtonDataPermissionHelper;
import com.kingdee.shr.base.syssetting.permission.data.ShrCheckDataPermissionUtil;
import com.kingdee.shr.base.syssetting.resourcemanager.ResourceManager;
import com.kingdee.shr.base.syssetting.util.BeanUtils;
import com.kingdee.shr.base.syssetting.util.SHRLicenseControlPolicyHelper;
import com.kingdee.shr.base.syssetting.util.WafUtils;
import com.kingdee.shr.base.syssetting.util.WorkPlatformUtil;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ShrDispatcherInterceptor
extends HandlerInterceptorAdapter {
    private static Logger logger = Logger.getLogger(ShrDispatcherInterceptor.class);

    protected void homepageTranlate(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String uipk = request.getParameter("uipk");
        Context ctx = SHRContext.getInstance().getContext();
        if (WorkPlatformUtil.isShowOldWorkbench((Context)ctx)) {
            if ("shr.perself.homepage.new".equals(uipk)) {
                response.sendRedirect("/shr/perSelf.do");
            } else if ("shr.manager.homepage.new".equals(uipk)) {
                response.sendRedirect("/shr/manager.do");
            } else if ("shr.myworkplatform.homepage".equals(uipk)) {
                response.sendRedirect(WorkPlatformUtil.getOldDefaultWorkplatform((Context)ctx));
            }
        } else if ("shr.perself.homepage".equals(uipk)) {
            response.sendRedirect("/shr/dynamic.do?uipk=shr.perself.homepage.new&billId=urc82BrSRtOcJIdAv8TcjLLHsrA%3D&inFrame=true&blank=true");
        } else if ("shr.manager.homepage".equals(uipk)) {
            response.sendRedirect("/shr/dynamic.do?uipk=shr.manager.homepage.new&billId=kFSKs4dqSxOJsBfFwxA%2B4rLHsrA%3D&inFrame=true&blank=true");
        } else if ("shr.myworkplatform.homepage".equals(uipk)) {
            // empty if block
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod && ((HandlerMethod)handler).getBean() instanceof IWebController) {
            if (SHRContext.getInstance() == null) {
                logger.error((Object)" ShrDispatcherInterceptor preHandle SHRContext.getInstance() is null ");
                return true;
            }
            this.homepageTranlate(request, response, handler);
            IWebController webController = (IWebController)((HandlerMethod)handler).getBean();
            this.checkWafLicense(request, response);
            if (InterceptorHelper.isIgnoredValidateRequest(request)) {
                logger.debug((Object)MessageFormat.format("isIgnoredValidateRequest,uri is:{0}", request.getRequestURI()));
                return true;
            }
            this.checkFuncPermissionByURL(request, response, webController);
            this.checkButtonDataPermission(request, response);
            this.processSystemParameter(request, response, webController);
        }
        return true;
    }

    public void processSessionValues(HttpServletRequest request, HttpServletResponse response, IWebController controller) throws Exception {
        if (controller instanceof IWebPageController) {
            Map sessionMap = ((IWebPageController)((Object)controller)).getSession();
            request.setAttribute("WafSession", (Object)sessionMap);
        }
    }

    private void processSystemParameter(HttpServletRequest request, HttpServletResponse response, IWebController webController) throws Exception {
        if (webController instanceof IWafController) {
            request.setAttribute("ownerUI", (Object)(((IWafController)((Object)webController)).getMetadataPK().toString().replace("\\", ".").replace("/", ".") + "Controller"));
        }
        this.processLocalResource(request, response, webController);
    }

    public void processLocalResource(HttpServletRequest request, HttpServletResponse response, IWebController controller) throws Exception {
        if (SHRContext.getInstance() == null) {
            return;
        }
        Context ctx = SHRContext.getInstance().getContext();
        ResourceManager resourceManager = (ResourceManager)BeanUtils.getBean("resourceManager");
        if (ctx == null) {
            return;
        }
        Map localMap = resourceManager.getControllerLocalResFromCache(controller, ctx.getLocale());
        StringBuffer JSLocaleScript = resourceManager.buildJSLocalRes(controller, ctx.getLocale());
        request.setAttribute("localeStr", (Object)localMap);
        request.setAttribute("localStr", (Object)localMap);
        request.setAttribute("WAF_LOCALE_JS_VAR", (Object)JSLocaleScript);
    }

    public void checkWafLicense(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        String uipk = request.getParameter("uipk");
        if (StringUtils.isEmpty((String)uipk)) {
            return;
        }
        HashSet<String> method = new HashSet<String>(4);
        method.add("addnew");
        method.add("view");
        method.add("initalize");
        method.add("edit");
        String methodStr = WafUtils.getRequestAction(request);
        if ("dataplatformService".equalsIgnoreCase(methodStr)) {
            methodStr = WafUtils.getDataPlatformMethod(SHRContext.getInstance().getContext(), request);
        }
        if (!method.contains(methodStr.toLowerCase())) {
            return;
        }
        String code = request.getParameter("md5_code");
        if (code != null && !"".equals(code) && !"undefined".equals(code)) {
            String newCode;
            String k = "";
            if (request.getSession().getAttribute("md5_key") != null) {
                k = (String)request.getSession().getAttribute("md5_key");
            }
            if ((newCode = MD5Util.getMD5String((String)(uipk + k))) != null && code.equals(newCode)) {
                return;
            }
        }
        SHRLicenseControlPolicyHelper.checkLicence(request, uipk);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        HandlerMethod handlerMethod;
        if (handler instanceof HandlerMethod && (handlerMethod = (HandlerMethod)handler).getBean() instanceof IWebController) {
            IWebController webController = (IWebController)handlerMethod.getBean();
            this.processSessionValues(request, response, webController);
        }
        super.afterCompletion(request, response, handler, ex);
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        super.postHandle(request, response, handler, modelAndView);
        if ("POST".equals(request.getMethod())) {
            return;
        }
        if ("/shr/uiview_config.do".equals(request.getRequestURI())) {
            return;
        }
        if ("/shr/shr/msf/service.do".equals(request.getRequestURI())) {
            return;
        }
        if (null == modelAndView || modelAndView.isEmpty() || null == modelAndView.getModel()) {
            return;
        }
        if (!CheckFunctionPermissionUtil.isNeedCheckFunctionPermission(request)) {
            return;
        }
        ShrCheckDataPermissionUtil.callIShrCheckDataPermissionService(request, response, handler, modelAndView);
    }

    private void checkFuncPermissionByURL(HttpServletRequest request, HttpServletResponse response, IWebController controller) throws SHRWebException {
        if (controller instanceof IWebComponentController) {
            return;
        }
        CheckFunctionPermissionUtil.checkFunctionPermission(request, response);
    }

    private void checkButtonDataPermission(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        if (ShrCheckDataPermissionUtil.checkIsShrWfButNoPermitemPermission(request)) {
            return;
        }
        SHRButtonDataPermissionHelper.checkButtonDataPermission(request);
    }
}

