/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.log;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.log.DefaultOperateLogService;
import com.kingdee.shr.base.syssetting.log.IOperateLogService;
import com.kingdee.shr.base.syssetting.log.LogServiceImplMapping;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.DynamicUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.log.cache.LogConfigBean;
import com.kingdee.shr.log.cache.LogConfigCacheHelper;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.util.ReflectionUtils;

public class OperateLogManager {
    private static Logger logger = Logger.getLogger(OperateLogManager.class);
    private static final String OPERATE_LOG_SERVICE = "OperateLogService";

    public static void preWriteLog(HttpServletRequest request) {
        try {
            IOperateLogService service = OperateLogManager.getIOperateLogService(SHRContext.getInstance().getContext(), request);
            if (null == service) {
                return;
            }
            service.preLogHandle(request);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void postWriteLog(HttpServletRequest request) {
        try {
            IOperateLogService service = (IOperateLogService)request.getAttribute(OPERATE_LOG_SERVICE);
            if (null == service) {
                return;
            }
            service.postLogHandle(request);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static LogConfigBean getLogConfigBean(Context ctx, HttpServletRequest request) throws BOSException, SHRWebException {
        String appCode;
        String uipk = DynamicUtil.getUIPK(request);
        String method = request.getParameter("method");
        LogConfigBean bean = LogConfigCacheHelper.getLogConfigBean((Context)ctx, (int)30, (String)MessageFormat.format("{0}#{1}", method, uipk));
        if (null != bean) {
            return bean;
        }
        UIViewInfo uiView = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
        if (null != uiView && null != uiView.getVarDefine(ctx) && !uiView.getVarDefine(ctx).isEmpty() && !StringUtils.isEmpty((String)(appCode = uiView.getVarDefine(ctx).get("appCode"))) && null != (bean = LogConfigCacheHelper.getLogConfigBean((Context)ctx, (int)20, (String)appCode))) {
            return bean;
        }
        bean = LogConfigCacheHelper.getLogConfigBean((Context)ctx, (int)10, (String)"system_log");
        return bean;
    }

    public static LogConfigBean getPrintLogConfigBean(Context ctx) throws BOSException {
        if (null == ctx) {
            return null;
        }
        return LogConfigCacheHelper.getLogConfigBean((Context)ctx, (int)30, (String)"templatePrint_log_config");
    }

    public static LogConfigBean getImportLogConfigBean(Context ctx) throws BOSException {
        if (null == ctx) {
            return null;
        }
        return LogConfigCacheHelper.getLogConfigBean((Context)ctx, (int)30, (String)"importPrint_log_config");
    }

    public static LogConfigBean getAttachMentLogConfigBean(Context ctx) throws BOSException {
        if (null == ctx) {
            return null;
        }
        return LogConfigCacheHelper.getLogConfigBean((Context)ctx, (int)30, (String)"attachment_operate_service");
    }

    public static LogConfigBean getAttachMentReNameConfigBean(Context ctx) throws BOSException {
        if (null == ctx) {
            return null;
        }
        return LogConfigCacheHelper.getLogConfigBean((Context)ctx, (int)30, (String)"attachment_rename_service");
    }

    public static IOperateLogService getIOperateLogService(Context ctx, LogConfigBean bean) throws SHRWebException {
        try {
            if (null == ctx || bean == null || StringUtils.isEmpty((String)bean.getImplClass())) {
                return null;
            }
            Class clazz = MsfClassLoaderFactory.forName((String)bean.getImplClass());
            Object obj = clazz.newInstance();
            if (obj instanceof IOperateLogService) {
                IOperateLogService service = (IOperateLogService)obj;
                service.setContext(ctx);
                service.setLogConfigBean(bean);
                return service;
            }
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static IOperateLogService getIOperateLogService(Context ctx, HttpServletRequest request) throws SHRWebException {
        try {
            LogConfigBean bean = OperateLogManager.getLogConfigBean(ctx, request);
            IOperateLogService service = OperateLogManager.getIOperateLogService(ctx, bean);
            if (null != service) {
                request.setAttribute(OPERATE_LOG_SERVICE, (Object)service);
            }
            return service;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void beforeWriteLog(HttpServletRequest request) {
        String logServiceImpl = OperateLogManager.findLogServiceImplClassName(request);
        if (StringUtils.isEmpty((String)logServiceImpl)) {
            DefaultOperateLogService logservice = new DefaultOperateLogService();
            try {
                logservice.preLogHandle(request);
            }
            catch (SHRWebException e) {
                e.printStackTrace();
            }
        } else {
            String methodName = "preLogHandle";
            OperateLogManager.doWriteCustomLog(request, logServiceImpl, methodName);
        }
    }

    public static void afterWriteLog(HttpServletRequest request) {
        String logServiceImpl = OperateLogManager.findLogServiceImplClassName(request);
        if (StringUtils.isEmpty((String)logServiceImpl)) {
            DefaultOperateLogService logservice = new DefaultOperateLogService();
            try {
                logservice.postLogHandle(request);
            }
            catch (SHRWebException e) {
                e.printStackTrace();
            }
        } else {
            String methodName = "postLogHandle";
            OperateLogManager.doWriteCustomLog(request, logServiceImpl, methodName);
        }
    }

    private static void doWriteCustomLog(HttpServletRequest request, String logServiceImpl, String methodName) {
        try {
            String checkMethodName = "customLogItemSet";
            String uipk = request.getParameter("uipk");
            String method0 = request.getParameter("method");
            if (StringUtils.isEmpty((String)method0)) {
                method0 = "initalize";
            }
            Class clazz = MsfClassLoaderFactory.forName((String)logServiceImpl);
            Object logServiceInstance = clazz.newInstance();
            Method checkMethod = ReflectionUtils.findMethod((Class)clazz, (String)checkMethodName, (Class[])new Class[]{HttpServletRequest.class});
            Object checkMethodResult = ReflectionUtils.invokeMethod((Method)checkMethod, logServiceInstance, (Object[])new Object[]{request});
            if (checkMethodResult instanceof Set) {
                Set set = (Set)checkMethodResult;
                if (null != set && set.size() > 0 && !StringUtils.isEmpty((String)uipk) && !StringUtils.isEmpty((String)method0)) {
                    String key = uipk + method0;
                    if (!StringUtils.isEmpty((String)key) && set.contains(key)) {
                        Method method = ReflectionUtils.findMethod((Class)clazz, (String)methodName, (Class[])new Class[]{HttpServletRequest.class});
                        ReflectionUtils.invokeMethod((Method)method, logServiceInstance, (Object[])new Object[]{request});
                    }
                } else {
                    OperateLogManager.executeLog(request, methodName);
                }
            }
        }
        catch (Exception e) {
            try {
                OperateLogManager.executeLog(request, methodName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            e.printStackTrace();
        }
    }

    private static void executeLog(HttpServletRequest request, String methodName) throws SHRWebException {
        DefaultOperateLogService logservice = new DefaultOperateLogService();
        if ("preLogHandle".equals(methodName)) {
            logservice.preLogHandle(request);
        } else if ("postLogHandle".equals(methodName)) {
            logservice.postLogHandle(request);
        }
    }

    public static String findLogServiceImplClassName(HttpServletRequest request) {
        Map<String, String> map;
        String appCode;
        Map<String, String> varDefine;
        String uipk = request.getParameter("uipk");
        String logServiceImpl = "";
        if (StringUtils.isEmpty((String)uipk)) {
            return logServiceImpl;
        }
        UIViewInfo uiViewInfo = null;
        try {
            uiViewInfo = UIViewUtil.getCurrentUIViewInfo((ServletRequest)request);
        }
        catch (SHRWebException e) {
            e.printStackTrace();
        }
        if (null != uiViewInfo && (varDefine = uiViewInfo.getVarDefine()) != null && !StringUtils.isEmpty((String)(appCode = varDefine.get("appCode"))) && null != (map = LogServiceImplMapping.getInstance())) {
            logServiceImpl = map.get(appCode);
        }
        return logServiceImpl;
    }

    public static void writeAccesLog(HttpServletRequest request, long startTime) {
        Context ctx = SHRContext.getInstance().getContext();
        String remoteAddr = OperateLogManager.getRemoteAddr(request);
        String uipk = request.getParameter("uipk");
        String method = request.getParameter("method");
        if (StringUtils.isEmpty((String)method)) {
            method = "initalize";
        }
        if (StringUtils.isEmpty((String)uipk)) {
            uipk = request.getParameter("handler");
        }
    }

    public static void writeAccesLog(HttpServletRequest request, String uri, String method, long startTime) {
        Context ctx = SHRContext.getInstance().getContext();
        String remoteAddr = OperateLogManager.getRemoteAddr(request);
        String uipk = request.getParameter("uipk");
        if (StringUtils.isEmpty((String)uipk)) {
            uipk = request.getParameter("handler");
        }
        OperateLogManager.doWriteAccessLog(ctx, uipk, method, remoteAddr, startTime);
    }

    public static void doWriteAccessLog(Context ctx, String uipk, String method, String remoteAddr, Long startTime) {
        try {
            Class<?> c = Class.forName("com.kingdee.shr.monitor.service.SHRWebAccessLogManager");
            Method m0 = c.getMethod("getInstance", new Class[0]);
            m0.invoke(c, new Object[0]);
            Method m = c.getMethod("addLog", Context.class, String.class, String.class, String.class, Long.class);
            m.invoke(c, ctx, remoteAddr, uipk, method, startTime);
        }
        catch (Exception e) {
            logger.error((Object)MessageFormat.format(" when invoke doWriteAccessLog fail ,Other functions are affected , cause : {0}", e.getMessage()));
        }
    }

    public static String getRemoteAddr(HttpServletRequest request) {
        String remoteAddr = request.getHeader("nap_proxy_client_ip");
        if (remoteAddr != null && remoteAddr.trim().length() > 0) {
            return remoteAddr;
        }
        remoteAddr = request.getHeader("x-forwarded-for");
        if (remoteAddr != null && remoteAddr.trim().length() > 0) {
            try {
                if (remoteAddr.indexOf(",") != -1) {
                    remoteAddr = remoteAddr.substring(0, remoteAddr.indexOf(","));
                }
                return remoteAddr;
            }
            catch (Exception e) {
                logger.error((Object)"X_FORWARDED_FOR : Get Real IP Address  err!", (Throwable)e);
            }
        }
        if ((remoteAddr = request.getHeader("Proxy-Client-IP")) != null && remoteAddr.trim().length() > 0) {
            return remoteAddr;
        }
        return request.getRemoteAddr() == null ? "172.0.0.1" : request.getRemoteAddr();
    }
}

