/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.util.Uuid;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;

public class VirtualDataFetcher {
    private IQueryExecutor exec;
    private List<Map<String, Object>> data;
    private int count;
    private int start;
    private int length;
    private Uuid uuid;

    public static VirtualDataFetcher createInstance(IQueryExecutor exec, int start, int length) {
        VirtualDataFetcher fetcher = new VirtualDataFetcher(exec, start, length);
        fetcher.executeData();
        return fetcher;
    }

    public static VirtualDataFetcher createInstance(IQueryExecutor exec, Uuid uuid, int start, int length) {
        VirtualDataFetcher fetcher = new VirtualDataFetcher(exec, uuid, start, length);
        fetcher.executeVirtualData();
        return fetcher;
    }

    private VirtualDataFetcher(IQueryExecutor exec, int start, int length) {
        this.exec = exec;
        this.start = start;
        this.length = length;
    }

    private VirtualDataFetcher(IQueryExecutor exec, Uuid uuid, int start, int length) {
        this.exec = exec;
        this.start = start;
        this.length = length;
        this.uuid = uuid;
    }

    public int getRowCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Object getRowData(int index) {
        return this.data.get(index);
    }

    public IQueryExecutor getQueryExecutor() {
        return this.exec;
    }

    public void reload() {
        this.executeData();
    }

    private void executeVirtualData() {
        try {
            ConfigMDUtil.setContextToThread((Context)SHRContext.getInstance().getContext());
            this.data = new LinkedList<Map<String, Object>>();
            IRowSet rowSet = this.exec.executeQuery(this.uuid, this.start, this.length);
            IRowSetMetaData md = rowSet.getRowSetMetaData();
            while (rowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                int count = md.getColumnCount();
                for (int i = 1; i <= count; ++i) {
                    String columnName = md.getColumnName(i);
                    Object value = rowSet.getObject(i);
                    map.put(columnName, value);
                }
                this.data.add(map);
            }
            this.count = this.data.size();
        }
        catch (SQLException e) {
            throw new FacesException("execute query error!", (Throwable)new SHRWebException(e));
        }
        catch (BOSException e) {
            throw new FacesException("execute query error!", (Throwable)new SHRWebException(e));
        }
    }

    private void executeData() {
        try {
            this.data = new LinkedList<Map<String, Object>>();
            IRowSet rowSet = this.exec.executeQuery(this.start, this.length);
            IRowSetMetaData md = rowSet.getRowSetMetaData();
            while (rowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                int count = md.getColumnCount();
                for (int i = 1; i <= count; ++i) {
                    String columnName = md.getColumnName(i);
                    Object value = rowSet.getObject(i);
                    map.put(columnName, value);
                }
                this.data.add(map);
            }
            this.count = this.data.size();
        }
        catch (SQLException e) {
            throw new FacesException("execute query error!", (Throwable)new SHRWebException(e));
        }
        catch (BOSException e) {
            throw new FacesException("execute query error!", (Throwable)new SHRWebException(e));
        }
    }

    public List<Map<String, Object>> getData() {
        return this.data;
    }

    public void setData(List<Map<String, Object>> data) {
        this.data = data;
    }

    public int getCount() {
        return this.count;
    }
}

