/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.permission.button;

import com.kingdee.bos.Context;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.dynamic.model.PageConfigParam;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class PageConfigParamManager {
    private static final String ADMINORGFIELD = "adminOrgField";
    private static final String HRORGFIELD = "hrOrgField";
    private static final String DEFAULTMANAGEFIELD = "isDefaultManage";
    private static final String CHECKMODEFIELD = "checkMode";
    private static final String CHECKRULEFIELD = "checkRule";

    public static Set<String> getAdminOrgFieldName(PageConfigParam pcp) {
        Set<String> adminOrgFieldSet = pcp.getAdminOrgFieldSet();
        return CollectionUtils.isEmpty(adminOrgFieldSet) ? Collections.EMPTY_SET : adminOrgFieldSet;
    }

    public static Set<String> getHrOrgFieldName(PageConfigParam pcp) {
        Set<String> hrOrgFieldSet = pcp.getHrOrgFieldSet();
        return CollectionUtils.isEmpty(hrOrgFieldSet) ? Collections.EMPTY_SET : hrOrgFieldSet;
    }

    public static String getDefaultManageFieldName(PageConfigParam pcp) {
        String defaultManageFiled = pcp.getDefaultManage();
        return StringUtils.isEmpty((String)defaultManageFiled) ? DEFAULTMANAGEFIELD : defaultManageFiled;
    }

    public static String getDefaultManageFieldNameByConfig(PageConfigParam pcp) {
        String defaultManageFiled = pcp.getDefaultManage();
        return defaultManageFiled;
    }

    public static String getCheckModeFieldName(PageConfigParam pcp) {
        String checkModeFiled = pcp.getCheckMode();
        return StringUtils.isEmpty((String)checkModeFiled) ? "server" : checkModeFiled;
    }

    public static String getCheckRuleFieldName(PageConfigParam pcp) {
        String checkRuleFiled = pcp.getCheckRule();
        return StringUtils.isEmpty((String)checkRuleFiled) ? "" : checkRuleFiled;
    }

    public static String getAdminOrgFieldNameStr(PageConfigParam pcp) {
        return PageConfigParamManager.convertSetToStr(PageConfigParamManager.getAdminOrgFieldName(pcp));
    }

    public static String getHrOrgFieldNameStr(PageConfigParam pcp) {
        return PageConfigParamManager.convertSetToStr(PageConfigParamManager.getHrOrgFieldName(pcp));
    }

    public static PageConfigParam parsePageConfig2ParamObj(Context ctx, UIViewInfo uiViewInfo) throws SHRWebException {
        PageConfigParam configParam = new PageConfigParam();
        if (null == uiViewInfo) {
            return configParam;
        }
        String pageParamConfig = uiViewInfo.getPageParamConfig();
        try {
            Object obj;
            HashMap map;
            if (!StringUtils.isEmpty((String)pageParamConfig) && null != (map = JSONUtils.convertJsonToObject(ctx, PageConfigParamManager.trimAllSpace(pageParamConfig))) && null != (obj = map.get("perm")) && obj instanceof Map) {
                Map param = (Map)obj;
                configParam.setAdminOrgFieldSet(PageConfigParamManager.convertStrToSet((String)param.get(ADMINORGFIELD)));
                configParam.setHrOrgFieldSet(PageConfigParamManager.convertStrToSet((String)param.get(HRORGFIELD)));
                configParam.setDefaultManage((String)param.get(DEFAULTMANAGEFIELD));
                configParam.setCheckMode((String)param.get(CHECKMODEFIELD));
                configParam.setCheckRule((String)param.get(CHECKRULEFIELD));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return configParam;
    }

    private static String trimAllSpace(String pageParamConfig) {
        return pageParamConfig.replace(" ", "");
    }

    public static Set<String> convertStrToSet(String value) {
        HashSet<String> valueSet = new HashSet<String>();
        if (!StringUtils.isEmpty((String)value)) {
            String[] arr;
            for (String id : arr = value.split(",")) {
                valueSet.add(id);
            }
        }
        return valueSet;
    }

    public static String convertSetToStr(Set<String> valueSet) {
        if (null == valueSet || valueSet.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (String value : valueSet) {
            buffer.append(value).append(",");
        }
        StringBuilder deleteChar = buffer.deleteCharAt(buffer.length() - 1);
        return deleteChar.toString();
    }

    public static boolean isClientCheckMode(PageConfigParam pcp) {
        String checkMode = PageConfigParamManager.getCheckModeFieldName(pcp);
        return "client".equalsIgnoreCase(checkMode);
    }

    public static boolean isServerCheckMode(PageConfigParam pcp) {
        String checkMode = PageConfigParamManager.getCheckModeFieldName(pcp);
        return "server".equalsIgnoreCase(checkMode);
    }

    public static boolean isNeedbuildDataModel(PageConfigParam pcp) {
        return !CollectionUtils.isEmpty(pcp.getAdminOrgFieldSet()) || !CollectionUtils.isEmpty(pcp.getHrOrgFieldSet());
    }
}

