/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.permission.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.shr.base.permission.IPRuleConfigUiview;
import com.kingdee.shr.base.permission.PRuleConfigUiviewCollection;
import com.kingdee.shr.base.permission.PRuleConfigUiviewFactory;
import com.kingdee.shr.base.permission.PRuleConfigUiviewInfo;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.permission.data.IShrCheckDataPermissionService;
import com.kingdee.shr.base.syssetting.permission.data.PermissionRuleConfigBean;
import com.kingdee.shr.base.syssetting.util.SHRPermissionWebUtils;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.web.servlet.ModelAndView;

public class ShrCheckDataPermissionUtil {
    private static Logger logger = Logger.getLogger(ShrCheckDataPermissionUtil.class);

    private static SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("uiview.id"));
        selector.add(new SelectorItemInfo("uiview.uipk"));
        selector.add(new SelectorItemInfo("shruicode"));
        selector.add(new SelectorItemInfo("config"));
        selector.addObjectCollection((IObjectCollection)ShrCheckDataPermissionUtil.getRuleConfigSelector());
        return selector;
    }

    private static SelectorItemCollection getRuleConfigSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("pRule.id"));
        selector.add(new SelectorItemInfo("pRule.number"));
        selector.add(new SelectorItemInfo("pRule.name"));
        selector.add(new SelectorItemInfo("pRule.config"));
        selector.add(new SelectorItemInfo("pRule.isPreset"));
        selector.add(new SelectorItemInfo("pRule.checker"));
        selector.add(new SelectorItemInfo("pRule.proKeys"));
        return selector;
    }

    public static void initUIViewInfoPermissionConfig(Context ctx, UIViewInfo uiViewInfo) throws SHRWebException {
        try {
            IPRuleConfigUiview iPRuleConfigUiview = PRuleConfigUiviewFactory.getLocalInstance((Context)ctx);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("uiview.id", (Object)uiViewInfo.getId()));
            entityViewInfo.setFilter(filter);
            entityViewInfo.setSelector(ShrCheckDataPermissionUtil.getSelector());
            PRuleConfigUiviewCollection coll = iPRuleConfigUiview.getPRuleConfigUiviewCollection(entityViewInfo);
            if (coll != null && coll.size() > 0) {
                HashMap<String, PermissionRuleConfigBean> permissionRule = new HashMap<String, PermissionRuleConfigBean>();
                int total = coll.size();
                for (int i = 0; i < total; ++i) {
                    PRuleConfigUiviewInfo info = coll.get(i);
                    ShrCheckDataPermissionUtil.convertPermissionRuleConfigBean(ctx, info, permissionRule);
                }
                uiViewInfo.setPermissionRule(permissionRule);
            } else {
                uiViewInfo.setPermissionRule(null);
            }
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
    }

    public static String getKey(String uipk, String shruicode) {
        StringBuilder key = new StringBuilder();
        key.append(uipk);
        if (!StringUtils.isEmpty((String)shruicode)) {
            key.append("&").append(shruicode);
        }
        return key.toString();
    }

    private static void convertPermissionRuleConfigBean(Context ctx, PRuleConfigUiviewInfo info, Map<String, PermissionRuleConfigBean> permissionRule) throws SHRWebException {
        String key = ShrCheckDataPermissionUtil.getKey(info.getUiview().getUipk(), info.getShruicode());
        if (permissionRule.containsKey(key)) {
            return;
        }
        PermissionRuleConfigBean bean = new PermissionRuleConfigBean();
        bean.setShruicode(info.getShruicode());
        bean.setUipk(info.getUiview().getUipk());
        String checker = null;
        Map fieldConfig = null;
        Map ruleConfig = null;
        if (null != info.getPRuleExt()) {
            checker = info.getPRuleExt().getChecker();
            if (!StringUtils.isEmpty((String)info.getConfigExt())) {
                fieldConfig = JSONUtils.convertJsonToObject(ctx, info.getConfigExt());
            }
            if (!StringUtils.isEmpty((String)info.getPRuleExt().getConfig())) {
                ruleConfig = JSONUtils.convertJsonToObject(ctx, info.getPRuleExt().getConfig());
            }
        } else if (null != info.getPRule()) {
            checker = info.getPRule().getChecker();
            if (!StringUtils.isEmpty((String)info.getConfig())) {
                fieldConfig = JSONUtils.convertJsonToObject(ctx, info.getConfig());
            }
            if (!StringUtils.isEmpty((String)info.getPRule().getConfig())) {
                ruleConfig = JSONUtils.convertJsonToObject(ctx, info.getPRule().getConfig());
            }
        }
        if (fieldConfig == null) {
            fieldConfig = Collections.EMPTY_MAP;
        }
        if (ruleConfig == null) {
            ruleConfig = Collections.EMPTY_MAP;
        }
        bean.setChecker(checker);
        bean.setFieldConfig(fieldConfig);
        bean.setRuleConfig(ruleConfig);
        permissionRule.put(key, bean);
    }

    public static void callIShrCheckDataPermissionService(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws SHRWebException {
        if (ShrCheckDataPermissionUtil.checkIsShrWfButNoPermitemPermission(request)) {
            return;
        }
        String operateState = (String)request.getAttribute("operateState");
        if (!"ADDNEW".equals(operateState)) {
            String uipk = request.getParameter("uipk");
            uipk = SHRPermissionWebUtils.getRealUipk(uipk);
            Context ctx = SHRContext.getInstance().getContext();
            UIViewInfo uiview = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
            if (null != uiview && ("core".equals(uiview.getType()) || "form".equals(uiview.getType()) || "wizard".equals(uiview.getType()) || "dynamicForm".equals(uiview.getType()))) {
                ShrCheckDataPermissionUtil.callIShrCheckDataPermissionService(ctx, uiview, request, modelAndView.getModel().get("model"));
            }
        }
    }

    public static void callIShrCheckDataPermissionService(Context ctx, UIViewInfo uiViewInfo, HttpServletRequest request, Object model) throws SHRWebException {
        if (null != uiViewInfo && null != uiViewInfo.getPermissionRule()) {
            String shruicode = (String)request.getAttribute("shruicode");
            String uipk = request.getParameter("uipk");
            uipk = SHRPermissionWebUtils.getRealUipk(uipk);
            String key = ShrCheckDataPermissionUtil.getKey(uipk, shruicode);
            String key0 = ShrCheckDataPermissionUtil.getKey(uipk, null);
            PermissionRuleConfigBean bean = null;
            if (uiViewInfo.getPermissionRule().containsKey(key)) {
                bean = uiViewInfo.getPermissionRule().get(key);
            } else if (uiViewInfo.getPermissionRule().containsKey(key0)) {
                bean = uiViewInfo.getPermissionRule().get(key0);
            }
            if (null == bean) {
                return;
            }
            IShrCheckDataPermissionService iShrCheckDataPermissionService = ShrCheckDataPermissionUtil.getIShrCheckDataPermissionService(bean);
            if (null != iShrCheckDataPermissionService) {
                iShrCheckDataPermissionService.checkDataPermission(request, ctx, bean.getFieldConfig(), bean.getRuleConfig(), model);
            }
        }
    }

    public static final boolean checkIsShrWfButNoPermitemPermission(HttpServletRequest request) {
        String uipk = request.getParameter("uipk");
        if (StringUtils.isEmpty((String)(uipk = SHRPermissionWebUtils.getRealUipk(uipk)))) {
            return false;
        }
        String billId = ShrCheckDataPermissionUtil.getBillId(request);
        String msgId = request.getParameter("msgId");
        Map shrWfInProcess = (Map)request.getSession().getAttribute("SHR_WF_IN_PROCESS");
        Map shrWfFinished = (Map)request.getSession().getAttribute("SHR_WF_FINISHED");
        Map shrWfCirculation = (Map)request.getSession().getAttribute("SHR_WF_CIRCULATION");
        Map myShrWfInOrFinished = (Map)request.getSession().getAttribute("MY_SHR_WF_INORFINISHED");
        Context ctx = SHRContext.getInstance().getContext();
        if (ShrCheckDataPermissionUtil.sessionDataCheckHandler(ctx, shrWfInProcess, uipk, billId, "shrWfInProcess")) {
            return true;
        }
        if (ShrCheckDataPermissionUtil.sessionDataCheckHandler(ctx, shrWfFinished, uipk, billId, "shrWfFinished")) {
            return true;
        }
        if (ShrCheckDataPermissionUtil.sessionDataCheckHandler(ctx, shrWfCirculation, uipk, msgId, "shrWfCirculation")) {
            return true;
        }
        return ShrCheckDataPermissionUtil.sessionDataCheckHandler(ctx, myShrWfInOrFinished, uipk, billId, "myShrWfInOrFinished");
    }

    public static final boolean sessionDataCheckHandler(Context ctx, Map<String, Set<String>> sessionMap, String uipk, String billID, String key) {
        if (null != sessionMap) {
            Set<String> idSet;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("{0} : {1}, current uipk={2}", key, JSONUtils.convertObjectToJson(ctx, sessionMap), uipk));
            }
            if (null != (idSet = sessionMap.get(uipk)) && !StringUtils.isEmpty((String)billID) && idSet.contains(billID)) {
                return true;
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("{0} is empty, current uipk={1}", key, uipk));
        }
        return false;
    }

    public static void sessionDataAddHandler(Map<String, Set<String>> sessionMap, String uipk, String billID) {
        if (null == sessionMap || StringUtils.isEmpty((String)uipk) || StringUtils.isEmpty((String)billID)) {
            return;
        }
        Set<Object> idSet = null;
        if (!sessionMap.containsKey(uipk)) {
            idSet = new HashSet<String>();
            idSet.add(billID);
            sessionMap.put(uipk, idSet);
        } else {
            idSet = sessionMap.get(uipk);
            if (!idSet.contains(billID)) {
                idSet.add(billID);
            }
        }
    }

    public static void sessionDataDeleteHandler(Map<String, Set<String>> sessionMap, String uipk, String billID) {
        if (null == sessionMap || StringUtils.isEmpty((String)uipk) || StringUtils.isEmpty((String)billID)) {
            return;
        }
        if (sessionMap.containsKey(uipk)) {
            Set<String> idSet0 = sessionMap.get(uipk);
            if (null != idSet0 && idSet0.contains(billID)) {
                idSet0.remove(billID);
            }
            if (null != idSet0 && idSet0.isEmpty()) {
                sessionMap.remove(uipk);
            }
        }
    }

    public static String getBillId(HttpServletRequest request) {
        String billId = request.getParameter("billID");
        if (StringUtils.isEmpty((String)billId)) {
            billId = request.getParameter("billId");
        }
        if (StringUtils.isEmpty((String)billId)) {
            billId = (String)request.getAttribute("billId");
        }
        return billId;
    }

    public static String getAssigmentId(HttpServletRequest request) {
        String assigmentId = request.getParameter("assigmentId");
        if (StringUtils.isEmpty((String)assigmentId)) {
            assigmentId = request.getParameter("assignmentID");
        }
        if (StringUtils.isEmpty((String)assigmentId)) {
            assigmentId = (String)request.getAttribute("assigmentId");
        }
        if (StringUtils.isEmpty((String)assigmentId)) {
            assigmentId = (String)request.getAttribute("assignmentID");
        }
        return assigmentId;
    }

    public static String getProcInstId(HttpServletRequest request) {
        String procInstId = request.getParameter("ProcInstId");
        if (StringUtils.isEmpty((String)procInstId)) {
            procInstId = (String)request.getAttribute("ProcInstId");
        }
        return procInstId;
    }

    public static final boolean hasPermissionRuleConfig(HttpServletRequest request) throws SHRWebException {
        String shruicode = (String)request.getAttribute("shruicode");
        String uipk = request.getParameter("uipk");
        uipk = SHRPermissionWebUtils.getRealUipk(uipk);
        UIViewInfo uiviewinfo = UIViewUtil.getUIViewInfoByUIPK(SHRContext.getInstance().getContext(), uipk);
        String key = ShrCheckDataPermissionUtil.getKey(uipk, shruicode);
        if (null != uiviewinfo && null != uiviewinfo.getPermissionRule() && uiviewinfo.getPermissionRule().containsKey(key)) {
            return true;
        }
        key = ShrCheckDataPermissionUtil.getKey(uipk, null);
        return null != uiviewinfo && null != uiviewinfo.getPermissionRule() && uiviewinfo.getPermissionRule().containsKey(key);
    }

    public static FilterInfo getListFilterByPermissionRuleConfig(Context ctx, UIViewInfo uiViewInfo, HttpServletRequest request) throws SHRWebException {
        String shruicode = (String)request.getAttribute("shruicode");
        String uipk = request.getParameter("uipk");
        uipk = SHRPermissionWebUtils.getRealUipk(uipk);
        String key = ShrCheckDataPermissionUtil.getKey(uipk, shruicode);
        String key0 = ShrCheckDataPermissionUtil.getKey(uipk, null);
        PermissionRuleConfigBean bean = null;
        if (null != uiViewInfo && null != uiViewInfo.getPermissionRule() && uiViewInfo.getPermissionRule().containsKey(key)) {
            bean = uiViewInfo.getPermissionRule().get(key);
        } else if (null != uiViewInfo && null != uiViewInfo.getPermissionRule() && uiViewInfo.getPermissionRule().containsKey(key0)) {
            bean = uiViewInfo.getPermissionRule().get(key0);
        }
        if (null == bean) {
            return null;
        }
        IShrCheckDataPermissionService iShrCheckDataPermissionService = ShrCheckDataPermissionUtil.getIShrCheckDataPermissionService(bean);
        if (null != iShrCheckDataPermissionService) {
            return iShrCheckDataPermissionService.getListPermissionFilterInfo(request, ctx, bean.getFieldConfig(), bean.getRuleConfig());
        }
        return null;
    }

    private static IShrCheckDataPermissionService getIShrCheckDataPermissionService(PermissionRuleConfigBean bean) throws SHRWebException {
        if (!StringUtils.isEmpty((String)bean.getChecker())) {
            try {
                Class clazz = MsfClassLoaderFactory.forName((String)bean.getChecker());
                Object obj = clazz.newInstance();
                if (obj instanceof IShrCheckDataPermissionService) {
                    return (IShrCheckDataPermissionService)obj;
                }
            }
            catch (ClassNotFoundException e) {
                throw new SHRWebException(e);
            }
            catch (InstantiationException e) {
                throw new SHRWebException(e);
            }
            catch (IllegalAccessException e) {
                throw new SHRWebException(e);
            }
        }
        return null;
    }
}

