/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.permission.helper.BasePermissionHelper;
import com.kingdee.shr.base.syssetting.action.ActionManager;
import com.kingdee.shr.base.syssetting.action.WebAction;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class PermissionHelper
extends BasePermissionHelper {
    public void checkPermission() {
    }

    public static void checkFunctionPermission(String permItemName, OrgUnitInfo mainOrg) throws BOSException, EASBizException {
        Context uiContext = SHRContext.getInstance().getContext();
        PermissionHelper.checkFunctionPermission((Context)uiContext, (String)permItemName, (OrgUnitInfo)mainOrg);
    }

    public static void checkFunctionPermission(String permItemName) throws BOSException, EASBizException {
        PermissionHelper.checkFunctionPermission(permItemName, null);
    }

    public static void checkActionsPermission(ActionManager actionManager, IMetaDataPK uiMedataPK, OrgUnitInfo mainOrg) throws EASBizException, BOSException {
        if (actionManager == null) {
            return;
        }
        ObjectUuidPK orgPK = null;
        Context uiContext = SHRContext.getInstance().getContext();
        OrgUnitInfo org = mainOrg;
        if (org == null) {
            org = (OrgUnitInfo)uiContext.get((Object)OrgType.ControlUnit);
        }
        if (org != null) {
            orgPK = new ObjectUuidPK(org.getId());
        }
        ObjectUuidPK userPK = null;
        CoreBaseInfo user = (CoreBaseInfo)uiContext.get((Object)"UserInfo");
        if (user != null) {
            userPK = new ObjectUuidPK(user.getId());
        }
        for (WebAction action : actionManager.getActionSet().values()) {
            MetaDataPK actionPK = MetaDataPK.create((String)action.getName());
            try {
                PermissionHelper.checkActionPermission((Context)uiContext, (IObjectPK)userPK, (IObjectPK)orgPK, (IMetaDataPK)uiMedataPK, (IMetaDataPK)actionPK);
                action.setVisible(true);
            }
            catch (PermissionException perm) {
                action.setVisible(false);
            }
        }
    }

    public static void checkActionsPermission(ActionManager actionManager, IMetaDataPK uiMedataPK) throws EASBizException, BOSException {
        PermissionHelper.checkActionsPermission(actionManager, uiMedataPK, null);
    }

    public static void checkUIPermission(IMetaDataPK uiMedataPK) throws EASBizException, BOSException {
        PermissionHelper.checkUIPermission(uiMedataPK, null);
    }

    public static void checkUIPermission(IMetaDataPK uiMedataPK, OrgUnitInfo mainOrg) throws EASBizException, BOSException {
        Context uiContext = SHRContext.getInstance().getContext();
        PermissionHelper.checkUIPermission((Context)uiContext, (IMetaDataPK)uiMedataPK, (OrgUnitInfo)mainOrg);
    }

    public static FieldPermission getQueryFieldPermission(IMetaDataPK queryPK, IObjectPK userPK, IObjectPK orgPK) throws BOSException, EASBizException {
        String keyStr = StringUtils.cnulls((Object)queryPK) + StringUtils.cnulls((Object)orgPK);
        FieldPermission retFieldPermission = null;
        Context ctx = SHRContext.getInstance().getContext();
        Object obj = SHRContext.getSessionContext().get("fieldPermission");
        Map fieldMap = null;
        if (obj == null) {
            fieldMap = new HashMap();
        } else if (obj instanceof Map) {
            fieldMap = (Map)obj;
        }
        SHRContext.getSessionContext().put("fieldPermission", fieldMap);
        if (fieldMap != null && fieldMap.containsKey(keyStr)) {
            retFieldPermission = (FieldPermission)fieldMap.get(keyStr);
        } else {
            IPermission perm = PermissionFactory.getLocalInstance((Context)ctx);
            FieldPermission fieldPermission = perm.getQueryFieldPermission(queryPK, userPK, orgPK);
            retFieldPermission = PermissionHelper.insertCache(keyStr, fieldPermission);
        }
        return (FieldPermission)retFieldPermission.clone();
    }

    private static FieldPermission insertCache(String keyStr, FieldPermission fieldPermission) {
        Map fieldMap = (Map)SHRContext.getSessionContext().get("fieldPermission");
        if (fieldPermission == null || fieldPermission.isEmpty()) {
            fieldMap.put(keyStr, FIELDPERMISSION_EMPTY);
        } else {
            fieldMap.put(keyStr, fieldPermission);
        }
        return (FieldPermission)fieldMap.get(keyStr);
    }

    public static FieldPermission getFieldPermission(BOSObjectType bizObjectType, IObjectPK userPK, IObjectPK orgPK) throws BOSException, EASBizException {
        String keyStr = StringUtils.cnulls((Object)bizObjectType) + StringUtils.cnulls((Object)orgPK);
        FieldPermission retFieldPermission = null;
        Context ctx = SHRContext.getInstance().getContext();
        Object obj = SHRContext.getSessionContext().get("fieldPermission");
        Map fieldMap = null;
        if (obj == null) {
            fieldMap = new HashMap();
        } else if (obj instanceof Map) {
            fieldMap = (Map)obj;
        }
        SHRContext.getSessionContext().put("fieldPermission", fieldMap);
        if (fieldMap != null && fieldMap.containsKey(keyStr)) {
            retFieldPermission = (FieldPermission)fieldMap.get(keyStr);
        } else {
            IPermission perm = PermissionFactory.getLocalInstance((Context)ctx);
            FieldPermission fieldPermission = perm.getFieldPermission(bizObjectType, userPK, orgPK);
            retFieldPermission = PermissionHelper.insertCache(keyStr, fieldPermission);
        }
        return (FieldPermission)retFieldPermission.clone();
    }
}

