/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.controller;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.DefaultDesktopEnum;
import com.kingdee.shr.base.syssetting.IUserSetting;
import com.kingdee.shr.base.syssetting.UserSettingCollection;
import com.kingdee.shr.base.syssetting.UserSettingFactory;
import com.kingdee.shr.base.syssetting.UserSettingInfo;
import com.kingdee.shr.base.syssetting.WorkPlatformInfo;
import com.kingdee.shr.base.syssetting.annotation.Action;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.core.WebPageController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.util.SHRUserCheckUtils;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.base.syssetting.web.util.WorkPlatformUtils;
import com.kingdee.shr.guilogin.SHRLoginUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"main"})
public class MainController
extends WebPageController {
    @Override
    public String initalizeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        if (ctx == null) {
            return "/shr/gui/logout";
        }
        boolean isCheckPasswordPolicy = SHRLoginUtil.isBaseDBUserAuthPatternByContext((Context)ctx);
        if (isCheckPasswordPolicy && SHRUserCheckUtils.checkPasswordPolicy(ctx, request)) {
            return "/shr/gui/passwordPolicyCheck";
        }
        super.initalizeAction(request, response, modelMap);
        return "redirect:" + this.getRedirectPage(request, ctx, null);
    }

    @RequestMapping(params={"method=saveDesktopSet"})
    @Action
    protected String saveDesktopSetAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, BOSException, EASBizException {
        Context ctx = SHRContext.getInstance().getContext();
        IUserSetting userSetting = UserSettingFactory.getRemoteInstance();
        UserSettingInfo setinfo = new UserSettingInfo();
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user", (Object)user.getId().toString(), CompareType.EQUALS));
        userSetting.delete(filterInfo);
        String desktopSet = request.getParameter("desktopSet");
        setinfo.setUser(user);
        setinfo.setDefaultDesktop(DefaultDesktopEnum.getEnum((String)desktopSet));
        userSetting.save((CoreBaseInfo)setinfo);
        JSONUtils.SUCCESS(true);
        return null;
    }

    @RequestMapping(params={"method=getDesktopSet"})
    @Action
    protected String getDesktopSetAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, BOSException, EASBizException {
        Context ctx = SHRContext.getInstance().getContext();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("defaultDesktop"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user", (Object)userId, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        UserSettingCollection collection = UserSettingFactory.getRemoteInstance().getUserSettingCollection(viewInfo);
        if (collection.size() > 0) {
            JSONUtils.SUCCESS(collection.get(0).getDefaultDesktop().getValue());
        } else {
            JSONUtils.SUCCESS("1");
        }
        return null;
    }

    private String getRedirectPage(HttpServletRequest request, Context ctx, UserInfo userInfo) throws ShrWebBizException {
        try {
            WorkPlatformInfo redirectWorkPlatform = WorkPlatformUtils.getUserRedirectWorkPlatform(request, ctx, userInfo);
            return redirectWorkPlatform.getUrl();
        }
        catch (Exception e) {
            throw new ShrWebBizException(e.getMessage());
        }
    }

    private boolean isPersonal(UserInfo userInfo) {
        Context ctx = SHRContext.getInstance().getContext();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("defaultDesktop"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user", (Object)userId, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        boolean isPersonal = true;
        try {
            UserSettingCollection collection = UserSettingFactory.getRemoteInstance().getUserSettingCollection(viewInfo);
            isPersonal = collection.size() <= 0 || !collection.get(0).getDefaultDesktop().getValue().equals("0");
            if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() == null) {
                isPersonal = false;
            }
        }
        catch (BOSException e) {
            this.logger.error((Object)e.getMessage());
        }
        return isPersonal;
    }
}

