/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.controller;

import com.grapecity.documents.excel.IWorksheet;
import com.grapecity.documents.excel.IWorksheets;
import com.grapecity.documents.excel.Workbook;
import com.kingdee.shr.base.syssetting.annotation.Action;
import com.kingdee.shr.base.syssetting.core.WebComponentController;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import java.io.File;
import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/previewexcel"})
public class PreViewExcelController
extends WebComponentController {
    private static Logger logger = Logger.getLogger(PreViewExcelController.class);

    @Action
    @RequestMapping(params={"method=preview"}, method={RequestMethod.GET})
    public void preview(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) {
        String fileName = request.getParameter("fileName");
        String tmpPath = request.getParameter("tmpPath");
        String filePath = MessageFormat.format("{0}{1}{2}{3}{4}", SHRSyssettingUtil.getShrWebWarTmpPath(), File.separator, tmpPath, File.separator, fileName);
        try {
            Workbook workbook = new Workbook();
            workbook.open(SHRCheck.checkFilePath((String)filePath));
            workbook.calculate();
            String jsonstr = null;
            if (null == request.getParameter("ext")) {
                jsonstr = workbook.toJson();
            } else {
                int maxColumnCount = 0;
                IWorksheets worksheets = workbook.getWorksheets();
                for (IWorksheet worksheet : worksheets) {
                    int columnCount;
                    if (null == worksheet.getUsedRange() || (columnCount = worksheet.getUsedRange().getColumnCount() + 26) <= maxColumnCount) continue;
                    maxColumnCount = columnCount;
                }
                StringBuilder sbStr = new StringBuilder();
                sbStr.append("{\"wbJson\": " + workbook.toJson());
                sbStr.append(", \"colunmName\": [");
                StringBuilder colunmStr = new StringBuilder();
                for (int i = 0; i < maxColumnCount; ++i) {
                    colunmStr.append(",\"").append(PreViewExcelController.getLetter(i)).append("\"");
                }
                if (colunmStr.length() > 0) {
                    sbStr.append(colunmStr.substring(1));
                }
                sbStr.append("]}");
                jsonstr = sbStr.toString();
            }
            JSONUtils.writeJson(response, jsonstr);
        }
        catch (Exception e) {
            JSONUtils.ERROR("preview excel error");
            logger.error((Object)"preview excel error", (Throwable)e);
        }
    }

    private static String getLetter(int index) {
        String colCode = "";
        char key = 'A';
        int loop = index / 26;
        if (loop > 0) {
            colCode = colCode + PreViewExcelController.getLetter(loop - 1);
        }
        key = (char)(key + index % 26);
        colCode = colCode + key;
        return colCode;
    }
}

