/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.dynamic.view.converter;

import com.kingdee.bos.Context;
import com.kingdee.shr.base.syssetting.UIType;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.model.CoreUIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FormUIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.view.converter.CoreUIViewConverter;
import com.kingdee.shr.base.syssetting.web.handler.EditHandler;
import com.kingdee.shr.base.syssetting.web.handler.MultiRowHandler;
import com.kingdee.shr.base.syssetting.web.handler.SingleRowHandler;
import com.kingdee.shr.base.syssetting.web.handler.TreeEditHandler;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class FormUIViewConverter
extends CoreUIViewConverter {
    public FormUIViewConverter(UIViewInfo dbUIViewInfo, Context ctx) {
        super(dbUIViewInfo, ctx);
    }

    @Override
    protected String getPageTitle(String viewTitle) {
        return viewTitle + UIType.form.getAlias();
    }

    @Override
    protected void assembleViewInfo(Element root, CoreUIViewInfo viewInfo) throws SHRWebException {
        this.setMultiRow(root, viewInfo);
        super.assembleViewInfo(root, viewInfo);
        this.setRequireAudit(root, viewInfo);
        this.setEditGridSorterItems(root, viewInfo);
        this.setSchemeNum(root, viewInfo);
        this.setSearchView(root, viewInfo);
    }

    private void setEditGridSorterItems(Element root, CoreUIViewInfo viewInfo) {
        Element element = this.getElement(root, "editGrid");
        if (element != null) {
            viewInfo.setHasEditGrid(true);
            String sorterItems = element.getAttributeValue("sorterItems");
            if (!StringUtils.isEmpty((String)sorterItems)) {
                viewInfo.setOrderBy(sorterItems);
            }
        }
    }

    private void setSchemeNum(Element root, CoreUIViewInfo viewInfo) {
        Element element = this.getElement(root, "singleRow");
        if (element != null) {
            FormUIViewInfo formUIViewInfo = (FormUIViewInfo)viewInfo;
            Attribute attribute = element.getAttribute("schemeNum");
            if (null == attribute) {
                return;
            }
            String schemeNum = attribute.getValue();
            if (!StringUtils.isEmpty((String)schemeNum)) {
                formUIViewInfo.setSchemeNum(schemeNum);
            }
        }
    }

    private void setSearchView(Element root, CoreUIViewInfo viewInfo) {
        Element element = this.getElement(root, "searchView");
        if (element != null) {
            viewInfo.setSearchView(element.getAttributeValue("uipk"));
            element.detach();
        }
    }

    private void setMultiRow(Element root, CoreUIViewInfo viewInfo) {
        Element element = this.getElement(root, "multiRow");
        if (element == null) {
            return;
        }
        viewInfo.setMultiRow(true);
        String sorterItems = element.getAttributeValue("sorterItems");
        if (!StringUtils.isEmpty((String)sorterItems)) {
            viewInfo.setOrderBy(sorterItems);
        }
    }

    private void setRequireAudit(Element root, CoreUIViewInfo viewInfo) {
        FormUIViewInfo formUIViewInfo = (FormUIViewInfo)viewInfo;
        if (formUIViewInfo.isMultiRow()) {
            Element element = this.getElement(root, "requireAudit");
            if (element == null) {
                return;
            }
            String value = element.getAttributeValue("value");
            if (StringUtils.isEmpty((String)value)) {
                value = element.getText();
            }
            formUIViewInfo.setRequireAudit(Boolean.parseBoolean(value));
            element.detach();
        } else {
            for (FieldInfo fieldInfo : formUIViewInfo.getFields()) {
                if (!fieldInfo.isRequireAudit()) continue;
                formUIViewInfo.setRequireAudit(true);
                break;
            }
        }
        Element e = this.getElement(root, "photo");
        if (null != e) {
            formUIViewInfo.setPhotoRequireAudit("true".equalsIgnoreCase(e.getAttributeValue("requireAudit")));
        }
    }

    @Override
    protected String getFrameworkJSClass(Element root, CoreUIViewInfo viewInfo) {
        String jsClass = null;
        Element element = this.getElement(root, "singleRow");
        jsClass = element != null ? "shr.framework.SingleRow" : (viewInfo.isMultiRow() ? "shr.framework.MultiRow" : "shr.framework.Edit");
        return jsClass;
    }

    @Override
    protected String getFrameworkHandler(Element root, CoreUIViewInfo viewInfo) {
        String handler = null;
        Element element = this.getElement(root, "singleRow");
        handler = element != null ? SingleRowHandler.class.getName() : (viewInfo.isMultiRow() ? MultiRowHandler.class.getName() : (this.isTreeBase(viewInfo.getEntityName()) ? TreeEditHandler.class.getName() : EditHandler.class.getName()));
        return handler;
    }

    private boolean isTreeBase(String entityName) {
        String treeEntityName = "com.kingdee.eas.framework.app.TreeBase";
        return MetaDataUtil.asSubEntity(entityName, treeEntityName);
    }

    @Override
    protected List<Element> getDefaultButtons(CoreUIViewInfo viewInfo) throws ShrWebBizException {
        if (viewInfo.isMultiRow()) {
            return null;
        }
        boolean isNeedHistory = MetaDataUtil.isNeedHistory(viewInfo.getEntityName());
        ArrayList<Element> buttons = new ArrayList<Element>();
        Element element = null;
        if (isNeedHistory) {
            element = new Element("button");
            element.setAttribute("name", "change");
            element.setAttribute("caption", SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"change", (Context)this.ctx));
            element.setAttribute("class", "btn-primary");
            element.setAttribute("pageStates", "VIEW");
            element.setAttribute("modelVersion", "current");
            element.setAttribute("isInnerButton", "true");
            buttons.add(element);
            element = new Element("button");
            element.setAttribute("name", "revise");
            element.setAttribute("caption", SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"revise", (Context)this.ctx));
            element.setAttribute("pageStates", "VIEW");
            element.setAttribute("modelVersion", "current");
            element.setAttribute("isInnerButton", "true");
            buttons.add(element);
            element = new Element("button");
            element.setAttribute("name", "viewHistoryRecord");
            element.setAttribute("caption", SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"view_history_record", (Context)this.ctx));
            element.setAttribute("pageStates", "VIEW");
            element.setAttribute("modelVersion", "current");
            element.setAttribute("isInnerButton", "true");
            buttons.add(element);
            element = new Element("button");
            element.setAttribute("name", "reviseHistory");
            element.setAttribute("caption", SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"revise", (Context)this.ctx));
            element.setAttribute("class", "btn-primary");
            element.setAttribute("pageStates", "VIEW");
            element.setAttribute("modelVersion", "history");
            element.setAttribute("historyVersion", "older");
            element.setAttribute("isInnerButton", "true");
            buttons.add(element);
        } else {
            element = new Element("button");
            element.setAttribute("name", "edit");
            element.setAttribute("caption", SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"edit", (Context)this.ctx));
            element.setAttribute("class", "btn-primary");
            element.setAttribute("pageStates", "VIEW");
            element.setAttribute("isInnerButton", "true");
            buttons.add(element);
        }
        element = new Element("button");
        element.setAttribute("name", "save");
        element.setAttribute("caption", SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"save", (Context)this.ctx));
        element.setAttribute("class", "btn-primary");
        element.setAttribute("pageStates", "EDIT,ADDNEW");
        element.setAttribute("isInnerButton", "true");
        buttons.add(element);
        element = new Element("button");
        element.setAttribute("name", "submit");
        element.setAttribute("caption", SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"submit", (Context)this.ctx));
        element.setAttribute("class", "btn-primary");
        element.setAttribute("pageStates", "VIEW,EDIT,ADDNEW");
        element.setAttribute("visible", "false");
        element.setAttribute("isInnerButton", "true");
        buttons.add(element);
        element = new Element("button");
        element.setAttribute("name", "enable");
        element.setAttribute("caption", SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"enable", (Context)this.ctx));
        element.setAttribute("class", "btn-primary");
        element.setAttribute("pageStates", "VIEW");
        element.setAttribute("visible", "false");
        element.setAttribute("isInnerButton", "true");
        buttons.add(element);
        element = new Element("button");
        element.setAttribute("name", "disable");
        element.setAttribute("caption", SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"disable", (Context)this.ctx));
        element.setAttribute("class", "btn-primary");
        element.setAttribute("pageStates", "VIEW");
        element.setAttribute("visible", "false");
        element.setAttribute("isInnerButton", "true");
        buttons.add(element);
        element = new Element("button");
        element.setAttribute("name", "workFlowDiagram");
        element.setAttribute("caption", SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"workflow_diagram", (Context)this.ctx));
        element.setAttribute("pageStates", "VIEW");
        element.setAttribute("visible", "false");
        element.setAttribute("isInnerButton", "true");
        buttons.add(element);
        element = new Element("button");
        element.setAttribute("name", "auditResult");
        element.setAttribute("caption", SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"audit_result", (Context)this.ctx));
        element.setAttribute("pageStates", "VIEW");
        element.setAttribute("visible", "false");
        element.setAttribute("isInnerButton", "true");
        buttons.add(element);
        element = new Element("button");
        element.setAttribute("name", "cancel");
        element.setAttribute("caption", SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"cancel", (Context)this.ctx));
        element.setAttribute("pageStates", "EDIT,ADDNEW");
        element.setAttribute("isInnerButton", "true");
        buttons.add(element);
        if (UIViewUtil.hasDefaultValueSolution(viewInfo.getContent())) {
            element = new Element("button");
            element.setAttribute("name", "saveTemplate");
            element.setAttribute("caption", SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"save_template", (Context)this.ctx));
            element.setAttribute("pageStates", "EDIT,ADDNEW");
            element.setAttribute("isInnerButton", "true");
            buttons.add(element);
        }
        return buttons;
    }

    @Override
    public com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo getUIViewInfo() {
        return new FormUIViewInfo();
    }
}

