/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.filter;

import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.web.filter.sqlinject.SQLInjectionFilterRequestWrapper;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SQLInjectionFilter
implements Filter {
    private static Logger logger = Logger.getLogger(SQLInjectionFilter.class);
    private String uipkWhiteList = "";
    private String[] sqlKeyWord;
    private String[] sqlinjectfilterparams;
    private boolean enableSQLInjectionFilter = true;
    private List<String> uipkWhiteLists = new ArrayList<String>();
    private List<String> customUipkWhiteLists = new ArrayList<String>();
    private static long customUipkWhiteFileLastModify = 0L;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.sqlKeyWord = filterConfig.getInitParameter("sqlKeyWord").split(",");
        this.sqlinjectfilterparams = filterConfig.getInitParameter("sqlinjectfilterparams").split(",");
        this.uipkWhiteList = filterConfig.getInitParameter("uipkWhiteList");
        this.initEnableSQLInjectionFilterValue(filterConfig);
        this.initUipkWhiteList();
        logger.debug((Object)" SQLInjectionFilter init success ");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        SQLInjectionFilterRequestWrapper sqlInjectionFilterRequestWrapper = new SQLInjectionFilterRequestWrapper(httpRequest);
        sqlInjectionFilterRequestWrapper.setSqlKeyword(this.sqlKeyWord);
        sqlInjectionFilterRequestWrapper.setSqlinjectfilterparams(this.sqlinjectfilterparams);
        boolean isIgnoredFilterRequest = this.isIgnoredFilterRequest(httpRequest);
        if (isIgnoredFilterRequest) {
            filterChain.doFilter(request, response);
        } else if (this.enableSQLInjectionFilter) {
            this.readCustominitUipkWhiteList();
            filterChain.doFilter((ServletRequest)sqlInjectionFilterRequestWrapper, (ServletResponse)httpResponse);
        } else {
            logger.warn((Object)" enableSQLInjectionFilter param disable , please check web.xml SQLInjectionFilter ");
            filterChain.doFilter(request, response);
        }
    }

    private boolean isIgnoredFilterRequest(HttpServletRequest request) {
        boolean ingoredRequestByUipk = this.ingoredRequestByUipk(request);
        return ingoredRequestByUipk;
    }

    public boolean ingoredRequestByUipk(HttpServletRequest request) {
        boolean flag = false;
        String uipk = request.getParameter("uipk");
        if (!StringUtils.isEmpty((String)uipk)) {
            if (this.uipkWhiteLists.contains(uipk)) {
                logger.info((Object)(" SQLInjectionFilter isIgnoredFilterRequest, uipk is :  " + SHRCheck.vaildLog((String)uipk)));
                flag = true;
            }
            if (this.customUipkWhiteLists.contains(uipk)) {
                logger.info((Object)(" SQLInjectionFilter isIgnoredFilterRequest, customUipkWhiteLists uipk is :  " + SHRCheck.vaildLog((String)uipk)));
                flag = true;
            }
        }
        return flag;
    }

    public void initEnableSQLInjectionFilterValue(FilterConfig filterConfig) {
        String initParameter = filterConfig.getInitParameter("enableSQLInjectionFilter");
        if (!StringUtils.isEmpty((String)initParameter)) {
            this.enableSQLInjectionFilter = Boolean.valueOf(initParameter);
        }
    }

    public void initUipkWhiteList() {
        if (!StringUtils.isEmpty((String)this.uipkWhiteList)) {
            String[] array = this.uipkWhiteList.split(",");
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                this.uipkWhiteLists.add(array[i].trim());
            }
        }
    }

    private void readCustominitUipkWhiteList() {
        String pattern = "{0}{1}server{2}deploy{3}easweb.ear{4}shr_web.war{5}WEB-INF{6}custom-uipkwhitelist.properties";
        String configFile = MessageFormat.format(pattern, System.getProperty("EAS_HOME"), File.separator, File.separator, File.separator, File.separator, File.separator, File.separator);
        File file = new File(SHRCheck.checkFilePath((String)configFile));
        if (!file.exists()) {
            this.customUipkWhiteLists.clear();
            customUipkWhiteFileLastModify = 0L;
            return;
        }
        if (customUipkWhiteFileLastModify == file.lastModified()) {
            return;
        }
        Properties properties = SQLInjectionFilter.load(configFile);
        String uipkList = String.valueOf(properties.get("uipkWhiteList"));
        String[] uipks = uipkList.split(",");
        this.customUipkWhiteLists.clear();
        for (String uipk : uipks) {
            this.customUipkWhiteLists.add(uipk.trim());
        }
        customUipkWhiteFileLastModify = file.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties load(String configFile) {
        Properties properties = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(SHRCheck.checkFilePath((String)configFile));
            properties.load(is);
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                logger.info((Object)e);
            }
        }
        return properties;
    }

    public void destroy() {
    }
}

