/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.bos.workflow.exception.MissMatchParticipantException;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.ExceptionMessageUtility;
import com.kingdee.eas.util.BizReference;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.base.permission.ShrPermissionException;
import com.kingdee.shr.base.permission.field.form.ShrFieldPermForm;
import com.kingdee.shr.base.syssetting.SHRCommonFacadeFactory;
import com.kingdee.shr.base.syssetting.action.DataPlatformAction;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.permission.button.PageConfigParamManager;
import com.kingdee.shr.base.syssetting.util.LicenseHelper;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.util.SHRPermissionWebUtils;
import com.kingdee.shr.base.syssetting.web.dynamic.context.RenderContext;
import com.kingdee.shr.base.syssetting.web.dynamic.model.PageConfigParam;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.DynamicUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.handler.ICoreHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.base.syssetting.web.plugin.PluginUtil;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.ui.ModelMap;

public class CoreHandler
implements ICoreHandler {
    private static Logger logger = Logger.getLogger(CoreHandler.class);
    protected static final String MODEL_ATTRIBUTE_KEY = "model";
    public static final String UI_OPERATEPARAM_KEY = "operateState";
    public static final String UI_STATUS_ADDNEW = "ADDNEW";
    public static final String UI_STATUS_EDIT = "EDIT";
    public static final String UI_STATUS_VIEW = "VIEW";
    public static final String UI_STATUS_READONLY = "readonly";
    public static final String PRODUCTION_MODE = "productionMode";
    public static final String PRODUCTION_MODE_VALUE = "production";
    private String uipk = null;

    @Override
    public Context getContext() {
        return SHRContext.getInstance().getContext();
    }

    @Override
    public String getShruicode(HttpServletRequest request) {
        return (String)request.getAttribute("shruicode");
    }

    @Override
    public String initalizeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        this.beforeRender(request, response, modelMap);
        return this.getViewName(request);
    }

    protected void beforeRender(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        this.setInitData(request, response, modelMap, (Map)request.getAttribute("view_initData"));
        modelMap.put((Object)"breadcrumbValue", (Object)this.getBreadcrumbValue(request, modelMap));
    }

    protected void setInitData(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, Map<String, Object> initData) throws SHRWebException {
        UIViewInfo uiViewInfo = this.getUIViewInfo(request);
        if (null != uiViewInfo) {
            PageConfigParam pcp = PageConfigParamManager.parsePageConfig2ParamObj(this.getContext(), uiViewInfo);
            initData.put("adminOrgField", PageConfigParamManager.getAdminOrgFieldNameStr(pcp));
            initData.put("hrOrgField", PageConfigParamManager.getHrOrgFieldNameStr(pcp));
            initData.put("isDefaultManage", PageConfigParamManager.getDefaultManageFieldName(pcp));
            initData.put("checkModel", PageConfigParamManager.getCheckModeFieldName(pcp));
        }
    }

    protected String getBreadcrumbValue(HttpServletRequest request, ModelMap modelMap) throws SHRWebException {
        UIViewInfo uiViewInfo = this.getUIViewInfo(request);
        if (uiViewInfo == null) {
            return null;
        }
        return uiViewInfo.getViewTitle();
    }

    protected final String getViewName() throws SHRWebException {
        return "dynamic:" + this.getUIViewInfo().getUipk() + ":" + SHRContext.getInstance().getContext().getLocale().toString();
    }

    protected final String getViewName(HttpServletRequest request) throws SHRWebException {
        return "dynamic:" + this.getUIViewInfo(request).getUipk() + ":" + SHRContext.getInstance().getContext().getLocale().toString();
    }

    protected UIViewInfo getUIViewInfo() throws SHRWebException {
        if (StringUtils.isEmpty((String)this.uipk)) {
            return UIViewUtil.getCurrentUIViewInfo(SHRContext.getInstance().getRequest());
        }
        return UIViewUtil.getUIViewInfoByUIPK(this.getContext(), this.uipk);
    }

    protected UIViewInfo getUIViewInfo(HttpServletRequest request) throws SHRWebException {
        if (StringUtils.isEmpty((String)this.uipk)) {
            return UIViewUtil.getCurrentUIViewInfo((ServletRequest)request);
        }
        return UIViewUtil.getUIViewInfoByUIPK(this.getContext(), this.uipk);
    }

    protected ICoreBase getBizInterface() throws SHRWebException {
        UIViewInfo viewInfo = this.getUIViewInfo();
        if (viewInfo == null) {
            return null;
        }
        try {
            return MetaDataUtil.getBizInterface(viewInfo.getEntityName());
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
    }

    protected ICoreBase getBizInterface(HttpServletRequest request) throws SHRWebException {
        UIViewInfo viewInfo = this.getUIViewInfo(request);
        if (viewInfo == null) {
            return null;
        }
        try {
            return MetaDataUtil.getBizInterface((Context)SHRContext.getInstance().getContext(), (String)viewInfo.getEntityName());
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
    }

    protected OrgUnitInfo getMainOrgInfo() {
        Context ctx = SHRContext.getInstance().getContext();
        return (OrgUnitInfo)ctx.get((Object)OrgType.ControlUnit);
    }

    protected String getMainOrgId() {
        String orgId;
        OrgUnitInfo mainOrg = this.getMainOrgInfo();
        String string = orgId = mainOrg == null ? "" : mainOrg.getString("id");
        if (orgId == null || orgId.trim().length() == 0) {
            orgId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        return orgId;
    }

    public String deleteAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        this.checkButtonInView(request, "delete");
        return this.doDelete(request, response, modelMap);
    }

    protected final String doDelete(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String billId = this.getBillId(request);
        String[] ids = billId.split(",");
        Context ctx = SHRContext.getInstance().getContext();
        HashSet<String> sucessIds = new HashSet<String>();
        for (int nIndex = 0; nIndex < ids.length; ++nIndex) {
            if (sucessIds.contains(ids[nIndex])) continue;
            try {
                this.runDelete(request, ids[nIndex]);
                this.deleteAttachment(ids[nIndex]);
                sucessIds.add(ids[nIndex]);
                continue;
            }
            catch (EASBizException e) {
                throw new ShrWebBizException(e.getMessage(), e);
            }
            catch (ObjectNotFoundException e) {
                throw new ShrWebBizException(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"data_delete", (Context)ctx));
            }
            catch (ObjectReferedException e) {
                BizReference ref = (BizReference)e.getReferingObject();
                if (ref != null) {
                    throw new ShrWebBizException(SHRWebResource.getString((String)"com.kingdee.eas.common.CommonResource", (String)"isReferedError", (Context)ctx, (Object[])new Object[]{ref.getRefEntityAlias(ctx.getLocale())}), e);
                }
                throw new ShrWebBizException(e.getMessage(), e);
            }
            catch (ShrWebBizException e) {
                throw e;
            }
            catch (BOSException e) {
                throw new SHRWebException(e.getMessage(), e);
            }
        }
        JSONUtils.SUCCESS(billId);
        return null;
    }

    private void deleteAttachment(String boId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("boID", (Object)boId));
        SHRAttachmentExtFactory.getRemoteInstance().delete(filter);
        BoAttchAssoFactory.getRemoteInstance().deleteAllAssociationsByBoID(boId);
    }

    public String batchDeleteAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        return this.doDeleteWithTips(request, response, modelMap);
    }

    protected String doDeleteWithTips(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String billId = this.getBillId(request);
        if (StringUtils.isEmpty((String)billId)) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "id_is_empty"));
        }
        String[] ids = billId.split(",");
        int sucess = 0;
        int failure = 0;
        BatchMessageTipsHeader batchMessageTipsHeader = new BatchMessageTipsHeader();
        HashSet<String> sucessIds = new HashSet<String>();
        for (String id : ids) {
            BatchMessageTipsBody body = new BatchMessageTipsBody();
            body.setId(id);
            if (sucessIds.contains(id)) continue;
            sucessIds.add(id);
            try {
                this.runDelete(request, id);
                this.deleteAttachment(id);
                this.clearCacheByNeed(request, id);
                ++sucess;
                body.setMuitTipsState(Boolean.TRUE.booleanValue());
                body.setMuitTipsMessage(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "operate_success") + "!");
            }
            catch (EASBizException e) {
                ++failure;
                body.setMuitTipsState(Boolean.FALSE.booleanValue());
                body.setMuitTipsMessage(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "operate_fail") + ": " + e.getMessage());
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                ++failure;
                body.setMuitTipsState(Boolean.FALSE.booleanValue());
                if (e instanceof ObjectNotFoundException) {
                    body.setMuitTipsMessage(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "unable_delete"));
                } else if (e instanceof ObjectReferedException) {
                    String errorMessage = ExceptionMessageUtility.getMessage((Throwable)e);
                    body.setMuitTipsMessage(errorMessage);
                } else if (e instanceof ShrWebBizException) {
                    body.setMuitTipsMessage(e.getMessage());
                } else {
                    body.setMuitTipsMessage(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "operate_fail") + "!" + SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "contact_admin"));
                }
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            batchMessageTipsHeader.addResult(body);
        }
        batchMessageTipsHeader.setBillId(billId);
        batchMessageTipsHeader.setFailureCount(failure);
        batchMessageTipsHeader.setSuccessCount(sucess);
        request.setAttribute("res_method_data", (Object)batchMessageTipsHeader);
        JSONUtils.SUCCESS(batchMessageTipsHeader);
        return null;
    }

    protected void runDelete(HttpServletRequest request, String id) throws BOSException, EASBizException, SHRWebException {
        EntityObjectInfo entityObject = MetaDataUtil.getEntityObject(id);
        String entryEntityName = entityObject.getFullName();
        ICoreBase iCoreBase = MetaDataUtil.getBizInterface((Context)SHRContext.getInstance().getContext(), (String)entryEntityName);
        ObjectUuidPK pk = new ObjectUuidPK(id);
        if (iCoreBase == null || !iCoreBase.exists((IObjectPK)pk)) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "unable_delete"));
        }
        iCoreBase.delete((IObjectPK)pk);
    }

    public String enableAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        this.checkButtonInView(request, "enable");
        return this.handleEnable(request, "enable");
    }

    public String disableAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        this.checkButtonInView(request, "disable");
        return this.handleEnable(request, "disable");
    }

    protected final String handleEnable(HttpServletRequest request, String methodName) throws SHRWebException {
        String billId = this.getBillId(request);
        String[] ids = billId.split(",");
        ICoreBase iCoreBase = this.getBizInterface(request);
        Method method = PluginUtil.getPluginMethod(iCoreBase, methodName, billId);
        if (method == null) {
            if ("disable".equals(methodName) || "enable".equals(methodName)) {
                for (String id : ids) {
                    this.doEnableBySql(id, methodName);
                }
                return null;
            }
            throw new ShrWebBizException(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "method_notexist"), iCoreBase.getName(), methodName));
        }
        try {
            for (String id : ids) {
                PluginUtil.invokeMethod(iCoreBase, method, id);
            }
        }
        catch (InvocationTargetException e) {
            throw new ShrWebBizException(e.getTargetException().getMessage(), e);
        }
        catch (Exception e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        this.writeSuccessData(billId);
        return null;
    }

    public void batchEnableAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        this.handleEnableWithTips(request, "enable");
    }

    public void batchDisableAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        this.handleEnableWithTips(request, "disable");
    }

    protected void handleEnableWithTips(HttpServletRequest request, String methodName) throws SHRWebException {
        String billId = this.getBillId(request);
        if (StringUtils.isEmpty((String)billId)) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "id_is_empty"));
        }
        String[] ids = billId.split(",");
        int sucess = 0;
        int failure = 0;
        ICoreBase iCoreBase = this.getBizInterface(request);
        BatchMessageTipsHeader batchMessageTipsHeader = new BatchMessageTipsHeader();
        Method method = PluginUtil.getPluginMethod(iCoreBase, methodName, billId);
        if (method == null) {
            throw new ShrWebBizException(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "method_notexist"), iCoreBase.getName(), methodName));
        }
        for (String id : ids) {
            BatchMessageTipsBody body = new BatchMessageTipsBody();
            body.setId(id);
            try {
                this.handleEnableWithTipsInvokeMethod(iCoreBase, method, id, methodName, body);
                this.clearCacheByNeed(request, id);
                ++sucess;
            }
            catch (InvocationTargetException e) {
                ++failure;
                body.setMuitTipsState(Boolean.FALSE.booleanValue());
                if (e.getTargetException() instanceof EASBizException) {
                    body.setMuitTipsMessage(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "operate_fail") + ": " + e.getTargetException().getMessage());
                } else {
                    body.setMuitTipsMessage(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "operate_fail") + "!" + SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "contact_admin"));
                }
                logger.error((Object)e.getTargetException().getMessage(), e.getTargetException());
            }
            catch (EASBizException e) {
                ++failure;
                body.setMuitTipsState(Boolean.FALSE.booleanValue());
                body.setMuitTipsMessage(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "operate_fail") + ": " + e.getMessage());
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                ++failure;
                body.setMuitTipsState(Boolean.FALSE.booleanValue());
                body.setMuitTipsMessage(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "operate_fail") + "!" + SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "contact_admin"));
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            batchMessageTipsHeader.addResult(body);
        }
        batchMessageTipsHeader.setBillId(billId);
        batchMessageTipsHeader.setFailureCount(failure);
        batchMessageTipsHeader.setSuccessCount(sucess);
        request.setAttribute("res_method_data", (Object)batchMessageTipsHeader);
        this.writeSuccessData(batchMessageTipsHeader);
    }

    protected void handleEnableWithTipsInvokeMethod(ICoreBase iCoreBase, Method method, String id, String methodName, BatchMessageTipsBody body) throws Exception {
        PluginUtil.invokeMethod(iCoreBase, method, id);
        body.setMuitTipsState(Boolean.TRUE.booleanValue());
        body.setMuitTipsMessage(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "operate_success") + "!");
    }

    protected void clearCacheByNeed(HttpServletRequest request, String id) throws SHRWebException {
    }

    private void doEnableBySql(String billId, String math) throws SHRWebException {
        try {
            SHRCommonFacadeFactory.getRemoteInstance().updateEnable(billId, math);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
    }

    protected String getBillId(HttpServletRequest request) throws SHRWebException {
        String billId = request.getParameter("billID");
        if (StringUtils.isEmpty((String)billId)) {
            billId = request.getParameter("billId");
        }
        if (StringUtils.isEmpty((String)billId)) {
            billId = (String)request.getAttribute("billId");
        }
        if (StringUtils.isEmpty((String)billId)) {
            throw new ShrWebBizException(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "is_empty"), "billId"));
        }
        return billId;
    }

    public Map<String, String> getNextPersMap(HttpServletRequest request) {
        HashMap<String, String> perMap = new HashMap<String, String>();
        String nextPers = request.getParameter("nextPers");
        if (nextPers != null && nextPers.length() > 0 && !"\"\"".equals(nextPers)) {
            List nextPersons = (List)JSONUtils.convertJsonToObject(SHRContext.getInstance().getContext(), nextPers, List.class);
            int size = nextPersons.size();
            for (int i = 0; i < size; ++i) {
                String perIDStr = (String)((Map)nextPersons.get(i)).get("value");
                String key = (String)((Map)nextPersons.get(i)).get("key");
                if (perIDStr.length() < 1) continue;
                String[] perIds = perIDStr.split(",");
                ArrayList<String> personIDs = new ArrayList<String>();
                for (int j = 0; j < perIds.length; ++j) {
                    personIDs.add(perIds[j]);
                }
                perMap.put(key, (String)((Object)personIDs));
            }
        }
        return perMap;
    }

    public void setNextActivityPerformer(Map perMap, CoreBaseInfo model) throws IOException {
        if (perMap != null && !perMap.isEmpty()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(perMap);
            oos.flush();
            oos.close();
            byte[] valueByteArray = baos.toByteArray();
            String result = StringUtils.byteArrayToString((byte[])valueByteArray);
            model.setExtendedProperty("DesignateNextActivityPerformerWhenSubmit", result);
        }
    }

    public String submitAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        try {
            CoreBaseInfo model = (CoreBaseInfo)request.getAttribute("dynamic_model");
            String operateState = this.getOperateStatus(request, modelMap);
            if (UI_STATUS_VIEW.equalsIgnoreCase(operateState)) {
                model = this.getValue(request, model.getId().toString());
            }
            this.beforeSubmit(request, response, model);
            Map<String, String> perMap = this.getNextPersMap(request);
            this.setNextActivityPerformer(perMap, model);
            if (UI_STATUS_ADDNEW.equalsIgnoreCase(operateState)) {
                model.setExtendedProperty("isAddNew", "isAddNew");
            }
            this.doFieldPermFilterSave(request, model);
            IObjectPK objectPK = this.runSubmit(request, response, model);
            model.setId(BOSUuid.read((String)objectPK.toString()));
            this.afterSubmit(request, response, model);
            this.saveAttachment(request, response, model);
            this.writeSuccessData(model.getId().toString());
        }
        catch (MissMatchParticipantException e) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "bill_binded"), e);
        }
        catch (MatchAssignmentException e) {
            if (e.getMessage().indexOf("BizObject aleady in process") >= 0) {
                throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "bill_unable_resubmit"), e);
            }
            throw new ShrWebBizException(e.getMessage(), e);
        }
        catch (Exception exception) {
            if (exception instanceof AlreadyInProcessQueueException) {
                throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "process_inline"), exception);
            }
            throw new ShrWebBizException(exception.getMessage(), exception);
        }
        return null;
    }

    protected void saveAttachment(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws SHRWebException {
        String boID = model.getId().toString();
        Context ctx = SHRContext.getInstance().getContext();
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String uipk = request.getParameter("uipk");
        String fileUUID = request.getParameter("fileUUID");
        if (StringUtils.isEmpty((String)uipk)) {
            return;
        }
        uipk = uipk.split("\\$")[0];
        try {
            String bunding = userId + "#" + uipk;
            if (!StringUtils.isEmpty((String)fileUUID)) {
                bunding = bunding + "#" + fileUUID;
            }
            SHRAttachmentExtFactory.getLocalInstance((Context)ctx).updateAffterSaveForm(boID, bunding);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
    }

    protected IObjectPK runSubmit(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws Exception {
        IObjectPK pk = null;
        this.doBeforeSubmitForWF(request, response, model);
        pk = this.getBizInterface(request).submit(model);
        return pk;
    }

    protected void doBeforeSubmitForWF(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) {
        String assignmentID = request.getParameter("assignmentID");
        if (!StringUtils.isEmpty((String)assignmentID)) {
            model.setExtendedProperty("assignmentID", assignmentID);
        }
    }

    protected void beforeSubmit(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws SHRWebException {
    }

    protected void afterSubmit(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws SHRWebException {
    }

    protected void writeSuccessData(Object object) throws SHRWebException {
        JSONUtils.SUCCESS(object);
    }

    protected void writeErrorData(String message) throws SHRWebException {
        JSONUtils.ERROR(message);
    }

    protected void writeErrorData(String message, Exception exception) throws SHRWebException {
        JSONUtils.ERROR(message, exception);
    }

    public boolean componentIsVisible(RenderContext context, String componentName) {
        return true;
    }

    public void destroyAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String uipk = request.getParameter("uipk");
        if (StringUtils.isEmpty((String)uipk)) {
            return;
        }
        String module = request.getParameter("module");
        LicenseHelper.releaseLicense(uipk, module);
        this.writeSuccessData("release license success");
    }

    public String getUipk() {
        return this.uipk;
    }

    public void setUipk(String uipk) {
        this.uipk = uipk;
    }

    protected String getOperateStatus(HttpServletRequest request, ModelMap modelMap) {
        String operateStatus = "";
        if (modelMap != null) {
            operateStatus = (String)modelMap.get((Object)UI_OPERATEPARAM_KEY);
        }
        if (StringUtils.isEmpty((String)operateStatus)) {
            operateStatus = (String)request.getAttribute(UI_OPERATEPARAM_KEY);
        }
        if (StringUtils.isEmpty((String)operateStatus)) {
            operateStatus = request.getParameter(UI_OPERATEPARAM_KEY);
        }
        return operateStatus;
    }

    protected CoreBaseInfo getValue(HttpServletRequest request, String modelID) throws SHRWebException {
        try {
            SorterItemCollection sorterColl = UIViewUtil.assembleEditGridSorterItemCollection(request);
            if (null != sorterColl && sorterColl.size() > 0) {
                return this.getBizInterface(request).getValue((IObjectPK)new ObjectUuidPK(modelID), this.getSelectors(request), sorterColl);
            }
            return this.getBizInterface(request).getValue((IObjectPK)new ObjectUuidPK(modelID), this.getSelectors(request));
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
    }

    protected SelectorItemCollection getSelectors() throws SHRWebException {
        UIViewInfo viewInfo = this.getUIViewInfo();
        SelectorItemCollection sic = null;
        if (viewInfo != null && (sic = viewInfo.getSelectors()) == null) {
            sic = UIViewUtil.assembleSelector(viewInfo);
            viewInfo.setSelectors(sic);
        }
        return sic;
    }

    protected SelectorItemCollection getSelectors(HttpServletRequest request) throws SHRWebException {
        Object[] reqSelectorObjs;
        Object reqSelectorObj = request.getAttribute("request_selector");
        UIViewInfo viewInfo = this.getUIViewInfo(request);
        if (null != reqSelectorObj && (reqSelectorObjs = (Object[])reqSelectorObj)[0].equals(viewInfo.getUipk())) {
            return (SelectorItemCollection)reqSelectorObjs[1];
        }
        SelectorItemCollection sic = null;
        if (viewInfo != null && (sic = viewInfo.getSelectors()) == null) {
            sic = UIViewUtil.assembleSelector(viewInfo);
            viewInfo.setSelectors(sic);
        }
        return sic;
    }

    protected String getCurrentRequestAdminOrgRangeSQL(HttpServletRequest request) throws SHRWebException {
        return SHRPermissionWebUtils.getCurrentRequestAdminOrgRangeSQL(request);
    }

    protected Set<String> getCurrentRequestAdminOrgRangeIdSet(HttpServletRequest request) throws SHRWebException {
        return SHRPermissionWebUtils.getCurrentRequestAdminOrgRangeIdSet(request);
    }

    protected String getCurrentRequestHROrgRangeInSQL(HttpServletRequest request) throws SHRWebException {
        return SHRPermissionWebUtils.getCurrentRequestHROrgRangeInSQL(request);
    }

    protected String getCurrentRequestHROrgRangeInSQLWithBracket(HttpServletRequest request) throws SHRWebException {
        return SHRPermissionWebUtils.getCurrentRequestHROrgRangeInSQLWithBracket(request);
    }

    protected Set<String> getCurrentRequestHROrgRangeIdSet(HttpServletRequest request) throws SHRWebException {
        return SHRPermissionWebUtils.getCurrentRequestHROrgRangeIdSet(request);
    }

    protected String getCurrentRequestPermItemId(HttpServletRequest request) throws SHRWebException {
        String permItemId = SHRPermissionWebUtils.getCurrentRequestPermItemId(request);
        if (StringUtils.isEmpty((String)permItemId) || "null".equals(permItemId)) {
            permItemId = "";
        }
        return permItemId;
    }

    protected PermItemInfo getCurrentRequestPermItem(HttpServletRequest request) throws SHRWebException {
        Object p = request.getAttribute("current_req_permItem");
        if (null != p && p instanceof PermItemInfo) {
            return (PermItemInfo)p;
        }
        return null;
    }

    protected String getCurrentRequestUserHeadOfDepartmentAdminRangeSQL(HttpServletRequest request) throws SHRWebException {
        return SHRPermissionWebUtils.getCurrentRequestUserHeadOfDepartmentAdminRangeSQL(request);
    }

    protected Set<String> getCurrentRequestUserHeadOfDepartmentAdminRangeSet(HttpServletRequest request) throws SHRWebException {
        return SHRPermissionWebUtils.getCurrentRequestUserHeadOfDepartmentAdminRangeSet(request);
    }

    protected String getMode(HttpServletRequest request) {
        return DynamicUtil.getProductionMode(request);
    }

    protected boolean isProductionMode(HttpServletRequest request) {
        return DynamicUtil.isProductionMode(request);
    }

    protected void doFieldPermFilterSave(HttpServletRequest request, CoreBaseInfo model) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        SelectorItemCollection selector = this.getSelectors(request);
        UIViewInfo uiViewInfo = UIViewUtil.getCurrentUIViewInfo((ServletRequest)request);
        ShrFieldPermForm shrFieldPerm = new ShrFieldPermForm(ctx, selector, uiViewInfo.getEntityName(), uiViewInfo.isHasEditGrid());
        try {
            shrFieldPerm.filterForSave(model);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
    }

    protected String getUipk(HttpServletRequest request) {
        if (!StringUtils.isEmpty((String)this.uipk)) {
            return this.uipk;
        }
        return UIViewUtil.getUipk((ServletRequest)request);
    }

    protected void checkDataPermission(HttpServletRequest request, Object obj) throws SHRWebException {
    }

    protected final void checkHROrgUnitDataPermission(HttpServletRequest request, String hrOrgUnitId) throws SHRWebException {
        try {
            Set<String> hrSets = this.getCurrentRequestHROrgRangeIdSet(request);
            if (null == hrSets || hrSets.isEmpty()) {
                logger.error((Object)"checkHROrgUnitDataPermission getCurrentRequestHROrgRangeIdSet is empty ");
                throw new ShrPermissionException(ShrPermissionException.NO_DATA_PERMISSION);
            }
            if (!hrSets.contains(hrOrgUnitId)) {
                logger.error((Object)("checkHROrgUnitDataPermission getCurrentRequestHROrgRangeIdSet not contains hrOrgUnitId :" + hrOrgUnitId));
                throw new ShrPermissionException(ShrPermissionException.NO_DATA_PERMISSION);
            }
        }
        catch (ShrPermissionException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
    }

    protected final void checkAdminOrgUnitDataPermission(HttpServletRequest request, String adminId) throws SHRWebException {
        try {
            Set<String> adminSets = this.getCurrentRequestAdminOrgRangeIdSet(request);
            if (null == adminSets || adminSets.isEmpty()) {
                logger.error((Object)"checkAdminOrgUnitDataPermission getCurrentRequestAdminOrgRangeIdSet is empty ");
                throw new ShrPermissionException(ShrPermissionException.NO_DATA_PERMISSION);
            }
            if (!adminSets.contains(adminId)) {
                logger.error((Object)("checkAdminOrgUnitDataPermission getCurrentRequestHROrgRangeIdSet not contains adminId :" + adminId));
                throw new ShrPermissionException(ShrPermissionException.NO_DATA_PERMISSION);
            }
        }
        catch (ShrPermissionException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
    }

    protected final void checkOUAndBUOrBuAndEntrust(HttpServletRequest request, String adminOrgId, String hrOrgUnitId, boolean isInnerPerson) throws SHRWebException {
        try {
            if (StringUtils.isEmpty((String)hrOrgUnitId) || StringUtils.isEmpty((String)adminOrgId)) {
                logger.error((Object)"checkOUAndBUOrBuAndEntrust hrOrgUnitId is null or adminOrgId is null ");
                throw new ShrPermissionException(ShrPermissionException.NO_DATA_PERMISSION);
            }
            Set<String> hrSets = this.getCurrentRequestHROrgRangeIdSet(request);
            Set<String> adminSets = this.getCurrentRequestAdminOrgRangeIdSet(request);
            boolean buAndEntrust = false;
            boolean buAndOu = false;
            if (null != hrSets && !hrSets.isEmpty() && hrSets.contains(hrOrgUnitId) && !isInnerPerson) {
                buAndEntrust = true;
            }
            if (null != hrSets && !hrSets.isEmpty() && null != adminSets && !adminSets.isEmpty() && hrSets.contains(hrOrgUnitId) && adminSets.contains(adminOrgId)) {
                buAndOu = true;
            }
            if (buAndEntrust || buAndOu) {
                return;
            }
            throw new ShrPermissionException(ShrPermissionException.NO_DATA_PERMISSION);
        }
        catch (ShrPermissionException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
    }

    protected final void checkOUAndBUOrOuAndEntrustOrBuAndEntrust(HttpServletRequest request, String adminOrgId, String hrOrgUnitId, boolean isInnerPerson) throws SHRWebException {
        try {
            if (StringUtils.isEmpty((String)hrOrgUnitId) || StringUtils.isEmpty((String)adminOrgId)) {
                logger.error((Object)"checkOUAndBUOrBuAndEntrust hrOrgUnitId is null or adminOrgId is null ");
                throw new ShrPermissionException(ShrPermissionException.NO_DATA_PERMISSION);
            }
            Set<String> hrSets = this.getCurrentRequestHROrgRangeIdSet(request);
            Set<String> adminSets = this.getCurrentRequestAdminOrgRangeIdSet(request);
            boolean buAndEntrust = false;
            boolean ouAndEntrust = false;
            boolean buAndOu = false;
            if (null != hrSets && !hrSets.isEmpty() && hrSets.contains(hrOrgUnitId) && !isInnerPerson) {
                buAndEntrust = true;
            }
            if (null != adminSets && !adminSets.isEmpty() && adminSets.contains(adminOrgId) && !isInnerPerson) {
                ouAndEntrust = true;
            }
            if (null != hrSets && !hrSets.isEmpty() && null != adminSets && !adminSets.isEmpty() && hrSets.contains(hrOrgUnitId) && adminSets.contains(adminOrgId)) {
                buAndOu = true;
            }
            if (buAndEntrust || buAndOu || ouAndEntrust) {
                return;
            }
            throw new ShrPermissionException(ShrPermissionException.NO_DATA_PERMISSION);
        }
        catch (ShrPermissionException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
    }

    protected final void checkOUAndBUOrBuAndEntrust(HttpServletRequest request, String adminOrgId, String adminOrgId2, String hrOrgUnitId, boolean isInnerPerson) throws SHRWebException {
        try {
            if (StringUtils.isEmpty((String)hrOrgUnitId) || StringUtils.isEmpty((String)adminOrgId)) {
                logger.error((Object)"checkOUAndBUOrBuAndEntrust hrOrgUnitId is null or adminOrgId is null ");
                throw new ShrPermissionException(ShrPermissionException.NO_DATA_PERMISSION);
            }
            Set<String> hrSets = this.getCurrentRequestHROrgRangeIdSet(request);
            Set<String> adminSets = this.getCurrentRequestAdminOrgRangeIdSet(request);
            boolean buAndEntrust = false;
            boolean buAndOu = false;
            if (null != hrSets && !hrSets.isEmpty() && hrSets.contains(hrOrgUnitId) && !isInnerPerson) {
                buAndEntrust = true;
            }
            if (null != hrSets && !hrSets.isEmpty() && null != adminSets && !adminSets.isEmpty() && hrSets.contains(hrOrgUnitId) && (adminSets.contains(adminOrgId) || adminSets.contains(adminOrgId2))) {
                buAndOu = true;
            }
            if (buAndEntrust || buAndOu) {
                return;
            }
            throw new ShrPermissionException(ShrPermissionException.NO_DATA_PERMISSION);
        }
        catch (ShrPermissionException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
    }

    protected final void checkButtonInView(HttpServletRequest request, String buttonName) throws SHRWebException {
        UIViewInfo uiViewInfo = this.getUIViewInfo(request);
        if (null != uiViewInfo) {
            try {
                if (UIViewUtil.isButtonInView(uiViewInfo, buttonName)) {
                    return;
                }
                throw new ShrPermissionException(ShrPermissionException.NO_FUNCTION_PERMISSION);
            }
            catch (ShrPermissionException e) {
                throw new ShrWebBizException(e.getMessage(), e);
            }
        }
    }

    @Override
    public String dataplatformServiceAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        try {
            Object obj = DataPlatformAction.doPolling(request);
            JSONUtils.writeJson(response, obj);
        }
        catch (ShrWebBizException e) {
            throw e;
        }
        catch (SHRWebException e1) {
            throw e1;
        }
        catch (Exception e2) {
            throw new SHRWebException(e2.getMessage(), e2);
        }
        return null;
    }
}

