/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.handler;

import com.google.gson.internal.LinkedTreeMap;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.bos.workflow.exception.MissMatchParticipantException;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.org.AdminTreeNodeInfo;
import com.kingdee.shr.base.permission.field.list.IShrFieldPermList;
import com.kingdee.shr.base.syssetting.DomainFilterFacadeFactory;
import com.kingdee.shr.base.syssetting.FunctionTypeEnum;
import com.kingdee.shr.base.syssetting.IListSetSolution;
import com.kingdee.shr.base.syssetting.ImportAndExportJsonDataFacadeFactory;
import com.kingdee.shr.base.syssetting.ListSetSolutionFactory;
import com.kingdee.shr.base.syssetting.app.builder.CommonTreeBuilder;
import com.kingdee.shr.base.syssetting.app.builder.ITreeBuilder;
import com.kingdee.shr.base.syssetting.app.builder.OrgUnitTreeBuilder;
import com.kingdee.shr.base.syssetting.app.filter.AdvanceFilterService;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.json.GridDataEntity;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.permission.data.ShrCheckDataPermissionUtil;
import com.kingdee.shr.base.syssetting.permission.expfilter.ExpFilterUtils;
import com.kingdee.shr.base.syssetting.sensitive.DataSensitiveEngineService;
import com.kingdee.shr.base.syssetting.util.HROrgUnitUtil;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.util.NetCtrlHelper;
import com.kingdee.shr.base.syssetting.util.SysSettingSHRBaseItemUtil;
import com.kingdee.shr.base.syssetting.web.controller.DataGridController;
import com.kingdee.shr.base.syssetting.web.dynamic.model.ListUIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.QuerySolutionInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.TreeNavigationInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.CommonGridListSetSolutionHelper;
import com.kingdee.shr.base.syssetting.web.dynamic.util.DynamicUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.util.ExportHelper;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.handler.CoreHandler;
import com.kingdee.shr.base.syssetting.web.handler.IListHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.base.syssetting.web.support.fieldrule.FieldRuleHelper;
import com.kingdee.shr.base.syssetting.web.util.FastFilterUtil;
import com.kingdee.shr.base.syssetting.web.util.UserUtil;
import com.kingdee.shr.base.syssetting.web.util.WebUtil;
import com.kingdee.shr.base.syssetting.web.util.ZipFileDownAndUploadUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.ui.ModelMap;

public class ListHandler
extends CoreHandler
implements IListHandler {
    private AdminTreeNodeInfo rootData;
    private static Logger logger = Logger.getLogger(ListHandler.class);
    protected DataGridController dataGrid = new DataGridController();

    @Override
    public String initalizeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        if (request.getParameter("rootId") != null) {
            modelMap.put((Object)"rootId", (Object)request.getParameter("rootId"));
        }
        return super.initalizeAction(request, response, modelMap);
    }

    @Override
    protected void setInitData(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, Map<String, Object> initData) throws SHRWebException {
        super.setInitData(request, response, modelMap, initData);
        Enumeration names = request.getParameterNames();
        String name = null;
        HashMap<String, String> parameters = new HashMap<String, String>();
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            parameters.put(name, request.getParameter(name));
        }
        initData.put("custom_params", parameters);
    }

    @Override
    public String getListDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        this.prepareQueryList(request, response, modelMap);
        long start = 0L;
        long end = 0L;
        if (logger.isDebugEnabled()) {
            start = new Date().getTime();
        }
        GridDataEntity gridDataEntity = this.getGridRequestData(request, response, modelMap);
        if (logger.isDebugEnabled()) {
            end = new Date().getTime();
            logger.debug((Object)MessageFormat.format("handler: {0}, get list data, cost: {1}", this.getClass().getName(), end - start));
        }
        this.afterGetListData(request, response, gridDataEntity);
        this.doFieldPermFilter(gridDataEntity);
        JSONUtils.writeJson(response, gridDataEntity);
        return null;
    }

    public String getListSumDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        this.prepareQueryList(request, response, modelMap);
        ListUIViewInfo listUIViewInfo = (ListUIViewInfo)this.getUIViewInfo(request);
        List<String> sumCols = listUIViewInfo.getSumColModel();
        HashMap result = new HashMap();
        JSONUtils.writeJson(response, result);
        return null;
    }

    protected GridDataEntity getGridRequestData(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        try {
            return this.dataGrid.getGridRequestData(request, response, modelMap);
        }
        catch (SHRWebException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            if (!StringUtils.isEmpty((String)e.getMessage()) && e.getMessage().indexOf("Please process pk") > -1) {
                String message = e.getMessage().replace("Please process pk", "").replace("at LocalBOSObjectFactory", "").replace("\\", ".");
                throw new ShrWebBizException(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "metadata_not_exist"), message), e);
            }
            throw e;
        }
    }

    protected void prepareQueryList(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String custom_params;
        ListUIViewInfo uiViewInfo = (ListUIViewInfo)this.getUIViewInfo(request);
        Map<String, String> option = null;
        if (uiViewInfo != null) {
            if (uiViewInfo.getQuery() != null) {
                request.setAttribute("query", (Object)uiViewInfo.getQuery());
            } else {
                request.setAttribute("view_model", (Object)uiViewInfo.getModel());
            }
            if (!StringUtils.isEmpty((String)uiViewInfo.getViewTitle())) {
                request.setAttribute("title", (Object)uiViewInfo.getViewTitle());
            }
            option = uiViewInfo.getQueryOption();
        }
        if (!StringUtils.isEmpty((String)(custom_params = request.getParameter("custom_params")))) {
            request.setAttribute("custom_params", (Object)JSONUtils.convertJsonToObject(SHRContext.getInstance().getContext(), custom_params));
        }
        EntityViewInfo defaultEntityViewInfo = this.getDefaultEntityViewInfo(request, response);
        defaultEntityViewInfo.setSelector(this.getSelectors(request));
        modelMap.put((Object)"DataGridEntityView", (Object)defaultEntityViewInfo);
        modelMap.put((Object)"queryOption", option);
    }

    protected Object getRequestParameter(HttpServletRequest request, String key) throws SHRWebException {
        String custom_params;
        Object value = request.getAttribute(key);
        if (value != null) {
            return value;
        }
        Map customParams = (Map)request.getAttribute("custom_params");
        if (customParams == null && !StringUtils.isEmpty((String)(custom_params = request.getParameter("custom_params")))) {
            customParams = JSONUtils.convertJsonToObject(SHRContext.getInstance().getContext(), custom_params);
            request.setAttribute("custom_params", (Object)customParams);
        }
        if (customParams != null && (value = customParams.get(key)) != null) {
            return value;
        }
        return request.getParameter(key);
    }

    protected Map<String, Object> initExportExcelConfig(HttpServletRequest request, ExportHelper helper) throws SHRWebException {
        Map<String, Object> params = helper.assembleHandleParam(request);
        return helper.createExcel(request, params);
    }

    public String exportToExcelAsynAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        this.checkButtonInView(request, "exportToExcelAsyn");
        return this.doExportToExcel(request, response, modelMap);
    }

    public String exportCurrentAsynAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        this.checkButtonInView(request, "exportCurrentAsyn");
        return this.doExportToExcel(request, response, modelMap);
    }

    public String exportCurrentAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        this.checkButtonInView(request, "exportCurrent");
        return this.doExportToExcel(request, response, modelMap);
    }

    public String exportToExcelAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        this.checkButtonInView(request, "exportToExcel");
        return this.doExportToExcel(request, response, modelMap);
    }

    protected final String doExportToExcel(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        this.prepareQueryList(request, response, modelMap);
        ExportHelper helper = !"true".equals(request.getAttribute("asyn")) ? new ExportHelper() : new ExportHelper(true);
        Map<String, Object> excelConfig = this.initExportExcelConfig(request, helper);
        List listData = null;
        String dataString = request.getParameter("datas");
        if (!StringUtils.isEmpty((String)dataString)) {
            listData = (List)JSONUtils.convertJsonToObject(SHRContext.getInstance().getContext(), dataString, List.class);
            this.afterGetExportData(request, response, listData);
            helper.fillData(excelConfig, listData);
        } else {
            this.setFilterBySelectedData(request, modelMap);
            long start = 0L;
            long end = 0L;
            String isAll = request.getParameter("isAll");
            if ("true".equals(isAll)) {
                this.exportAllToExcel(request, response, modelMap, helper, excelConfig);
            } else {
                if (logger.isDebugEnabled()) {
                    start = System.currentTimeMillis();
                }
                if (this.isUserNewExportQueryAll()) {
                    modelMap.put((Object)"isUserNewExportQueryAll", (Object)true);
                }
                GridDataEntity gridDataEntity = this.getGridRequestData(request, response, modelMap);
                this.doFieldPermFilter(gridDataEntity);
                if (logger.isDebugEnabled()) {
                    end = System.currentTimeMillis();
                    logger.debug((Object)MessageFormat.format("handler: {0}, get list data, cost: {1}", this.getClass().getName(), end - start));
                }
                listData = gridDataEntity.getRows();
                this.afterGetExportData(request, response, listData);
                String isSensitive = request.getParameter("isSensitive");
                if ("true".equals(isSensitive)) {
                    Context ctx = SHRContext.getInstance().getContext();
                    DataSensitiveEngineService iDataSensitiveEngineService = new DataSensitiveEngineService(ctx);
                    iDataSensitiveEngineService.convertSensitiveData(listData, this.getUipk(request));
                }
                helper.fillData0(excelConfig, listData);
            }
        }
        String fileName = "";
        fileName = excelConfig.get("isMuti") != null ? helper.writeExcelToFileAndCompress(excelConfig) : helper.writeExcelToFile(request, excelConfig);
        if (StringUtils.isEmpty((String)fileName)) {
            return null;
        }
        if (this.isRequestJSON(request)) {
            if ("true".equals(request.getAttribute("asyn"))) {
                return request.getContextPath() + fileName;
            }
            this.writeSuccessData(fileName);
            return null;
        }
        modelMap.clear();
        try {
            fileName = WebUtil.convertFileNameForDownload(request, fileName);
            return "redirect:" + fileName;
        }
        catch (UnsupportedEncodingException e) {
            throw new SHRWebException(e);
        }
    }

    protected void exportAllToExcel(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, ExportHelper helper, Map<String, Object> excelConfig) throws SHRWebException {
        int columnsSize;
        int pageRow;
        long start = 0L;
        long end = 0L;
        int page = 1;
        int rows = 8000;
        String query = request.getParameter("query");
        if (StringUtils.isEmpty((String)query)) {
            query = (String)request.getAttribute("query");
        }
        UIViewInfo uv = this.getUIViewInfo(request);
        if (StringUtils.isEmpty((String)query) && "list".equals(uv.getType())) {
            rows = 500;
        }
        if ("dynamicList".equals(uv.getType()) && (pageRow = 100000 / (columnsSize = ((List)excelConfig.get("columnModel")).size())) < rows) {
            rows = pageRow;
        }
        List listData = null;
        if (logger.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        Map<String, Boolean> userData = new HashMap<String, Comparable<Boolean>>();
        userData.put("isExportAllToExcelCount", true);
        userData.put("rows", (Boolean)((Object)Integer.valueOf(rows)));
        userData.put("page", (Boolean)((Object)Integer.valueOf(page)));
        boolean isOrderForExportAll = true;
        try {
            String p = ParamManager.getParamValue((Context)SHRContext.getInstance().getContext(), null, (String)"sHRSupportExportOrder");
            if (!"true".equals(p)) {
                isOrderForExportAll = false;
            }
        }
        catch (Exception p) {
            // empty catch block
        }
        userData.put("sHRSupportExportOrder", isOrderForExportAll);
        request.setAttribute("_userData_", userData);
        GridDataEntity gridDataEntity0 = this.getGridRequestData(request, response, modelMap);
        userData = (Map)gridDataEntity0.getUserdata();
        userData.put("isExportAllToExcelCount", false);
        userData.put("isLastTime", false);
        userData.put("sHRSupportExportOrder", isOrderForExportAll);
        long totalCount = gridDataEntity0.getRecords();
        end = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("handler: {0}, gridDataEntity0 , cost: {1}", this.getClass().getName(), end - start));
        }
        if (totalCount <= 0L) {
            helper.fillData0(excelConfig, null);
            return;
        }
        if (totalCount > 1000000L) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "max_over"));
        }
        int fetchTimes = (int)(totalCount / (long)rows) + 1;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("handler: {0},totalCount:{1} fetchTimes:{2},per count: {3}", this.getClass().getName(), totalCount, fetchTimes, rows));
        }
        Context ctx = SHRContext.getInstance().getContext();
        DataSensitiveEngineService iDataSensitiveEngineService = new DataSensitiveEngineService(ctx);
        String strUipk = this.getUipk(request);
        GridDataEntity gridDataEntity = null;
        for (int i = 0; i < fetchTimes; ++i) {
            if (logger.isDebugEnabled()) {
                start = System.currentTimeMillis();
            }
            userData.put("rows", (Boolean)((Object)Integer.valueOf(rows)));
            userData.put("page", (Boolean)((Object)Integer.valueOf(page++)));
            if (i == fetchTimes - 1) {
                userData.put("isLastTime", true);
            }
            request.setAttribute("_userData_", userData);
            start = System.currentTimeMillis();
            gridDataEntity = this.getGridRequestData(request, response, modelMap);
            this.doFieldPermFilter(gridDataEntity);
            listData = gridDataEntity.getRows();
            end = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("exportAllToExcel, getGridRequestData, cost: {0} ms", end - start));
            }
            start = System.currentTimeMillis();
            this.afterGetExportData(request, response, listData);
            end = System.currentTimeMillis();
            String isSensitive = request.getParameter("isSensitive");
            if ("true".equals(isSensitive)) {
                iDataSensitiveEngineService.convertSensitiveData(listData, strUipk);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("exportAllToExcel, afterGetExportData, cost: {0} ms", end - start));
            }
            start = System.currentTimeMillis();
            helper.fillData0(excelConfig, listData);
            end = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("exportAllToExcel, fillData0, cost: {0} ms", end - start));
            }
            listData = null;
            gridDataEntity = null;
        }
    }

    protected final void setFilterBySelectedData(HttpServletRequest request, ModelMap modelMap) {
        String fieldName_key = request.getParameter("fieldName_key");
        if (StringUtils.isEmpty((String)fieldName_key)) {
            return;
        }
        String selectedData = request.getParameter("selectedData");
        StringBuilder sb = new StringBuilder();
        sb.append(fieldName_key);
        sb.append("  in (");
        sb.append("'");
        sb.append(selectedData.replace(",", "','"));
        sb.append("'");
        sb.append(")");
        modelMap.put((Object)"filter", (Object)sb.toString());
    }

    protected final boolean isRequestJSON(HttpServletRequest request) {
        String value = request.getHeader("Accept");
        return value != null && value.contains("application/json");
    }

    protected void afterGetListData(HttpServletRequest request, HttpServletResponse response, GridDataEntity gridDataEntity) throws SHRWebException {
    }

    public void afterGetExportData(HttpServletRequest request, HttpServletResponse response, List listData) throws SHRWebException {
    }

    @Override
    protected SelectorItemCollection getSelectors(HttpServletRequest request) throws SHRWebException {
        UIViewInfo viewInfo = this.getUIViewInfo(request);
        SelectorItemCollection sic = null;
        if (viewInfo != null && (sic = viewInfo.getSelectors()) == null) {
            sic = UIViewUtil.assembleListSelector(SHRContext.getInstance().getContext(), viewInfo);
            viewInfo.setSelectors(sic);
        }
        return sic;
    }

    protected EntityViewInfo getDefaultEntityViewInfo(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        EntityViewInfo defaultViewInfo = new EntityViewInfo();
        FilterInfo botpFilterInfo = this.getBotpFilter(request);
        if (botpFilterInfo != null) {
            defaultViewInfo.setFilter(botpFilterInfo);
            return defaultViewInfo;
        }
        if (logger.isDebugEnabled()) {
            String uipk = this.getUipk();
            logger.debug((Object)("getDefaultEntityViewInfo:" + uipk));
        }
        FilterInfo defaultFilterInfo = this.getDefaultFilter(request, response);
        if (logger.isDebugEnabled()) {
            String msg = defaultFilterInfo != null ? defaultFilterInfo.toSql() : "";
            logger.debug((Object)("defaultFilterInfo:" + msg));
        }
        FilterInfo customFilterInfo = this.getCustomFilter(request, response);
        if (logger.isDebugEnabled()) {
            String msg = customFilterInfo != null ? customFilterInfo.toSql() : "";
            logger.debug((Object)("customFilterInfo:" + msg));
        }
        FilterInfo domainFilterInfo = this.getDomainFilter(request);
        if (logger.isDebugEnabled()) {
            String msg = domainFilterInfo != null ? domainFilterInfo.toSql() : "";
            logger.debug((Object)("domainFilterInfo:" + msg));
        }
        FilterInfo treeDomainFilter = this.getTreeDomainFilter(request);
        if (logger.isDebugEnabled()) {
            String msg = treeDomainFilter != null ? treeDomainFilter.toSql() : "";
            logger.debug((Object)("treeDomainFilter:" + msg));
        }
        FilterInfo fastFilter = this.getFastFilter(request);
        if (logger.isDebugEnabled()) {
            String msg = fastFilter != null ? fastFilter.toSql() : "";
            logger.debug((Object)("fastFilter:" + msg));
        }
        FilterInfo advanceFilter = this.getAdvanceFilter(request);
        if (logger.isDebugEnabled()) {
            String msg = advanceFilter != null ? advanceFilter.toSql() : "";
            logger.debug((Object)("advanceFilter:" + msg));
        }
        FilterInfo fieldCasFilter = this.getFieldCasFilter(request);
        if (logger.isDebugEnabled()) {
            String msg = fieldCasFilter != null ? fieldCasFilter.toSql() : "";
            logger.debug((Object)("fieldCasFilter:" + msg));
        }
        FilterInfo expFilter = this.getExpFilter(request);
        if (logger.isDebugEnabled()) {
            String msg = expFilter != null ? expFilter.toSql() : "";
            logger.debug((Object)("expFilter:" + msg));
        }
        FilterInfo filterInfo = new FilterInfo();
        try {
            filterInfo.mergeFilter(defaultFilterInfo, "AND");
            filterInfo.mergeFilter(customFilterInfo, "AND");
            filterInfo.mergeFilter(domainFilterInfo, "AND");
            filterInfo.mergeFilter(treeDomainFilter, "AND");
            filterInfo.mergeFilter(fastFilter, "AND");
            filterInfo.mergeFilter(advanceFilter, "AND");
            filterInfo.mergeFilter(fieldCasFilter, "AND");
            filterInfo.mergeFilter(expFilter, "AND");
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        defaultViewInfo.setFilter(filterInfo);
        if (logger.isDebugEnabled()) {
            String msg = defaultViewInfo != null ? defaultViewInfo.toString() : "";
            logger.debug((Object)("defaultViewInfo:" + msg));
        }
        return defaultViewInfo;
    }

    protected FilterInfo getExpFilter(HttpServletRequest request) throws SHRWebException {
        UIViewInfo uiviewInfo = this.getUIViewInfo(request);
        boolean isEnableExpFilterReal = false;
        boolean isEnableExpFilterParam = false;
        String isEnableExpFilter = request.getParameter("isEnableExpFilter");
        if (!StringUtils.isEmpty((String)isEnableExpFilter)) {
            isEnableExpFilterParam = Boolean.parseBoolean(isEnableExpFilter);
        }
        if (uiviewInfo.isEnableExpFilter()) {
            isEnableExpFilterReal = isEnableExpFilterParam || StringUtils.isEmpty((String)isEnableExpFilter);
        } else if (isEnableExpFilterParam) {
            isEnableExpFilterReal = true;
        }
        if (isEnableExpFilterReal) {
            try {
                String uipk0 = uiviewInfo.getUipk();
                if (!StringUtils.isEmpty((String)uipk0) && uipk0.indexOf("$") != -1) {
                    uipk0 = uipk0.substring(0, uipk0.indexOf("$"));
                }
                return ExpFilterUtils.getPermssionExpFilterInfo((Context)SHRContext.getInstance().getContext(), (String)uipk0);
            }
            catch (EASBizException e) {
                throw new ShrWebBizException(e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new SHRWebException(e);
            }
        }
        return null;
    }

    protected FilterInfo getDefaultFilter(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        return null;
    }

    protected FilterInfo getFastFilter(HttpServletRequest request) throws SHRWebException {
        String fastFilterItems = request.getParameter("fastFilterItems");
        if (StringUtils.isEmpty((String)fastFilterItems)) {
            if (SysSettingSHRBaseItemUtil.isSHRBaseItem((EntityObjectInfo)MetaDataUtil.getEntityObjectByEntityName(this.getUIViewInfo(request).getEntityName()).getBaseEntity())) {
                return this.getBaseItemFastFilter(request);
            }
            return null;
        }
        HashMap map = JSONUtils.convertJsonToObject(SHRContext.getInstance().getContext(), fastFilterItems);
        if (null == map || map.size() <= 0) {
            if (SysSettingSHRBaseItemUtil.isSHRBaseItem((EntityObjectInfo)MetaDataUtil.getEntityObjectByEntityName(this.getUIViewInfo(request).getEntityName()).getBaseEntity())) {
                return this.getBaseItemFastFilter(request);
            }
            return null;
        }
        FilterInfo filter = null;
        for (Object key : map.keySet()) {
            if (!(map.get(key) instanceof Map)) continue;
            Map subMap = (Map)map.get(key);
            request.setAttribute((String)key, subMap.get("values"));
        }
        filter = SysSettingSHRBaseItemUtil.isSHRBaseItem((EntityObjectInfo)MetaDataUtil.getEntityObjectByEntityName(this.getUIViewInfo(request).getEntityName()).getBaseEntity()) ? this.getBaseItemFastFilter(request) : this.getBusinessFastFilter(request);
        return filter;
    }

    protected FilterInfo getBotpFilter(HttpServletRequest request) throws SHRWebException {
        HashMap customMap;
        String isBotpOperate;
        String customParams = request.getParameter("custom_params");
        if (!StringUtils.isEmpty((String)customParams) && !StringUtils.isEmpty((String)(isBotpOperate = (String)(customMap = JSONUtils.convertJsonToObject(SHRContext.getInstance().getContext(), customParams)).get("botp"))) && isBotpOperate.equals("true")) {
            String botpId = (String)customMap.get("botpId");
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)botpId, CompareType.EQUALS));
            return filter;
        }
        return null;
    }

    protected FilterInfo getAdvanceFilter(HttpServletRequest request) throws SHRWebException {
        String advanceFilterItems = request.getParameter("advancedFilter");
        FilterInfo filter = null;
        if (!StringUtils.isEmpty((String)advanceFilterItems)) {
            AdvanceFilterService advanceFilterService = new AdvanceFilterService(SHRContext.getInstance().getContext());
            filter = advanceFilterService.parse(advanceFilterItems);
        }
        return filter;
    }

    protected FilterInfo getFieldCasFilter(HttpServletRequest request) throws SHRWebException {
        String fieldCasFilterItems = request.getParameter("FieldCasFilter");
        FilterInfo filter = null;
        if (!StringUtils.isEmpty((String)fieldCasFilterItems)) {
            AdvanceFilterService advanceFilterService = new AdvanceFilterService(this.getContext());
            String casFilterString = FieldRuleHelper.getFieldFilter(this.getContext(), fieldCasFilterItems);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("casFilterString:" + casFilterString));
            }
            filter = advanceFilterService.parse(casFilterString);
        }
        return filter;
    }

    protected FilterInfo getBaseItemFastFilter(HttpServletRequest request) throws SHRWebException {
        return null;
    }

    protected FilterInfo getBusinessFastFilter(HttpServletRequest request) throws SHRWebException {
        String fastFilterItems = request.getParameter("fastFilterItems");
        return FastFilterUtil.generateBizFastFilterInfo(fastFilterItems);
    }

    protected FilterInfo getCustomFilter(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        return null;
    }

    public QuerySolutionInfo afterGetDefaultSolutionInfo(HttpServletRequest request, QuerySolutionInfo querySolutionInfo) {
        return querySolutionInfo;
    }

    protected FilterInfo getDomainFilter(HttpServletRequest request) throws SHRWebException {
        ListUIViewInfo uiViewInfo = (ListUIViewInfo)this.getUIViewInfo(request);
        String domain = request.getParameter("domain");
        FilterInfo filter = null;
        FilterInfo permissionFilter = null;
        if (StringUtils.isEmpty((String)domain)) {
            domain = uiViewInfo.getDomain();
        }
        try {
            if (!StringUtils.isEmpty((String)domain)) {
                filter = DomainFilterFacadeFactory.getLocalInstance((Context)this.getContext()).getDomainFilter(uiViewInfo.getEntityName(), domain, this.assembleDomainParams(request));
            }
            permissionFilter = this.getCheckDataPermissionFilter(request, uiViewInfo);
            FilterInfo result = new FilterInfo();
            result.mergeFilter(filter, "AND");
            result.mergeFilter(permissionFilter, "AND");
            return result;
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
    }

    protected final FilterInfo getCheckDataPermissionFilter(HttpServletRequest request, UIViewInfo uiViewInfo) throws SHRWebException {
        if (ShrCheckDataPermissionUtil.hasPermissionRuleConfig(request)) {
            return ShrCheckDataPermissionUtil.getListFilterByPermissionRuleConfig(this.getContext(), uiViewInfo, request);
        }
        return null;
    }

    protected FilterInfo getTreeDomainFilter(HttpServletRequest request) throws SHRWebException {
        return this.getTreeDomainFilter(request, null);
    }

    protected FilterInfo getTreeDomainFilter(HttpServletRequest request, Map<String, String> param) throws SHRWebException {
        String filterName;
        ListUIViewInfo uiViewInfo = (ListUIViewInfo)this.getUIViewInfo(request);
        if (!uiViewInfo.isNavigateList()) {
            return null;
        }
        if (param == null) {
            String str = request.getParameter("tree_params");
            if (StringUtils.isEmpty((String)str)) {
                return null;
            }
            param = JSONUtils.convertJsonToObject(SHRContext.getInstance().getContext(), str);
        }
        if (StringUtils.isEmpty((String)(filterName = uiViewInfo.getTreeDomainFilter()))) {
            filterName = "TreeLongNumberFilter";
        } else if (filterName.startsWith("$")) {
            filterName = filterName.substring(1).trim();
        }
        try {
            param.putAll(this.assembleDomainParams(request));
            return DomainFilterFacadeFactory.getLocalInstance((Context)SHRContext.getInstance().getContext()).getFilter(filterName, uiViewInfo.getQueryFieldName(), (Map)param);
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
    }

    protected String assembleTreeDataUserAdminOrgRangeSQL(HttpServletRequest request) throws SHRWebException {
        return this.getCurrentRequestAdminOrgRangeSQL(request);
    }

    @Override
    public String getTreeDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        try {
            String rootId = request.getParameter("rootId");
            String nodeId = request.getParameter("nodeId");
            if (StringUtils.isEmpty((String)nodeId)) {
                nodeId = (String)request.getAttribute("nodeId");
            }
            Context ctx = SHRContext.getInstance().getContext();
            ListUIViewInfo uiViewInfo = (ListUIViewInfo)this.getUIViewInfo(request);
            ITreeBuilder treeBuilder = this.getTreeBuilder(uiViewInfo);
            HashMap<String, String> params = new HashMap<String, String>();
            this.initTreeDataParams(request, params, uiViewInfo);
            Object result = null;
            boolean isTree = Boolean.parseBoolean(request.getParameter("isTree"));
            if (isTree) {
                params.put("nodeId", rootId);
                params.put("rootAlias", uiViewInfo.getTreeNavigation().getRootAlias());
                result = treeBuilder.getAllNodes(ctx, params);
            } else if (!StringUtils.isEmpty((String)nodeId)) {
                params.put("nodeId", nodeId);
                result = treeBuilder.getChildren(ctx, params);
            } else {
                params.put("nodeId", rootId);
                params.put("rootAlias", uiViewInfo.getTreeNavigation().getRootAlias());
                result = treeBuilder.getRootNode(ctx, params);
            }
            JSONUtils.writeJson(response, result);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage());
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        return null;
    }

    protected void initTreeDataParams(HttpServletRequest request, Map<String, String> params, ListUIViewInfo uiViewInfo) throws SHRWebException {
        String isSealUp = request.getParameter("isSealUp");
        String subLevels = request.getParameter("subLevels");
        String includeSub = request.getParameter("includeSub");
        String userAdminOrgRangeSql = this.assembleTreeDataUserAdminOrgRangeSQL(request);
        String adminOrgHisDate = request.getParameter("adminOrgHisDate");
        params.put("domain", uiViewInfo.getTreeNavigation().getDomain());
        params.put("treeModel", uiViewInfo.getTreeNavigation().getTreeModel());
        params.put("userAdminOrgRangeSql", userAdminOrgRangeSql);
        params.put("isSealUp", isSealUp);
        params.put("subLevels", subLevels);
        params.put("includeSub", includeSub);
        params.put("adminOrgHisDate", adminOrgHisDate);
    }

    private ITreeBuilder getTreeBuilder(ListUIViewInfo uiViewInfo) throws SHRWebException {
        TreeNavigationInfo treeNavigation = uiViewInfo.getTreeNavigation();
        String treeBuilder = treeNavigation.getBuilder();
        if (StringUtils.isEmpty((String)treeBuilder)) {
            treeBuilder = !StringUtils.isEmpty((String)treeNavigation.getTreeModel()) ? CommonTreeBuilder.class.getName() : OrgUnitTreeBuilder.class.getName();
        }
        return (ITreeBuilder)DynamicUtil.newInstance(treeBuilder);
    }

    public Map<String, Map<String, List<String>>> getBacthNextPersMap(HttpServletRequest request) {
        HashMap<String, Map<String, List<String>>> billMap = new HashMap<String, Map<String, List<String>>>();
        String nextPers = request.getParameter("nextPers");
        if (nextPers != null && nextPers.length() > 0 && !"\"\"".equals(nextPers)) {
            List nextPersons = (List)JSONUtils.convertJsonToObject(SHRContext.getInstance().getContext(), nextPers, List.class);
            int size = nextPersons.size();
            for (int i = 0; i < size; ++i) {
                HashMap perMap = new HashMap();
                String billid = (String)((Map)nextPersons.get(i)).get("billid");
                List nextList = (List)((Map)nextPersons.get(i)).get("nextPers");
                for (int j = 0; j < nextList.size(); ++j) {
                    String perIDStr = (String)((Map)nextList.get(j)).get("value");
                    String key = (String)((Map)nextList.get(j)).get("key");
                    if (perIDStr.length() < 1) continue;
                    String[] perIds = perIDStr.split(",");
                    ArrayList<String> personIDs = new ArrayList<String>();
                    for (int k = 0; k < perIds.length; ++k) {
                        personIDs.add(perIds[k]);
                    }
                    perMap.put(key, personIDs);
                }
                billMap.put(billid, perMap);
            }
        }
        return billMap;
    }

    @Override
    public String submitAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String billId = this.getBillId(request);
        String[] ids = null;
        try {
            ids = billId.split(",");
            Map<String, Map<String, List<String>>> perMap = this.getBacthNextPersMap(request);
            NetCtrlHelper.batchRequestObjIDForUpdate(Arrays.asList(ids));
            CoreBaseInfo model = null;
            for (int i = 0; i < ids.length; ++i) {
                model = this.getValue(request, ids[i]);
                this.beforeSubmit(request, response, model);
                if (perMap != null && !perMap.isEmpty()) {
                    this.setNextActivityPerformer(perMap.get(model.getId().toString()), model);
                }
                this.runSubmit(request, response, model);
                this.afterSubmit(request, response, model);
            }
            this.writeSuccessData(billId);
        }
        catch (MissMatchParticipantException e) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "bill_binded"), e);
        }
        catch (MatchAssignmentException e) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "bill_binded"), e);
        }
        catch (Exception exception) {
            throw new SHRWebException(exception.getMessage(), exception);
        }
        finally {
            try {
                NetCtrlHelper.batchReleaseObjIDForUpdate(Arrays.asList(ids));
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    protected void beforeSubmit(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws SHRWebException {
        model.setInt("billState", 1);
    }

    @Override
    protected SelectorItemCollection getSelectors() throws SHRWebException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    protected boolean isUserNewExportQueryAll() {
        return true;
    }

    protected Map<String, String> assembleDomainParams(HttpServletRequest request) throws SHRWebException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.putAll(WebUtil.getParameterMap(request));
        params.put("permItemId", this.getCurrentRequestPermItemId(request));
        return params;
    }

    public String getHrOrgUnitDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String isUnSealUp = request.getParameter("isUnSealUp");
        boolean isSealUp = false;
        if (!StringUtils.isEmpty((String)isUnSealUp) && "false".equals(isUnSealUp)) {
            isSealUp = true;
        }
        try {
            JSONUtils.SUCCESS(HROrgUnitUtil.getHROrgUnits(this.getCurrentRequestHROrgRangeInSQL(request), isSealUp));
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
        return null;
    }

    public String exportJsonDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String content = null;
        try {
            content = ImportAndExportJsonDataFacadeFactory.getRemoteInstance().exportByJsonData(this.getFunctionTypeEnum(request, response, modelMap));
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
        String timestr = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        String entityName = this.getUIViewInfo(request).getEntityName();
        String preFileName = entityName.substring(entityName.lastIndexOf(".") + 1);
        String textFileName = preFileName + "_" + timestr + ".txt";
        String zipFileName = preFileName + "_" + timestr + ".zip";
        try {
            ZipFileDownAndUploadUtil.writeFile(UserUtil.getUserTempDirAbsolutePath(request.getSession()), textFileName, content);
            ZipFileDownAndUploadUtil.zipSigleFile(UserUtil.getUserTempDirAbsolutePath(request.getSession()) + File.separator + zipFileName, UserUtil.getUserTempDirAbsolutePath(request.getSession()) + File.separator + textFileName);
        }
        catch (IOException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("method", "tmp");
        params.put("file", zipFileName);
        params.put("filename", zipFileName);
        String fileName = DynamicUtil.assembleUrl("/downloadfile.do", params);
        if (StringUtils.isEmpty((String)fileName)) {
            return null;
        }
        if (this.isRequestJSON(request)) {
            this.writeSuccessData(fileName);
            return null;
        }
        modelMap.clear();
        return "redirect:" + fileName;
    }

    public String importJsonDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        try {
            ImportAndExportJsonDataFacadeFactory.getRemoteInstance().importByJsonData(ZipFileDownAndUploadUtil.uploadFile(request, response), this.getFunctionTypeEnum(request, response, modelMap));
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        return null;
    }

    protected FunctionTypeEnum getFunctionTypeEnum(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        return null;
    }

    private Object processTreeResultBeforeResponse(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, Object result) throws SHRWebException {
        if (this.rootData == null) {
            if (result instanceof AdminTreeNodeInfo) {
                AdminTreeNodeInfo r;
                this.rootData = r = (AdminTreeNodeInfo)result;
                request.setAttribute("nodeId", (Object)r.getId());
                this.getTreeDataAction(request, response, modelMap);
                return null;
            }
            List treeNodeInfoList = (List)result;
            if (null == treeNodeInfoList || treeNodeInfoList.size() <= 0) {
                return null;
            }
            Iterator iterator = treeNodeInfoList.iterator();
            while (iterator.hasNext()) {
                AdminTreeNodeInfo adminTreeNodeInfo;
                adminTreeNodeInfo.setParent(!(adminTreeNodeInfo = (AdminTreeNodeInfo)iterator.next()).isLeaf());
            }
        } else {
            List treeNodeInfoList = (List)result;
            if (null == treeNodeInfoList || treeNodeInfoList.size() <= 0) {
                return this.rootData;
            }
            Iterator iterator = treeNodeInfoList.iterator();
            while (iterator.hasNext()) {
                AdminTreeNodeInfo adminTreeNodeInfo;
                adminTreeNodeInfo.setParent(!(adminTreeNodeInfo = (AdminTreeNodeInfo)iterator.next()).isLeaf());
            }
            this.rootData.setSubAdminlist(treeNodeInfoList);
            return this.rootData;
        }
        return result;
    }

    public void getListSolutionFieldsAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        Context context = SHRContext.getInstance().getContext();
        ArrayList<Object> list = new ArrayList<Object>();
        LinkedTreeMap configMap = new LinkedTreeMap();
        try {
            IListSetSolution remoteInstance = ListSetSolutionFactory.getRemoteInstance();
            String uipk = request.getParameter("uipk");
            CommonGridListSetSolutionHelper.getTableSetFromUiview(uipk, (Map<String, Object>)configMap, true);
            if (configMap.isEmpty()) {
                return;
            }
            List colModel = (List)configMap.get("columns");
            if (colModel != null) {
                for (Map map : colModel) {
                    Object fieldsMap = new LinkedTreeMap();
                    fieldsMap = map;
                    String currentLocale = context.getLocale().getLanguage().toString();
                    String name = (String)map.get("name");
                    fieldsMap.put("id", "");
                    fieldsMap.put("field", name);
                    Object label = map.get("label");
                    if (label instanceof Map) {
                        Map labelMap = (Map)label;
                        String LocaleLabel = String.valueOf(labelMap.get(currentLocale));
                        if (!StringUtils.isEmpty((String)LocaleLabel)) {
                            fieldsMap.put("name", LocaleLabel);
                        }
                        if (name.equalsIgnoreCase("id")) {
                            labelMap.put(currentLocale, "id");
                            Map nameMultiLan = (Map)map.get("nameMultiLan");
                            nameMultiLan.put(currentLocale, "id");
                        }
                    }
                    fieldsMap.put("number", "");
                    fieldsMap.put("f7FieldName", "");
                    fieldsMap.put("isLeaf", true);
                    fieldsMap.put("enumSource", "");
                    fieldsMap.put("children", null);
                    list.add(fieldsMap);
                }
            }
            JSONUtils.writeJson(response, list);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    protected GridDataEntity doFieldPermFilter(GridDataEntity gridData) throws SHRWebException {
        if (null != this.dataGrid.getShrFieldPermList()) {
            try {
                IShrFieldPermList shrFieldPermList = this.dataGrid.getShrFieldPermList();
                shrFieldPermList.filterData(gridData.getRows());
            }
            catch (EASBizException e) {
                throw new ShrWebBizException(e.getMessage(), e);
            }
            catch (BOSException e) {
                throw new SHRWebException(e);
            }
        }
        return gridData;
    }
}

