/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgUnitHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.json.adapter.BizEnumAdapter;
import com.kingdee.shr.base.syssetting.json.adapter.BosObjectCollectionTypeAdapter;
import com.kingdee.shr.base.syssetting.json.adapter.BosObjectTypeAdapter;
import com.kingdee.shr.base.syssetting.json.adapter.DateTypeAdapter;
import com.kingdee.shr.base.syssetting.json.adapter.EnumTypeAdapter;
import com.kingdee.shr.base.syssetting.json.result.ShrJsonResultEntity;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.web.json.adapter.BOSUuidTypeAdapter;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class JSONUtils {
    protected static Logger logger = Logger.getLogger(JSONUtils.class);
    public static final String SUCCESS = "success";
    public static final String FAILTURE = "error";
    public static final String QUOTES_PREFIX = "${quote_2312415321232}";
    public static final String LEFT_BRACKETS_PREFIX = "${leftbracket_2312415321232}";
    public static final String RIGHT_BRACKETS_PREFIX = "${rightbracket_2312415321232}";
    public static final String CONTENT_TYPE_JSON = "application/json;charset=UTF-8";
    public static final String CONTENT_TYPE_TEXT = "text/html;charset=UTF-8";

    public static String convertObjectToJson(Object object) {
        return JSONUtils.convertObjectToJson(JSONUtils.getContext(), object);
    }

    public static String convertObjectToJson(Context ctx, Object object) {
        if (object == null || object.equals("")) {
            return "\"\"";
        }
        Gson gson = JSONUtils.getGson(ctx);
        String result = gson.toJson(object);
        if (result == null) {
            return "\"\"";
        }
        result = JSONUtils.processJsonResult(result);
        return result;
    }

    public static String processJsonResult(String result) {
        result = result.replace(QUOTES_PREFIX, "\"");
        result = result.replace("\"${leftbracket_2312415321232}", "{");
        result = result.replace(LEFT_BRACKETS_PREFIX, "{");
        result = result.replace("${rightbracket_2312415321232}\"", "}");
        result = result.replace(RIGHT_BRACKETS_PREFIX, "}");
        return result;
    }

    public static Object doOrgConvert(String orgType, Object value) throws EASBizException, BOSException {
        if (orgType == null || value == null || !(value instanceof CtrlUnitInfo)) {
            return value;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        return NewOrgUnitHelper.getTypedOrgUnit((String)((CtrlUnitInfo)value).getId().toString(), (SelectorItemCollection)sic, (OrgType)JSONUtils.getOrgType(orgType));
    }

    private static OrgType getOrgType(String orgTypeStr) {
        Set allOrgType = OrgTypeInfoMgr.getInstance().getAllOrgType();
        Object[] arrayOrgType = allOrgType.toArray();
        for (int i = 0; i < arrayOrgType.length; ++i) {
            OrgType orgType = (OrgType)arrayOrgType[i];
            if (!orgType.getName().equals(orgTypeStr)) continue;
            return orgType;
        }
        return OrgType.NONE;
    }

    private static Context getContext() {
        if (null == SHRContext.getInstance() || null == SHRContext.getInstance().getContext()) {
            if (null == ContextUtils.getContextFromSession()) {
                return null;
            }
            return ContextUtils.getContextFromSession();
        }
        return SHRContext.getInstance().getContext();
    }

    public static String convertObjectToJsonForF7(String orgType, Object value) throws EASBizException, BOSException, SHRWebException {
        return JSONUtils.convertObjectToJsonForF7(JSONUtils.getContext(), orgType, value);
    }

    public static String convertObjectToJsonForF7(Context ctx, String orgType, Object value) throws EASBizException, BOSException, SHRWebException {
        if (value == null || value instanceof String && "".equals(((String)value).trim())) {
            return "null";
        }
        if (value instanceof String) {
            return (String)value;
        }
        return JSONUtils.convertObjectToJson(ctx, JSONUtils.doOrgConvert(orgType, value));
    }

    public static Object convertJsonToObject(String json, Class<?> clz) {
        return JSONUtils.convertJsonToObject(JSONUtils.getContext(), json, clz);
    }

    public static Object convertJsonToObject(Context ctx, String json, Class<?> clz) {
        if (StringUtils.isEmpty((String)json)) {
            return null;
        }
        Gson gson = JSONUtils.getGson(ctx);
        return gson.fromJson(json, clz);
    }

    public static HashMap convertJsonToObject(String json) throws SHRWebException {
        return JSONUtils.convertJsonToObject(JSONUtils.getContext(), json);
    }

    public static HashMap convertJsonToObject(Context ctx, String json) throws SHRWebException {
        if (StringUtils.isEmpty((String)json)) {
            return new HashMap(0);
        }
        Gson gson = JSONUtils.getGson(ctx);
        return (HashMap)gson.fromJson(json.toString(), HashMap.class);
    }

    public static String encodeJson(String json) throws SHRWebException {
        StringBuilder encodedJson = new StringBuilder();
        for (int i = 0; i < json.length(); ++i) {
            char c = json.charAt(i);
            if (c > '\u007f') {
                encodedJson.append("\\u").append(Integer.toHexString(c));
                continue;
            }
            encodedJson.append(c);
        }
        return encodedJson.toString();
    }

    public static void writeJson(HttpServletResponse response, Object object) throws SHRWebException {
        JSONUtils.writeJson(SHRContext.getInstance().getContext(), response, object);
    }

    public static void writeJson(Context ctx, HttpServletResponse response, Object object) throws SHRWebException {
        if (object == null) {
            return;
        }
        JSONUtils.writeJson(response, JSONUtils.convertObjectToJson(ctx, object));
    }

    public static void writeJson(HttpServletResponse response, String json) throws SHRWebException {
        PrintWriter pw;
        response.setContentType(CONTENT_TYPE_JSON);
        try {
            pw = response.getWriter();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SHRWebException("can't open the output stream!");
        }
        pw.write(json);
        pw.flush();
    }

    public static void SUCCESS(Object object) throws SHRWebException {
        ServletResponse response = SHRContext.getInstance().getResponse();
        JSONUtils.SUCCESS(object, response);
    }

    public static void SUCCESS(Object object, String contentType) throws SHRWebException {
        ServletResponse response = SHRContext.getInstance().getResponse();
        JSONUtils.SUCCESS(object, response, contentType);
    }

    public static void SUCCESS(Object object, ServletResponse response) throws SHRWebException {
        JSONUtils.SUCCESS(object, response, CONTENT_TYPE_JSON);
    }

    public static void SUCCESS(Object object, ServletResponse response, String contentType) throws SHRWebException {
        PrintWriter pw;
        response.setContentType(contentType);
        try {
            pw = response.getWriter();
        }
        catch (IOException e) {
            throw new SHRWebException("can't open the output stream!");
        }
        StringBuilder strSuccessJson = new StringBuilder();
        strSuccessJson.append("{");
        strSuccessJson.append("\"result\":\"");
        strSuccessJson.append(SUCCESS);
        strSuccessJson.append("\",\"data\":");
        strSuccessJson.append(JSONUtils.convertObjectToJson(SHRContext.getInstance().getContext(), object).toString());
        ServletRequest request = SHRContext.getInstance().getRequest();
        String successMessage = (String)request.getAttribute("successMessage");
        if (!StringUtils.isEmpty((String)successMessage)) {
            strSuccessJson.append(",\"successMessage\":\"");
            strSuccessJson.append(successMessage);
            strSuccessJson.append("\"");
        }
        strSuccessJson.append("}");
        pw.flush();
        pw.write(strSuccessJson.toString());
        pw.flush();
    }

    public static void SUCCESS(ShrJsonResultEntity entity) throws SHRWebException {
        PrintWriter pw;
        if (entity == null) {
            return;
        }
        ServletResponse response = SHRContext.getInstance().getResponse();
        Context ctx = SHRContext.getInstance().getContext();
        response.setContentType(CONTENT_TYPE_JSON);
        try {
            pw = response.getWriter();
        }
        catch (IOException e) {
            throw new SHRWebException("can't open the output stream!");
        }
        String strSuccessJson = null;
        strSuccessJson = "{\"result\":\"success\",\"data\":" + JSONUtils.convertObjectToJson(ctx, entity.getData()).toString() + ",\"uiItems\":" + JSONUtils.convertObjectToJson(ctx, entity.getUiItems()) + ",\"script\":" + JSONUtils.convertObjectToJson(ctx, entity.getScript()) + ",\"isAutoExecuteUpdateUIItem\":" + JSONUtils.convertObjectToJson(ctx, entity.isAutoExecuteUpdateUIItem()) + ",\"isAutoExecuteScript\":" + JSONUtils.convertObjectToJson(ctx, entity.isAutoExecuteScript()) + "}";
        pw.flush();
        pw.write(strSuccessJson);
        pw.flush();
    }

    public static void ERROR(String message) {
        JSONUtils.ERROR(message, null, CONTENT_TYPE_JSON);
    }

    public static void ERROR(String message, String contentType) {
        JSONUtils.ERROR(message, null, contentType);
    }

    public static void ERROR(String message, Exception exception) {
        JSONUtils.ERROR(message, exception, CONTENT_TYPE_JSON);
    }

    public static void ERROR(String message, Exception exception, String contentType) {
        if (exception != null) {
            logger.error((Object)SHRCheck.vaildLog((String)(message + exception.getMessage())), (Throwable)exception);
        }
        ServletResponse response = SHRContext.getInstance().getResponse();
        response.setContentType(contentType);
        PrintWriter pw = null;
        try {
            pw = response.getWriter();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        StringBuffer exceptionBuffer = null;
        if (exception != null) {
            StringWriter writer = new StringWriter();
            PrintWriter exWriter = new PrintWriter(writer);
            exception.printStackTrace(exWriter);
            exceptionBuffer = writer.getBuffer();
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("result", FAILTURE);
        resultMap.put("summary", message);
        resultMap.put("detailInfo", "");
        pw.write(JSONUtils.convertObjectToJson(SHRContext.getInstance().getContext(), resultMap));
        pw.flush();
    }

    public static Gson getGson() {
        return JSONUtils.getGson(JSONUtils.getContext());
    }

    public static Gson getGson(Context ctx) {
        GsonBuilder builder = new GsonBuilder();
        builder.serializeNulls();
        builder.disableHtmlEscaping();
        builder.serializeSpecialFloatingPointValues();
        builder.registerTypeHierarchyAdapter(Date.class, (Object)new DateTypeAdapter());
        builder.registerTypeHierarchyAdapter(Timestamp.class, (Object)new DateTypeAdapter());
        builder.registerTypeHierarchyAdapter(BOSUuid.class, (Object)new BOSUuidTypeAdapter());
        builder.registerTypeHierarchyAdapter(IObjectValue.class, (Object)new BosObjectTypeAdapter(ctx));
        builder.registerTypeHierarchyAdapter(IObjectCollection.class, (Object)new BosObjectCollectionTypeAdapter(ctx));
        builder.registerTypeHierarchyAdapter(OrgUnitInfo.class, (Object)new BosObjectTypeAdapter(ctx));
        builder.registerTypeHierarchyAdapter(BizEnumValueDTO.class, (Object)new BizEnumAdapter());
        builder.registerTypeHierarchyAdapter(Enum.class, (Object)new EnumTypeAdapter());
        return builder.create();
    }
}

