/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.support.fieldrule;

import com.google.gson.JsonSyntaxException;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.FieldRuleException;
import com.kingdee.shr.base.syssetting.FieldRuleInfo;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.app.cache.FieldRuleCacheHelper;
import com.kingdee.shr.base.syssetting.app.util.XMLUtil;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.fieldrule.FieldRuleUtils;
import com.kingdee.shr.base.syssetting.fieldrule.formula.FieldRuleFormulaEngine;
import com.kingdee.shr.base.syssetting.fieldrule.model.CalculateConfig;
import com.kingdee.shr.base.syssetting.fieldrule.model.DefaultValueConfig;
import com.kingdee.shr.base.syssetting.fieldrule.model.Field;
import com.kingdee.shr.base.syssetting.fieldrule.model.FieldRule;
import com.kingdee.shr.base.syssetting.fieldrule.model.FilterConfig;
import com.kingdee.shr.base.syssetting.fieldrule.model.FilterConfigItem;
import com.kingdee.shr.base.syssetting.fieldrule.model.LinkConfig;
import com.kingdee.shr.base.syssetting.fieldrule.model.runtime.CalculateFieldValue;
import com.kingdee.shr.base.syssetting.fieldrule.model.runtime.FieldFilterValue;
import com.kingdee.shr.base.syssetting.fieldrule.model.runtime.FieldItem;
import com.kingdee.shr.base.syssetting.fieldrule.model.runtime.FilterFieldItem;
import com.kingdee.shr.base.syssetting.fieldrule.model.runtime.LinkFieldValue;
import com.kingdee.shr.base.syssetting.fieldrule.model.type.Type;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdom2.Document;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldRuleHelper {
    private static Logger logger = LoggerFactory.getLogger(FieldRuleHelper.class);
    private static final String DEFAULT_VALUE_RULE = "defaultValueRule";
    private static final String GROUP_FIELD_VALUE = "groupFieldValue";
    private static final String EDIT_GRID_FIELD_VALUE = "editGridFieldValue";
    private static final String FIELD_FILTER = "fieldFilter";
    private static final String LINK_RULE = "linkRule";
    private static final String LINK_FIELD = "linkField";
    private static final String CALCULATE_FIELD = "calculateField";
    private static final String FIELD = "field";

    private FieldRuleHelper() {
    }

    public static void initFieldRule(Context ctx, String uipk) {
        try {
            FieldRuleCacheHelper.get((Context)ctx, (String)uipk);
        }
        catch (Exception e) {
            logger.error("fieldRule Init Error ! ViewInfoUipk Is : [{}]", (Object)uipk);
            e.printStackTrace();
        }
    }

    public static Map<String, Object> getFieldRuleInitData(Context ctx, String uipk) {
        try {
            return FieldRuleCacheHelper.get((Context)ctx, (String)uipk);
        }
        catch (Exception e) {
            logger.error("fieldRule Init Error ! ViewInfoUipk Is : [{}]", (Object)uipk);
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> getConvertFieldRuleInitData(Context ctx, String uipk) {
        HashMap<String, Object> fieldRuleMapClient = null;
        Map<String, Object> fieldRuleMap = FieldRuleHelper.getFieldRuleInitData(ctx, uipk);
        if (fieldRuleMap instanceof Map) {
            fieldRuleMapClient = new HashMap<String, Object>();
            if (fieldRuleMap.get(DEFAULT_VALUE_RULE) instanceof Map) {
                FieldRuleHelper.assembleDefaultValueRule(ctx, fieldRuleMapClient, (Map)fieldRuleMap.get(DEFAULT_VALUE_RULE));
            }
            if (fieldRuleMap.get(FIELD_FILTER) instanceof Map) {
                FieldRuleHelper.assembleFieldFilter(fieldRuleMapClient, (Map)fieldRuleMap.get(FIELD_FILTER));
            }
            if (fieldRuleMap.get(LINK_RULE) instanceof Map) {
                FieldRuleHelper.assembleLinkField(fieldRuleMapClient, (Map)fieldRuleMap.get(LINK_RULE));
            }
        }
        return fieldRuleMapClient;
    }

    public static void setFieldDefaultValue(Context ctx, String uipk, CoreBaseInfo coreBaseInfo) {
        Map<String, Object> fieldRule = FieldRuleHelper.getFieldRuleInitData(ctx, uipk);
        if (null != fieldRule && null != fieldRule.get(DEFAULT_VALUE_RULE) && null != ((Map)fieldRule.get(DEFAULT_VALUE_RULE)).get(GROUP_FIELD_VALUE)) {
            FieldRuleHelper.setDefaultValue((Map)((Map)fieldRule.get(DEFAULT_VALUE_RULE)).get(GROUP_FIELD_VALUE), coreBaseInfo);
        }
    }

    public static String getFieldFilter(Context ctx, String fieldCasFilterItems) {
        Map<String, Object> fieldRuleMap;
        HashMap fieldCasFilter = JSONUtils.convertJsonToObject((Context)ctx, (String)fieldCasFilterItems);
        String f7Name = (String)fieldCasFilter.get("f7name");
        String uipk = (String)fieldCasFilter.get("uipk");
        if (StringUtils.isEmpty((String)f7Name) || StringUtils.isEmpty((String)uipk)) {
            return null;
        }
        List fields = null;
        if (fieldCasFilter.get(FIELD) instanceof List) {
            fields = (List)fieldCasFilter.get(FIELD);
        }
        if (null != (fieldRuleMap = FieldRuleHelper.getFieldRuleInitData(ctx, uipk)) && fieldRuleMap.get(FIELD_FILTER) instanceof Map) {
            Map fieldFilter = (Map)fieldRuleMap.get(FIELD_FILTER);
            FieldFilterValue fieldFilterValue = (FieldFilterValue)fieldFilter.get(f7Name);
            if (null != fieldFilterValue && null != fields) {
                Map filterItemMaping = fieldFilterValue.getFilterItemMaping();
                HashMap<String, FilterFieldItem> filterItemMapingTemp = new HashMap<String, FilterFieldItem>();
                for (Map.Entry entry : filterItemMaping.entrySet()) {
                    for (Map field : fields) {
                        FilterFieldItem filterFieldItem = (FilterFieldItem)entry.getValue();
                        if (!filterFieldItem.getName().equals(field.get("name"))) continue;
                        Object value = field.get("value");
                        if (null == value || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
                            String condition = fieldFilterValue.getCondition();
                            String key = (String)entry.getKey();
                            String newKey = key + "000";
                            condition = condition.replace(key, "(" + key + " " + "or" + " " + newKey + ")");
                            filterFieldItem.setCompareType("is");
                            filterFieldItem.setValue((Object)"");
                            FilterFieldItem item = new FilterFieldItem();
                            item.setCompareType("isnot");
                            item.setName(filterFieldItem.getName());
                            item.setValue(filterFieldItem.getValue());
                            item.setType(filterFieldItem.getType());
                            item.setValue((Object)"");
                            filterItemMapingTemp.put(newKey, item);
                            fieldFilterValue.setCondition(condition);
                            continue;
                        }
                        ((FilterFieldItem)entry.getValue()).setValue(value);
                    }
                }
                if (!filterItemMapingTemp.isEmpty()) {
                    filterItemMaping.putAll(filterItemMapingTemp);
                }
            }
            return JSONUtils.convertObjectToJson((Context)ctx, (Object)fieldFilterValue);
        }
        return null;
    }

    public static Object getLinkFieldResult(Context ctx, Map<String, Object> param, IObjectValue model) throws EASBizException {
        Object value = null;
        try {
            Map calculateField;
            CalculateFieldValue calculateFieldValue;
            Map linkField;
            LinkFieldValue linkFieldValue;
            String uipk = (String)param.get("uipk");
            Map<String, Object> fieldRuleMap = FieldRuleHelper.getFieldRuleInitData(ctx, uipk);
            if (null == fieldRuleMap || fieldRuleMap.isEmpty()) {
                return null;
            }
            String id = (String)param.get("id");
            String ruleType = (String)param.get("type");
            int entrysIndex = null != param.get("entrysIndex") ? Integer.valueOf((String)param.get("entrysIndex")) : 0;
            String formulaString = null;
            Map vars = null;
            List targetFields = null;
            if (LINK_FIELD.equals(ruleType) && fieldRuleMap.get(LINK_RULE) instanceof Map && ((Map)fieldRuleMap.get(LINK_RULE)).get(LINK_FIELD) instanceof Map && null != (linkFieldValue = (LinkFieldValue)(linkField = (Map)((Map)fieldRuleMap.get(LINK_RULE)).get(LINK_FIELD)).get(id))) {
                vars = linkFieldValue.getVars();
                formulaString = linkFieldValue.getCondition().getValue();
            }
            if (CALCULATE_FIELD.equals(ruleType) && fieldRuleMap.get(LINK_RULE) instanceof Map && ((Map)fieldRuleMap.get(LINK_RULE)).get(CALCULATE_FIELD) instanceof Map && null != (calculateFieldValue = (CalculateFieldValue)(calculateField = (Map)((Map)fieldRuleMap.get(LINK_RULE)).get(CALCULATE_FIELD)).get(id))) {
                targetFields = calculateFieldValue.getTargetFields();
                vars = calculateFieldValue.getVars();
                formulaString = calculateFieldValue.getCondition().getValue();
            }
            if (null != vars && null != model) {
                vars.put("entrys#Index", entrysIndex);
                String entityName = (String)model.get("_entityName");
                if (!StringUtils.isEmpty((String)entityName)) {
                    String objectName = entityName.substring(entityName.lastIndexOf(".") + 1, entityName.length());
                    vars.replace(objectName, model);
                }
                vars.put("codeMirrorResult", "NONERETURN");
            }
            if (null == (value = FieldRuleFormulaEngine.runFormula(formulaString, vars, (Context)ctx)) || "NONERETURN".equals(value)) {
                return value;
            }
            if (CALCULATE_FIELD.equals(ruleType) && null != targetFields && !targetFields.isEmpty()) {
                FieldItem field = (FieldItem)targetFields.get(0);
                String dataTypeName = field.getType();
                if (DataType.BOOLEAN.getName().equalsIgnoreCase(dataTypeName)) {
                    return FieldRuleUtils.getBooleanFieldValue((Object)value);
                }
                if (DataType.STRING.getName().equalsIgnoreCase(dataTypeName)) {
                    return FieldRuleUtils.getLocalValue((Context)ctx, (Object)value);
                }
                if (DataType.DATE.getName().equalsIgnoreCase(dataTypeName) || DataType.TIME.getName().equalsIgnoreCase(dataTypeName) || DataType.TIMESTAMP.getName().equalsIgnoreCase(dataTypeName)) {
                    return FieldRuleUtils.getDateFieldValue((Object)value);
                }
                if (Boolean.TRUE.equals(FieldRuleUtils.isNumberType((String)dataTypeName))) {
                    return FieldRuleUtils.getNumberFieldValue((String)dataTypeName, (Object)value);
                }
                if (DataType.OBJECTVALUE.getName().equalsIgnoreCase(field.getType())) {
                    return FieldRuleHelper.assemableF7Value(ctx, value, field, param);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new FieldRuleException(FieldRuleException.ERROR_FIELDRULE_FORMULA);
        }
        return value;
    }

    private static Object assemableF7Value(Context ctx, Object value, FieldItem field, Map<String, Object> param) {
        if (value instanceof String && !BOSUuid.isValid((String)((String)value), (boolean)true)) {
            return value;
        }
        String entityname = field.getFullName();
        if (!StringUtils.isEmpty((String)entityname)) {
            if (!(value instanceof CoreBaseInfo)) {
                value = FieldRuleUtils.getF7FieldValue((Context)ctx, (Object)value, (String)entityname, null);
            }
            if (value instanceof CoreBaseInfo) {
                HashMap<String, String> objectValue = new HashMap<String, String>();
                objectValue.put("id", ((CoreBaseInfo)value).getId().toString());
                String displayName = (String)param.get("displayFormat");
                if (!StringUtils.isEmpty((String)displayName)) {
                    objectValue.put(displayName, ((CoreBaseInfo)value).get(displayName, ctx.getLocale()).toString());
                } else {
                    objectValue.put("name", ((CoreBaseInfo)value).get("name", ctx.getLocale()).toString());
                }
                return objectValue;
            }
        }
        return value;
    }

    public static boolean isCurrentRuleByDefault(Context ctx, String uipk) {
        Map<String, Object> fieldRule = FieldRuleHelper.getFieldRuleInitData(ctx, uipk);
        if (null != fieldRule && null != fieldRule.get(DEFAULT_VALUE_RULE) && null != ((Map)fieldRule.get(DEFAULT_VALUE_RULE)).get("priority")) {
            String priority = (String)((Map)fieldRule.get(DEFAULT_VALUE_RULE)).get("priority");
            return Type.Priority.CURRENTRULE.name().equalsIgnoreCase(priority);
        }
        return false;
    }

    public static void checkFieldRule(Context ctx, FieldRuleInfo fieldRuleInfo, List<Map<String, String>> data, boolean isProductionMode) throws SHRWebException {
        UIViewInfo uIViewInfo = fieldRuleInfo.getUiview();
        Map<String, Set<String>> ruleFields = null;
        LinkedHashMap<String, String> mainCheckRow = new LinkedHashMap<String, String>();
        mainCheckRow.put("fieldRuleNumber", fieldRuleInfo.getNumber());
        mainCheckRow.put("fieldRuleName", fieldRuleInfo.getName());
        String msgTrue = SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "true");
        String msgFalse = SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "false");
        String isExt = StringUtils.isEmpty((String)fieldRuleInfo.getExtend()) ? msgFalse : msgTrue;
        mainCheckRow.put("fieldRuleIsExt", isExt);
        String uipk = uIViewInfo.getUipk();
        mainCheckRow.put("uipk", uipk);
        try {
            if (StringUtils.isEmpty((String)uipk)) {
                String uiViewNonExist = new FieldRuleException(FieldRuleException.ERROR_FIELD_UIVIEW_NONEXIST).getMessage();
                mainCheckRow.put("uiviewIsExt", null);
                mainCheckRow.put("errorField", null);
                mainCheckRow.put("fieldRuleConfig", null);
                mainCheckRow.put("errorMsg", uiViewNonExist);
                data.add(mainCheckRow);
                return;
            }
            mainCheckRow.put("uiviewIsExt", StringUtils.isEmpty((String)uIViewInfo.getExtend()) ? msgFalse : msgTrue);
            String content = null;
            String uiviewContent = null;
            if (isProductionMode) {
                content = fieldRuleInfo.getExtend();
                uiviewContent = uIViewInfo.getExtend();
            } else {
                content = fieldRuleInfo.getContent();
                uiviewContent = uIViewInfo.getContent();
                if (StringUtils.isEmpty((String)content) || StringUtils.isEmpty((String)uIViewInfo.getContent())) {
                    return;
                }
            }
            if (StringUtils.isEmpty((String)content) || StringUtils.isEmpty((String)uiviewContent)) {
                return;
            }
            FieldRule fieldRule = (FieldRule)JSONUtils.convertJsonToObject((Context)ctx, (String)content, FieldRule.class);
            ruleFields = FieldRuleHelper.getFields(fieldRule);
            if (!ruleFields.isEmpty()) {
                HashSet<String> fields = new HashSet<String>();
                HashSet<String> outOfNames = new HashSet<String>();
                Document doc = XMLUtil.parseXML((String)uiviewContent);
                Element uiviewRootElement = doc.getRootElement();
                List<Element> fieldElements = UIViewUtil.getElement(uiviewRootElement, "//field");
                List<Element> editGridElement = UIViewUtil.getElement(uiviewRootElement, "//editGrid");
                FieldRuleHelper.assembleFields(fieldElements, fields);
                FieldRuleHelper.assembleEditGridFields(editGridElement, fields);
                if (!fields.isEmpty()) {
                    for (Map.Entry<String, Set<String>> entry : ruleFields.entrySet()) {
                        if (fields.contains(entry.getKey())) continue;
                        outOfNames.add(entry.getKey());
                    }
                }
                if (!outOfNames.isEmpty()) {
                    for (String outOfName : outOfNames) {
                        String fieldNonExist = new FieldRuleException(FieldRuleException.ERROR_FIELDS_NONEXIST, new Object[]{"[" + outOfName + "]"}).getMessage();
                        LinkedHashMap<String, String> checkRow = new LinkedHashMap<String, String>(mainCheckRow);
                        checkRow.put("errorField", outOfName);
                        checkRow.put("fieldRuleConfig", ruleFields.get(outOfName).stream().collect(Collectors.joining(",")));
                        checkRow.put("errorMsg", fieldNonExist);
                        data.add(checkRow);
                    }
                }
            }
        }
        catch (JsonSyntaxException | BOSException e) {
            logger.error("checkFieldRule Error,  Uiview Uipk : {}", (Object)uipk);
        }
    }

    private static void assembleFields(List<Element> fieldElements, Set<String> fields) {
        if (!fieldElements.isEmpty()) {
            for (Element e : fieldElements) {
                String name = e.getAttributeValue("name");
                fields.add(name);
            }
        }
    }

    private static void assembleEditGridFields(List<Element> editGridElement, Set<String> fields) throws SHRWebException {
        if (!editGridElement.isEmpty()) {
            for (Element e : editGridElement) {
                String entrysName = e.getAttributeValue("name");
                List<Element> columnElements = UIViewUtil.getElement(e, "//column");
                if (columnElements.isEmpty()) continue;
                for (Element ce : columnElements) {
                    String name = ce.getAttributeValue("name");
                    fields.add(MessageFormat.format("{0}.{1}", entrysName, name));
                }
            }
        }
    }

    private static Map<String, Set<String>> getFields(FieldRule fieldRule) {
        HashMap<String, Set<String>> fields = new HashMap<String, Set<String>>();
        if (null != fieldRule.getDefaultValueRule() && fieldRule.getDefaultValueRule().isEnable() && fieldRule.getDefaultValueRule().getConfig() instanceof List) {
            FieldRuleHelper.getDefaultConfigField(fieldRule.getDefaultValueRule().getConfig(), fields);
        }
        if (null != fieldRule.getFilterRule() && fieldRule.getFilterRule().isEnable() && fieldRule.getFilterRule().getConfig() instanceof List) {
            FieldRuleHelper.getFilterConfigField(fieldRule.getFilterRule().getConfig(), fields);
        }
        if (null != fieldRule.getLinkRule() && fieldRule.getLinkRule().isEnable() && fieldRule.getLinkRule().getLinkConfig() instanceof List || fieldRule.getLinkRule().getCalculateConfig() instanceof List) {
            FieldRuleHelper.getLinkConfigField(fieldRule.getLinkRule().getLinkConfig(), fields);
            FieldRuleHelper.getCalculateConfigField(fieldRule.getLinkRule().getCalculateConfig(), fields);
        }
        return fields;
    }

    private static void getLinkConfigField(List<LinkConfig> linkConfigs, Map<String, Set<String>> fields) {
        String filedRuleLink = SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "filed_rule_link");
        for (LinkConfig linkConfig : linkConfigs) {
            HashSet<String> value;
            for (Field linkField : linkConfig.getFields()) {
                value = fields.containsKey(linkField.getName()) ? fields.get(linkField.getName()) : new HashSet<String>();
                value.add(filedRuleLink);
                fields.put(linkField.getName(), value);
            }
            for (Field targetField : linkConfig.getTargetFields()) {
                value = fields.containsKey(targetField.getName()) ? fields.get(targetField.getName()) : new HashSet();
                value.add(filedRuleLink);
                fields.put(targetField.getName(), value);
            }
        }
    }

    private static void getCalculateConfigField(List<CalculateConfig> calculateConfigs, Map<String, Set<String>> fields) {
        String filedRuleLink = SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "filed_rule_link");
        for (CalculateConfig calculateConfig : calculateConfigs) {
            HashSet<String> value;
            for (Field calculateField : calculateConfig.getFields()) {
                value = fields.containsKey(calculateField.getName()) ? fields.get(calculateField.getName()) : new HashSet<String>();
                value.add(filedRuleLink);
                fields.put(calculateField.getName(), value);
            }
            for (Field targetField : calculateConfig.getTargetFields()) {
                value = fields.containsKey(targetField.getName()) ? fields.get(targetField.getName()) : new HashSet();
                value.add(filedRuleLink);
                fields.put(targetField.getName(), value);
            }
        }
    }

    private static void getDefaultConfigField(List<DefaultValueConfig> configs, Map<String, Set<String>> fields) {
        for (DefaultValueConfig defaultValueRuleConfig : configs) {
            if (!defaultValueRuleConfig.isEnable()) continue;
            Field field = defaultValueRuleConfig.getField();
            HashSet<String> value = fields.containsKey(field.getName()) ? fields.get(field.getName()) : new HashSet<String>();
            value.add(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "field_rule_default"));
            fields.put(field.getName(), value);
        }
    }

    private static void getFilterConfigField(List<FilterConfig> configs, Map<String, Set<String>> fields) {
        String fieldRuleFilter = SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "field_rule_filter");
        for (FilterConfig filterRuleConfig : configs) {
            Field field = filterRuleConfig.getField();
            HashSet<String> value = fields.containsKey(field.getName()) ? fields.get(field.getName()) : new HashSet<String>();
            value.add(fieldRuleFilter);
            fields.put(field.getName(), value);
            for (FilterConfigItem filterConfigItem : filterRuleConfig.getFilterConfig()) {
                if (!Type.DEPENDFIELD.name().equalsIgnoreCase(filterConfigItem.getCompareType()) || !(filterConfigItem.getFilterValue() instanceof Map)) continue;
                Map dependField = (Map)filterConfigItem.getFilterValue();
                value = fields.containsKey(field.getName()) ? fields.get(field.getName()) : new HashSet();
                value.add(fieldRuleFilter);
                fields.put((String)dependField.get("name"), value);
            }
        }
    }

    private static void setDefaultValue(Map<String, Object> groupFieldValue, CoreBaseInfo coreBaseInfo) {
        for (Map.Entry<String, Object> entry : groupFieldValue.entrySet()) {
            coreBaseInfo.put(entry.getKey(), entry.getValue());
        }
    }

    private static void assembleDefaultValueRule(Context ctx, Map<String, Object> fieldRuleMapClient, Map<String, Object> defaultValueRule) {
        HashMap<String, Object> defaultValueRuleValue = new HashMap<String, Object>();
        if (defaultValueRule.get(EDIT_GRID_FIELD_VALUE) instanceof Map) {
            defaultValueRuleValue = new HashMap();
            Map editGridFieldValue = (Map)defaultValueRule.get(EDIT_GRID_FIELD_VALUE);
            for (Map.Entry entry : editGridFieldValue.entrySet()) {
                Object obj = entry.getValue();
                if (obj instanceof Enum) {
                    Enum objEnum = (Enum)obj;
                    Object value = null;
                    value = objEnum instanceof StringEnum ? ((StringEnum)objEnum).getValue() : (objEnum instanceof DynamicEnum ? ((DynamicEnum)objEnum).getValue() : (objEnum instanceof LongEnum ? Long.valueOf(((LongEnum)objEnum).getValue()) : (objEnum instanceof IntEnum ? Integer.valueOf(((IntEnum)objEnum).getValue()) : (objEnum instanceof FloatEnum ? Float.valueOf(((FloatEnum)objEnum).getValue()) : (objEnum instanceof DoubleEnum ? Double.valueOf(((DoubleEnum)objEnum).getValue()) : objEnum.getName())))));
                    editGridFieldValue.put(entry.getKey(), value);
                    continue;
                }
                if (!(obj instanceof CoreBaseInfo)) continue;
                HashMap<String, String> objectValue = new HashMap<String, String>();
                objectValue.put("id", ((CoreBaseInfo)obj).getId().toString());
                objectValue.put("name", ((CoreBaseInfo)obj).get("name", ctx.getLocale()).toString());
                editGridFieldValue.put(entry.getKey(), objectValue);
            }
            defaultValueRuleValue.put(EDIT_GRID_FIELD_VALUE, defaultValueRule.get(EDIT_GRID_FIELD_VALUE));
        }
        fieldRuleMapClient.put(DEFAULT_VALUE_RULE, defaultValueRuleValue);
    }

    private static void assembleFieldFilter(Map<String, Object> fieldRuleMapClient, Map<String, FieldFilterValue> fieldFilter) {
        HashMap convertF7Filter = new HashMap();
        HashMap<String, Object> convertFieldFilter = null;
        for (Map.Entry<String, FieldFilterValue> entry : fieldFilter.entrySet()) {
            convertFieldFilter = new HashMap<String, Object>();
            FieldFilterValue fieldFilterValue = entry.getValue();
            Map filterItemMaping = fieldFilterValue.getFilterItemMaping();
            ArrayList fields = new ArrayList();
            for (Map.Entry item : filterItemMaping.entrySet()) {
                FilterFieldItem filterField = (FilterFieldItem)item.getValue();
                if (!filterField.isDependField()) continue;
                HashMap<String, Object> field = new HashMap<String, Object>();
                field.put("name", filterField.getName());
                field.put("type", filterField.getType());
                field.put("alias", filterField.getAlias());
                field.put("value", filterField.getValue());
                field.put("isEditGridField", filterField.isEditGridField());
                field.put("isTip", filterField.isTip());
                fields.add(field);
            }
            convertFieldFilter.put("tips", fieldFilterValue.getTips());
            convertFieldFilter.put("isEditGridField", fieldFilterValue.isEditGridField());
            convertFieldFilter.put(FIELD, fields);
            convertF7Filter.put(entry.getKey(), convertFieldFilter);
        }
        fieldRuleMapClient.put(FIELD_FILTER, convertF7Filter);
    }

    private static void assembleLinkField(Map<String, Object> fieldRuleMapClient, Map<String, Object> linkRule) {
        ArrayList linkFields = null;
        HashMap<String, Object> linkRuleValue = new HashMap<String, Object>();
        if (linkRule.get(LINK_FIELD) instanceof Map) {
            linkFields = new ArrayList();
            Map linkConfigValues = (Map)linkRule.get(LINK_FIELD);
            for (Map.Entry entry : linkConfigValues.entrySet()) {
                HashMap<String, Object> linkField = new HashMap<String, Object>();
                LinkFieldValue linkFieldValue = (LinkFieldValue)entry.getValue();
                linkField.put(FIELD, linkFieldValue.getFields());
                linkField.put("targetField", linkFieldValue.getTargetFields());
                linkField.put("linkType", linkFieldValue.getLinkType());
                linkField.put("isConditionValue", linkFieldValue.isConditionValue());
                linkField.put("conditionFields", linkFieldValue.getCondition().getField());
                linkField.put("key", entry.getKey());
                linkFields.add(linkField);
            }
            linkRuleValue.put(LINK_FIELD, linkFields);
        }
        ArrayList calculateFields = null;
        if (linkRule.get(CALCULATE_FIELD) instanceof Map) {
            calculateFields = new ArrayList();
            Map calculateFieldValues = (Map)linkRule.get(CALCULATE_FIELD);
            for (Map.Entry entry : calculateFieldValues.entrySet()) {
                HashMap<String, Object> calculateField = new HashMap<String, Object>();
                CalculateFieldValue calculateFieldValue = (CalculateFieldValue)entry.getValue();
                calculateField.put(FIELD, calculateFieldValue.getFields());
                calculateField.put("targetField", calculateFieldValue.getTargetFields());
                calculateField.put("linkType", calculateFieldValue.getOperateType());
                calculateField.put("isConditionValue", calculateFieldValue.isConditionValue());
                calculateField.put("conditionFields", calculateFieldValue.getCondition().getField());
                calculateField.put("key", entry.getKey());
                calculateFields.add(calculateField);
            }
            linkRuleValue.put(CALCULATE_FIELD, calculateFields);
        }
        linkRuleValue.put("layout", linkRule.get("layout"));
        fieldRuleMapClient.put(LINK_RULE, linkRuleValue);
    }
}

