/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.templatetranslator;

import com.kingdee.bos.Context;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.XMLUtil;
import com.kingdee.shr.base.syssetting.web.templatetranslator.IElementTranslator;
import com.kingdee.shr.base.syssetting.web.templatetranslator.IElementTranslatorStore;
import com.kingdee.shr.base.syssetting.web.templatetranslator.ITemplateTranslator;
import com.kingdee.shr.base.syssetting.web.templatetranslator.TemplateTranslateException;
import org.jdom2.Document;
import org.jdom2.Element;

public abstract class AbstractTemplateTranslator
implements ITemplateTranslator {
    private IElementTranslatorStore store;

    @Override
    public String translate(UIViewInfo viewInfo, Context ctx) throws TemplateTranslateException {
        IElementTranslator translator;
        Element rootElement = null;
        try {
            Document doc = XMLUtil.parseXML(viewInfo.getContent());
            rootElement = doc.getRootElement();
        }
        catch (SHRWebException e) {
            throw new TemplateTranslateException(e.getMessage(), e);
        }
        StringBuilder sb = new StringBuilder();
        if (this.store == null) {
            this.store = this.getTranslatorStore();
        }
        if ((translator = this.store.getElementTranslator(rootElement, ctx)) != null) {
            sb.append(translator.translate(rootElement, viewInfo, this.store));
        }
        return sb.toString();
    }

    protected abstract IElementTranslatorStore getTranslatorStore();
}

