/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.templatetranslator.freemarker;

import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.XMLUtil;
import com.kingdee.shr.base.syssetting.web.templatetranslator.AbstractElementTranslator;
import com.kingdee.shr.base.syssetting.web.templatetranslator.IElementTranslatorStore;
import com.kingdee.shr.base.syssetting.web.templatetranslator.TemplateTranslateException;
import java.util.HashSet;
import java.util.Set;
import org.jdom2.Element;

public class DefaultTranslator
extends AbstractElementTranslator {
    private Set<String> excludeTags = new HashSet<String>();

    public DefaultTranslator() {
        this.excludeTags.add("handler");
        this.excludeTags.add("plugin");
        this.excludeTags.add("jsclass");
        this.excludeTags.add("searchview");
        this.excludeTags.add("addNewview");
    }

    @Override
    public String translate(Element element, UIViewInfo viewInfo, IElementTranslatorStore store) throws TemplateTranslateException {
        String tagName;
        if (this.excludeTags.contains(element.getName().toLowerCase())) {
            return "";
        }
        String directive = element.getAttributeValue("directive");
        String prefix = null;
        if ("true".equalsIgnoreCase(directive)) {
            String userDefine = element.getAttributeValue("userDefine");
            prefix = "true".equalsIgnoreCase(userDefine) ? "@" : "#";
            element.removeAttribute("directive");
            element.removeAttribute("userDefine");
        }
        if ((tagName = element.getName()).startsWith("ctrl.")) {
            prefix = "@";
        }
        if (prefix != null) {
            tagName = prefix + tagName;
        }
        return this.convertElementString(element, viewInfo, store, tagName);
    }

    private String convertElementString(Element element, UIViewInfo viewInfo, IElementTranslatorStore store, String tagName) throws TemplateTranslateException {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(tagName);
        sb.append(XMLUtil.attributesToString(element));
        sb.append(">");
        sb.append(this.translateChildren(element, viewInfo, store));
        sb.append("</");
        sb.append(tagName);
        sb.append(">");
        return sb.toString();
    }
}

