/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.BASE64Decoder;
import com.kingdee.eas.util.BASE64Encoder;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.base.syssetting.web.util.AESUtil;
import com.kingdee.shr.base.syssetting.web.util.EncrytRule;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class UrlParamEncryptHelper {
    private static Logger logger = Logger.getLogger(UrlParamEncryptHelper.class);

    public static EncrytRule getEncrytRule() {
        EncrytRule encrytRule = EncrytRule.BASE64;
        try {
            if (null != SHRContext.getInstance()) {
                Context context = SHRContext.getInstance().getContext();
                encrytRule = UrlParamEncryptHelper.getEncrytRule0(encrytRule, context);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        return encrytRule;
    }

    public static EncrytRule getEncrytRule(Context context) {
        EncrytRule encrytRule = EncrytRule.BASE64;
        try {
            encrytRule = UrlParamEncryptHelper.getEncrytRule0(encrytRule, context);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        return encrytRule;
    }

    private static EncrytRule getEncrytRule0(EncrytRule encrytRule, Context context) throws BOSException, EASBizException {
        String shrUrlParamEncryptRuleValue = ParamManager.getParamValue((Context)context, null, (String)"ShrUrlParamEncryptRule");
        if (!StringUtils.isEmpty((String)shrUrlParamEncryptRuleValue)) {
            encrytRule = EncrytRule.valueOf(Integer.parseInt(shrUrlParamEncryptRuleValue));
        }
        return encrytRule;
    }

    public static String subPrefixValue(String value) throws IOException {
        Properties p = SHRSyssettingUtil.getKingdeeSupportConfigProperties();
        String prefixString = p.getProperty("PREFIX_STR_Encrypt");
        if (null != value && value.startsWith(prefixString)) {
            return value.substring(prefixString.length());
        }
        return value;
    }

    public static String concatPrefixValue(String value) throws IOException {
        Properties p = SHRSyssettingUtil.getKingdeeSupportConfigProperties();
        String prefixString = p.getProperty("PREFIX_STR_Encrypt");
        if (null != value && !value.startsWith(prefixString)) {
            return prefixString.concat(value);
        }
        return value;
    }

    public static String decodeValue(String value) throws SHRWebException {
        if (StringUtils.isEmpty((String)value)) {
            return value;
        }
        EncrytRule encrytRule = UrlParamEncryptHelper.getEncrytRule();
        return UrlParamEncryptHelper.decodeValue0(value, encrytRule);
    }

    public static String decodeValue(Context ctx, String value) throws SHRWebException {
        if (StringUtils.isEmpty((String)value)) {
            return value;
        }
        EncrytRule encrytRule = UrlParamEncryptHelper.getEncrytRule(ctx);
        return UrlParamEncryptHelper.decodeValue0(value, encrytRule);
    }

    private static String decodeValue0(String value, EncrytRule encrytRule) {
        String sourceValue = value;
        try {
            switch (encrytRule) {
                case AES: {
                    value = UrlParamEncryptHelper.decodeForAes(value);
                    break;
                }
                default: {
                    value = UrlParamEncryptHelper.decodeForBase64(value);
                }
            }
            value = URLDecoder.decode(value, "UTF-8");
        }
        catch (Exception e) {
            value = sourceValue;
            logger.error((Object)MessageFormat.format("UrlParamEncryptHelper#decodeValue0_Ciphertext decryption error : {0},{1}", value, e.getMessage()));
        }
        return value;
    }

    public static String decodeForAes(String value) throws Exception {
        Properties p = SHRSyssettingUtil.getKingdeeSupportConfigProperties();
        return AESUtil.aesDecrypt(value, p.getProperty("AES_ENCRNUMBER_STR_Encrypt"));
    }

    public static String decodeForBase64(String value) throws SHRWebException {
        try {
            value = UrlParamEncryptHelper.subPrefixValue(value);
            if (Base64.isBase64((String)value)) {
                value = new String(new BASE64Decoder().decodeBuffer(value));
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new ShrWebBizException("Ciphertext decryption error :", e);
        }
        return value;
    }

    public static String encodeForBase64(String value) throws SHRWebException {
        try {
            value = new BASE64Encoder().encodeBuffer(value.getBytes()).replaceAll("\\r\\n", "").replaceAll("\\n", "");
            value = UrlParamEncryptHelper.concatPrefixValue(value);
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new ShrWebBizException("Ciphertext decryption error :", e);
        }
        return value;
    }

    public static String encodeValue(Context ctx, String value) throws SHRWebException {
        if (StringUtils.isEmpty((String)value)) {
            return value;
        }
        try {
            EncrytRule encrytRule = UrlParamEncryptHelper.getEncrytRule(ctx);
            value = URLEncoder.encode(value, "UTF-8");
            Properties p = SHRSyssettingUtil.getKingdeeSupportConfigProperties();
            switch (encrytRule) {
                case AES: {
                    value = AESUtil.aesEncrypt(value, p.getProperty("AES_ENCRNUMBER_STR_Encrypt"));
                    break;
                }
                default: {
                    value = UrlParamEncryptHelper.encodeForBase64(value);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new ShrWebBizException("Ciphertext decryption error :", e);
        }
        return value;
    }
}

