/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.util;

import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public final class ZipFileDownAndUploadUtil {
    private static String RESOURCE = "com.kingdee.shr.base.syssetting.SHRSyssettingResource";
    private static Logger logger = Logger.getLogger(ZipFileDownAndUploadUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        if (null == fileMap || fileMap.size() == 0 || fileMap.size() > 1) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "only_one"));
        }
        StringBuffer str = new StringBuffer();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            String fileName = file.getOriginalFilename();
            String type = fileName.substring(fileName.lastIndexOf(".") + 1);
            if (!"zip".equalsIgnoreCase(type)) {
                throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "not_zipfile"));
            }
            ZipInputStream zipIs = null;
            try {
                zipIs = new ZipInputStream(file.getInputStream());
                java.util.zip.ZipEntry zipEntry = null;
                while ((zipEntry = zipIs.getNextEntry()) != null) {
                    try (BufferedReader br = null;){
                        String s;
                        br = new BufferedReader(new InputStreamReader(zipIs));
                        while ((s = br.readLine()) != null) {
                            str.append(s);
                        }
                    }
                    zipIs.closeEntry();
                }
            }
            finally {
                if (zipIs == null) continue;
                zipIs.close();
            }
        }
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String dirPath, String fileName, String data) throws IOException {
        File file;
        File dir = new File(dirPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((file = new File(dir, fileName)).exists()) {
            file.delete();
        }
        try (FileWriter fw = null;){
            fw = new FileWriter(file);
            if (!StringUtils.isEmpty((String)data)) {
                fw.write(data);
            }
            fw.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipSigleFile(String fileNameFullPath, String fullFilePath) throws IOException {
        File zipfile = new File(fileNameFullPath);
        if (zipfile.exists()) {
            zipfile.delete();
        }
        ZipOutputStream zipOut = null;
        FileInputStream in = null;
        BufferedInputStream bi = null;
        try {
            int len;
            zipOut = new ZipOutputStream((OutputStream)new FileOutputStream(fileNameFullPath));
            zipOut.setEncoding("UTF-8");
            byte[] buf = new byte[5120];
            File file = new File(fullFilePath);
            in = new FileInputStream(file);
            bi = new BufferedInputStream(in);
            zipOut.putNextEntry(new ZipEntry(file.getName()));
            while ((len = in.read(buf)) != -1) {
                zipOut.write(buf, 0, len);
            }
        }
        catch (Throwable throwable) {
            ZipFileDownAndUploadUtil.closeStream(new Closeable[]{bi, in, zipOut});
            throw throwable;
        }
        ZipFileDownAndUploadUtil.closeStream(new Closeable[]{bi, in, zipOut});
    }

    private static void closeStream(Closeable ... sList) {
        for (Closeable s : sList) {
            try {
                if (s == null) continue;
                s.close();
            }
            catch (IOException e) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

