/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.mobile.server;

import com.kingdee.bos.Context;
import com.kingdee.bos.actiondispatcher.DispatcherContext;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.mobile.server.WorkflowServerBSFInstance;
import com.kingdee.bos.workflow.monitor.IWfProcDiagramEncoderFacade;
import com.kingdee.bos.workflow.monitor.WfFacadeUtilFactory;
import com.kingdee.bos.workflow.monitor.WfProcDiagramEncoder;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class DownloadAction {
    public void download() throws IOException {
        HttpServletRequest request = DispatcherContext.getHttpServletRequest();
        HttpServletResponse response = DispatcherContext.getHttpServletResponse();
        HttpSession session = request.getSession();
        Context ctx = (Context)session.getAttribute("XTContext");
        WorkflowServerBSFInstance service = WorkflowServerBSFInstance.getInstance(ctx);
        String id = request.getParameter("id");
        String type = request.getParameter("type");
        byte[] bytes = null;
        try {
            bytes = service.getAttachmentAsBytes(id, type);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (bytes == null) {
            response.setContentType("application/octet-stream;charset=UTF-8");
            bytes = new byte[]{};
            response.getOutputStream().write(bytes);
            response.getOutputStream().flush();
        } else {
            response.setContentType("application/octet-stream;UTF-8");
            response.getOutputStream().write(bytes);
            response.getOutputStream().flush();
        }
    }

    public void outProcessDiagram() throws IOException {
        HttpServletRequest request = DispatcherContext.getHttpServletRequest();
        HttpServletResponse response = DispatcherContext.getHttpServletResponse();
        HttpSession session = request.getSession();
        String procInstId = request.getParameter("procInstId");
        Context ctx = (Context)session.getAttribute("XTContext");
        if (procInstId == null) {
            String billid = request.getParameter("billid");
            try {
                ProcessInstInfo[] procs = EnactmentServiceFactory.createEnactService((Context)ctx).getProcessInstanceByHoldedObjectId(billid);
                if (procs.length == 0) {
                    procs = EnactmentServiceFactory.createEnactService((Context)ctx).getAllProcessInstancesByBizobjId(billid);
                }
                procInstId = procs[0].getProcInstId();
            }
            catch (Exception e) {
                Logger.error((Throwable)e, (String)e.getMessage());
            }
        } else {
            procInstId = URLDecoder.decode(procInstId, "utf-8");
        }
        try {
            IWfProcDiagramEncoderFacade encoder = WfFacadeUtilFactory.createRemoteWfProcDiagramEncoder();
            byte[] bs = encoder.getImage(procInstId);
            ByteArrayOutputStream bis = new ByteArrayOutputStream();
            bis.write(bs);
            bis.writeTo((OutputStream)response.getOutputStream());
            bis.close();
        }
        catch (Exception ex) {
            try {
                WfProcDiagramEncoder encoder = new WfProcDiagramEncoder(procInstId, ctx);
                encoder.outputImage((OutputStream)response.getOutputStream(), true);
            }
            catch (Exception e) {
                Logger.error((Throwable)e, (String)e.getMessage());
            }
        }
    }
}

