/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.mobile.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.BlockActivityDef;
import com.kingdee.bos.workflow.define.EndActivityDef;
import com.kingdee.bos.workflow.define.EventActivityDef;
import com.kingdee.bos.workflow.define.ExtenalClassActivityDef;
import com.kingdee.bos.workflow.define.FunctionActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ResponsibleCollection;
import com.kingdee.bos.workflow.define.ResponsibleDef;
import com.kingdee.bos.workflow.define.RouterActivityDef;
import com.kingdee.bos.workflow.define.ScriptActivityDef;
import com.kingdee.bos.workflow.define.ServiceActivityDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.define.extended.BotpActivityDef;
import com.kingdee.bos.workflow.define.extended.ManualDecisionActivityDef;
import com.kingdee.bos.workflow.define.extended.MessageActivityDef;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import org.apache.log4j.Logger;

public class JumpPermissionUtil {
    private static Logger logger = Logger.getLogger(JumpPermissionUtil.class);

    public static boolean checkProcessOperate(ProcessDef processDef, ProcessInstInfo processInstInfo, String permissionName, boolean isOnlyView, Context ctx) throws EASBizException, BOSException {
        String userName = ctx.getUserName();
        UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUser(userName);
        if (user == null) {
            return false;
        }
        String employeeId = (user.getPerson() == null ? user.getId() : user.getPerson().getId()).toString();
        if (JumpPermissionUtil.checkResponsibles(processDef, employeeId)) {
            return true;
        }
        if (isOnlyView && processInstInfo != null) {
            String initiatorId = processInstInfo.getInitiatorId();
            if (user.getId().toString().equals(initiatorId)) {
                return true;
            }
        }
        IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
        try {
            permission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), null, null, permissionName);
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"permission check error!", (Throwable)ex);
            return false;
        }
    }

    private static boolean checkResponsibles(ProcessDef processDef, String employeeId) throws EASBizException, BOSException {
        if (processDef == null) {
            return false;
        }
        ResponsibleCollection respons = processDef.getProcessHeader().getResponsibles();
        if (respons == null) {
            return false;
        }
        for (ResponsibleDef resDef : respons) {
            String id = resDef.getID();
            if (!id.equals(employeeId)) continue;
            return true;
        }
        return false;
    }

    public static boolean canjump(String procInstId, Context ctx) throws Exception {
        IEnactmentService service;
        ProcessInstInfo processInstInfo;
        boolean disableJump = false;
        String parentProcInstId = null;
        if (procInstId.endsWith("WFPCINST") && (processInstInfo = (service = EnactmentServiceFactory.createEnactService((Context)ctx)).getProcessInstInfo(procInstId)) != null) {
            if ("closed.completed".equals(processInstInfo.getState())) {
                disableJump = true;
            }
            parentProcInstId = processInstInfo.getParentProcInstId();
            ProcessDef pdf = service.getProcessDefByDefineHashValue(processInstInfo.getProcDefHashValue());
            if (!JumpPermissionUtil.checkProcessOperate(pdf, null, "", false, ctx)) {
                disableJump = true;
            }
        }
        return disableJump;
    }

    public static String convertActType(ActivityDef actDef) {
        if (actDef instanceof ManpowerActivityDef) {
            return "\u4eba\u5de5";
        }
        if (actDef instanceof StartActivityDef) {
            return "\u5f00\u59cb";
        }
        if (actDef instanceof ApproveActivityDef) {
            return "\u5ba1\u6279";
        }
        if (actDef instanceof BlockActivityDef) {
            return "\u6d3b\u52a8\u5757";
        }
        if (actDef instanceof BotpActivityDef) {
            return "\u5355\u636e\u8f6c\u6362";
        }
        if (actDef instanceof EndActivityDef) {
            return " \u7ed3\u675f";
        }
        if (actDef instanceof EventActivityDef) {
            return "\u4e8b\u4ef6";
        }
        if (actDef instanceof ExtenalClassActivityDef) {
            return " \u5916\u90e8\u8c03\u7528";
        }
        if (actDef instanceof FunctionActivityDef) {
            return "\u51fd\u6570";
        }
        if (actDef instanceof ManualDecisionActivityDef) {
            return "\u4eba\u5de5\u51b3\u7b56";
        }
        if (actDef instanceof MessageActivityDef) {
            return "\u6d88\u606f";
        }
        if (actDef instanceof RouterActivityDef) {
            return "\u8def\u7531";
        }
        if (actDef instanceof ScriptActivityDef) {
            return "\u811a\u672c";
        }
        if (actDef instanceof ServiceActivityDef) {
            return "Web\u670d\u52a1";
        }
        if (actDef instanceof SubflowActivityDef) {
            return "\u5b50\u6d41\u7a0b";
        }
        if (actDef instanceof ToolActivityDef) {
            return "\u81ea\u52a8";
        }
        if (actDef == null) {
            return "";
        }
        return actDef.getType().toString();
    }
}

