/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.mobile.server;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.actiondispatcher.DispatcherContext;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.kscript.runtime.InterpreterException;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.SubmitAssignResult;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ActualParameterDef;
import com.kingdee.bos.workflow.define.AssignmentMessage;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.exception.ForbidForwardException;
import com.kingdee.bos.workflow.ext.Config;
import com.kingdee.bos.workflow.ext.ConfigLoader;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.mobile.server.AddAttachmentUtils;
import com.kingdee.bos.workflow.mobile.server.ApproveHisHelper;
import com.kingdee.bos.workflow.mobile.server.ApproveUtilFactory;
import com.kingdee.bos.workflow.mobile.server.JumpPermissionUtil;
import com.kingdee.bos.workflow.mobile.server.ListDataHelper;
import com.kingdee.bos.workflow.mobile.server.WfUtilFactory;
import com.kingdee.bos.workflow.monitor.ApprovePolicy;
import com.kingdee.bos.workflow.monitor.ApproveUtil;
import com.kingdee.bos.workflow.monitor.DynamicOperationInfo;
import com.kingdee.bos.workflow.monitor.DynamicOperationServiceFactory;
import com.kingdee.bos.workflow.monitor.IDynamicOperationService;
import com.kingdee.bos.workflow.monitor.IDynamicWfServiceFacade;
import com.kingdee.bos.workflow.monitor.IWfProcDiagramEncoderFacade;
import com.kingdee.bos.workflow.monitor.WfFacadeUtilFactory;
import com.kingdee.bos.workflow.monitor.WfProcDiagramEncoder;
import com.kingdee.bos.workflow.monitor.WfUtil;
import com.kingdee.bos.workflow.monitor.app.DynamicWfService;
import com.kingdee.bos.workflow.monitor.app.WfMonitorImageUIFacade;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.AssignmentMonitorService;
import com.kingdee.bos.workflow.service.IAssignmentMonitorService;
import com.kingdee.bos.workflow.service.IDynamicWfService;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.eas.base.attachment.AttachmentCollection;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentFtpFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IAttachmentFtpFacade;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.ftp.AttachmentUploadClient;
import com.kingdee.eas.base.attachment.util.AttachmentUtils;
import com.kingdee.eas.base.attachment.util.VariousAttachmentInfoMaker;
import com.kingdee.eas.base.fme.service.FMEServiceFactory;
import com.kingdee.eas.base.fme.service.IFMEService;
import com.kingdee.eas.base.fme.service.ServiceResult;
import com.kingdee.eas.base.message.util.ProcessCenterUtil;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.IPassComment;
import com.kingdee.eas.base.multiapprove.ManualDecisionInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveManageFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveStatusEnum;
import com.kingdee.eas.base.multiapprove.PassCommentFactory;
import com.kingdee.eas.base.multiapprove.PassCommentInfo;
import com.kingdee.eas.base.multiapprove.PassCommentMonitorUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.util.EASWebContextUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.BASE64Decoder;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.sns.task.util.utils;
import com.kingdee.util.StringUtils;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Blob;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class WorkflowServerBSFInstance {
    private Logger logger = Logger.getLogger(WorkflowServerBSFInstance.class);
    private static final Locale L1 = new Locale("l1");
    private static final Locale L3 = new Locale("l3");
    private Context ctx;
    private static int VERSION_NOW = 3;
    private static final String MULTIAPPROVE_RESOURCE = "com.kingdee.eas.base.multiapprove.MultiApproveResource";

    public static WorkflowServerBSFInstance getInstance(Context ctx) {
        WorkflowServerBSFInstance instance = new WorkflowServerBSFInstance();
        instance.ctx = ctx;
        return instance;
    }

    public Map rollbackAssignment(String assignId) throws BOSException {
        Locale l = this.ctx.getLocale();
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        AssignmentInfo assignmentInfo = svc.getAssignmentById(assignId);
        String actInstId = assignmentInfo.getActInstId();
        String message = "";
        String success = "false";
        if (this.canRollbackAssignment(svc, actInstId)) {
            try {
                String billid = assignmentInfo.getBizObjectIds();
                this.addrollback(this.ctx, billid);
                svc.rollbackActInst(actInstId);
                message = "\u64a4\u56de\u6210\u529f";
                success = "true";
            }
            catch (Exception e) {
                message = "\u64a4\u56de\u5931\u8d25";
            }
        } else {
            message = "\u4e0d\u80fd\u64a4\u56de";
        }
        String returnStr = "";
        returnStr = "{\"message\":\"" + message + "\"}";
        HashMap<String, String> resultmap = new HashMap<String, String>();
        resultmap.put("success", success);
        resultmap.put("message", message);
        return resultmap;
    }

    public Map getList(String sql, String condition, int start, int length, String type) {
        long t1 = System.currentTimeMillis();
        List resultList = null;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            String fprocinstid;
            Map map;
            int i;
            ArrayList<Map> list;
            HttpServletRequest request = DispatcherContext.getHttpServletRequest();
            String eid = (String)request.getSession().getAttribute("eid");
            String openid = (String)request.getSession().getAttribute("openid");
            String userId = this.ctx.getCaller().toString();
            System.out.print("workflowlistaction : " + sql);
            this.logger.error((Object)("workflowlistaction : " + sql));
            System.out.print("workflowlistaction : " + sql);
            this.logger.error((Object)("workflowlistaction : " + sql));
            sql = sql.replace("?", "'" + userId + "'");
            resultList = ListDataHelper.getRowSet(this.ctx, sql, start, length, type);
            System.out.print("workflowlistaction : " + resultList);
            this.logger.error((Object)("workflowlistaction : " + resultList));
            if ("myhavedo".equals(type) || "mydoing".equals(type)) {
                list = new ArrayList<Map>();
                if (resultList.size() > 0) {
                    for (i = 0; i < resultList.size(); ++i) {
                        map = (Map)resultList.get(i);
                        fprocinstid = (String)map.get("fprocinstid");
                        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
                        String billId = service.getBizObjIdByProcessInstanceId(fprocinstid);
                        map.put("fbizobjid", billId);
                        try {
                            if (!StringUtils.isEmpty((String)billId) && billId.length() > 0) {
                                BOSObjectType bostype = BOSUuid.read((String)billId).getType();
                                String billAlias = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity(bostype).getAlias();
                                map.put("billName", billAlias);
                            }
                        }
                        catch (Exception e) {
                            map.put("billName", "");
                        }
                        list.add(map);
                    }
                }
                resultList = list;
            }
            if ("mydoing".equals(type)) {
                list = new ArrayList();
                if (resultList.size() > 0) {
                    for (i = 0; i < resultList.size(); ++i) {
                        HashMap<String, Object> map1;
                        HashMap<Object, Object> checkMap;
                        ArrayList personList;
                        ResultSetMetaData meta;
                        map = (Map)resultList.get(i);
                        fprocinstid = (String)map.get("fprocinstid");
                        String sqlMyDoing_GetPerson = "select fpersonuserid,fpersonusername_l2 fpersonusername from t_wfr_assign where fprocinstid in ('" + fprocinstid + "')";
                        IRowSet countRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sqlMyDoing_GetPerson);
                        if (countRowSet.size() > 0) {
                            meta = countRowSet.getMetaData();
                            personList = new ArrayList();
                            checkMap = new HashMap<Object, Object>();
                            while (countRowSet.next()) {
                                if (countRowSet.getObject(1) != null && !checkMap.containsKey(countRowSet.getObject(1))) {
                                    checkMap.put(countRowSet.getObject(1), countRowSet.getObject(1));
                                    map1 = new HashMap<String, Object>();
                                    map1.put("fpersonusername", countRowSet.getObject(2));
                                    map1.put("fpersonuserid", countRowSet.getObject(1));
                                    personList.add(map1);
                                }
                                map.put("fpersonusername_l2", personList);
                            }
                            list.add(map);
                            continue;
                        }
                        sqlMyDoing_GetPerson = "select fpersonuserid,fpersonusername_l2 fpersonusername from t_wfr_assign where fprocinstid in (select  FPROCINSTID  from t_wfr_procinst where FPARENTPROCINSTID  ='" + fprocinstid + "')";
                        countRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sqlMyDoing_GetPerson);
                        if (countRowSet.size() <= 0) continue;
                        meta = countRowSet.getMetaData();
                        personList = new ArrayList();
                        checkMap = new HashMap();
                        while (countRowSet.next()) {
                            if (countRowSet.getObject(1) != null && !checkMap.containsKey(countRowSet.getObject(1))) {
                                checkMap.put(countRowSet.getObject(1), countRowSet.getObject(1));
                                map1 = new HashMap();
                                map1.put("fpersonusername", countRowSet.getObject(2));
                                map1.put("fpersonuserid", countRowSet.getObject(1));
                                personList.add(map1);
                            }
                            map.put("fpersonusername_l2", personList);
                        }
                        list.add(map);
                    }
                    resultList = list;
                }
            }
            if ("havedo".equals(type)) {
                resultList = this.getProcState(resultList);
            }
            resultMap.put("resultList", resultList);
            resultMap.put("openid", openid);
            resultMap.put("eid", eid);
            resultMap.put("version", VERSION_NOW);
            try {
                String countsql = "select  count(*)   FROM t_wfr_assign a, t_bas_assignread b WHERE  a.fassignid = b.fassignid  AND a.fstate IN (1, 2) AND a.fissendmsg = 1   and fbizobjid is not null  and fpersonuserid =  '" + userId + "'";
                IRowSet countRowSet = DbUtil.executeQuery((Context)this.ctx, (String)countsql);
                if (countRowSet.size() > 0) {
                    ResultSetMetaData meta = countRowSet.getMetaData();
                    while (countRowSet.next()) {
                        if (countRowSet.getObject(1) == null) continue;
                        resultMap.put("listCount", countRowSet.getObject(1).toString());
                    }
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("lightapp getListCount error :: " + e.getMessage()), (Throwable)e);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("lightapp getList error :: " + e.getMessage()), (Throwable)e);
            resultMap.put("success", "false");
            resultMap.put("errorCode", "EAS_ERROR_00003");
            resultMap.put("error", e.getMessage());
        }
        resultMap.put("apiVersion", this.getApiVersion());
        this.logger.debug((Object)("getList time in eas :: " + (System.currentTimeMillis() - t1)));
        return resultMap;
    }

    private List getProcState(List resultList) {
        ArrayList<Map> list = new ArrayList<Map>();
        try {
            for (int i = 0; i < resultList.size(); ++i) {
                boolean isClosedState;
                Map map = (Map)resultList.get(i);
                String fprocinstid = (String)map.get("fprocinstid");
                IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
                String actStateStr = service.getProcessInstInfo(fprocinstid).getState();
                boolean bl = isClosedState = WfState.ABORTED.getValue().equals(actStateStr) || WfState.COMPLETED.getValue().equals(actStateStr) || WfState.TERMINATED.getValue().equals(actStateStr) || WfState.CLOSED.getValue().equals(actStateStr);
                if (isClosedState) {
                    map.put("fstate", "\u5df2\u5b8c\u6210");
                } else {
                    map.put("fstate", "\u8fdb\u884c\u4e2d");
                }
                list.add(map);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getApproveHistory(String billId) {
        long t1 = System.currentTimeMillis();
        ApproveHisHelper a = new ApproveHisHelper();
        a.setContext(this.ctx);
        a.setBillId(billId);
        try {
            ArrayList<HashMap<String, String>> list = a.getHistory();
            this.logger.debug((Object)("getApproveHistory timeout :: " + (System.currentTimeMillis() - t1)));
            return list;
        }
        catch (Exception e) {
            this.logger.error((Object)("lightapp getApproveHistory error :: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public Map getSelectPolicy(String assignID, String value) throws Exception {
        long t1 = System.currentTimeMillis();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            StringBuffer aproveyes = new StringBuffer();
            StringBuffer aproveno = new StringBuffer();
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            AssignmentInfo assign = service.getAssignmentById(assignID);
            ProcessDef processDef = service.getProcessDefByDefineHashValue(assign.getProcDefHashValue());
            ApprovePolicy[] policies = this.getDecisionText(this.ctx, assign, processDef);
            for (int j = 0; j < policies.length; ++j) {
                if ("false".equalsIgnoreCase(policies[j].getApproveResult())) {
                    aproveno.append(policies[j].getKey() + "," + policies[j].getName() + "," + policies[j].getTransitionId() + ";");
                    continue;
                }
                aproveyes.append(policies[j].getKey() + "," + policies[j].getName() + "," + policies[j].getTransitionId() + ";");
            }
            if ("1".equals(value)) {
                map.put("result", aproveyes.toString());
            } else {
                map.put("result", aproveno.toString());
            }
            Map actmap = service.getActivityDefAndActivityInstInfo(assignID);
            ActivityDef def = (ActivityDef)actmap.get("ACTIVITYDEF");
            ExtendedAttributeDef ed = def.getActivityHeader().getExtendedAttributes().get("customUIStatus");
            if (ed != null) {
                String v = ed.getValue();
                if (v != null && v.length() > 0 && "EDIT".equalsIgnoreCase(v)) {
                    map.put("needEdit", true);
                    return map;
                }
                map.put("needEdit", false);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("lightapp getSelectPolicy error :: " + e.getMessage()), (Throwable)e);
            map.put("success", "false");
            map.put("errorCode", e.getMessage());
        }
        try {
            String opinion = this.getDefaultOpinion(assignID);
            map.put("defaultOpinion", opinion);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.logger.error((Object)("getSelectPolicy timeout :: " + (System.currentTimeMillis() - t1)));
        return map;
    }

    public Map submitApprove(String assignID, String ifpass, ArrayList listperSons, String opinion, String policy, String editParam, String billId) {
        long t1 = System.currentTimeMillis();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            MultiApproveInfo info = new MultiApproveInfo();
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            AssignmentInfo assignInfo = service.getAssignmentById(assignID);
            String procinstId = assignInfo.getProcInstId();
            if (StringUtils.isEmpty((String)policy)) {
                policy = "0";
            }
            if (listperSons != null) {
                for (int m = 0; m < listperSons.size(); ++m) {
                    HashMap map1 = (HashMap)listperSons.get(m);
                    String actKey = map1.get("actKey").toString();
                    String[] personIds = map1.get("personId").toString().split(",");
                    ArrayList<String> person = new ArrayList<String>();
                    for (int k = 0; k < personIds.length; ++k) {
                        if (StringUtils.isEmpty((String)personIds[k])) continue;
                        person.add(personIds[k]);
                    }
                    if (person.size() <= 0) continue;
                    service.setProcessContext(procinstId, actKey, person);
                }
            }
            info.setAssignment(assignID);
            String[] bizObjectId = assignInfo.getBizObjectIdArray();
            if (bizObjectId != null && bizObjectId.length > 0) {
                billId = bizObjectId[0];
            }
            info.setBillId(BOSUuid.read((String)billId));
            info.setExtendedProperty("businuessObjectId", bizObjectId.toString());
            info.setExtendedProperty("assignmentID", assignID);
            info.setExtendedProperty("isAddNew", "isAddNew");
            info.setOpinion(opinion);
            if ("1".equals(ifpass)) {
                info.setIsPass(ApproveResult.getEnum((String)"true"));
            } else {
                info.setIsPass(ApproveResult.getEnum((String)"false"));
            }
            if (!StringUtils.isEmpty((String)editParam)) {
                this.saveBill(editParam);
            }
            Map m = this.getSelectPolicy(assignID, ifpass);
            String conten = (String)m.get("result");
            String[] c = conten.split(";");
            String pName = "\u65e0";
            for (int i = 0; i < c.length; ++i) {
                String[] poName = c[i].split(",");
                if (!policy.equals(poName[0]) || poName.length <= 1) continue;
                pName = poName[1];
            }
            info.setHandlerOpinion(Integer.parseInt(policy));
            info.setHandlerContent(pName);
            info.setStatus(MultiApproveStatusEnum.SUBMIT);
            MultiApproveFactory.getLocalInstance((Context)this.ctx).submit((CoreBaseInfo)info);
            map.put("success", true);
            map.put("result", "\u5ba1\u6279\u6210\u529f");
            this.logger.error((Object)("submitApprove timeout :: " + (System.currentTimeMillis() - t1)));
            return map;
        }
        catch (Exception e) {
            this.logger.error((Object)("lightapp submitApprove error :: " + e.getMessage()), (Throwable)e);
            map.put("success", false);
            map.put("errorCode", e.getMessage());
            this.logger.debug((Object)("submitApprove timeout :: " + (System.currentTimeMillis() - t1)));
            return map;
        }
    }

    private ApprovePolicy[] getDecisionText(Context ctx, AssignmentInfo assign, ProcessDef def) {
        long t1 = System.currentTimeMillis();
        ApproveActivityDef actDef = (ApproveActivityDef)def.getActivityDef(assign.getActDefId());
        String decisions = actDef.getManualDecisionItems(ctx.getLocale());
        ExtendedAttributeCollection eac = actDef.getActivityHeader().getExtendedAttributes();
        ExtendedAttributeDef ead = null;
        if (StringUtils.isEmpty((String)decisions)) {
            ead = eac.get("manualDecisionItems");
            decisions = ead != null ? ead.getValue() : null;
        }
        ArrayList<ApprovePolicy> decisionItems = new ArrayList<ApprovePolicy>();
        if (decisions != null && decisions.trim().length() > 0) {
            this.parseDecisionText(decisions, decisionItems, ctx);
        }
        if (decisionItems.size() == 0) {
            decisionItems.add(this.toMap("0", "\u65e0", "true", "\u540c\u610f", "", true, ctx));
            decisionItems.add(this.toMap("0", "\u65e0", "false", "\u4e0d\u540c\u610f", "", true, ctx));
        }
        this.logger.debug((Object)("getDecisionText timeout :: " + (System.currentTimeMillis() - t1)));
        return decisionItems.toArray(new ApprovePolicy[0]);
    }

    private ApprovePolicy toMap(String key, String text, String result, String title, String associatedLine, boolean isAll, Context ctx) {
        if (L1.equals(ctx.getLocale())) {
            if ("\u540c\u610f".equals(title)) {
                title = "Agree";
            } else if ("\u4e0d\u540c\u610f".equals(title)) {
                title = "Disagree";
            }
        } else if (L3.equals(ctx.getLocale())) {
            if ("\u540c\u610f".equals(title)) {
                title = "\u901a\u904e";
            } else if ("\u4e0d\u540c\u610f".equals(title)) {
                title = "\u4e0d\u901a\u904e";
            }
        }
        if (L1.equals(ctx.getLocale())) {
            if (!"none".equalsIgnoreCase(text) && text != null && text.length() > 0) {
                title = title + ", " + text;
            }
        } else if (!"\u65e0".equals(text) && text != null && text.length() > 0) {
            title = title + "\uff0c" + text;
        }
        return new ApprovePolicy(result, key, text, title, associatedLine);
    }

    private void parseDecisionText(String decisions, ArrayList decisionItems, Context ctx) {
        int agrees = 0;
        int disagrees = 0;
        String[] items = StringUtils.split((String)decisions, (String)":");
        for (int i = 0; i < items.length; ++i) {
            String line;
            String[] itemRow = StringUtils.split((String)items[i], (String)";");
            String key = itemRow[0];
            String text = itemRow[1];
            String type = itemRow.length == 2 ? "\u5168\u90e8" : itemRow[2];
            String string = line = itemRow.length < 4 ? "" : itemRow[3];
            if ("agree".equalsIgnoreCase(type) || type.equals("\u540c\u610f")) {
                decisionItems.add(this.toMap(key, text, "true", "\u540c\u610f", line, false, ctx));
                ++agrees;
                continue;
            }
            if ("disagree".equalsIgnoreCase(type) || type.equals("\u4e0d\u540c\u610f")) {
                decisionItems.add(this.toMap(key, text, "false", "\u4e0d\u540c\u610f", line, false, ctx));
                ++disagrees;
                continue;
            }
            if (!"all".equalsIgnoreCase(type) && !type.equals("\u5168\u90e8")) continue;
            decisionItems.add(this.toMap(key, text, "true", "\u540c\u610f", line, true, ctx));
            ++agrees;
            decisionItems.add(this.toMap(key, text, "false", "\u4e0d\u540c\u610f", line, true, ctx));
            ++disagrees;
        }
        if (agrees + disagrees > 0 && agrees * disagrees == 0) {
            if (agrees == 0) {
                decisionItems.add(this.toMap("0", "", "true", "\u540c\u610f", "", true, ctx));
            } else if (disagrees == 0) {
                decisionItems.add(this.toMap("0", "", "false", "\u4e0d\u540c\u610f", "", true, ctx));
            }
        }
    }

    public List executeQuery(String sql, Object[] params) throws Exception {
        long t1 = System.currentTimeMillis();
        IRowSet countRowSet = null;
        countRowSet = params != null && params.length > 0 ? DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])params) : DbUtil.executeQuery((Context)this.ctx, (String)sql);
        ArrayList list = new ArrayList();
        if (countRowSet.size() > 0) {
            ResultSetMetaData meta = countRowSet.getMetaData();
            int count = meta.getColumnCount();
            HashMap<String, String> map = null;
            while (countRowSet.next()) {
                map = new HashMap<String, String>();
                for (int m = 1; m <= count; ++m) {
                    String value = "";
                    if (countRowSet.getObject(m) != null) {
                        value = countRowSet.getObject(m).toString();
                    }
                    map.put(meta.getColumnName(m).toLowerCase(), value);
                }
                list.add(map);
            }
        }
        this.logger.debug((Object)("executeQuery SQL :: " + sql));
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                this.logger.debug((Object)("executeQuery SQL  params :: " + params[i]));
            }
        }
        this.logger.debug((Object)("executeQuery timeout :: " + (System.currentTimeMillis() - t1)));
        return list;
    }

    public Map queryReturnWithOpenId(String sql, Object[] params) throws BOSException, SQLException, UnsupportedEncodingException {
        long t1 = System.currentTimeMillis();
        IRowSet countRowSet = null;
        HttpServletRequest request = DispatcherContext.getHttpServletRequest();
        String userId = this.ctx.getCaller().toString();
        countRowSet = params != null ? DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])params) : DbUtil.executeQuery((Context)this.ctx, (String)sql);
        ArrayList list = new ArrayList();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (countRowSet.size() > 0) {
            ResultSetMetaData meta = countRowSet.getMetaData();
            int count = meta.getColumnCount();
            HashMap<String, Object> map = null;
            while (countRowSet.next()) {
                map = new HashMap<String, Object>();
                for (int m = 1; m <= count; ++m) {
                    map.put(meta.getColumnName(m).toLowerCase(), countRowSet.getObject(m));
                }
                list.add(map);
            }
            returnMap.put("list", list);
        }
        String eid = (String)request.getSession().getAttribute("eid");
        String openid = (String)request.getSession().getAttribute("openid");
        returnMap.put("eid", eid);
        returnMap.put("openid", openid);
        returnMap.put("userId", userId);
        returnMap.put("version", VERSION_NOW);
        returnMap.put("apiVersion", this.getApiVersion());
        this.logger.debug((Object)("queryReturnWithOpenId SQL :: " + sql));
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                this.logger.debug((Object)("queryReturnWithOpenId SQL  params :: " + params[i]));
            }
        }
        this.logger.debug((Object)("queryReturnWithOpenId timeout :: " + (System.currentTimeMillis() - t1)));
        return returnMap;
    }

    public Map executeQueryForPassAssign(String sql, Object[] params) throws BOSException, SQLException, UnsupportedEncodingException {
        HashMap<String, Object> returnMap;
        HttpServletRequest request;
        long t1;
        block14: {
            t1 = System.currentTimeMillis();
            ArrayList list = new ArrayList();
            request = DispatcherContext.getHttpServletRequest();
            returnMap = new HashMap<String, Object>();
            try {
                IRowSet countRowSet = null;
                String userId = this.ctx.getCaller().toString();
                sql = sql.replace("?", userId);
                countRowSet = params != null ? DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])params) : DbUtil.executeQuery((Context)this.ctx, (String)sql);
                IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx);
                if (countRowSet.size() <= 0) break block14;
                ResultSetMetaData meta = countRowSet.getMetaData();
                int count = meta.getColumnCount();
                HashMap<String, String> map = null;
                while (countRowSet.next()) {
                    map = new HashMap<String, String>();
                    for (int m = 1; m <= count; ++m) {
                        String value = "";
                        if (countRowSet.getObject(m) != null) {
                            value = countRowSet.getObject(m).toString();
                        }
                        if ("fsourceids".equalsIgnoreCase(meta.getColumnName(m).toLowerCase())) {
                            String valueO = countRowSet.getObject(m).toString();
                            map.put("fsourceids", valueO);
                            String[] sourcdids = valueO.replace("PASS::", "").split(":");
                            String[] sourcdidsnew = valueO.split("\\|");
                            String fproinstid = "";
                            String billid = "";
                            if (sourcdids.length == 1 && sourcdidsnew.length > 1) {
                                map.put("type", "passcommonent");
                                billid = sourcdidsnew[2];
                                fproinstid = sourcdidsnew[1];
                            } else {
                                billid = sourcdids[1];
                                fproinstid = sourcdids[0];
                            }
                            if (!StringUtils.isEmpty((String)billid)) {
                                String billName = loader.getEntity(BOSUuid.read((String)billid).getType()).getAlias();
                                map.put("billName", billName);
                            }
                            map.put("fbizobjid", billid);
                            map.put("fproinstid", fproinstid);
                            String personsql = "select finitiatorid,finitiatorname_l2 from t_wfr_procinst where fprocinstid= '" + fproinstid + "'";
                            IRowSet percountRowSet = DbUtil.executeQuery((Context)this.ctx, (String)personsql);
                            if (percountRowSet.size() <= 0) continue;
                            ResultSetMetaData permeta = percountRowSet.getMetaData();
                            int percount = permeta.getColumnCount();
                            if (!percountRowSet.next()) continue;
                            for (int k = 1; k <= percount; ++k) {
                                if (percountRowSet.getObject(k) != null) {
                                    value = percountRowSet.getObject(k).toString();
                                }
                                map.put(permeta.getColumnName(k).toLowerCase(), value);
                            }
                            continue;
                        }
                        if ("fsendtime".equalsIgnoreCase(meta.getColumnName(m).toLowerCase())) {
                            SimpleDateFormat s = new SimpleDateFormat("MM-dd HH:mm");
                            map.put("fsendtime", s.format(countRowSet.getObject(m)));
                            continue;
                        }
                        map.put(meta.getColumnName(m).toLowerCase(), value);
                    }
                    list.add(map);
                }
                returnMap.put("list", list);
            }
            catch (Exception e) {
                this.logger.error((Object)("lightapp executeQueryForPassAssign error :: " + e.getMessage()), (Throwable)e);
                returnMap.put("success", "false");
                returnMap.put("errorCode", e.getMessage());
            }
        }
        String eid = (String)request.getSession().getAttribute("eid");
        String openid = (String)request.getSession().getAttribute("openid");
        returnMap.put("eid", eid);
        returnMap.put("openid", openid);
        returnMap.put("version", VERSION_NOW);
        this.logger.debug((Object)("executeQueryForPassAssign SQL :: " + sql));
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                this.logger.debug((Object)("executeQueryForPassAssign SQL  params :: " + params[i]));
            }
        }
        this.logger.debug((Object)("executeQueryForPassAssign timeout :: " + (System.currentTimeMillis() - t1)));
        return returnMap;
    }

    public Object excuteScript(String script, Map params) {
        long t1 = System.currentTimeMillis();
        Interpreter interpreter = new Interpreter();
        interpreter.setSupportDebug(false);
        interpreter.setProperyExprOwnerNullIgore(true);
        interpreter.setForBot(true);
        params.put("__bosContext", this.ctx);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("data", interpreter.eval(script, params));
            result.put("state", "success");
        }
        catch (InterpreterException e) {
            InvocationTargetException targetExp;
            String errorMsg = e.getInfoId() + "  : " + e.getErrorLineCode();
            if (e.getCause() != null && e.getCause() instanceof InvocationTargetException && (targetExp = (InvocationTargetException)e.getCause()).getCause() != null && targetExp.getCause().getMessage() != null) {
                errorMsg = errorMsg + targetExp.getCause().getMessage();
            }
            result.put("state", "fail");
            result.put("msg", errorMsg);
            this.logger.error((Object)("lightapp excuteScript error :: " + e.getMessage()), (Throwable)e);
            result.put("success", "false");
            result.put("errorCode", errorMsg);
            this.logger.debug((Object)("excuteScript timeout :: " + (System.currentTimeMillis() - t1)));
            return result;
        }
        catch (Exception e2) {
            this.logger.error((Object)("lightapp excuteScript error :: " + e2.getMessage()), (Throwable)e2);
            result.put("success", "false");
            result.put("errorCode", e2.getMessage());
        }
        this.logger.debug((Object)("excuteScript timeout :: " + (System.currentTimeMillis() - t1)));
        return result;
    }

    public Map forward(String assignId, String billID, String toPersonId, Map opinionMap, String opinion) throws Exception {
        long t1 = System.currentTimeMillis();
        HashMap<String, String> ret = new HashMap<String, String>();
        PersonInfo p = ContextUtil.getCurrentUserInfo((Context)this.ctx).getPerson();
        try {
            String allow = this.allowForward(assignId);
            if (!"true".equals(allow)) {
                ret.put("faild", "\u65e0\u8f6c\u4ea4\u6743\u9650");
                ret.put("reason", "");
                ret.put("success", "\u65e0\u8f6c\u4ea4\u6743\u9650");
                ret.put("errorCode", "");
                return ret;
            }
            String personId = p.getId().toString();
            if (personId.equals(toPersonId)) {
                ret.put("faild", "\u4e0d\u80fd\u8f6c\u4ea4\u7ed9\u81ea\u5df1");
                ret.put("success", "");
                ret.put("", "");
                return ret;
            }
            long t2 = System.currentTimeMillis();
            Person[] persons = EnactmentServiceFactory.createEnactService((Context)this.ctx).getPersonByPersonID(toPersonId);
            this.logger.debug((Object)("forward getPerson cost :: " + (System.currentTimeMillis() - t2)));
            String toUserId = persons[0].getUserId();
            String toUserName = persons[0].getUserName(new Locale("l2"));
            HashMap m = new HashMap();
            for (Object lan : opinionMap.keySet()) {
                if (lan == null) continue;
                m.put(new Locale(lan.toString()), opinionMap.get(lan));
            }
            t2 = System.currentTimeMillis();
            try {
                new WfUtil(this.ctx).forward(assignId, toUserId, m, opinion);
            }
            catch (ForbidForwardException e) {
                ret.put("faild", "\u65e0\u8f6c\u4ea4\u6743\u9650");
                ret.put("reason", "");
                ret.put("success", "\u65e0\u8f6c\u4ea4\u6743\u9650");
                ret.put("errorCode", "");
                return ret;
            }
            this.logger.debug((Object)("forward forward cost :: " + (System.currentTimeMillis() - t2)));
            this.appendOpinion(assignId, billID, opinion, toUserName + " \u4ee3\u7406 " + p.toString());
            this.logger.debug((Object)("forward timeout :: " + (System.currentTimeMillis() - t1)));
        }
        catch (Exception t) {
            ret.put("faild", "\u8f6c\u4ea4\u5931\u8d25");
            ret.put("reason", "");
            this.logger.error((Object)("lightapp forward error :: " + t.getMessage()), (Throwable)t);
            ret.put("success", "false");
            ret.put("errorCode", t.getMessage());
            return ret;
        }
        ret.put("success", "\u8f6c\u4ea4\u6210\u529f");
        ret.put("faild", "");
        ret.put("reason", "");
        return ret;
    }

    public String allowForward(String assignmentIds) {
        String result = "";
        boolean allowForward = false;
        String[] ids = StringUtils.split((String)assignmentIds, (String)";");
        ArrayList<String> idStr = new ArrayList<String>();
        for (int i = 0; i < ids.length; ++i) {
            if (StringUtils.isEmpty((String)ids[i])) continue;
            String tmp = ids[i].toString();
            idStr.add(tmp);
        }
        String[] assignIds = idStr.toArray(new String[1]);
        IEnactmentService enactServe = null;
        try {
            enactServe = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            allowForward = enactServe.allowForward(assignIds);
            result = String.valueOf(allowForward);
        }
        catch (WfException e) {
            result = "Function allowForward of EnactmentService is error";
        }
        catch (BOSException e) {
            result = "createEnactService error";
        }
        return result;
    }

    public void passAssign(Map map, String[] usetList, Map opinionMap, Map localMap) throws Exception {
        long t1 = System.currentTimeMillis();
        try {
            MultiApproveInfo info = new MultiApproveInfo();
            info.setAssignment((String)map.get("assignment"));
            info.setBillId(BOSUuid.read((String)((String)map.get("billId"))));
            String assignID = (String)map.get("assignment");
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            AssignmentInfo assignInfo = service.getAssignmentById(assignID);
            String billID = assignInfo.getAssignInfo().getBizObjID();
            StringBuilder sb1 = new StringBuilder();
            sb1.append("PASS:");
            sb1.append(":").append(assignInfo.getProcInstId());
            sb1.append(":").append(billID);
            sb1.append(":").append(this.ctx.getCaller().toString());
            sb1.append(":").append(map.get("isproccloss"));
            sb1.append(":").append(map.get("isAllowrepass"));
            sb1.append(":").append(assignID);
            opinionMap.put("sourceIds", sb1.toString());
            HashMap m = new HashMap();
            for (Object lan : localMap.keySet()) {
                if (lan == null) continue;
                m.put(new Locale(lan.toString()), localMap.get(lan));
            }
            m.putAll(opinionMap);
            String personIds = (String)opinionMap.get("personIdList");
            ArrayList<String> personIdSet = new ArrayList<String>();
            JSONArray personList = JSON.parseArray((String)personIds);
            for (int len = 0; len < personList.size(); ++len) {
                personIdSet.add((String)personList.get(len));
            }
            ArrayList<String> useridlis = new ArrayList<String>();
            for (int i = 0; i < usetList.length; ++i) {
                Person[] persons = service.getPersonByPersonID(usetList[i]);
                for (int j = 0; j < persons.length; ++j) {
                    Person person = persons[j];
                    if (person == null) continue;
                    useridlis.add(person.getUserId());
                }
            }
            UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)this.ctx);
            Locale[] locales = ApplicationUtil.getContextLocales((Context)this.ctx);
            String opinion = (String)map.get("opinion");
            for (int i = 0; i < locales.length; ++i) {
                Locale locale = locales[i];
                String data = "\n\n/*" + ResourceBase.getString((String)MULTIAPPROVE_RESOURCE, (String)"passaround_title", (Locale)locale) + "\r\n" + opinion + "\r\n" + ResourceBase.getString((String)MULTIAPPROVE_RESOURCE, (String)"passaround.user", (Locale)locale) + currentUserInfo.getName(locale);
                m.put(locale, data);
                m.put("opinion" + locale.getDisplayName(), opinion);
            }
            String[] newids = new String[useridlis.size()];
            for (int k = 0; k < useridlis.size(); ++k) {
                newids[k] = (String)useridlis.get(k);
            }
            m.put("personIdList", personIdSet);
            MultiApproveManageFactory.getLocalInstance((Context)this.ctx).sendPassAroundMsgWithOption(info, newids, m);
        }
        catch (Exception e) {
            this.logger.error((Object)("lightapp passAssign error :: " + e.getMessage()), (Throwable)e);
        }
        this.logger.debug((Object)("passAssign timeout :: " + (System.currentTimeMillis() - t1)));
    }

    public Map joinApprover(Map params) throws Exception {
        long t1 = System.currentTimeMillis();
        String opinion = (String)params.get("opinion");
        String assignmentId = (String)params.get("assignID");
        String billId = (String)params.get("billId");
        String procInstId = (String)params.get("procInstId");
        String persons = (String)params.get("personID");
        String personName = (String)params.get("personName");
        String[] personIDS = persons.split(",");
        String[] personNameArray = personName.split(",");
        HashSet<String> selectedPersonIds = new HashSet<String>();
        PersonInfo p = ContextUtil.getCurrentUserInfo((Context)this.ctx).getPerson();
        String personId = p.getId().toString();
        HashMap<String, String> remap = new HashMap<String, String>();
        for (int k = 0; k < personIDS.length; ++k) {
            selectedPersonIds.add(personIDS[k]);
            if (!personId.equals(personIDS[k])) continue;
            remap.put("faild", "\u4e0d\u80fd\u4f1a\u7b7e\u7ed9\u81ea\u5df1");
            remap.put("success", "");
            remap.put("", "");
            return remap;
        }
        String personNameStr = "";
        try {
            UserInfo info = ContextUtil.getCurrentUserInfo((Context)this.ctx);
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            HashMap<String, Object> counterSignInfoMap = new HashMap<String, Object>();
            Locale l = new Locale("l1");
            map.put(l, opinion + "\r\n\r\n" + info.getName(l));
            l = new Locale("l2");
            map.put(l, opinion + "\r\n\r\n" + info.getName(l));
            l = new Locale("l3");
            map.put(l, opinion + "\r\n\r\n" + info.getName(l));
            map.put("assignCountersign", Boolean.TRUE);
            this.setCounterSignInfo(counterSignInfoMap, info, this.ctx.getLocale(), opinion);
            counterSignInfoMap.put("procInstId", procInstId);
            map.put("counterSignInfo", counterSignInfoMap);
            service.assignCountersign(assignmentId, selectedPersonIds.toArray(new String[0]), map);
            for (int k = 0; k < personNameArray.length; ++k) {
                personNameStr = personNameStr + "\u3010" + personNameArray[k] + "\u3011";
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("lightapp joinApprover failed. " + e.getMessage()), (Throwable)e);
            remap.put("failed", "\u4f1a\u7b7e\u5931\u8d25");
            remap.put("success", "false");
            remap.put("errorCode", e.getMessage());
            this.logger.error((Object)("joinApprover timeout :: " + (System.currentTimeMillis() - t1)));
            return remap;
        }
        this.appendOpinion(assignmentId, billId, opinion, "\u3010" + p.toString() + "\u3011" + "\u4f1a\u7b7e\u7ed9 " + personNameStr);
        remap.put("failed", "");
        remap.put("success", "\u4f1a\u7b7e\u6210\u529f");
        this.logger.debug((Object)("joinApprover timeout :: " + (System.currentTimeMillis() - t1)));
        return remap;
    }

    public List getDesignPerson(Map params) throws Exception {
        long t1 = System.currentTimeMillis();
        String assignmentId = (String)params.get("assignID");
        ArrayList reList = new ArrayList();
        try {
            Locale locale = this.ctx.getLocale();
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            AssignmentInfo assignInfo = service.getAssignmentById(assignmentId);
            String procInstId = assignInfo.getProcInstId();
            Map map = service.getProcessContext(procInstId);
            HashSet assignmentIds = (HashSet)map.get("countersignAssignments");
            if (assignmentIds == null) {
                assignmentIds = new HashSet();
            }
            String actInstId = assignInfo.getActInstId();
            Iterator iterator = assignmentIds.iterator();
            IPerson iPerson = PersonFactory.getLocalInstance((Context)this.ctx);
            String isAssigned = this.getResoureText("isAssigned");
            boolean hasAssigned = false;
            HashSet<String> selectedPersonIds = new HashSet<String>();
            while (iterator.hasNext()) {
                String empId;
                String assignId = (String)iterator.next();
                AssignmentInfo info = service.getAssignmentById(assignId);
                if (WfAssignmentState.CANCELED == info.getState() || WfAssignmentState.COMPLETED == info.getState() || WfAssignmentState.PROCESSING == info.getState() || WfAssignmentState.REJECTED == info.getState() || !info.getActInstId().equals(actInstId) || selectedPersonIds.contains(empId = info.getEmployeeId())) continue;
                hasAssigned = true;
                PersonInfo personInfo = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(empId));
                if (selectedPersonIds.contains(empId)) continue;
                selectedPersonIds.add(empId);
                HashMap<String, String> approver = new HashMap<String, String>();
                approver.put("fpersonid", empId);
                approver.put("isAssigned", isAssigned);
                approver.put("fname_l2", personInfo.getName(locale));
                reList.add(approver);
            }
            if (!hasAssigned) {
                AssignmentInfo[] infos = service.getAssignmentByActInstId(actInstId);
                HashSet<String> set = new HashSet<String>();
                for (int i = 0; i < infos.length; ++i) {
                    String personId;
                    AssignmentInfo info = infos[i];
                    if (WfAssignmentState.CANCELED == info.getState() || WfAssignmentState.COMPLETED == info.getState() || WfAssignmentState.PROCESSING == info.getState() || WfAssignmentState.REJECTED == info.getState() || set.contains(personId = info.getEmployeeId())) continue;
                    set.add(personId);
                    PersonInfo person = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
                    if (selectedPersonIds.contains(personId)) continue;
                    selectedPersonIds.add(personId);
                    HashMap<String, String> approver = new HashMap<String, String>();
                    approver.put("fpersonid", personId);
                    approver.put("isAssigned", isAssigned);
                    approver.put("fname_l2", person.getName(locale));
                    reList.add(approver);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("lightapp getDesignPerson error :: " + e));
        }
        this.logger.debug((Object)("getDesignPerson timeout :: " + (System.currentTimeMillis() - t1)));
        return reList;
    }

    private String getResoureText(String string) {
        return null;
    }

    private void setCounterSignInfo(Map<String, Object> map, UserInfo user, Locale locale, String opinion) {
        HashMap<Locale, String> commentMap = new HashMap<Locale, String>();
        commentMap.put(locale, StringUtils.trim((String)opinion));
        HashMap<Object, String> initiatorMap = new HashMap<Object, String>();
        initiatorMap.put(locale, user.getName(locale));
        initiatorMap.put("counterSignInitiatorID", user.getId() != null ? user.getId().toString() : "");
        map.put("counterSignComment", commentMap);
        map.put("counterSignInitiator", initiatorMap);
    }

    public Map submitPassComment(Map params) throws Exception {
        ProcessInstInfo info;
        String billId;
        long t1 = System.currentTimeMillis();
        String opinion = (String)params.get("opinion");
        String assignId = (String)params.get("assignID");
        String passId = (String)params.get("passId");
        String id = (String)params.get("id");
        String billID = (String)params.get("billID");
        String passerId = (String)params.get("personID");
        String procInstId = (String)params.get("procInstId");
        String parameter = (String)params.get("parameter");
        String chksendMessage = (String)params.get("chksendMessage");
        String chksendMobile = (String)params.get("chksendMobile");
        String chksendMail = (String)params.get("chksendMail");
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        HashMap<String, String> remap = new HashMap<String, String>();
        boolean isFeedBack = false;
        boolean cannotSubmit = false;
        boolean complete = true;
        if (billID != null && !"".equals(billID)) {
            billId = billID;
            ProcessInstInfo[] procs = svc.getProcessInstanceByHoldedObjectId(billId);
            if (!(procs != null && procs.length != 0 || (procs = svc.getAllProcessInstancesByBizobjId(billId)) != null && procs.length != 0)) {
                remap.put("failed", "\u6ca1\u6709\u6d41\u7a0b\u5b9e\u4f8b!");
                remap.put("success", "");
                return remap;
            }
            String state = "";
            procInstId = "";
            for (int i = 0; i < procs.length; ++i) {
                state = procs[i].getState();
                procInstId = procs[i].getProcInstId();
                if (!state.startsWith("open.running")) continue;
                complete = false;
                break;
            }
            if (!state.startsWith("open.running")) {
                Timestamp d = null;
                for (int i = 0; i < procs.length; ++i) {
                    Timestamp tmp = procs[i].getCreatedTime();
                    if (d != null && d.after((Date)tmp)) continue;
                    d = tmp;
                    state = procs[i].getState();
                    procInstId = procs[i].getProcInstId();
                }
            }
            cannotSubmit = false;
        } else {
            String lastItemStr;
            String[] tmp = parameter.substring("PASS::".length()).split(":");
            if (tmp != null && tmp.length > 0 && !StringUtils.isEmpty((String)(lastItemStr = tmp[tmp.length - 1])) && lastItemStr.endsWith("PASSID")) {
                passId = lastItemStr;
                assignId = tmp[tmp.length - 2];
            }
            procInstId = tmp[0];
            billId = tmp[1];
            passerId = tmp[2];
            cannotSubmit = Boolean.parseBoolean(tmp[3]);
        }
        if (cannotSubmit && (info = svc.getProcessInstInfo(procInstId)) != null && info.getState().startsWith("open.running")) {
            cannotSubmit = false;
        }
        if (cannotSubmit) {
            cannotSubmit = true;
            remap.put("failed", "\u7981\u6b62\u53cd\u9988\u6b64\u6b21\u4f20\u9605!");
            remap.put("success", "");
            return remap;
        }
        isFeedBack = PassCommentMonitorUtil.isAlreadyPassFeedBack((Context)this.ctx, (String)passId, (String)this.ctx.getCaller().toString());
        if (isFeedBack) {
            cannotSubmit = true;
            remap.put("failed", "\u60a8\u5df2\u53cd\u9988\u6b64\u4f20\u9605\uff0c\u7981\u6b62\u91cd\u590d\u53cd\u9988!");
            remap.put("success", "");
            return remap;
        }
        if (opinion == null || opinion.length() == 0) {
            opinion = "";
        }
        HashMap<Object, String> map = new HashMap<Object, String>();
        String callerName = null;
        AssignInfo assignInfo = null;
        UserInfo userInfo = null;
        try {
            userInfo = UserFactory.getLocalInstance((Context)this.ctx).getUserInfo("where id='" + this.ctx.getCaller().toString() + "'");
            callerName = userInfo.getName(this.ctx.getLocale());
            if (assignId != null) {
                assignInfo = EnactmentServiceFactory.createEnactService((Context)this.ctx).getAssignmentById(assignId).getAssignInfo();
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("lightapp submitPassComment error:  get username by id[" + this.ctx.getCaller().toString() + "] error:" + ex.getMessage()), (Throwable)ex);
            callerName = "";
        }
        if (assignInfo == null) {
            map.put(new Locale("l1"), "Get the reply message from " + callerName);
            map.put(new Locale("l2"), "\u6536\u5230\u6765\u81ea " + callerName + " \u7684\u4f20\u9605\u53cd\u9988\u4fe1\u606f");
            map.put(new Locale("l3"), "\u6536\u5230\u4f86\u81ea " + callerName + " \u7684\u50b3\u95b1\u53cd\u994b\u4fe1\u606f");
        } else {
            Locale L = new Locale("l1");
            map.put(L, "Reply[" + assignInfo.getSubject(L) + "]");
            L = new Locale("l2");
            map.put(L, "\u4f20\u9605\u53cd\u9988[" + assignInfo.getSubject(L) + "]");
            L = new Locale("l3");
            map.put(L, "\u50b3\u95b1\u53cd\u994b[" + assignInfo.getSubject(L) + "]");
        }
        try {
            String personId = "";
            callerName = userInfo.getName(this.ctx.getLocale());
            PersonInfo personInfo = userInfo.getPerson();
            if (personInfo != null) {
                personId = personInfo.getId().toString();
            }
            if (opinion.length() > 500) {
                throw new Exception("");
            }
            IPassComment pass = PassCommentFactory.getLocalInstance((Context)this.ctx);
            PassCommentInfo comment = null;
            if (!StringUtils.isEmpty((String)passId) && !StringUtils.isEmpty((String)personId) && (comment = pass.getPassCommentInfo("  where passId='" + passId + "' and personId='" + personId + "'")) != null) {
                comment.setComment(opinion, this.ctx.getLocale());
                comment.setUpdateTime(new Timestamp(System.currentTimeMillis()));
                pass.save((CoreBaseInfo)comment);
            }
            if (comment == null) {
                comment = new PassCommentInfo();
                comment.setInitiator("");
                comment.setBillId(billId);
                comment.setProcInstId(procInstId);
                comment.setUserID(this.ctx.getCaller().toString());
                comment.setComment(opinion, this.ctx.getLocale());
                pass.addnew(comment);
            }
            map.put("receiver", passerId);
            map.put("sender", callerName);
            map.put("body", opinion);
            if ("yes".equals(chksendMessage)) {
                map.put("is_message", "true");
            }
            if ("yes".equals(chksendMobile)) {
                map.put("is_mobile", "true");
            }
            if ("yes".equals(chksendMail)) {
                map.put("is_mail", "true");
            }
            map.put("boid", billId);
            map.put("procInstId", procInstId);
            pass.sendReplyMessage(map);
        }
        catch (Exception e) {
            this.logger.error((Object)("lightapp submitPassComment error :: " + e.getMessage()), (Throwable)e);
            remap.put("success", "false");
            remap.put("errorCode", e.getMessage());
            remap.put("failed", "\u4f20\u9605\u53cd\u9988\u5931\u8d25");
            this.logger.error((Object)("submit timeout :: " + (System.currentTimeMillis() - t1)));
            return remap;
        }
        boolean result = ProcessCenterUtil.setReadStatus((String)("'" + id + "'"), (int)10, (int)0, (Context)this.ctx);
        remap.put("failed", "");
        remap.put("success", "\u4f20\u9605\u53cd\u9988\u6210\u529f");
        this.logger.debug((Object)("submit timeout :: " + (System.currentTimeMillis() - t1)));
        return remap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttachment(String id, String type) throws EASBizException, BOSException, UnsupportedEncodingException {
        File file;
        long t1;
        block37: {
            t1 = System.currentTimeMillis();
            file = null;
            if (!StringUtils.isEmpty((String)id)) {
                id = AttachmentUtils.init().checkID(id);
                AttachmentInfo info = null;
                FileOutputStream out = null;
                String fileName = "";
                String simpleName = "";
                byte[] size = null;
                try {
                    if ("BILLATTACH".equals(type)) {
                        String sql = "select FileData from T_BAS_BillAttachment where FID ='" + id + "'";
                        IRowSet countRowSet = null;
                        countRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                        if (countRowSet.size() > 0) {
                            while (countRowSet.next()) {
                                Blob sx = null;
                                sx = countRowSet.getBlob(1);
                                size = sx.getBytes(1L, (int)sx.length());
                            }
                        } else {
                            sql = "select fdocentity from T_CP_Document where FID ='" + id + "'";
                            countRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                            if (countRowSet.size() > 0) {
                                while (countRowSet.next()) {
                                    Blob sx = null;
                                    sx = countRowSet.getBlob(1);
                                    size = sx.getBytes(1L, (int)sx.length());
                                }
                            } else {
                                sql = "select FDocEntity from T_CP_DocReceive where FID ='" + id + "'";
                                countRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                                if (countRowSet.size() > 0) {
                                    while (countRowSet.next()) {
                                        Blob sx = null;
                                        sx = countRowSet.getBlob(1);
                                        size = sx.getBytes(1L, (int)sx.length());
                                    }
                                } else {
                                    sql = "select FDocEntity from T_CP_DocDispatch where FID ='" + id + "'";
                                    countRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                                    if (countRowSet.size() > 0) {
                                        while (countRowSet.next()) {
                                            Blob sx = null;
                                            sx = countRowSet.getBlob(1);
                                            size = sx.getBytes(1L, (int)sx.length());
                                        }
                                    } else {
                                        sql = "select FContentFile  from T_CON_ContractContent where FID ='" + id + "'";
                                        countRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                                        if (countRowSet.size() > 0) {
                                            while (countRowSet.next()) {
                                                Blob sx = null;
                                                sx = countRowSet.getBlob(1);
                                                size = sx.getBytes(1L, (int)sx.length());
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        simpleName = "doc";
                        fileName = "\u6b63\u6587";
                        break block37;
                    }
                    if ("FTP".equals(type)) {
                        String path1;
                        IFMEService fmeService = FMEServiceFactory.getServiceInstance((Context)this.ctx);
                        HttpServletRequest request = DispatcherContext.getHttpServletRequest();
                        ServiceResult re = fmeService.downloadFileInServer(id, request);
                        String string = path1 = re.getResultDetail();
                        return string;
                    }
                    if (!StringUtils.isEmpty((String)id)) {
                        try {
                            AttachmentCollection col;
                            BOSUuid.read((String)id);
                            info = AttachmentFactory.getLocalInstance((Context)this.ctx).getAttachmentInfo((IObjectPK)new ObjectUuidPK(id));
                            if (info == null && (col = AttachmentFactory.getLocalInstance((Context)this.ctx).getAttachmentCollection("where attachID = '" + id + "'")) != null && col.size() > 0) {
                                info = col.get(0);
                            }
                        }
                        catch (Exception e) {
                            info = AttachmentFactory.getLocalInstance((Context)this.ctx).getAttachmentInfo("where attachID = '" + id + "'");
                        }
                        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)this.ctx);
                        size = asm.download(info.getId().toString());
                        simpleName = info.getSimpleName();
                        fileName = info.getName();
                    }
                    String path = System.getProperty("EAS_HOME");
                    file = new File(path = path + "/server/deploy/eas.ear/light_app_bas.war/download/");
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    file = new File(path + fileName + "." + simpleName);
                    Random rom = new Random();
                    while (file.exists()) {
                        file = new File(path + fileName + "." + rom.nextInt(1000) + "." + simpleName);
                    }
                    out = new FileOutputStream(file);
                    out.write(size);
                    out.flush();
                }
                catch (Exception e) {
                    this.logger.error((Object)("lightapp getAttachMent error :: " + e.getMessage()), (Throwable)e);
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (Exception ex) {
                        this.logger.error((Object)ex);
                    }
                }
            }
        }
        this.logger.debug((Object)("getAttachMent timeout :: " + (System.currentTimeMillis() - t1)));
        return file.getName();
    }

    public byte[] getAttachmentAsBytes(String id, String type) throws EASBizException, BOSException, UnsupportedEncodingException {
        long t1 = System.currentTimeMillis();
        Object file = null;
        if (!StringUtils.isEmpty((String)id)) {
            id = AttachmentUtils.init().checkID(id);
            AttachmentInfo info = null;
            Object out = null;
            String fileName = "";
            String simpleName = "";
            byte[] size = null;
            try {
                if ("BILLATTACH".equals(type)) {
                    this.logger.error((Object)("lightapp getAttachmentAsBytes  :: type" + type));
                    String sql = "select FileData from T_BAS_BillAttachment where FID ='" + id + "'";
                    IRowSet countRowSet = null;
                    countRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                    this.logger.error((Object)("lightapp getAttachmentAsBytes  :: countRowSet.size() =" + countRowSet.size()));
                    if (countRowSet.size() > 0) {
                        while (countRowSet.next()) {
                            Blob sx = null;
                            sx = countRowSet.getBlob(1);
                            size = sx.getBytes(1L, (int)sx.length());
                        }
                    } else {
                        sql = "select FDocEntity from T_CP_DocDispatch where FID ='" + id + "'";
                        countRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                        this.logger.error((Object)("lightapp getAttachmentAsBytes  :: countRowSet.size() =" + countRowSet.size()));
                        if (countRowSet.size() > 0) {
                            while (countRowSet.next()) {
                                Blob sx = null;
                                sx = countRowSet.getBlob(1);
                                size = sx.getBytes(1L, (int)sx.length());
                            }
                        } else {
                            sql = "select FDocEntity from T_CP_DocReceive where FID ='" + id + "'";
                            countRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                            this.logger.error((Object)("lightapp getAttachmentAsBytes  :: countRowSet.size() =" + countRowSet.size()));
                            if (countRowSet.size() > 0) {
                                while (countRowSet.next()) {
                                    Blob sx = null;
                                    sx = countRowSet.getBlob(1);
                                    size = sx.getBytes(1L, (int)sx.length());
                                }
                            } else {
                                sql = "select fdocentity from T_CP_Document where FID ='" + id + "'";
                                countRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                                this.logger.error((Object)("lightapp getAttachmentAsBytes  :: countRowSet.size() =" + countRowSet.size()));
                                if (countRowSet.size() > 0) {
                                    while (countRowSet.next()) {
                                        Blob sx = null;
                                        sx = countRowSet.getBlob(1);
                                        size = sx.getBytes(1L, (int)sx.length());
                                    }
                                } else {
                                    sql = "select FContentFile  from T_CON_ContractContent where FID ='" + id + "'";
                                    countRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                                    if (countRowSet.size() > 0) {
                                        while (countRowSet.next()) {
                                            Blob sx = null;
                                            sx = countRowSet.getBlob(1);
                                            size = sx.getBytes(1L, (int)sx.length());
                                        }
                                    }
                                }
                            }
                        }
                    }
                    simpleName = "doc";
                    fileName = "\u6b63\u6587";
                } else {
                    if ("FTP".equals(type)) {
                        int n;
                        IFMEService fmeService = FMEServiceFactory.getServiceInstance((Context)this.ctx);
                        HttpServletRequest request = DispatcherContext.getHttpServletRequest();
                        String sql = "select fbusinessid,fdocumentid from t_fme_busidoc  where fid='" + id + "'";
                        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                        String docuid = "";
                        String busid = "";
                        while (rows.next()) {
                            docuid = rows.getString("fdocumentid");
                            busid = rows.getString("fbusinessid");
                        }
                        ServiceResult re = fmeService.downloadFileInServer(busid, docuid, request);
                        String path1 = re.getResultDetail();
                        File file1 = new File(path1);
                        FileInputStream fis = new FileInputStream(file1);
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        byte[] b = new byte[1024];
                        while ((n = fis.read(b)) != -1) {
                            bos.write(b, 0, n);
                        }
                        fis.close();
                        bos.close();
                        size = bos.toByteArray();
                        String[] s = new String[]{path1};
                        file1.delete();
                        return size;
                    }
                    try {
                        AttachmentCollection col;
                        BOSUuid.read((String)id);
                        info = AttachmentFactory.getLocalInstance((Context)this.ctx).getAttachmentInfo((IObjectPK)new ObjectUuidPK(id));
                        if (info == null && (col = AttachmentFactory.getLocalInstance((Context)this.ctx).getAttachmentCollection("where attachID = '" + id + "'")) != null && col.size() > 0) {
                            info = col.get(0);
                        }
                    }
                    catch (Exception e) {
                        info = AttachmentFactory.getLocalInstance((Context)this.ctx).getAttachmentInfo("where attachID = '" + id + "'");
                    }
                    AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)this.ctx);
                    size = asm.download(info.getId().toString());
                    this.logger.error((Object)("lightapp getAttachmentAsBytes  ::size.size() =" + size.length));
                    simpleName = info.getSimpleName();
                    fileName = info.getName();
                }
                return size;
            }
            catch (Exception e) {
                this.logger.error((Object)("lightapp getAttachMent error :: " + e.getMessage()), (Throwable)e);
            }
        }
        return null;
    }

    public Map appendActivity(Map params) throws BOSException {
        long t1 = System.currentTimeMillis();
        String activitiesReq = (String)params.get("activities");
        String activitiesNameReq = (String)params.get("activitiesName");
        String assignId = (String)params.get("assignId");
        String billId = (String)params.get("billId");
        String appendMode = (String)params.get("appendMode");
        String routeMode = (String)params.get("routeMode");
        boolean abortCurrentActivity = Boolean.valueOf((String)params.get("abortCurrentActivity"));
        String signopinion = (String)params.get("signopinion");
        PersonInfo p = ContextUtil.getCurrentUserInfo((Context)this.ctx).getPerson();
        String personId = p.getId().toString();
        JSONArray activitiesJSON = JSON.parseArray((String)activitiesReq);
        JSONArray activitiesNameJSON = JSON.parseArray((String)activitiesNameReq);
        ArrayList<IDynamicWfService.DynamicActivityDef> activities = new ArrayList<IDynamicWfService.DynamicActivityDef>();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < activitiesJSON.size(); ++i) {
            IDynamicWfService.DynamicActivityDef act = new IDynamicWfService.DynamicActivityDef();
            ArrayList<IDynamicWfService.Performer> performerList = new ArrayList<IDynamicWfService.Performer>();
            JSONArray array = (JSONArray)activitiesJSON.get(i);
            if (array.size() == 0) continue;
            if (activitiesNameJSON.get(i).equals("")) {
                activitiesNameJSON.set(i, (Object)"\u65b0\u5efa\u4efb\u52a1");
            }
            act.actName = activitiesNameJSON.getString(i);
            for (int i2 = 0; i2 < array.size(); ++i2) {
                JSONObject obj = array.getJSONObject(i2);
                if (personId.equals(obj.getString("fpersonid"))) {
                    map = new HashMap();
                    map.put("status", "error1");
                    return map;
                }
                IDynamicWfService.Performer p1 = new IDynamicWfService.Performer();
                p1.personId = obj.getString("fpersonid");
                p1.personName = obj.getString("fname_l2");
                performerList.add(p1);
            }
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            Map map1 = service.getActivityDefAndActivityInstInfo(assignId);
            ApproveActivityDef approveDef = map1.get("ACTIVITYDEF") != null ? (ApproveActivityDef)map.get("ACTIVITYDEF") : null;
            IDynamicWfService.DynamicActivityDef actd = new IDynamicWfService.DynamicActivityDef();
            if (approveDef != null) {
                ExtendedAttributeCollection extendedAttrs = approveDef.getActivityHeader().getExtendedAttributes();
                String defaultKickBack = extendedAttrs.get("kickBack") != null ? extendedAttrs.get("kickBack").getValue() : "true";
                String defaultJumpTo = extendedAttrs.get("jumpTo") != null ? extendedAttrs.get("jumpTo").getValue() : "true";
                String defaultAppendActivity = extendedAttrs.get("appendActivity") != null ? extendedAttrs.get("appendActivity").getValue() : "true";
                String defaultsubmitNextPerformer = extendedAttrs.get("assignnextparticipantActivity") != null ? extendedAttrs.get("assignnextparticipantActivity").getValue() : "true";
                AssignmentMessage msg = approveDef.getMessage();
                Config cfg = ConfigLoader.getConfig4Server();
                boolean allowAppend = cfg.getBoolean("append.activity.default.allow.append", billId, StringUtils.isEmpty((String)defaultAppendActivity) ? "true" : defaultAppendActivity);
                boolean allowJumpTo = cfg.getBoolean("append.activity.default.allow.jump.to", billId, StringUtils.isEmpty((String)defaultJumpTo) ? "true" : defaultJumpTo);
                boolean allowKickBack = cfg.getBoolean("append.activity.default.allow.kick.back", billId, StringUtils.isEmpty((String)defaultKickBack) ? "true" : defaultKickBack);
                boolean allowSubmitNextPerformer = cfg.getBoolean("append.activity.default.allow.submitNextPerformer", billId, StringUtils.isEmpty((String)defaultsubmitNextPerformer) ? "true" : defaultsubmitNextPerformer);
                boolean isSendSMS = cfg.getBoolean("append.activity.default.sendSMS", billId, "false");
                boolean isSendMail = cfg.getBoolean("append.activity.default.sendMail", billId, "false");
                String attachmentMode = cfg.getString("append.activity.default.attachment.mode", billId, "1");
                act.allowAppend = allowAppend;
                act.allowJumpTo = allowJumpTo;
                act.allowKickBack = allowKickBack;
                act.allowSubmitNextPerformer = allowSubmitNextPerformer;
                act.isSendSMS = isSendSMS;
                act.isSendMail = isSendMail;
                act.attachmentMode = attachmentMode;
            }
            act.performers = performerList.toArray(new IDynamicWfService.Performer[0]);
            activities.add(act);
        }
        try {
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            AssignmentInfo assign = service.getAssignmentById(assignId);
            IDynamicWfServiceFacade svc = WfFacadeUtilFactory.getDynamicWfService((Context)this.ctx);
            svc.appendActivity(assignId, activities.toArray(new IDynamicWfService.DynamicActivityDef[0]), appendMode, routeMode, abortCurrentActivity);
            String personNamestr = "";
            for (int i = 0; i < activitiesJSON.size(); ++i) {
                JSONArray array = (JSONArray)activitiesJSON.get(i);
                if (array.size() == 0) continue;
                for (int i2 = 0; i2 < array.size(); ++i2) {
                    JSONObject obj = array.getJSONObject(i2);
                    personNamestr = personNamestr + "\u3010" + obj.getString("fname_l2") + "\u3011";
                    this.saveAppendOp(assignId, this.ctx.getCaller().toString(), obj.getString("fpersonid"), assign.getActInstId());
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("lightapp appendActivity error :: " + e.getMessage()), (Throwable)e);
            map.put("success", "false");
            map.put("errorCode", e.getMessage());
            map.put("status", "error2");
            this.logger.error((Object)("appendActivity timeout :: " + (System.currentTimeMillis() - t1)));
            return map;
        }
        map.put("status", "success");
        this.logger.debug((Object)("appendActivity timeout :: " + (System.currentTimeMillis() - t1)));
        return map;
    }

    private String saveAppendOp(String assignId, String userid, String toUserid, String actid) throws Exception {
        try {
            String sql = " insert into  T_wf_APPENDACTIVITY (Factinstid,fpersonuserid,ftopersonuserid,fassignid) values('" + actid + "','" + userid + "','" + toUserid + "','" + assignId + "') ";
            DbUtil.execute((Context)this.ctx, (String)sql);
        }
        catch (Exception e) {
            this.logger.error((Object)("lightapp saveBill error :: " + e.getMessage()), (Throwable)e);
            throw new Exception("EAS_ERROR_00001", e);
        }
        return "true";
    }

    public void appendOpinion(String assignId, String billId, String opinion, String typeStr) throws EASBizException, BOSException {
        long t1 = System.currentTimeMillis();
        MultiApproveInfo info = new MultiApproveInfo();
        info.setAssignment(assignId);
        info.setBillId(BOSUuid.read((String)billId));
        info.setExtendedProperty("businuessObjectId", billId);
        info.setExtendedProperty("assignmentID", assignId);
        info.setExtendedProperty("isAddNew", "isAddNew");
        info.setIsMailNotifyNext(false);
        info.setIsMobelNotifyNext(false);
        if (opinion != null && opinion.length() > 0) {
            info.setOpinion(typeStr + " | " + opinion);
        } else {
            info.setOpinion(typeStr);
        }
        info.setIsPass(ApproveResult.PASS);
        info.setHandlerOpinion(0);
        info.setHandlerContent("\u540c\u610f");
        MultiApproveFactory.getLocalInstance((Context)this.ctx).addnew((CoreBaseInfo)info);
        this.logger.debug((Object)("appendOpinion timeout :: " + (System.currentTimeMillis() - t1)));
    }

    public Map getActNextPersonAttributes(String assignId) throws EASBizException, BOSException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        try {
            String v;
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            AssignmentInfo assign = service.getAssignmentById(assignId);
            ret.put("assignNeedEdit", false);
            Map actmap = service.getActivityDefAndActivityInstInfo(assignId);
            ActivityDef def = (ActivityDef)actmap.get("ACTIVITYDEF");
            ExtendedAttributeDef ed = def.getActivityHeader().getExtendedAttributes().get("customUIStatus");
            if (ed != null && (v = ed.getValue()) != null && v.length() > 0 && "EDIT".equalsIgnoreCase(v)) {
                ret.put("assignNeedEdit", true);
            }
            Map map = service.getExtendedAttributesFromActivityInst(assign.getActInstId());
            Boolean shouldCheckNextPartipants = Boolean.parseBoolean((String)map.get("shouldCheckNextPartipants"));
            Boolean alwaysSetNextPersons = Boolean.parseBoolean((String)map.get("alwaysSetNextPersons"));
            Boolean alwaysSetNextPerson = ConfigLoader.getConfig4Server().getBoolean("always.set.next.persons", assign.getBizObjectIds(), "false");
            if (alwaysSetNextPerson.booleanValue()) {
                alwaysSetNextPersons = alwaysSetNextPerson;
            }
            ret.put("alwaysSetNextPersons", alwaysSetNextPersons);
            Map amap = service.getActivityDefAndActivityInstInfo(assignId);
            ManpowerActivityDef activityDef = (ManpowerActivityDef)amap.get("ACTIVITYDEF");
            ret.put("isShowAllManpowerActivities", activityDef.isShowAllManpowerActivities());
            ret.put("isShowAllEmptyManpowerActivites", activityDef.isShowAllEmptyManpowerActivites());
            ret.put("mustShowPostActivities", activityDef.isMustShowParticipantsCheckList());
            ret.put("shouldCheckNextPartipants", Boolean.parseBoolean((String)map.get("nextPerson")) || activityDef.isMustShowParticipantsCheckList());
            Boolean canSpecifyNextPerformer = activityDef.canSpecifyNextActivityPerformer();
            ret.put("mustShowPostActivities", activityDef.isMustShowParticipantsCheckList());
            ret.put("nextPersonSceneName", map.get("nextPersonSceneName"));
            ret.put("nextPerson", map.get("nextPerson"));
            if (alwaysSetNextPersons.booleanValue()) {
                canSpecifyNextPerformer = true;
            }
            ret.put("canSpecifyNextPerformer", canSpecifyNextPerformer);
        }
        catch (Exception e) {
            this.logger.error((Object)("lightapp getActNextPersonAttributes error :: " + e.getMessage()), (Throwable)e);
            ret.put("success", "false");
            ret.put("errorCode", e.getMessage());
        }
        return ret;
    }

    public String ifExistEmptyPersonWhenPostParticipants(String assignId) throws Exception {
        List list = ApproveUtilFactory.getInstance(this.ctx).findPostParticipants(assignId, null);
        for (Map map : list) {
            HashMap persons = (HashMap)map.get("persons");
            if (!persons.isEmpty()) continue;
            return "true";
        }
        return "false";
    }

    public Map getDecisionItems(String assignId) throws Exception {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            IAssignmentMonitorService assignMonSerivce = AssignmentMonitorService.getService((Context)this.ctx);
            AssignmentInfo assignInfo = assignMonSerivce.getAssignmentById(assignId);
            Map argMap = assignMonSerivce.getAssignmentArgument(assignId, true);
            Object tmp = argMap.get("MANUALDECISION_DESC");
            String decisionDesc = tmp == null ? "" : tmp.toString();
            tmp = assignInfo.getSubject(this.ctx.getLocale());
            String decisionTitle = tmp == null ? "" : tmp.toString();
            tmp = argMap.get("MANUALDECISION_ITEMS");
            String decisionItems = tmp == null ? "" : tmp.toString();
            resultMap.put("MANUALDECISION_DESC", decisionDesc.replaceAll("\"", "&quot;"));
            resultMap.put("MANUALDECISION_ITEMS", decisionItems.replaceAll("\"", "&quot;"));
            resultMap.put("MANUALDECISION_NAME", decisionTitle.replaceAll("\"", "&quot;"));
        }
        catch (Exception e) {
            this.logger.error((Object)("lightapp getDecisionItems error :: " + e.getMessage()), (Throwable)e);
            resultMap.put("success", "false");
            resultMap.put("errorCode", e.getMessage());
        }
        return resultMap;
    }

    public Map submitDecision(Map params) throws Exception {
        String assignId = (String)params.get("assignId");
        String decisionTitle = (String)params.get("decisionTitle");
        String selectValue = (String)params.get("selectValue");
        String decisionItems = (String)params.get("decisionItems");
        String decisionDesc = (String)params.get("decisionDesc");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            Map data = this.collectInput(decisionTitle, selectValue, decisionItems, decisionDesc);
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            AssignmentInfo assignment = service.getAssignmentById(assignId);
            String userId = this.ctx.getCaller().toString();
            SubmitAssignResult result = service.submitAssignment(data, userId, "com.kingdee.eas.base.multiapprove.client", "ManualDecisionUIFunction", "ConfirmAction", assignment, null);
            if (result.getStatus()) {
                resultMap.put("result", "true");
            } else {
                resultMap.put("result", "false");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("lightapp submitDecision error :: " + e.getMessage()), (Throwable)e);
            resultMap.put("success", "false");
            resultMap.put("errorCode", e.getMessage());
            resultMap.put("result", "false");
            resultMap.put("message", e.getMessage());
        }
        return resultMap;
    }

    private Map collectInput(String decisionTitle, String selectValue, String decisionItems, String decisionDesc) throws BOSException {
        HashMap<String, ManualDecisionInfo> data = new HashMap<String, ManualDecisionInfo>();
        ManualDecisionInfo info = new ManualDecisionInfo();
        info.setSelectItemCount(1);
        info.setName(decisionTitle);
        info.setSelectedItems(selectValue);
        info.setSelectedIndices("0");
        info.setSelectItems(decisionItems);
        info.setDescription(decisionDesc);
        String newId = BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
        info.setId(BOSUuid.read((String)newId));
        data.put(newId, info);
        return data;
    }

    public Map getProcinstState(String billId) throws Exception {
        long t1 = System.currentTimeMillis();
        HashMap<String, Object> remap = new HashMap<String, Object>();
        boolean complete = true;
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        ProcessInstInfo[] procs = svc.getProcessInstanceByHoldedObjectId(billId);
        if (!(procs != null && procs.length != 0 || (procs = svc.getAllProcessInstancesByBizobjId(billId)) != null && procs.length != 0)) {
            remap.put("failed", "\u6ca1\u6709\u6d41\u7a0b\u5b9e\u4f8b!");
            remap.put("success", "");
            return remap;
        }
        String state = "";
        String procInstId = "";
        for (int i = 0; i < procs.length; ++i) {
            state = procs[i].getState();
            procInstId = procs[i].getProcInstId();
            if (!state.startsWith("open.running")) continue;
            complete = false;
            break;
        }
        this.logger.debug((Object)("submit timeout :: " + (System.currentTimeMillis() - t1)));
        remap.put("complete", complete);
        return remap;
    }

    public Map quickApprove(String assignIds, String ifpass, String opinion, String policy) {
        long t1 = System.currentTimeMillis();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] assignID = assignIds.split(",");
        int successCount = 0;
        int failedCount = 0;
        String reason = "";
        try {
            for (int i = 0; i < assignID.length; ++i) {
                boolean ifNeedSetNextPerson = this.needSetNextPerson(assignID[i]);
                if (ifNeedSetNextPerson) {
                    ++failedCount;
                    reason = "\u9700\u6307\u5b9a\u4e0b\u4e00\u6b65\u53c2\u4e0e\u4eba";
                    continue;
                }
                MultiApproveInfo info = new MultiApproveInfo();
                IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
                AssignmentInfo assignInfo = service.getAssignmentById(assignID[i]);
                Map poMap = this.getSelectPolicy(assignID[i], ifpass);
                String conten = (String)poMap.get("result");
                String[] c = conten.split(";");
                String pName = "\u65e0";
                String defaultpolicy = "";
                if (c.length > 0) {
                    String[] poName = c[0].split(",");
                    defaultpolicy = poName[0];
                }
                if (StringUtils.isEmpty((String)policy)) {
                    policy = defaultpolicy;
                }
                info.setAssignment(assignID[i]);
                String billId = "";
                String[] bizObjectId = assignInfo.getBizObjectIdArray();
                if (bizObjectId != null && bizObjectId.length > 0) {
                    billId = bizObjectId[0];
                }
                info.setBillId(BOSUuid.read((String)billId));
                info.setExtendedProperty("businuessObjectId", bizObjectId.toString());
                info.setExtendedProperty("assignmentID", assignID[i]);
                info.setExtendedProperty("isAddNew", "isAddNew");
                if ("1".equals(ifpass)) {
                    info.setIsPass(ApproveResult.getEnum((String)"true"));
                    opinion = "\u540c\u610f";
                } else {
                    info.setIsPass(ApproveResult.getEnum((String)"false"));
                    opinion = "\u4e0d\u540c\u610f";
                }
                info.setOpinion(opinion);
                info.setHandlerOpinion(Integer.parseInt(policy));
                info.setHandlerContent("");
                info.setStatus(MultiApproveStatusEnum.SUBMIT);
                MultiApproveFactory.getLocalInstance((Context)this.ctx).submit((CoreBaseInfo)info);
                this.logger.debug((Object)("quickApprove timeout :: " + (System.currentTimeMillis() - t1)));
                ++successCount;
            }
        }
        catch (Exception e) {
            ++failedCount;
            reason = "\u5ba1\u6279\u5931\u8d25";
            this.logger.error((Object)"lightapp quickApprove error :: ", (Throwable)e);
        }
        this.logger.debug((Object)("submitApprove timeout :: " + (System.currentTimeMillis() - t1)));
        map.put("success", true);
        map.put("result", reason);
        map.put("failedCouunt", failedCount);
        map.put("successCouunt", successCount);
        return map;
    }

    private boolean checkIfCanApprove(String billId) {
        boolean support = true;
        if (StringUtils.isEmpty((String)billId)) {
            return support;
        }
        try {
            BOSObjectType bosType = BOSUuid.read((String)billId).getType();
            IMetaDataPK pk = MDContextFactory.getSystemMDContext().entityMapping.getProperty(bosType);
            String sql = "SELECT FIsMobileApprove FROM T_WM_BillDigest WHERE FMetadataPK = '";
            sql = sql + pk.getFullName().toString() + "'";
            IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rows.next()) {
                int isMobileApprove = rows.getInt("FIsMobileApprove");
                if (isMobileApprove != 0) continue;
                support = false;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"checkIsSupportXT is error: ", (Throwable)e);
        }
        return support;
    }

    private boolean needSetNextPerson(String assignID) {
        try {
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            AssignmentInfo assign = service.getAssignmentById(assignID);
            Map map = service.getExtendedAttributesFromActivityInst(assign.getActInstId());
            String alwaysSetNextPersons = (String)map.get("alwaysSetNextPersons");
            map = service.getActivityDefAndActivityInstInfo(assignID);
            ManpowerActivityDef activityDef = (ManpowerActivityDef)map.get("ACTIVITYDEF");
            boolean showAllEmptyManpowerActivites = activityDef.isShowAllEmptyManpowerActivites();
            if ("true".equals(alwaysSetNextPersons)) {
                if (showAllEmptyManpowerActivites) {
                    String ifEmpty = this.ifExistEmptyPersonWhenPostParticipants(assignID);
                    return "true".equals(ifEmpty);
                }
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("lightapp getDecisionItems error :: " + e.getMessage()), (Throwable)e);
            return true;
        }
        return false;
    }

    private String saveBill(String objectStr) throws Exception {
        try {
            Map map = (Map)JSON.parse((String)objectStr);
            if (map.isEmpty()) {
                return "";
            }
            for (Map.Entry entry : map.entrySet()) {
                String id = (String)entry.getKey();
                Map itemObj = (Map)entry.getValue();
                BOSObjectType bostype = BOSUuid.read((String)id).getType();
                EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity(bostype);
                String TableName = entityObjectInfo.getTable().getName();
                String sql = " update " + TableName + "  ";
                String mdSql = "";
                for (Map.Entry entryenw : itemObj.entrySet()) {
                    PropertyCollection properties = entityObjectInfo.getInheritedNoDuplicatedPropertiesRuntime();
                    PropertyInfo p = (PropertyInfo)properties.getObject(entryenw.getKey());
                    String feildName = p.getMappingField().getName();
                    DataType type = null;
                    if (p instanceof OwnPropertyInfo) {
                        OwnPropertyInfo op = (OwnPropertyInfo)p;
                        type = op.getDataType();
                    }
                    System.out.print("111111111111111111111111=" + type);
                    if ("".equals(mdSql)) {
                        if (DataType.TIMESTAMP.equals((Object)type)) {
                            mdSql = feildName + " = {ts'" + (String)entryenw.getValue() + "'}";
                            continue;
                        }
                        if (DataType.DATE.equals((Object)type)) {
                            mdSql = feildName + " = {d'" + (String)entryenw.getValue() + "'}";
                            continue;
                        }
                        mdSql = feildName + " = '" + (String)entryenw.getValue() + "'";
                        continue;
                    }
                    if (DataType.TIMESTAMP.equals((Object)type)) {
                        mdSql = mdSql + "," + feildName + " = {ts'" + (String)entryenw.getValue() + "'}";
                        continue;
                    }
                    if (DataType.DATE.equals((Object)type)) {
                        mdSql = mdSql + "," + feildName + " = {d'" + (String)entryenw.getValue() + "'}";
                        continue;
                    }
                    mdSql = mdSql + "," + feildName + " = '" + (String)entryenw.getValue() + "'";
                }
                if (!"".equals(mdSql)) {
                    sql = sql + " set " + mdSql + " where fid='" + id + "'";
                }
                DbUtil.execute((Context)this.ctx, (String)sql);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("lightapp saveBill error :: " + e.getMessage()), (Throwable)e);
            throw new Exception("EAS_ERROR_00001", e);
        }
        return "true";
    }

    public List findPostParticipants(String assignId, String associatedLine) throws Exception {
        List nextActs = null;
        try {
            nextActs = new ArrayList();
            ApproveUtil approveUtil = new ApproveUtil(this.ctx);
            nextActs = approveUtil.findPostParticipants(assignId, associatedLine);
        }
        catch (Exception e) {
            System.out.println("tttttttttttttttttttttttttttt");
            this.logger.error((Object)"findPostParticipants error", (Throwable)e);
        }
        return nextActs;
    }

    private EntityObjectInfo loadEntity(Context ctx, IMetaDataPK pk) throws Exception {
        try {
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo entity = loader.getEntity(pk);
            return entity;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String changgeMessageType(String procinstid) {
        String re = utils.changgebypro((Context)this.ctx, (String)procinstid);
        return re;
    }

    private boolean canRollbackAssignment(IEnactmentService svc, String actInstId) {
        try {
            return svc.canRollbackActInst(actInstId);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void addrollback(Context ctx, String billid) {
        try {
            String l = ctx.getLocale().toString();
            String sql = "update T_BAS_MULTIAPPROVE set FOPINION_" + l + " = FOPINION_" + l + "||'rollback' where fbillid='" + billid + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
    }

    public List getPersonInfo(String type, String orgId, String personName) {
        long t1 = System.currentTimeMillis();
        List list = null;
        try {
            String sql = "select pu.fpersonid,        pu.fname_l2,        po.fname_l2  as poName,        ad.fname_l2  as adName,        pu.fid   from t_pm_user pu  inner join t_bd_person pe     on pu.fpersonid = pe.fid  inner join t_org_positionmember pm     on pm.fpersonid = pu.fpersonid  inner join t_org_position po     on po.fid = pm.fpositionid  inner join t_org_admin ad     on ad.fid = po.FAdminOrgUnitID   where pm.FIsPrimary = 1    and pu.fisdelete = 0    and pu.fislocked = 0    and pu.fforbidden = 0    and pe.fdeletedstatus = 1 ";
            if ("quickSearch".equals(type)) {
                sql = sql + " and (pu.fname_l2 like ? or pe.fsimplenamepingyin like ?) ";
                list = this.executeQuery(sql, new Object[]{"%" + personName.toLowerCase() + "%", "" + personName.toLowerCase() + "%"});
            } else if ("curOrg".equals(type)) {
                String id = this.getCurOrg();
                sql = sql + " and ad.fid=?";
                list = this.executeQuery(sql, new Object[]{id});
            } else if ("allOrg".equals(type)) {
                sql = sql + " and ad.fid=?";
                list = this.executeQuery(sql, new Object[]{orgId});
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("lightapp getPersonInfo error :: " + e.getMessage()), (Throwable)e);
        }
        this.logger.error((Object)("getPersonInfo time in eas :: " + (System.currentTimeMillis() - t1)));
        return list;
    }

    private String getCurOrg() {
        String id = "";
        try {
            String userId = this.ctx.getCaller().toString();
            String sql = "select top 1d.fid   from t_org_positionmember a, t_pm_user b, t_org_position c, t_org_admin d  where b.fpersonid = a.fpersonid    and c.fid = a.fpositionid    and c.fadminorgunitid = d.fid    and b.fid = '" + userId + "' and a.FISPRIMARY ='1'";
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            if (rowSet.size() > 0) {
                while (rowSet.next()) {
                    if (rowSet.getString("fid") == null) continue;
                    id = rowSet.getString("fid");
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("lightapp getCurOrg error :: " + e.getMessage()), (Throwable)e);
        }
        return id;
    }

    public Map addAttachment(String boid, Map m, String fileData) throws EASBizException, BOSException, IOException {
        SimpleAttachmentInfo sai = new SimpleAttachmentInfo();
        boid = URLDecoder.decode(boid);
        String type = (String)m.get("type");
        String attatchid = (String)m.get("attatchid");
        String fileSize = (String)m.get("fileSize");
        String fileName = (String)m.get("fileName");
        String fileExt = (String)m.get("fileExt");
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        fileName = URLDecoder.decode(fileName);
        byte[] content = null;
        if ("getAttach".equals(type)) {
            content = this.getAttachByte(attatchid);
        } else if ("getPicthur".equals(type)) {
            BASE64Decoder decoder = new BASE64Decoder();
            content = decoder.decodeBuffer(fileData);
            for (int i = 0; i < content.length; ++i) {
                if (content[i] >= 0) continue;
                int n = i;
                content[n] = (byte)(content[n] + 256);
            }
        }
        sai.setContent(content);
        sai.setExtName(fileExt);
        sai.setBeizhu("\u6d41\u7a0b\u52a9\u624b\u9644\u4ef6\u4e0a\u4f20");
        sai.setMainName(fileName);
        AttachmentInfo attachmentInfo = VariousAttachmentInfoMaker.makeAppAttachmentInfo((Context)this.ctx, (IAttachment)AttachmentFactory.getLocalInstance((Context)this.ctx), (String)boid, (SimpleAttachmentInfo)sai);
        String attchID = "";
        byte[] fileInfo = attachmentInfo.getFile();
        if (fileInfo != null && fileInfo.length > 0x500000) {
            attachmentInfo.setFile(null);
            attchID = AttachmentFactory.getLocalInstance((Context)this.ctx).addnew(attachmentInfo).toString();
            try {
                IAttachmentFtpFacade iAttachmentFacade = AttachmentFtpFacadeFactory.getLocalInstance((Context)this.ctx);
                AttachmentUploadClient fileUpload = new AttachmentUploadClient(AttachmentFtpFacadeFactory.getLocalInstance((Context)this.ctx));
                fileUpload.uploadFile(attchID, fileInfo);
            }
            catch (BOSException e) {
                AttachmentFactory.getLocalInstance((Context)this.ctx).delete((IObjectPK)new ObjectStringPK(attchID));
                this.logger.info((Object)"upload file fail:", (Throwable)e);
                throw e;
            }
            catch (EASBizException e) {
                AttachmentFactory.getLocalInstance((Context)this.ctx).delete((IObjectPK)new ObjectStringPK(attchID));
                this.logger.info((Object)"upload file fail:", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                AttachmentFactory.getLocalInstance((Context)this.ctx).delete((IObjectPK)new ObjectStringPK(attchID));
                this.logger.info((Object)"upload file fail:", (Throwable)e);
                throw new BOSException(e.getMessage());
            }
        } else {
            this.logger.info((Object)" begin one part file upload");
            attchID = AttachmentFactory.getLocalInstance((Context)this.ctx).addnew(attachmentInfo).toString();
        }
        resultMap.put("success", true);
        return resultMap;
    }

    private byte[] getAttachByte(String attatchid) {
        String root = "http://yunzhijia.com/microblog/filesvr/" + attatchid;
        URL url = null;
        byte[] data = null;
        try {
            url = new URL(root);
            InputStream in = url.openStream();
            ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
            byte[] buff = new byte[100];
            int rc = 0;
            while ((rc = in.read(buff, 0, 100)) > 0) {
                swapStream.write(buff, 0, rc);
            }
            data = swapStream.toByteArray();
            System.out.println("\u6587\u4ef6\u8bfb\u5b8c");
        }
        catch (Exception e) {
            System.out.println("IO\u5f02\u5e38\uff1a" + e);
        }
        byte[] content = data;
        for (int i = 0; i < content.length; ++i) {
            if (content[i] >= 0) continue;
            int n = i;
            content[n] = (byte)(content[n] + 256);
        }
        return content;
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while ((n = in.read(buffer)) != -1) {
            out.write(buffer, 0, n);
        }
        return out.toByteArray();
    }

    public Map getAttachMode(String assignID, Map map) throws Exception {
        Map<String, Boolean> m = new HashMap<String, Boolean>();
        try {
            m = AddAttachmentUtils.getPermissionMode(this.ctx, assignID);
            m.put("success", true);
        }
        catch (Exception e) {
            m.put("success", false);
            m.put("canAdd", false);
        }
        return m;
    }

    public Map deleteAttachment(String billId, String id) throws EASBizException, BOSException {
        HashMap<String, Boolean> m = new HashMap<String, Boolean>();
        try {
            BoAttchAssoInfo binfo = new BoAttchAssoInfo();
            binfo.setBoID(billId);
            AttachmentInfo attachmentInfo = new AttachmentInfo();
            attachmentInfo.setId(BOSUuid.read((String)id));
            binfo.setAttachment(attachmentInfo);
            BoAttchAssoCollection bc = new BoAttchAssoCollection();
            bc.add(binfo);
            BoAttchAssoFactory.getLocalInstance((Context)this.ctx).deleteByBoList(bc);
            m.put("success", true);
        }
        catch (Exception e) {
            m.put("success", false);
            m.put("canAdd", false);
        }
        return m;
    }

    public IDynamicWfService.JumpTarget[] getKickBackList(Map map) throws EASBizException, BOSException {
        HashMap<String, Boolean> m = new HashMap<String, Boolean>();
        IDynamicWfService.JumpTarget[] targets = null;
        try {
            String assignId = (String)map.get("assignId");
            IDynamicWfServiceFacade svc = WfFacadeUtilFactory.getDynamicWfService((Context)this.ctx);
            targets = svc.getKickBackTargets(assignId);
        }
        catch (Exception e) {
            m.put("success", false);
        }
        return targets;
    }

    public Map kickback(Map map) throws EASBizException, BOSException {
        HashMap<String, Boolean> m = new HashMap<String, Boolean>();
        m.put("success", true);
        try {
            String actDefId = (String)map.get("actDefId");
            String type = (String)map.get("type");
            String assignId = (String)map.get("assignId");
            String opinion = (String)map.get("opinion") + "kickback";
            DynamicWfService svc = new DynamicWfService(this.ctx);
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            AssignmentInfo currentAssignInfo = service.getAssignmentById(assignId);
            String currentActDefId = currentAssignInfo.getActDefId();
            String hash = service.getProcessInstInfo(currentAssignInfo.getProcInstId()).getProcDefHashValue();
            ProcessDef def = service.getProcessDefByDefineHashValue(hash);
            ActivityDef actDef = def.getActivityDef(currentAssignInfo.getActDefId());
            ActivityCollection activityCollection = actDef.getAllPreviousActivities();
            if ("1".equals(type)) {
                actDefId = "";
                for (int i = 0; i < activityCollection.size(); ++i) {
                    if (!"MANPOWER".equals(activityCollection.get(i).getType().toString()) || currentActDefId.equals(activityCollection.get(i).getID())) continue;
                    actDefId = activityCollection.get(i).getID();
                    break;
                }
            }
            String procInstId = currentAssignInfo.getProcInstId();
            String hashkick = service.getProcessInstInfo(procInstId).getProcDefHashValue();
            ProcessDef defkick = service.getProcessDefByDefineHashValue(hashkick);
            ActivityDef actDefkick = defkick.getActivityDef(actDefId);
            service.jump(procInstId, actDefkick, opinion);
            IDynamicOperationService serivce = DynamicOperationServiceFactory.getLocalInstance((Context)this.ctx);
            DynamicOperationInfo info = new DynamicOperationInfo();
            info.setType("redirect");
            info.setBillId(null);
            info.setProcInstId(procInstId);
            info.setActInstId(null);
            info.setActName(null);
            info.setTargetActId(actDefId);
            info.setTargetActName(actDefkick.getName(this.ctx.getLocale()));
            info.setComment(opinion, new Locale("l1"));
            info.setComment(opinion, new Locale("l2"));
            info.setComment(opinion, new Locale("l3"));
            info.setCreatorId(this.ctx.getCaller().toString());
            String userName = ContextUtil.getCurrentUserInfo((Context)this.ctx).getName(this.ctx.getLocale());
            info.setCreatorName(userName);
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
            serivce.addNewDynamicOperationInfo(info);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)"error", (Throwable)e);
            m.put("success", false);
        }
        return m;
    }

    public Map getCount(String sql) throws EASBizException, BOSException {
        HttpServletRequest request = DispatcherContext.getHttpServletRequest();
        String eid = (String)request.getSession().getAttribute("eid");
        String openid = (String)request.getSession().getAttribute("openid");
        HashMap<String, Object> remap = new HashMap<String, Object>();
        remap.put("eid", eid);
        remap.put("openid", openid);
        try {
            String userId = this.ctx.getCaller().toString();
            List re = this.executeQuery(sql, new Object[]{userId, userId, userId, userId});
            remap.put("result", re);
        }
        catch (Exception e) {
            this.logger.error((Object)"getCount error ", (Throwable)e);
            e.printStackTrace();
        }
        return remap;
    }

    public String getActBounds(Map<String, String> paramMap) throws IOException {
        String procInstId = paramMap.get("procInstId");
        if (procInstId == null) {
            String billid = paramMap.get("billid");
            try {
                ProcessInstInfo[] procs = EnactmentServiceFactory.createEnactService((Context)this.ctx).getProcessInstanceByHoldedObjectId(billid);
                if (procs.length == 0) {
                    procs = EnactmentServiceFactory.createEnactService((Context)this.ctx).getAllProcessInstancesByBizobjId(billid);
                }
                procInstId = procs[0].getProcInstId();
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            procInstId = URLDecoder.decode(procInstId, "utf-8");
        }
        Locale l = this.ctx.getLocale();
        String notSelectActivity = "";
        Map map = null;
        notSelectActivity = l.equals(new Locale("l1")) ? "Please select a activity first!" : (l.equals(new Locale("l3")) ? "\u8acb\u55ae\u64ca\u6d3b\u52d5\u5716\u6a19\uff0c\u9078\u64c7\u4e00\u500b\u6d3b\u52d5!" : "\u8bf7\u5355\u51fb\u6d3b\u52a8\u56fe\u6807, \u9009\u62e9\u4e00\u4e2a\u6d3b\u52a8!");
        EASWebContextUtil.initRpcConfig((Context)this.ctx);
        try {
            WfProcDiagramEncoder encoder = new WfProcDiagramEncoder(procInstId, this.ctx);
            map = encoder.getActBounds();
        }
        catch (Exception e) {
            try {
                IWfProcDiagramEncoderFacade encoder = WfFacadeUtilFactory.createRemoteWfProcDiagramEncoder();
                map = encoder.getActBounds(procInstId);
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        Map performers = null;
        Set currentActDefs = null;
        List actsHasAppended = null;
        performers = (Map)map.get("{performer}");
        currentActDefs = (Set)map.get("{openActDefs}");
        actsHasAppended = (List)map.get("{appendedActs}");
        HashMap<String, Rectangle> rectMap = new HashMap<String, Rectangle>();
        HashMap<String, String> tipsMap = new HashMap<String, String>();
        if (map != null) {
            for (String id : map.keySet()) {
                if (id.endsWith(".width") || id.indexOf("performer") > -1 || id.indexOf("openActDefs") > -1 || id.indexOf("appendedActs") > -1) continue;
                Rectangle rect = (Rectangle)map.get(id);
                rectMap.put(id, rect);
                List list = (List)performers.get(id);
                StringBuffer actids = new StringBuffer();
                if (list != null && list.size() > 0) {
                    for (int i = 0; i < list.size(); ++i) {
                        Object obj = list.get(i);
                        if (actids.length() > 0) {
                            actids.append(";");
                        }
                        actids.append(obj);
                    }
                }
                String tips = "";
                try {
                    tips = new WfMonitorImageUIFacade(this.ctx).getActTips(procInstId, id, actids.toString());
                }
                catch (Exception e) {
                    // empty catch block
                }
                tipsMap.put(id, tips);
            }
        }
        HashMap<String, Map> re = new HashMap<String, Map>();
        re.put("map", map);
        re.put("rectMap", rectMap);
        re.put("tipsMap", tipsMap);
        return JSON.toJSONString(re);
    }

    public Map getJumpList(Map paramMap) throws Exception {
        String procInstId = (String)paramMap.get("procInstId");
        Locale locale = this.ctx.getLocale();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            ProcessInstInfo processInstInfo = svc.getProcessInstInfo(procInstId);
            ProcessDef pdf = svc.getProcessDefByDefineHashValue(processInstInfo.getProcDefHashValue());
            if (!JumpPermissionUtil.checkProcessOperate(pdf, null, "wf_report_Monitor_OperateJump", false, this.ctx)) {
                procInstId = null;
                map.put("success", "fasle");
                map.put("message", "nopermision");
                return map;
            }
            List list = svc.getJumpTargetActivitys(procInstId);
            ArrayList activities = new ArrayList(list.size());
            for (ActivityDef act : list) {
                HashMap<String, String> item = new HashMap<String, String>();
                item.put("type", JumpPermissionUtil.convertActType(act));
                item.put("name", act.getName(locale));
                item.put("id", act.getID());
                activities.add(item);
            }
            map.put("success", "true");
            map.put("actlist", activities);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return map;
    }

    public Map jump(Map paramMap) throws Exception {
        String procInstId = (String)paramMap.get("procInstId");
        String opinion = (String)paramMap.get("opinion") + "";
        String selectionStr = (String)paramMap.get("selectionStr");
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)selectionStr)) {
            String msg = "msgNeedTarget";
            map.put("success", "false");
            map.put("msg", msg);
            this.logger.error((Object)("jump failed:" + msg));
            return map;
        }
        try {
            WfUtil util = WfUtilFactory.getInstance(this.ctx);
            util.jumpTo(procInstId, selectionStr, opinion);
        }
        catch (Exception e) {
            this.logger.error((Object)"jump failed", (Throwable)e);
            map.put("success", "false");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        map.put("success", "true");
        return map;
    }

    public Map getExtendedAttributesFromActivityInst(Map paramMap) throws Exception {
        Map<String, Boolean> map = new HashMap();
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        String assignID = (String)paramMap.get("assignID");
        AssignmentInfo info = service.getAssignmentById(assignID);
        String actdefid = info.getAssignInfo().get("actinstid").toString();
        String procInstId = info.getProcInstId();
        map = service.getExtendedAttributesFromActivityInst(actdefid);
        if (this.getApiVersion() > 701) {
            boolean canjump = JumpPermissionUtil.canjump(procInstId, this.ctx);
            map.put("canjump", canjump);
            map.put("canViewProcess", true);
        }
        return map;
    }

    public String getDefaultOpinion(String assignID) throws Exception {
        HashMap map = new HashMap();
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        AssignmentInfo assigninfo = svc.getAssignmentById(assignID);
        ProcessDef def = svc.getProcessDefByDefineHashValue(assigninfo.getProcDefHashValue());
        ApproveActivityDef actDef = (ApproveActivityDef)def.getActivityDef(assigninfo.getActDefId());
        String opinion = "";
        ActualParameterCollection aParams = actDef.getActualParameters();
        if (aParams != null) {
            for (int i = 0; i < aParams.size(); ++i) {
                DataFieldDef dfDef;
                ActualParameterDef param = aParams.get(i);
                String name = param.getDataFieldName((ActivityDef)actDef);
                if (name == null || !name.startsWith("defaultOpinion") || (dfDef = def.getDataFieldDef(param.getExpr())) == null) continue;
                opinion = dfDef.getInitValue();
                break;
            }
        }
        return opinion;
    }

    public Map saveSignImg(Map paramMap) throws Exception {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("success", true);
        String assignID = (String)paramMap.get("assignID");
        String type = (String)paramMap.get("type");
        String imgdata = (String)paramMap.get("imgdata");
        try {
            Object[] param;
            String hassql = "select * from t_wfr_signimage where fassignid='" + assignID + "' ";
            IRowSet countRowSet = DbUtil.executeQuery((Context)this.ctx, (String)hassql);
            String sql = "";
            if (countRowSet.size() > 0) {
                sql = "update t_wfr_signimage set fcontent=?  where  fassignid=? ";
                param = new Object[]{imgdata, assignID};
            } else {
                sql = " insert into  t_wfr_signimage (fuserid,fassignid,fimagetype,fcontent) values(?,?,?,?) ";
                param = new Object[]{this.ctx.getCaller().toString(), assignID, type, imgdata};
            }
            DbUtil.execute((Context)this.ctx, (String)sql, (Object[])param);
        }
        catch (Exception e) {
            map.put("success", false);
            this.logger.error((Object)("lightapp saveBill error :: " + e.getMessage()), (Throwable)e);
            throw new Exception("EAS_ERROR_00001", e);
        }
        return map;
    }

    public String getVersion(String eid) {
        return "2";
    }

    public int getApiVersion() {
        return 702;
    }
}

