<Data version="20170616">
	<Sources>
		<BizMetaSource name="s1656571513978" bizMetaType="EASDBCenter" dbCenterId="ORANEW0518" type="BizMeta">
			<UserSQLs>
				<UserSQL name="dm1656571660312" sqlType="KSQL"><![CDATA[select t1.fMaterialId         物料id,
       tbm.fnumber            物料编码,
       tbm.fname_l2           物料名称,
       t1.FYEAR               会计年度,
       t1.FPERIOD             会计期间,
       tob.fnumber            库存组织编号,
       tob.fname_l2           库存组织名称,
       bobu.fnumber           财务组织编号,
       bobu.fname_l2          财务组织名称,
       t1.factualcost         出库总成本,
       t2.FPERIODBEGINBALANCE 期初金额,
       t2.FPERIODENDBALANCE   期末金额

  from (select ttse.FSTORAGEORGUNITID,
               ttse.FCOMPANYORGUNITID,
               ttse.fMaterialId,
               tts.FYEAR,
               tts.FPERIOD,
               sum(ttse.factualcost) as factualcost
          from T_IM_SaleIssueBill tts
          left join T_IM_SaleIssueEntry ttse
            on tts.fid = ttse.FParentID
         where tts.FBASESTATUS = 4
         group by ttse.FSTORAGEORGUNITID,
                  ttse.FCOMPANYORGUNITID,
                  ttse.fMaterialId,
                  tts.FYEAR,
                  tts.FPERIOD
        ) t1
  left join (select tii.FSTORAGEORGUNITID,
                    tii.FCOMPANYORGUNITID,
                    tii.FMATERIALID,
                    tii.FYEAR,
                    tii.FPERIOD,
                    sum(tii.FPERIODBEGINBALANCE) as FPERIODBEGINBALANCE,
                    sum(tii.FPERIODENDBALANCE) as FPERIODENDBALANCE
               from T_IM_InventoryBalance tii
              group by tii.FSTORAGEORGUNITID,
                       tii.FCOMPANYORGUNITID,
                       tii.fMaterialId,
                       tii.FYEAR,
                       tii.FPERIOD
             ) t2
    on t1.FSTORAGEORGUNITID = t2.FSTORAGEORGUNITID
   and t1.FCOMPANYORGUNITID = t2.FCOMPANYORGUNITID
   and t1.fMaterialId = t2.fMaterialId
   and t1.FYEAR = t2.FYEAR
   and t1.FPERIOD = t2.FPERIOD
  left join T_BD_Material tbm
    on t1.fMaterialId = tbm.fid
  left join T_ORG_BaseUnit tob
    on t1.FStorageOrgUnitID = tob.fid
  left join T_ORG_BaseUnit bobu
    on t1.fcompanyorgunitid = bobu.fid
 order by t1.FYEAR desc, t1.FPERIOD desc]]></UserSQL>
			</UserSQLs>
		</BizMetaSource>
	</Sources>
	<ExtractSchedule dayAtMonthly="0" weekAtWeekly="1" time="75600" />
	<Entities>
		<Entity name="dm1656571660312" alias="库存周转率" associateName="dm1656571660312" directModel="false" source="s1656571513978">
			<Design x="10" y="10" width="200" height="90" />
			<Properties>
				<Property name="物料ID" associateName="物料ID" alias="物料ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="物料编码" associateName="物料编码" alias="物料编码" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="物料名称" associateName="物料名称" alias="物料名称" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="会计年度" associateName="会计年度" alias="会计年度" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="会计期间" associateName="会计期间" alias="会计期间" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="库存组织编号" associateName="库存组织编号" alias="库存组织编号" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="库存组织名称" associateName="库存组织名称" alias="库存组织名称" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="财务组织编号" associateName="财务组织编号" alias="财务组织编号" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="财务组织名称" associateName="财务组织名称" alias="财务组织名称" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="出库总成本" associateName="出库总成本" alias="出库总成本" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="期初金额" associateName="期初金额" alias="期初金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="期末金额" associateName="期末金额" alias="期末金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="F1656580705807" associateName="F1656580705807" alias="会计区间" dataType="STRING" formula="[会计年度]+ &quot;年&quot; + [会计期间] + &quot;期&quot;" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
	</Entities>
	<Relations />
	<UnionEntityInnerRelations />
</Data>