/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.formater;

import com.kingdee.bos.privacy.ParamData;
import com.kingdee.bos.sql.dom.AbstractUpdateItem;
import com.kingdee.bos.sql.dom.SqlBlockStmt;
import com.kingdee.bos.sql.dom.SqlCaseItem;
import com.kingdee.bos.sql.dom.SqlColumnDef;
import com.kingdee.bos.sql.dom.SqlDelete;
import com.kingdee.bos.sql.dom.SqlInsert;
import com.kingdee.bos.sql.dom.SqlOrderByItem;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlTableSourceBase;
import com.kingdee.bos.sql.dom.SqlUnionSelect;
import com.kingdee.bos.sql.dom.SqlUpdate;
import com.kingdee.bos.sql.dom.SqlUpdateItem;
import com.kingdee.bos.sql.dom.SubQueryUpdateItem;
import com.kingdee.bos.sql.dom.expr.JavaObjectValueExpr;
import com.kingdee.bos.sql.dom.expr.QueryExpr;
import com.kingdee.bos.sql.dom.expr.SqlAggregateExpr;
import com.kingdee.bos.sql.dom.expr.SqlAllColumnExpr;
import com.kingdee.bos.sql.dom.expr.SqlAllExpr;
import com.kingdee.bos.sql.dom.expr.SqlAnyExpr;
import com.kingdee.bos.sql.dom.expr.SqlBetweenExpr;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlCaseExpr;
import com.kingdee.bos.sql.dom.expr.SqlCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlDateTimeExpr;
import com.kingdee.bos.sql.dom.expr.SqlDoubleExpr;
import com.kingdee.bos.sql.dom.expr.SqlEmptyExpr;
import com.kingdee.bos.sql.dom.expr.SqlExistsExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlInListExpr;
import com.kingdee.bos.sql.dom.expr.SqlInSubQueryExpr;
import com.kingdee.bos.sql.dom.expr.SqlIntExpr;
import com.kingdee.bos.sql.dom.expr.SqlLongExpr;
import com.kingdee.bos.sql.dom.expr.SqlMethodInvokeExpr;
import com.kingdee.bos.sql.dom.expr.SqlNCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlNotExpr;
import com.kingdee.bos.sql.dom.expr.SqlNullExpr;
import com.kingdee.bos.sql.dom.expr.SqlPriorIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlSomeExpr;
import com.kingdee.bos.sql.dom.expr.SqlVarRefExpr;
import com.kingdee.bos.sql.dom.stmt.CallStmt;
import com.kingdee.bos.sql.dom.stmt.SqlAlterTableStmt;
import com.kingdee.bos.sql.dom.stmt.SqlAlterViewStmt;
import com.kingdee.bos.sql.dom.stmt.SqlBreakStmt;
import com.kingdee.bos.sql.dom.stmt.SqlCloseStmt;
import com.kingdee.bos.sql.dom.stmt.SqlContinueStmt;
import com.kingdee.bos.sql.dom.stmt.SqlCreateIndexStmt;
import com.kingdee.bos.sql.dom.stmt.SqlCreateTableStmt;
import com.kingdee.bos.sql.dom.stmt.SqlCreateViewStmt;
import com.kingdee.bos.sql.dom.stmt.SqlCursorLoopStmt;
import com.kingdee.bos.sql.dom.stmt.SqlDeallocateStmt;
import com.kingdee.bos.sql.dom.stmt.SqlDeleteStmt;
import com.kingdee.bos.sql.dom.stmt.SqlDropFunctionStmt;
import com.kingdee.bos.sql.dom.stmt.SqlDropIndexStmt;
import com.kingdee.bos.sql.dom.stmt.SqlDropTableStmt;
import com.kingdee.bos.sql.dom.stmt.SqlDropTriggerStmt;
import com.kingdee.bos.sql.dom.stmt.SqlDropViewStmt;
import com.kingdee.bos.sql.dom.stmt.SqlExecStmt;
import com.kingdee.bos.sql.dom.stmt.SqlFetchStmt;
import com.kingdee.bos.sql.dom.stmt.SqlGotoStmt;
import com.kingdee.bos.sql.dom.stmt.SqlIfStmt;
import com.kingdee.bos.sql.dom.stmt.SqlInsertStmt;
import com.kingdee.bos.sql.dom.stmt.SqlLabelStmt;
import com.kingdee.bos.sql.dom.stmt.SqlOpenStmt;
import com.kingdee.bos.sql.dom.stmt.SqlSelectStmt;
import com.kingdee.bos.sql.dom.stmt.SqlSetLocalVariantStmt;
import com.kingdee.bos.sql.dom.stmt.SqlShowColumnsStmt;
import com.kingdee.bos.sql.dom.stmt.SqlShowTablesStmt;
import com.kingdee.bos.sql.dom.stmt.SqlStmt;
import com.kingdee.bos.sql.dom.stmt.SqlTrancateTableStmt;
import com.kingdee.bos.sql.dom.stmt.SqlUpdateStmt;
import com.kingdee.bos.sql.dom.stmt.SqlWhileStmt;
import com.kingdee.bos.sql.formater.FormatOptions;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.Token;
import com.kingdee.bos.sql.schema.FunctionDef;
import com.kingdee.bos.sql.util.SqlBinaryOpExprProcessor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class SQLFormater
implements SqlBinaryOpExprProcessor {
    public static final String HIERARCHICAL_QUERY_FLAG = "HIERARCHICAL_QUERY_FLAG";
    private final Map funcMap = new Hashtable();
    private final List funcList = new ArrayList();
    protected int max_length_of_index_name = -1;
    protected int max_length_of_table_name = -1;
    protected int max_length_of_constraint_name = -1;
    protected int max_length_of_column_name = -1;
    protected int max_length_of_column_count = -1;
    protected int max_length_of_row_size = -1;
    protected Map context = Collections.synchronizedMap(new HashMap());
    protected static final String isScriptContext = "isScriptContext";
    protected static final String toUpperCase = "toUpperCase";
    protected static final String Identity = "Identity";
    protected static final String Split = "~9^Nz";
    protected StringBuffer buffer;
    protected FormatOptions options;
    protected ParamData paramData = new ParamData(null);

    public SQLFormater(StringBuffer sb) {
        this.buffer = sb == null ? new StringBuffer() : sb;
        this.options = new FormatOptions();
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }

    public void setParamData(ParamData paramData) {
        this.paramData = paramData;
    }

    public FormatOptions getOptions() {
        return this.options;
    }

    public void setOptions(FormatOptions options) {
        this.options = options;
    }

    protected void afterFormat(StringBuffer buffer) {
    }

    public final void formatStmt(SqlStmt stmt) throws FormaterException {
        this.paramData.addTableAlias(this, stmt);
        if (stmt.type == 0) {
            this.formatSelectStmt((SqlSelectStmt)stmt);
            ArrayList subQueries = new ArrayList();
            subQueries.addAll(((SqlSelectStmt)stmt).select.subQueries);
            stmt.addExtAttr("SubQuery", subQueries);
        } else if (stmt.type == 2) {
            SqlInsertStmt insertStmt = (SqlInsertStmt)stmt;
            SqlInsert insert = ((SqlInsertStmt)stmt).insert;
            for (int i = 0; i < insert.columnList.size(); ++i) {
                Object colItem = insert.columnList.get(i);
                this.paramData.changeInsertColumn(insertStmt, colItem);
            }
            this.formatInsertStmt((SqlInsertStmt)stmt);
        } else if (stmt.type == 1) {
            this.formatDeleteStmt((SqlDeleteStmt)stmt);
        } else if (stmt.type == 3) {
            SqlUpdateStmt updateStmt = (SqlUpdateStmt)stmt;
            SqlUpdate update = updateStmt.update;
            for (int i = 0; i < update.updateList.size(); ++i) {
                AbstractUpdateItem abstract_item = (AbstractUpdateItem)update.updateList.get(i);
                this.paramData.changeUpdateColumn(updateStmt, abstract_item);
            }
            this.formatUpdateStmt((SqlUpdateStmt)stmt);
        } else if (stmt.type == 24) {
            SqlCreateTableStmt tableStmt = (SqlCreateTableStmt)stmt;
            try {
                this.formatCreateTableStmt(tableStmt);
            }
            catch (FormaterException ex) {
                throw new FormaterException("formate table stmt error. table name is '" + tableStmt.name + "'\n" + ex.getMessage());
            }
        } else if (stmt.type == 33) {
            this.formatAlterTableStmt((SqlAlterTableStmt)stmt);
        } else if (stmt.type == 45) {
            this.formatDropViewStmt((SqlDropViewStmt)stmt);
        } else if (stmt instanceof SqlDropTriggerStmt) {
            this.formatDropTriggerStmt((SqlDropTriggerStmt)stmt);
        } else if (stmt instanceof SqlDropTableStmt) {
            this.formatDropTableStmt((SqlDropTableStmt)stmt);
        } else if (stmt instanceof SqlCreateViewStmt) {
            this.formatCreateViewStmt((SqlCreateViewStmt)stmt);
        } else if (stmt instanceof SqlDropIndexStmt) {
            this.formatDropIndexStmt((SqlDropIndexStmt)stmt);
        } else if (stmt instanceof SqlCreateIndexStmt) {
            this.formatCreateIndexStmt((SqlCreateIndexStmt)stmt);
        } else if (stmt instanceof SqlAlterViewStmt) {
            this.formatAlterViewStmt((SqlAlterViewStmt)stmt);
        } else if (stmt instanceof SqlTrancateTableStmt) {
            this.formatTrancateTableStmt((SqlTrancateTableStmt)stmt);
        } else if (stmt instanceof SqlShowTablesStmt) {
            this.formatShowTablesStmt((SqlShowTablesStmt)stmt);
        } else if (stmt instanceof SqlShowColumnsStmt) {
            this.formatShowColumnsStmt((SqlShowColumnsStmt)stmt);
        } else if (stmt instanceof SqlExecStmt) {
            this.formatExecStmt((SqlExecStmt)stmt);
        } else if (stmt instanceof CallStmt) {
            this.formatCallStmt((CallStmt)stmt);
        } else if (stmt instanceof SqlBlockStmt) {
            this.formatBlockStmt((SqlBlockStmt)stmt);
        } else if (stmt instanceof SqlIfStmt) {
            this.formatIfStmt((SqlIfStmt)stmt);
        } else if (stmt instanceof SqlWhileStmt) {
            this.formatWhileStmt((SqlWhileStmt)stmt);
        } else if (stmt instanceof SqlCloseStmt) {
            this.formatCloseStmt((SqlCloseStmt)stmt);
        } else if (stmt instanceof SqlDeallocateStmt) {
            this.formatDeallocateStmt((SqlDeallocateStmt)stmt);
        } else if (stmt instanceof SqlSetLocalVariantStmt) {
            this.formatSetLocalVariantStmt((SqlSetLocalVariantStmt)stmt);
        } else if (stmt instanceof SqlOpenStmt) {
            this.formatOpenStmt((SqlOpenStmt)stmt);
        } else if (stmt instanceof SqlCursorLoopStmt) {
            this.formatCursorLoopStmt((SqlCursorLoopStmt)stmt);
        } else if (stmt instanceof SqlFetchStmt) {
            this.formatFetchStmt((SqlFetchStmt)stmt);
        } else if (stmt instanceof SqlBreakStmt) {
            this.formatBreakStmt((SqlBreakStmt)stmt);
        } else if (stmt instanceof SqlContinueStmt) {
            this.formatContinueStmt((SqlContinueStmt)stmt);
        } else if (stmt instanceof SqlLabelStmt) {
            this.formatLabelStmt((SqlLabelStmt)stmt);
        } else if (stmt instanceof SqlGotoStmt) {
            this.formatGotoStmt((SqlGotoStmt)stmt);
        } else if (stmt instanceof SqlDropFunctionStmt) {
            this.formatDropFunction((SqlDropFunctionStmt)stmt);
        } else {
            throw new FormaterException("unexpect statement: '" + stmt.getClass().getName() + "'");
        }
    }

    protected void handleSqlSelectInUnionSelect(SqlSelectBase select) throws FormaterException {
        this.formatSelectBase(select);
    }

    public void formatSelectBase(SqlSelectBase select) throws FormaterException {
        if (select instanceof SqlSelect) {
            this.formatSelect((SqlSelect)select);
        } else if (select instanceof SqlUnionSelect) {
            SqlUnionSelect unionSelect = (SqlUnionSelect)select;
            if (unionSelect.left instanceof SqlUnionSelect && ((SqlUnionSelect)unionSelect.left).option != unionSelect.option) {
                this.buffer.append('(');
                this.formatSelectBase(unionSelect.left);
                this.buffer.append(')');
            } else {
                this.handleSqlSelectInUnionSelect(unionSelect.left);
                select.subQueries.addAll(unionSelect.left.subQueries);
            }
            if (unionSelect.option == 0) {
                this.buffer.append(" UNION ");
            } else if (unionSelect.option == 1) {
                this.buffer.append(" UNION ALL ");
            } else {
                throw new FormaterException("Eorr Union Option.");
            }
            if (unionSelect.right instanceof SqlUnionSelect && ((SqlUnionSelect)unionSelect.right).option != unionSelect.option) {
                this.buffer.append('(');
                this.formatSelectBase(unionSelect.right);
                this.buffer.append(')');
            } else {
                this.handleSqlSelectInUnionSelect(unionSelect.right);
                select.subQueries.addAll(unionSelect.right.subQueries);
            }
            if (unionSelect.orderBy.size() != 0) {
                this.buffer.append(" ORDER BY ");
                boolean flag = false;
                Iterator iterator = unionSelect.orderBy.iterator();
                while (iterator.hasNext()) {
                    if (flag) {
                        this.buffer.append(", ");
                    }
                    SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
                    this.formatExpr(orderByIterm.expr);
                    if (orderByIterm.mode == 0) {
                        this.buffer.append(" ASC");
                    } else {
                        this.buffer.append(" DESC");
                    }
                    flag = true;
                }
            }
        }
    }

    protected void formatCallStmt(CallStmt stmt) throws FormaterException {
        this.buffer.append('{');
        if (stmt.returnExpr != null) {
            this.formatExpr(stmt.returnExpr);
            this.buffer.append(" = CALL ");
        } else {
            this.buffer.append("CALL ");
        }
        this.buffer.append(stmt.procName);
        if (stmt.paramList != null && stmt.paramList.size() != 0) {
            this.buffer.append('(');
            for (int i = 0; i < stmt.paramList.size(); ++i) {
                if (i != 0) {
                    this.buffer.append(", ");
                }
                SqlExpr expr = (SqlExpr)stmt.paramList.get(i);
                this.formatExpr(expr);
            }
            this.buffer.append(')');
        }
        this.buffer.append('}');
    }

    public final void formatExpr(SqlExpr expr) throws FormaterException {
        this.paramData.changeCondition(expr);
        this.formatExpr(expr, true);
        if (expr.type == 13) {
            this.paramData.resetSubParamData();
        }
    }

    public void formatExpr(SqlExpr expr, boolean appendBrace) throws FormaterException {
        if (expr == null) {
            throw new IllegalArgumentException("expr is null");
        }
        if (expr.type == 8) {
            this.buffer.append("*");
        } else if (expr.type == 4) {
            this.formatIdentifierExpr(expr);
        } else if (expr.type == 1) {
            this.buffer.append(((SqlIntExpr)expr).text);
        } else if (expr.type == 27) {
            this.buffer.append(((SqlLongExpr)expr).text);
        } else if (expr.type == 2) {
            this.buffer.append(((SqlDoubleExpr)expr).text);
        } else if (expr.type == 0) {
            this.formatBinaryOpExpr((SqlBinaryOpExpr)expr, appendBrace);
        } else if (expr.type == 10) {
            this.formatMethodInvokeExpr((SqlMethodInvokeExpr)expr);
        } else if (expr.type == 11) {
            this.formatAggregateExprExpr((SqlAggregateExpr)expr);
        } else if (expr.type == 5) {
            this.formatChar((SqlCharExpr)expr);
        } else if (expr.type == 6) {
            this.formatNChar((SqlNCharExpr)expr);
        } else if (expr.type == 3) {
            this.formatVarRef((SqlVarRefExpr)expr);
        } else if (expr.type == 12) {
            this.formatCaseExpr((SqlCaseExpr)expr);
        } else if (expr.type == 14) {
            this.formatInListExpr((SqlInListExpr)expr);
        } else if (expr.type == 15) {
            this.formatExiststExpr((SqlExistsExpr)expr);
        } else if (expr.type == 13) {
            this.formatInSubQueryExpr((SqlInSubQueryExpr)expr);
        } else if (expr.type == 16) {
            this.formatAllExpr((SqlAllExpr)expr);
        } else if (expr.type == 17) {
            this.formatBetweenExpr((SqlBetweenExpr)expr);
        } else if (expr.type == 18) {
            this.formatAnyExpr((SqlAnyExpr)expr);
        } else if (expr.type == 19) {
            this.formatSomeExpr((SqlSomeExpr)expr);
        } else if (expr.type == 20) {
            this.formatNullExpr((SqlNullExpr)expr);
        } else if (expr.type == 21) {
            this.formatDateTimeExpr((SqlDateTimeExpr)expr);
        } else if (expr.type == 24) {
            this.formatQueryExpr((QueryExpr)expr);
        } else if (expr.type == 25) {
            this.formatPriorIdentifierExpr((SqlPriorIdentifierExpr)expr);
        } else if (expr.type == 9) {
            this.formatNotExpr((SqlNotExpr)expr);
        } else if (expr.type == 26) {
            JavaObjectValueExpr java_value_expr = (JavaObjectValueExpr)expr;
            Object val = java_value_expr.value;
            if (val == null) {
                this.buffer.append("NULL");
            } else if (val instanceof String) {
                String str_val = (String)val;
                str_val = str_val.replaceAll("'", "''");
                this.buffer.append(str_val);
            } else if (val instanceof Calendar) {
                Calendar calendar = (Calendar)val;
                this.buffer.append("{" + calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5) + " " + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13) + "}");
            } else {
                this.buffer.append(val.toString());
            }
        } else if (expr.type != 28) {
            throw new FormaterException("unexpect expression: '" + expr + "'");
        }
    }

    protected String formatTableName(String tableName) {
        return tableName;
    }

    protected String formatViewName(String name) {
        return name;
    }

    protected String formatConstraintName(String name) {
        return name;
    }

    protected String formatColumnName(String name) {
        return name;
    }

    protected String formateIndexName(String indexName) {
        return indexName;
    }

    protected int functionCount() {
        return this.funcList.size();
    }

    protected void addFunction(FunctionDef func) {
        this.funcList.add(func);
        this.funcMap.put(func.name, func);
    }

    protected void removeParameter(FunctionDef func) {
        this.funcList.remove(func);
        this.funcMap.remove(func.name);
    }

    protected void removeFunctionAt(int index) {
        FunctionDef func = (FunctionDef)this.funcList.get(index);
        this.funcList.remove(index);
        this.funcMap.remove(func.name);
    }

    protected void clearFunction() {
        this.funcList.clear();
        this.funcMap.clear();
    }

    protected FunctionDef getFunction(int funcIndex) {
        return (FunctionDef)this.funcList.get(funcIndex);
    }

    protected FunctionDef getFunction(String funcName) {
        return (FunctionDef)this.funcMap.get(funcName);
    }

    protected void validateCreateTableStmt(SqlCreateTableStmt stmt) throws FormaterException {
        if (stmt.name == null) {
            throw new FormaterException("table name cannot be null.");
        }
        if (this.max_length_of_table_name != -1 && stmt.name.length() > this.max_length_of_table_name) {
            throw new FormaterException("table name greate than " + this.max_length_of_table_name + ", table name is '" + stmt.name + "'");
        }
    }

    protected void validConstraintName(String constriantName) throws FormaterException {
        if (constriantName != null && constriantName.length() != 0 && this.max_length_of_constraint_name != -1 && constriantName.length() > this.max_length_of_constraint_name) {
            throw new FormaterException("constraint name greate than " + this.max_length_of_constraint_name + ", constraint name is '" + constriantName + "'");
        }
    }

    protected String getIndexName(SqlCreateIndexStmt stmt) {
        return this.formateIndexName(stmt.indexName);
    }

    protected String getIndexName(SqlDropIndexStmt stmt) {
        return stmt.indexName;
    }

    public void replaceBinaryOpExpr(SqlBinaryOpExpr expr, Map replaceMap) throws FormaterException {
        if (expr.operator == 13) {
            this.replaceExpr(expr.left, replaceMap);
            return;
        }
        if (expr.operator == 41) {
            this.replaceExpr(expr.left, replaceMap);
            return;
        }
        if (expr.operator == 20) {
            this.replaceExpr(expr.left, replaceMap);
            this.replaceExpr(expr.right, replaceMap);
            return;
        }
        if (expr.operator == 43) {
            this.replaceExpr(expr.left, replaceMap);
            this.replaceExpr(expr.right, replaceMap);
            return;
        }
        if (expr.operator == 10) {
            this.replaceExpr(expr.left, replaceMap);
            this.replaceExpr(expr.right, replaceMap);
            return;
        }
        if (expr.operator == 0) {
            if (expr.left instanceof SqlBinaryOpExpr) {
                SqlBinaryOpExpr binaryOpLeft = (SqlBinaryOpExpr)expr.left;
                if (binaryOpLeft.operator == 0) {
                    this.replaceExpr(binaryOpLeft, replaceMap);
                } else {
                    this.replaceExpr(binaryOpLeft, replaceMap);
                }
            } else {
                this.replaceExpr(expr.left, replaceMap);
            }
            if (expr.right instanceof SqlBinaryOpExpr) {
                SqlBinaryOpExpr binaryOpRight = (SqlBinaryOpExpr)expr.right;
                if (binaryOpRight.operator == 0) {
                    this.replaceExpr(binaryOpRight, replaceMap);
                } else {
                    this.replaceExpr(binaryOpRight, replaceMap);
                }
            } else {
                this.replaceExpr(expr.right, replaceMap);
            }
            return;
        }
        if (expr.operator == 8) {
            if (expr.left instanceof SqlBinaryOpExpr) {
                SqlBinaryOpExpr binaryOpLeft = (SqlBinaryOpExpr)expr.left;
                if (binaryOpLeft.operator == 8) {
                    this.replaceExpr(binaryOpLeft, replaceMap);
                } else {
                    this.replaceExpr(binaryOpLeft, replaceMap);
                }
            } else {
                this.replaceExpr(expr.left, replaceMap);
            }
            if (expr.right instanceof SqlBinaryOpExpr) {
                SqlBinaryOpExpr binaryOpRight = (SqlBinaryOpExpr)expr.right;
                if (binaryOpRight.operator == 8) {
                    this.replaceExpr(binaryOpRight, replaceMap);
                } else {
                    this.replaceExpr(binaryOpRight, replaceMap);
                }
            } else {
                this.replaceExpr(expr.right, replaceMap);
            }
            return;
        }
        if (expr.operator == 1) {
            this.replaceExpr(expr.left, replaceMap);
            if (!(expr.right instanceof SqlIdentifierExpr || expr.right instanceof SqlCharExpr || expr.right instanceof SqlNCharExpr)) {
                this.replaceExpr(expr.right, replaceMap);
            }
            return;
        }
        this.replaceExpr(expr.left, replaceMap);
        this.replaceExpr(expr.right, replaceMap);
    }

    protected void replaceExpr(SqlExpr expr, Map replaceMap) throws FormaterException {
        if (expr == null) {
            throw new IllegalArgumentException("expr is null");
        }
        if (!(expr instanceof SqlAllColumnExpr)) {
            if (expr instanceof SqlIdentifierExpr) {
                String ident = ((SqlIdentifierExpr)expr).value;
                if (replaceMap.get(ident.toUpperCase()) != null) {
                    ((SqlIdentifierExpr)expr).value = (String)replaceMap.get(ident.toUpperCase());
                }
            } else if (!(expr instanceof SqlIntExpr) && !(expr instanceof SqlDoubleExpr)) {
                if (expr instanceof SqlBinaryOpExpr) {
                    this.replaceBinaryOpExpr((SqlBinaryOpExpr)expr, replaceMap);
                } else if (expr instanceof SqlMethodInvokeExpr) {
                    this.replaceMethodInvokeExpr((SqlMethodInvokeExpr)expr, replaceMap);
                } else if (!(expr instanceof SqlAggregateExpr || expr instanceof SqlCharExpr || expr instanceof SqlNCharExpr || expr instanceof SqlVarRefExpr)) {
                    if (expr instanceof SqlCaseExpr) {
                        this.replaceCaseExpr((SqlCaseExpr)expr, replaceMap);
                    } else if (!(expr instanceof SqlInListExpr || expr instanceof SqlExistsExpr || expr instanceof SqlInSubQueryExpr || expr instanceof SqlAllExpr || expr instanceof SqlBetweenExpr || expr instanceof SqlAnyExpr || expr instanceof SqlSomeExpr || expr instanceof SqlNullExpr || expr instanceof SqlDateTimeExpr || expr instanceof QueryExpr || expr instanceof SqlPriorIdentifierExpr)) {
                        throw new FormaterException("unexpect expression: '" + expr + "'");
                    }
                }
            }
        }
    }

    protected void replaceCaseExpr(SqlCaseExpr expr, Map replaceMap) throws FormaterException {
        if (expr.valueExpr != null) {
            this.replaceExpr(expr.valueExpr, replaceMap);
        }
        for (SqlCaseItem caseItem : expr.itemList) {
            this.replaceExpr(caseItem.conditionExpr, replaceMap);
            this.replaceExpr(caseItem.valueExpr, replaceMap);
        }
        if (expr.elseExpr != null) {
            this.replaceExpr(expr.elseExpr, replaceMap);
        }
    }

    protected boolean isToUpperCaseExpr(SqlIdentifierExpr expr) {
        return expr.value.equalsIgnoreCase(Token.KSQL_COL_NAME.value) || expr.value.equalsIgnoreCase(Token.INDNAME.value) || expr.value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value) || expr.value.equalsIgnoreCase(Token.TABNAME.value) || expr.value.equalsIgnoreCase(Token.KSQL_CREATETIME.value) || expr.value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value) || expr.value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value) || expr.value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value);
    }

    protected StringBuffer handleComma(StringBuffer buff, int pos) {
        String tmpStr = buff.substring(pos);
        buff.replace(pos, buff.length(), tmpStr.replaceAll("'", "''"));
        return buff;
    }

    protected void enableSplitTag() {
        this.context.put(Split, Boolean.TRUE);
    }

    protected void disableSplitTag() {
        this.context.put(Split, Boolean.FALSE);
    }

    protected boolean isInsertSplitTag() {
        Boolean insert = (Boolean)this.context.get(Split);
        if (insert == null) {
            return false;
        }
        return insert;
    }

    protected void formatAnyExpr(SqlAnyExpr expr) throws FormaterException {
        this.buffer.append("ANY (");
        this.formatSelectBase(expr.subQuery);
        this.buffer.append(")");
    }

    protected void formatBetweenExpr(SqlBetweenExpr expr) throws FormaterException {
        this.buffer.append("(");
        this.formatExpr(expr.testExpr);
        if (expr.not) {
            this.buffer.append(" NOT BETWEEN ");
        } else {
            this.buffer.append(" BETWEEN ");
        }
        this.formatExpr(expr.beginExpr);
        this.buffer.append(" AND ");
        this.formatExpr(expr.endExpr);
        this.buffer.append(")");
    }

    protected void formatSomeExpr(SqlSomeExpr expr) throws FormaterException {
        this.buffer.append("SOME (");
        this.formatSelectBase(expr.subQuery);
        this.buffer.append(")");
    }

    protected void formatInListExpr(SqlInListExpr expr) throws FormaterException {
        this.formatExpr(expr.expr);
        if (expr.not) {
            this.buffer.append(" NOT IN (");
        } else {
            this.buffer.append(" IN (");
        }
        Iterator iterator = expr.targetList.iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlExpr exprItem = (SqlExpr)iterator.next();
            this.formatExpr(exprItem);
            flag = true;
        }
        this.buffer.append(")");
    }

    protected void formatDropViewStmt(SqlDropViewStmt stmt) throws FormaterException {
        this.buffer.append("DROP VIEW ");
        this.buffer.append(stmt.viewName);
    }

    protected void formatExiststExpr(SqlExistsExpr expr) throws FormaterException {
        if (expr.not) {
            this.buffer.append("NOT EXISTS (");
        } else {
            this.buffer.append("EXISTS (");
        }
        this.formatSelectBase(expr.subQuery);
        this.buffer.append(")");
    }

    public String format(Collection stmtList) throws FormaterException {
        Iterator iterator = stmtList.iterator();
        this.context.clear();
        boolean flag = false;
        while (iterator.hasNext()) {
            if (flag) {
                if (this.buffer.charAt(this.buffer.length() - 1) != ';') {
                    this.buffer.append(";");
                }
                this.buffer.append("\n");
            }
            SqlStmt stmt = (SqlStmt)iterator.next();
            this.formatStmt(stmt);
            flag = true;
        }
        if (stmtList.size() > 1 && this.buffer.charAt(this.buffer.length() - 1) != ';') {
            this.buffer.append(";");
        }
        this.afterFormat(this.buffer);
        return this.buffer.toString();
    }

    protected void formatDropTableStmt(SqlDropTableStmt stmt) throws FormaterException {
        this.buffer.append("DROP TABLE ");
        this.buffer.append(this.formatTableName(stmt.tableName));
    }

    protected void formatDropTriggerStmt(SqlDropTriggerStmt stmt) throws FormaterException {
        this.buffer.append("DROP TRIGGER ");
        this.buffer.append(stmt.trggerName);
    }

    protected void formatCreateViewStmt(SqlCreateViewStmt stmt) throws FormaterException {
        this.buffer.append("CREATE VIEW " + this.formatViewName(stmt.name));
        if (stmt.columnList.size() != 0) {
            this.buffer.append("(");
            for (int i = 0; i < stmt.columnList.size(); ++i) {
                if (i != 0) {
                    this.buffer.append(", ");
                }
                String colName = (String)stmt.columnList.get(i);
                this.buffer.append(this.formatColumnName(colName));
            }
            this.buffer.append(")");
        }
        this.buffer.append(" AS ");
        this.formatSelectBase(stmt.select);
    }

    protected void formatSelectStmt(SqlSelectStmt stmt) throws FormaterException {
        this.formatSelectBase(stmt.select);
    }

    protected void formatAlterViewStmt(SqlAlterViewStmt stmt) throws FormaterException {
        this.buffer.append("ALTER VIEW " + this.formatViewName(stmt.name));
        this.buffer.append(" AS ");
        this.formatSelectBase(stmt.select);
    }

    protected void formateUpdateItem(AbstractUpdateItem abstract_item) throws FormaterException {
        if (abstract_item instanceof SqlUpdateItem) {
            SqlUpdateItem item = (SqlUpdateItem)abstract_item;
            this.buffer.append(item.name);
            this.buffer.append(" = ");
            this.formatExpr(item.expr);
        } else if (abstract_item instanceof SubQueryUpdateItem) {
            SubQueryUpdateItem queryItem = (SubQueryUpdateItem)abstract_item;
            boolean flag = false;
            this.buffer.append('(');
            Iterator iter = queryItem.columnList.iterator();
            while (iter.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String column = (String)iter.next();
                this.buffer.append(column);
                flag = true;
            }
            this.buffer.append(") = (");
            this.formatSelectBase(queryItem.subQuery);
            this.buffer.append(")");
        } else {
            throw new FormaterException("unexpect update item: '" + abstract_item + "'");
        }
    }

    protected void formatUpdateStmt(SqlUpdateStmt stmt) throws FormaterException {
        SqlUpdate update = stmt.update;
        this.buffer.append("UPDATE ");
        this.buffer.append(update.updateTable.name);
        if (update.updateTable.alias != null) {
            this.buffer.append(" ");
            this.buffer.append(update.updateTable.alias);
        }
        this.buffer.append(" SET ");
        Iterator iterator = update.updateList.iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            AbstractUpdateItem abstract_item = (AbstractUpdateItem)iterator.next();
            if (flag) {
                this.buffer.append(", ");
            }
            this.formateUpdateItem(abstract_item);
            flag = true;
        }
        if (update.tableSource != null) {
            throw new FormaterException("update tableSource can't be null");
        }
        if (update.condition != null) {
            this.buffer.append(" WHERE ");
            this.formatExpr(update.condition);
        }
    }

    protected void formatInSubQueryExpr(SqlInSubQueryExpr expr) throws FormaterException {
        this.formatExpr(expr.expr);
        if (expr.not) {
            this.buffer.append(" NOT IN (");
        } else {
            this.buffer.append(" IN (");
        }
        this.formatSelectBase(expr.subQuery);
        this.buffer.append(")");
    }

    protected void formatCaseExpr(SqlCaseExpr expr) throws FormaterException {
        this.buffer.append("CASE ");
        if (expr.valueExpr != null) {
            this.formatExpr(expr.valueExpr);
        }
        Iterator iterator = expr.itemList.iterator();
        while (iterator.hasNext()) {
            this.buffer.append(" WHEN ");
            SqlCaseItem caseItem = (SqlCaseItem)iterator.next();
            this.formatExpr(caseItem.conditionExpr);
            this.buffer.append(" THEN ");
            this.formatExpr(caseItem.valueExpr);
        }
        if (expr.elseExpr != null) {
            this.buffer.append(" ELSE ");
            this.formatExpr(expr.elseExpr);
        }
        this.buffer.append(" END");
    }

    protected void formatDeleteStmt(SqlDeleteStmt stmt) throws FormaterException {
        SqlDelete delete = stmt.delete;
        this.buffer.append("DELETE ");
        this.formatHintForDelete(stmt);
        if (delete.tableName != null && delete.tableName.length() != 0) {
            if (delete.tableSource != null) {
                throw new FormaterException("not support");
            }
            this.buffer.append("FROM ");
            this.buffer.append(this.formatTableName(delete.tableName));
        } else {
            this.buffer.append("FROM ");
            this.formatTableSource(delete.tableSource);
        }
        if (delete.condition != null) {
            this.buffer.append(" WHERE ");
            this.formatExpr(delete.condition);
        }
    }

    protected void formatHintForDelete(SqlDeleteStmt stmt) throws FormaterException {
    }

    protected void formatInsertStmt(SqlInsertStmt stmt) throws FormaterException {
        int i;
        boolean flag;
        this.buffer.append("INSERT INTO ");
        SqlInsert insert = stmt.insert;
        this.buffer.append(this.formatTableName(insert.tableName));
        if (!insert.columnList.isEmpty()) {
            this.buffer.append(" (");
            flag = false;
            for (i = 0; i < insert.columnList.size(); ++i) {
                Object colItem;
                if (flag) {
                    this.buffer.append(", ");
                }
                if ((colItem = insert.columnList.get(i)) instanceof SqlIdentifierExpr) {
                    SqlIdentifierExpr identExpr = (SqlIdentifierExpr)colItem;
                    this.buffer.append(this.formatColumnName(identExpr.value));
                } else if (colItem instanceof String) {
                    this.buffer.append(this.formatColumnName((String)colItem));
                } else {
                    throw new FormaterException("unexpect expression: '" + colItem + "'");
                }
                flag = true;
            }
            this.buffer.append(")");
        }
        if (insert.valueList.size() != 0) {
            this.buffer.append(" VALUES (");
            flag = false;
            for (i = 0; i < insert.valueList.size(); ++i) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr valueExpr = (SqlExpr)insert.valueList.get(i);
                this.formatExpr(valueExpr);
                flag = true;
            }
            this.buffer.append(")");
        } else {
            this.buffer.append(" ");
            this.formatSelectBase(stmt.insert.subQuery);
        }
    }

    protected void formatCreateIndexStmt(SqlCreateIndexStmt stmt) throws FormaterException {
        if (stmt.isUnique) {
            this.buffer.append("CREATE UNIQUE INDEX ");
        }
        if (stmt.isCluster) {
            this.buffer.append("CREATE CLUSTERED INDEX ");
        }
        if (!stmt.isCluster && !stmt.isUnique) {
            this.buffer.append("CREATE INDEX ");
        }
        this.buffer.append(this.getIndexName(stmt));
        this.buffer.append(" ON ");
        this.buffer.append(this.formatTableName(stmt.tableName));
        this.buffer.append(" (");
        boolean flag = false;
        Iterator iterator = stmt.itemList.iterator();
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
            this.formatExpr(orderByIterm.expr);
            if (orderByIterm.mode != 0) {
                this.buffer.append(" DESC");
            }
            flag = true;
        }
        this.buffer.append(")");
    }

    protected void formatTrancateTableStmt(SqlTrancateTableStmt stmt) throws FormaterException {
        this.buffer.append("TRUNCATE TABLE ");
        this.buffer.append(this.formatTableName(stmt.tableName));
    }

    protected void formatAggregateExprExpr(SqlAggregateExpr expr) throws FormaterException {
        this.buffer.append(expr.methodName);
        this.buffer.append("(");
        if (expr.option == 0) {
            this.buffer.append("DISTINCT ");
        }
        Iterator iterator = expr.paramList.iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlExpr param = (SqlExpr)iterator.next();
            this.formatExpr(param, false);
            flag = true;
        }
        this.buffer.append(")");
    }

    protected void formatChar(SqlCharExpr expr) throws FormaterException {
        this.buffer.append("'");
        this.buffer.append(expr.text);
        this.buffer.append("'");
    }

    protected void formatNChar(SqlNCharExpr expr) throws FormaterException {
        this.buffer.append("N'");
        this.buffer.append(expr.text);
        this.buffer.append("'");
    }

    protected void formatAllExpr(SqlAllExpr expr) throws FormaterException {
        this.buffer.append("ALL (");
        this.formatSelectBase(expr.subQuery);
        this.buffer.append(")");
    }

    protected void formatIdentifierExpr(SqlExpr expr) {
        String ident = ((SqlIdentifierExpr)expr).value;
        if (ident != null && ident.length() != 0 && ident.charAt(0) == '\"') {
            this.buffer.append(ident.toUpperCase());
        } else {
            this.buffer.append(ident);
        }
    }

    protected void formatDropFunction(SqlDropFunctionStmt stmt) throws FormaterException {
        this.buffer.append("DROP FUNCTION ");
        if (stmt.schema != null) {
            this.buffer.append(stmt.schema);
            this.buffer.append(".");
        }
        if (stmt.functionName == null) {
            throw new FormaterException("function name cannot be null");
        }
        this.buffer.append(stmt.functionName);
    }

    protected void formatNotExpr(SqlNotExpr notExpr) throws FormaterException {
        this.buffer.append("NOT ");
        this.buffer.append("(");
        this.formatExpr(notExpr.expr);
        this.buffer.append(")");
    }

    protected void formatDropIndexStmt(SqlDropIndexStmt stmt) throws FormaterException {
        this.buffer.append("DROP INDEX ");
        this.buffer.append(this.getIndexName(stmt));
    }

    protected void formatNullExpr(SqlNullExpr expr) {
        this.buffer.append("NULL");
    }

    protected void formatEmptyExpr(SqlEmptyExpr expr) {
        this.buffer.append("EMPTY");
    }

    protected void formeatUnkownMethodInvokeExpr(SqlMethodInvokeExpr expr) throws FormaterException {
        throw new FormaterException("unexpect function, function name is '" + expr.methodName + "'");
    }

    protected void formatQueryExpr(QueryExpr expr) throws FormaterException {
        this.buffer.append('(');
        this.formatSelectBase(expr.subQuery);
        this.buffer.append(')');
    }

    protected void formatVarRef(SqlVarRefExpr expr) throws FormaterException {
        this.buffer.append(expr.text);
    }

    @Override
    public void process(SqlBinaryOpExpr expr, int leftBracket, int rightBracket, Map options) throws Exception {
        Boolean b;
        boolean appendBrace = true;
        if (options != null && (b = (Boolean)options.get("appendBrace")) != null) {
            appendBrace = b;
        }
        for (int i = 0; i < leftBracket; ++i) {
            this.buffer.append("(");
        }
        if (expr.left instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr oExpr = (SqlBinaryOpExpr)expr.left;
            if (oExpr.operator != 8 && oExpr.operator != 7) {
                this.formatBinaryOpExpr(oExpr, appendBrace);
            }
        } else {
            this.formatExpr(expr.left, appendBrace);
        }
        if (expr.operator == 8) {
            this.buffer.append(" OR ");
        } else if (expr.operator == 7) {
            this.buffer.append(" AND ");
        }
        if (expr.right instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr oExpr = (SqlBinaryOpExpr)expr.right;
            if (oExpr.operator != 8 && oExpr.operator != 7) {
                this.formatBinaryOpExpr(oExpr, appendBrace);
            }
        } else {
            this.formatExpr(expr.right, appendBrace);
        }
        for (int i = 0; i < rightBracket; ++i) {
            this.buffer.append(")");
        }
    }

    protected abstract void formatBinaryOpExpr(SqlBinaryOpExpr var1, boolean var2) throws FormaterException;

    protected abstract void formatTableSource(SqlTableSourceBase var1) throws FormaterException;

    protected abstract void formatPriorIdentifierExpr(SqlPriorIdentifierExpr var1) throws FormaterException;

    protected abstract void formatMethodInvokeExpr(SqlMethodInvokeExpr var1) throws FormaterException;

    protected abstract void formatBlockStmt(SqlBlockStmt var1) throws FormaterException;

    protected abstract void formatIfStmt(SqlIfStmt var1) throws FormaterException;

    protected abstract void formatWhileStmt(SqlWhileStmt var1) throws FormaterException;

    protected abstract void formatDeallocateStmt(SqlDeallocateStmt var1) throws FormaterException;

    protected abstract void formatCloseStmt(SqlCloseStmt var1) throws FormaterException;

    protected abstract void formatSetLocalVariantStmt(SqlSetLocalVariantStmt var1) throws FormaterException;

    protected abstract void formatOpenStmt(SqlOpenStmt var1) throws FormaterException;

    protected abstract void formatCursorLoopStmt(SqlCursorLoopStmt var1) throws FormaterException;

    protected abstract void formatFetchStmt(SqlFetchStmt var1) throws FormaterException;

    protected abstract void formatBreakStmt(SqlBreakStmt var1) throws FormaterException;

    protected abstract void formatContinueStmt(SqlContinueStmt var1) throws FormaterException;

    protected abstract void formatGotoStmt(SqlGotoStmt var1) throws FormaterException;

    protected abstract void formatLabelStmt(SqlLabelStmt var1) throws FormaterException;

    protected abstract void formatCreateTableStmt(SqlCreateTableStmt var1) throws FormaterException;

    protected abstract void formatAlterTableStmt(SqlAlterTableStmt var1) throws FormaterException;

    protected abstract void formatDateTimeExpr(SqlDateTimeExpr var1) throws FormaterException;

    protected abstract void formatColumnDef(SqlColumnDef var1) throws FormaterException;

    protected abstract void formatExecStmt(SqlExecStmt var1) throws FormaterException;

    protected abstract void formatShowTablesStmt(SqlShowTablesStmt var1) throws FormaterException;

    protected abstract void formatShowColumnsStmt(SqlShowColumnsStmt var1) throws FormaterException;

    protected abstract void formatSelect(SqlSelect var1) throws FormaterException;

    private void replaceMethodInvokeExpr(SqlMethodInvokeExpr expr, Map replaceMap) throws FormaterException {
        for (int i = 0; i < expr.parameters.size(); ++i) {
            this.replaceExpr((SqlExpr)expr.parameters.get(i), replaceMap);
        }
    }

    protected boolean checkHaveChineseOrderBy(List orderBy) {
        Iterator iterator = orderBy.iterator();
        boolean res = false;
        while (iterator.hasNext()) {
            SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
            if (orderByIterm.chineseOrderByMode == -1) continue;
            res = true;
            break;
        }
        return res;
    }
}

