/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.shell.trace;

import com.kingdee.bos.sql.shell.trace.InterruptedError;
import org.apache.log4j.Logger;

public class Queue {
    private static Logger logger = Logger.getLogger(Queue.class);
    private QueueItem first;
    private QueueItem last;
    private int blocked;
    private static QueueItem freeItemChain;

    public synchronized void put(Object obj) {
        if (this.first == null) {
            this.first = this.last = Queue.createItem(obj);
        } else {
            this.last = this.last.next = Queue.createItem(obj);
        }
        if (this.blocked != 0) {
            this.notifyAll();
        }
        if (logger.isDebugEnabled() && obj == null) {
            logger.debug((Object)"put obj is null.");
        }
    }

    public synchronized Object get(long timeout) {
        if (this.first == null || this.blocked != 0) {
            if (timeout == 0L) {
                return null;
            }
            long startTime = System.currentTimeMillis();
            do {
                long currentTime;
                if ((currentTime = System.currentTimeMillis()) - startTime >= timeout) {
                    return null;
                }
                try {
                    long rest = timeout - currentTime + startTime;
                    ++this.blocked;
                    this.wait(rest);
                    --this.blocked;
                }
                catch (InterruptedException e) {
                    this.notifyAll();
                    --this.blocked;
                    throw new InterruptedError();
                }
            } while (this.first == null);
        }
        QueueItem item = this.first;
        Object obj = item.obj;
        this.first = this.first.next;
        Queue.freeItem(item);
        if (this.blocked != 0 && this.first != null) {
            this.notifyAll();
        }
        if (logger.isDebugEnabled() && obj == null) {
            logger.debug((Object)"get null obj");
        }
        return obj;
    }

    public synchronized Object get() {
        return this.get(Long.MAX_VALUE);
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    private static final synchronized QueueItem createItem(Object obj) {
        QueueItem item;
        if (freeItemChain == null) {
            item = new QueueItem();
        } else {
            item = freeItemChain;
            freeItemChain = Queue.freeItemChain.next;
        }
        item.obj = obj;
        item.next = null;
        return item;
    }

    private static final synchronized void freeItem(QueueItem item) {
        item.next = freeItemChain;
        freeItemChain = item;
    }

    static class QueueItem {
        QueueItem next;
        Object obj;

        QueueItem() {
        }
    }
}

