/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.parser;

import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlCaseItem;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.expr.ObjectCreateExpr;
import com.kingdee.bos.sql.dom.expr.QueryExpr;
import com.kingdee.bos.sql.dom.expr.SqlAggregateExpr;
import com.kingdee.bos.sql.dom.expr.SqlAllColumnExpr;
import com.kingdee.bos.sql.dom.expr.SqlAllExpr;
import com.kingdee.bos.sql.dom.expr.SqlAnyExpr;
import com.kingdee.bos.sql.dom.expr.SqlBetweenExpr;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlCaseExpr;
import com.kingdee.bos.sql.dom.expr.SqlCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlConvertTypeExpr;
import com.kingdee.bos.sql.dom.expr.SqlDateTimeExpr;
import com.kingdee.bos.sql.dom.expr.SqlDoubleExpr;
import com.kingdee.bos.sql.dom.expr.SqlEmptyExpr;
import com.kingdee.bos.sql.dom.expr.SqlExistsExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentityExpr;
import com.kingdee.bos.sql.dom.expr.SqlInListExpr;
import com.kingdee.bos.sql.dom.expr.SqlInSubQueryExpr;
import com.kingdee.bos.sql.dom.expr.SqlIntExpr;
import com.kingdee.bos.sql.dom.expr.SqlLongExpr;
import com.kingdee.bos.sql.dom.expr.SqlMethodInvokeExpr;
import com.kingdee.bos.sql.dom.expr.SqlNCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlNotExpr;
import com.kingdee.bos.sql.dom.expr.SqlNullExpr;
import com.kingdee.bos.sql.dom.expr.SqlPriorIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlSomeExpr;
import com.kingdee.bos.sql.dom.expr.SqlVarRefExpr;
import com.kingdee.bos.sql.parser.KeyWord;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.SelectParser;
import com.kingdee.bos.sql.parser.SqlParserBase;
import com.kingdee.bos.sql.parser.Token;
import com.kingdee.bos.sql.parser.TokenList;
import java.util.Collection;

public class SqlExprParser
extends SqlParserBase {
    private KeyWord inSubQueryKeyword;
    private final TokenList _tokenList;
    public boolean allowStringAdditive = false;

    public SqlExprParser(TokenList tokList) {
        this._tokenList = tokList;
    }

    public SqlExprParser(Lexer lexer) throws ParserException {
        this._tokenList = new TokenList(lexer);
    }

    public SqlExprParser(String text) throws ParserException {
        Lexer lexer = new Lexer(text);
        this._tokenList = new TokenList(lexer);
    }

    public final SqlExpr expr() throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.MulToken)) {
            this._tokenList.match();
            return new SqlAllColumnExpr();
        }
        SqlExpr expr = this.unary();
        if (this._tokenList.lookup(0).equals(Token.InToken)) {
            expr = this.inRest(expr);
        }
        if (this._tokenList.lookup(0).equals(Token.CommaToken)) {
            return expr;
        }
        return this.exprRest(expr);
    }

    public final SqlExpr exprRest(SqlExpr expr) throws ParserException {
        expr = this.multiplicativeRest(expr);
        expr = this.additiveRest(expr);
        expr = this.inRest(expr);
        expr = this.relationalRest(expr);
        expr = this.equalityRest(expr);
        expr = this.andRest(expr);
        expr = this.orRest(expr);
        return expr;
    }

    public final void exprList(Collection exprCol) throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.CloseBraceToken)) {
            return;
        }
        if (this._tokenList.lookup(0).equals(Token.EOFToken)) {
            return;
        }
        SqlExpr expr = this.expr();
        exprCol.add(expr);
        while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
            this._tokenList.match();
            expr = this.expr();
            exprCol.add(expr);
        }
    }

    public final SqlExpr unary() throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.MinusToken)) {
            if (this._tokenList.lookup((int)1).type == 8) {
                SqlIntExpr intExpr = new SqlIntExpr("-" + this._tokenList.lookup((int)1).value);
                this._tokenList.match();
                this._tokenList.match();
                return intExpr;
            }
            if (this._tokenList.lookup((int)1).type == 11 || this._tokenList.lookup((int)1).type == 10) {
                SqlDoubleExpr doubleExpr = new SqlDoubleExpr("-" + this._tokenList.lookup((int)1).value);
                this._tokenList.match();
                this._tokenList.match();
                return doubleExpr;
            }
            if (this._tokenList.lookup((int)1).type == 15) {
                SqlLongExpr longExpr = new SqlLongExpr("-" + this._tokenList.lookup((int)1).value);
                this._tokenList.match();
                this._tokenList.match();
                return longExpr;
            }
        }
        return this.primary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SqlExpr primary() throws ParserException {
        SqlExpr sql_expr = null;
        if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
            this._tokenList.match();
            sql_expr = this.expr();
            this._tokenList.match(Token.CloseBraceToken);
        } else if (this._tokenList.lookup((int)0).type == 1) {
            sql_expr = new SqlIdentifierExpr(this._tokenList.lookup((int)0).value, this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
        } else if (this._tokenList.lookup((int)0).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value) || this._tokenList.lookup((int)0).value.equalsIgnoreCase(Token.TABNAME.value) || this._tokenList.lookup((int)0).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value) || this._tokenList.lookup((int)0).value.equalsIgnoreCase(Token.INDNAME.value) || this._tokenList.lookup((int)0).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value) || this._tokenList.lookup((int)0).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value) || this._tokenList.lookup((int)0).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
            sql_expr = new SqlIdentifierExpr(this._tokenList.lookup((int)0).value, this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
        } else if (this._tokenList.lookup((int)0).value.equalsIgnoreCase("IDENTITY")) {
            String identityName = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(Token.IdentityToken);
            this._tokenList.match(Token.OpenBraceToken);
            String dataType = this._tokenList.lookup((int)0).value;
            this._tokenList.match();
            this._tokenList.match(Token.CommaToken);
            int seed = Integer.parseInt(this._tokenList.lookup((int)0).value);
            this._tokenList.match();
            this._tokenList.match(Token.CommaToken);
            int increment = Integer.parseInt(this._tokenList.lookup((int)0).value);
            this._tokenList.match();
            this._tokenList.match(Token.CloseBraceToken);
            sql_expr = new SqlIdentityExpr(identityName, false, dataType, seed, increment);
        } else if (this._tokenList.lookup(0).equals(Token.New)) {
            this._tokenList.match();
            StringBuffer typeNameBuffer = new StringBuffer();
            StringBuffer orgTypeNameBuffer = new StringBuffer();
            typeNameBuffer.append(this._tokenList.lookup((int)0).value);
            orgTypeNameBuffer.append(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
            while (this._tokenList.lookup(0).equals(Token.PeriodToken)) {
                this._tokenList.match();
                typeNameBuffer.append('.');
                orgTypeNameBuffer.append('.');
                typeNameBuffer.append(this._tokenList.lookup((int)0).value);
                orgTypeNameBuffer.append(this._tokenList.lookup(0).getOrgValue());
                this._tokenList.match();
            }
            this._tokenList.match(Token.OpenBraceToken);
            ObjectCreateExpr newExpr = new ObjectCreateExpr(typeNameBuffer.toString(), orgTypeNameBuffer.toString());
            this.exprList(newExpr.paramList);
            this._tokenList.match(Token.CloseBraceToken);
            sql_expr = newExpr;
        } else if (this._tokenList.lookup((int)0).type == 8) {
            sql_expr = new SqlIntExpr(this._tokenList.lookup((int)0).value);
            this._tokenList.match();
        } else if (this._tokenList.lookup((int)0).type == 15) {
            sql_expr = new SqlLongExpr(this._tokenList.lookup((int)0).value);
            this._tokenList.match();
        } else if (this._tokenList.lookup((int)0).type == 10) {
            sql_expr = new SqlDoubleExpr(this._tokenList.lookup((int)0).value);
            this._tokenList.match();
        } else if (this._tokenList.lookup((int)0).type == 6) {
            String val = this._tokenList.lookup((int)0).value;
            sql_expr = new SqlCharExpr(val);
            this._tokenList.match();
        } else if (this._tokenList.lookup((int)0).type == 7) {
            String val = this._tokenList.lookup((int)0).value;
            sql_expr = new SqlNCharExpr(val);
            this._tokenList.match();
        } else if (this._tokenList.lookup((int)0).type == 2) {
            sql_expr = new SqlVarRefExpr(this._tokenList.lookup((int)0).value);
            this._tokenList.match();
        } else if (this._tokenList.lookup(0).equals(Token.CaseToken)) {
            SqlCaseExpr caseExpr = new SqlCaseExpr();
            caseExpr.setExprWord(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
            if (!this._tokenList.lookup(0).equals(Token.WhenToken)) {
                caseExpr.valueExpr = this.expr();
            }
            String whenWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(Token.WhenToken);
            SqlExpr testExpr = this.expr();
            String thenWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(Token.ThenToken);
            SqlExpr valueExpr = this.expr();
            SqlCaseItem caseItem = new SqlCaseItem(testExpr, valueExpr);
            caseItem.setWhenWord(whenWord);
            caseItem.setThenWord(thenWord);
            caseExpr.itemList.add(caseItem);
            while (this._tokenList.lookup(0).equals(Token.WhenToken)) {
                whenWord = this._tokenList.lookup(0).getOrgValue();
                this._tokenList.match();
                testExpr = this.expr();
                thenWord = this._tokenList.lookup(0).getOrgValue();
                this._tokenList.match(Token.ThenToken);
                valueExpr = this.expr();
                caseItem = new SqlCaseItem(testExpr, valueExpr);
                caseItem.setWhenWord(whenWord);
                caseItem.setThenWord(thenWord);
                caseExpr.itemList.add(caseItem);
            }
            if (this._tokenList.lookup(0).equals(Token.ElseToken)) {
                String elseWord = this._tokenList.lookup(0).getOrgValue();
                this._tokenList.match();
                caseExpr.elseExpr = this.expr();
                caseExpr.setElseWord(elseWord);
            }
            String endWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(Token.EndToken);
            caseExpr.setEndWord(endWord);
            sql_expr = caseExpr;
        } else if (this._tokenList.lookup(0).equals(Token.ExistsToken)) {
            String existsWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            KeyWord originalKeyword = null;
            if (this.inSubQueryKeyword != null) {
                originalKeyword = this._tokenList.lexer._keywords;
                this._tokenList.lexer._keywords = this.inSubQueryKeyword;
            }
            try {
                this._tokenList.match(Token.OpenBraceToken);
                SelectParser selectParser = new SelectParser(this._tokenList);
                SqlSelectBase subQuery = selectParser.select();
                this._tokenList.match(Token.CloseBraceToken);
                sql_expr = new SqlExistsExpr(subQuery);
                sql_expr.setExprWord(existsWord);
            }
            finally {
                if (originalKeyword != null) {
                    this._tokenList.lexer._keywords = originalKeyword;
                }
            }
        } else if (this._tokenList.lookup(0).equals(Token.NotToken)) {
            String notWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            if (this._tokenList.lookup(0).equals(Token.ExistsToken)) {
                notWord = notWord + " " + this._tokenList.lookup(0).getOrgValue();
                this._tokenList.match();
                KeyWord originalKeyword = null;
                if (this.inSubQueryKeyword != null) {
                    originalKeyword = this._tokenList.lexer._keywords;
                    this._tokenList.lexer._keywords = this.inSubQueryKeyword;
                }
                try {
                    this._tokenList.match(Token.OpenBraceToken);
                    SelectParser selectParser = new SelectParser(this._tokenList);
                    SqlSelectBase subQuery = selectParser.select();
                    this._tokenList.match(Token.CloseBraceToken);
                    sql_expr = new SqlExistsExpr(subQuery, true);
                }
                finally {
                    if (originalKeyword != null) {
                        this._tokenList.lexer._keywords = originalKeyword;
                    }
                }
            } else if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                this._tokenList.match(Token.OpenBraceToken);
                sql_expr = new SqlNotExpr(this.expr());
                this._tokenList.match(Token.CloseBraceToken);
            } else {
                throw new ParserException("not support token" + this._tokenList.lookup(0), 0, 0);
            }
            sql_expr.setExprWord(notWord);
        } else if (this._tokenList.lookup(0).equals(Token.AllToken)) {
            String allWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            this._tokenList.match(Token.OpenBraceToken);
            SelectParser selectParser = new SelectParser(this._tokenList);
            SqlSelectBase subQuery = selectParser.select();
            this._tokenList.match(Token.CloseBraceToken);
            sql_expr = new SqlAllExpr(allWord, subQuery);
        } else if (this._tokenList.lookup(0).equals(Token.LeftToken)) {
            sql_expr = new SqlIdentifierExpr("LEFT", this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
        } else if (this._tokenList.lookup(0).equals(Token.RightToken)) {
            sql_expr = new SqlIdentifierExpr("RIGHT", this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
        } else if (this._tokenList.lookup(0).equals(Token.ConvertToken)) {
            sql_expr = new SqlIdentifierExpr("CONVERT", this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
        } else if (this._tokenList.lookup(0).equals(Token.NullIfToken)) {
            sql_expr = new SqlIdentifierExpr("NULLIF", this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
        } else if (this._tokenList.lookup(0).equals(Token.AnyToken)) {
            String anyWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            this._tokenList.match(Token.OpenBraceToken);
            SelectParser selectParser = new SelectParser(this._tokenList);
            SqlSelectBase subQuery = selectParser.select();
            this._tokenList.match(Token.CloseBraceToken);
            sql_expr = new SqlAnyExpr(anyWord, subQuery);
        } else if (this._tokenList.lookup(0).equals(Token.SomeToken)) {
            String someWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            this._tokenList.match(Token.OpenBraceToken);
            SelectParser selectParser = new SelectParser(this._tokenList);
            SqlSelectBase subQuery = selectParser.select();
            this._tokenList.match(Token.CloseBraceToken);
            sql_expr = new SqlSomeExpr(someWord, subQuery);
        } else if (this._tokenList.lookup(0).equals(Token.NullToken)) {
            String nullWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            sql_expr = SqlNullExpr.instance;
            sql_expr.setExprWord(nullWord);
        } else if (this._tokenList.lookup(0).equals(Token.EmptyToken)) {
            String emptyWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            sql_expr = SqlEmptyExpr.instance;
            sql_expr.setExprWord(emptyWord);
        } else {
            if (this._tokenList.lookup(0).equals(Token.OpenCurlyBraceToken) || (this._tokenList.lookup(0).equals(Token.DateToken) || this._tokenList.lookup(0).equals(Token.TimeToken) || this._tokenList.lookup(0).equals(Token.TimeStampToken)) && this._tokenList.lookup((int)1).type == 6) {
                return this.parseDatetimeExpr();
            }
            if (this._tokenList.lookup(0).equals(Token.SelectToken)) {
                SelectParser selectParser = new SelectParser(this._tokenList);
                SqlSelectBase select = selectParser.select();
                QueryExpr queryExpr = new QueryExpr(select);
                sql_expr = queryExpr;
            } else if (this._tokenList.lookup(0).equals(Token.PriorToken)) {
                this._tokenList.match();
                String ident = this._tokenList.lookup((int)0).value;
                sql_expr = new SqlPriorIdentifierExpr(ident);
                this._tokenList.match(1);
            } else if (this._tokenList.lookup(0).equals(Token.UserToken) || this._tokenList.lookup(0).equals(Token.IndexToken)) {
                sql_expr = new SqlIdentifierExpr("\"" + this._tokenList.lookup((int)0).value + "\"", this._tokenList.lookup(0).getOrgValue());
                this._tokenList.match();
            } else if (this._tokenList.lookup(0).equals(Token.DateToken) || this._tokenList.lookup(0).equals(Token.TimeToken) || this._tokenList.lookup(0).equals(Token.TimeStampToken) || this._tokenList.lookup(0).equals(Token.GroupToken)) {
                sql_expr = new SqlIdentifierExpr("\"" + this._tokenList.lookup((int)0).value + "\"", this._tokenList.lookup(0).getOrgValue());
                this._tokenList.match();
            } else {
                throw new ParserException("ERROR. Token's value : " + this._tokenList.lookup((int)0).value + ", token's type : " + this._tokenList.lookup(0).typename() + ", line " + this._tokenList.lookup((int)0).beginLine + ", column " + this._tokenList.lookup((int)0).beginColumn);
            }
        }
        sql_expr = this.primaryRest(sql_expr);
        return sql_expr;
    }

    private final SqlDateTimeExpr parseSql99DateExpr() throws ParserException {
        this._tokenList.match(Token.DateToken);
        SqlDateTimeExpr expr = new SqlDateTimeExpr();
        String dateChar = this._tokenList.lookup((int)0).value;
        this._tokenList.match(6);
        Lexer lexer = new Lexer(dateChar);
        TokenList charTokList = new TokenList(lexer);
        String yearStr = charTokList.lookup((int)0).value;
        charTokList.match(8);
        int year = Integer.parseInt(yearStr);
        expr.setYear(year);
        charTokList.match(Token.MinusToken);
        String monthStr = charTokList.lookup((int)0).value;
        charTokList.match(8);
        int month = Integer.parseInt(monthStr);
        expr.setMonth(month);
        charTokList.match(Token.MinusToken);
        String dateStr = charTokList.lookup((int)0).value;
        charTokList.match(8);
        int date = Integer.parseInt(dateStr);
        expr.setDate(date);
        return expr;
    }

    private final SqlDateTimeExpr parseSql99TimeStampExpr() throws ParserException {
        this._tokenList.match(Token.TimeStampToken);
        SqlDateTimeExpr expr = new SqlDateTimeExpr();
        String dateChar = this._tokenList.lookup((int)0).value;
        this._tokenList.match(6);
        Lexer lexer = new Lexer(dateChar);
        TokenList charTokList = new TokenList(lexer);
        String yearStr = charTokList.lookup((int)0).value;
        charTokList.match(8);
        int year = Integer.parseInt(yearStr);
        expr.setYear(year);
        charTokList.match(Token.MinusToken);
        String monthStr = charTokList.lookup((int)0).value;
        charTokList.match(8);
        int month = Integer.parseInt(monthStr);
        expr.setMonth(month);
        charTokList.match(Token.MinusToken);
        String dateStr = charTokList.lookup((int)0).value;
        charTokList.match(8);
        int date = Integer.parseInt(dateStr);
        expr.setDate(date);
        if (charTokList.lookup(0).equals(Token.EOFToken)) {
            charTokList.match();
        } else {
            String hourStr = charTokList.lookup((int)0).value;
            charTokList.match(8);
            int hour = Integer.parseInt(hourStr);
            expr.setHour(hour);
            charTokList.match(Token.ColonToken);
            String minuteStr = charTokList.lookup((int)0).value;
            charTokList.match(8);
            int minute = Integer.parseInt(minuteStr);
            expr.setMinute(minute);
            charTokList.match(Token.ColonToken);
            if (charTokList.lookup((int)0).type == 8) {
                String secondStr = charTokList.lookup((int)0).value;
                charTokList.match();
                int second = Integer.parseInt(secondStr);
                expr.setSecond(second);
            } else if (charTokList.lookup((int)0).type == 10) {
                String doubleStr = charTokList.lookup((int)0).value;
                String secondStr = doubleStr.substring(0, doubleStr.indexOf(46));
                charTokList.match();
                int second = Integer.parseInt(secondStr);
                expr.setSecond(second);
                String milliSecondStr = doubleStr.substring(doubleStr.indexOf(46) + 1);
                int milliSecond = Integer.parseInt(milliSecondStr);
                expr.setMillisecond(milliSecond);
            } else {
                throw new ParserException("Error DateTime Formate.");
            }
        }
        return expr;
    }

    private final SqlDateTimeExpr parseDatetimeExpr() throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.DateToken)) {
            return this.parseSql99DateExpr();
        }
        if (this._tokenList.lookup(0).equals(Token.TimeStampToken)) {
            return this.parseSql99TimeStampExpr();
        }
        this._tokenList.match(Token.OpenCurlyBraceToken);
        SqlDateTimeExpr expr = new SqlDateTimeExpr();
        if (this._tokenList.lookup((int)0).type == 8) {
            expr.setDataTimeWord("");
            String yearStr = this._tokenList.lookup((int)0).value;
            this._tokenList.match(8);
            int year = Integer.parseInt(yearStr);
            expr.setYear(year);
            this._tokenList.match(Token.MinusToken);
            String monthStr = this._tokenList.lookup((int)0).value;
            this._tokenList.match(8);
            int month = Integer.parseInt(monthStr);
            expr.setMonth(month);
            this._tokenList.match(Token.MinusToken);
            String dateStr = this._tokenList.lookup((int)0).value;
            this._tokenList.match(8);
            int date = Integer.parseInt(dateStr);
            expr.setDate(date);
            if (this._tokenList.lookup(0).equals(Token.CloseCurlyBraceToken)) {
                this._tokenList.match(Token.CloseCurlyBraceToken);
            } else {
                String hourStr = this._tokenList.lookup((int)0).value;
                this._tokenList.match(8);
                int hour = Integer.parseInt(hourStr);
                expr.setHour(hour);
                this._tokenList.match(Token.ColonToken);
                String minuteStr = this._tokenList.lookup((int)0).value;
                this._tokenList.match(8);
                int minute = Integer.parseInt(minuteStr);
                expr.setMinute(minute);
                this._tokenList.match(Token.ColonToken);
                if (this._tokenList.lookup((int)0).type == 8) {
                    String secondStr = this._tokenList.lookup((int)0).value;
                    this._tokenList.match();
                    int second = Integer.parseInt(secondStr);
                    expr.setSecond(second);
                } else if (this._tokenList.lookup((int)0).type == 10) {
                    String doubleStr = this._tokenList.lookup((int)0).value;
                    String secondStr = doubleStr.substring(0, doubleStr.indexOf(46));
                    this._tokenList.match();
                    int second = Integer.parseInt(secondStr);
                    expr.setSecond(second);
                    String milliSecondStr = doubleStr.substring(doubleStr.indexOf(46) + 1);
                    int milliSecond = Integer.parseInt(milliSecondStr);
                    expr.setMillisecond(milliSecond);
                } else {
                    throw new ParserException("Error DateTime Formate.");
                }
                this._tokenList.match(Token.CloseCurlyBraceToken);
            }
        } else if (this._tokenList.lookup((int)0).type == 1) {
            String type = this._tokenList.lookup((int)0).value;
            if (type.equalsIgnoreCase("ts")) {
                expr.setTimeType(-19000);
                expr.setDataTimeWord(type);
            } else if (type.equalsIgnoreCase("d")) {
                expr.setTimeType(-19001);
                expr.setDataTimeWord(type);
            } else if (type.equalsIgnoreCase("t")) {
                expr.setTimeType(-19002);
                expr.setDataTimeWord(type);
            } else {
                throw new ParserException("Error DateTime Formate.");
            }
            this._tokenList.match();
            String dateChar = this._tokenList.lookup((int)0).value;
            this._tokenList.match(6);
            Lexer lexer = new Lexer(dateChar);
            TokenList charTokList = new TokenList(lexer);
            if (expr.timeType() == -19000 || expr.timeType() == -19001) {
                String yearStr = charTokList.lookup((int)0).value;
                charTokList.match(8);
                int year = Integer.parseInt(yearStr);
                expr.setYear(year);
                charTokList.match(Token.MinusToken);
                String monthStr = charTokList.lookup((int)0).value;
                charTokList.match(8);
                int month = Integer.parseInt(monthStr);
                expr.setMonth(month);
                charTokList.match(Token.MinusToken);
                String dateStr = charTokList.lookup((int)0).value;
                charTokList.match(8);
                int date = Integer.parseInt(dateStr);
                expr.setDate(date);
            }
            if (charTokList.lookup(0).equals(Token.EOFToken)) {
                charTokList.match();
                if (expr.timeType() == -19000) {
                    expr.setHour(0);
                    expr.setMinute(0);
                    expr.setSecond(0);
                }
            } else if (expr.timeType() == -19000 || expr.timeType() == -19002) {
                String hourStr = charTokList.lookup((int)0).value;
                charTokList.match(8);
                int hour = Integer.parseInt(hourStr);
                expr.setHour(hour);
                charTokList.match(Token.ColonToken);
                String minuteStr = charTokList.lookup((int)0).value;
                charTokList.match(8);
                int minute = Integer.parseInt(minuteStr);
                expr.setMinute(minute);
                charTokList.match(Token.ColonToken);
                String secondStr = charTokList.lookup((int)0).value;
                charTokList.match(8);
                int second = Integer.parseInt(secondStr);
                expr.setSecond(second);
            }
            this._tokenList.match(Token.CloseCurlyBraceToken);
        } else {
            throw new ParserException("Error DateTime Formate.");
        }
        return expr;
    }

    public final SqlExpr primaryRest(SqlExpr expr) throws ParserException {
        if (expr == null) {
            throw new IllegalArgumentException("expr");
        }
        if (this._tokenList.lookup(0).equals(Token.PeriodToken)) {
            this._tokenList.match();
            if (this._tokenList.lookup(0).equals(Token.MulToken)) {
                SqlAllColumnExpr rightExp = new SqlAllColumnExpr();
                this._tokenList.match();
                expr = new SqlBinaryOpExpr(expr, 20, rightExp);
            } else if (this._tokenList.lookup(1).equals(Token.OpenBraceToken)) {
                String methodName = this._tokenList.lookup((int)0).value;
                this._tokenList.match();
                this._tokenList.match(Token.OpenBraceToken);
                SqlMethodInvokeExpr methodInvokeExpr = new SqlMethodInvokeExpr(methodName);
                if (this._tokenList.lookup(0).equals(Token.CloseBraceToken)) {
                    this._tokenList.match();
                } else {
                    this.exprList(methodInvokeExpr.parameters);
                    this._tokenList.match(Token.CloseBraceToken);
                }
                expr = methodInvokeExpr;
            } else {
                SqlIdentifierExpr rightExp = new SqlIdentifierExpr(this._tokenList.lookup((int)0).value, this._tokenList.lookup(0).getOrgValue());
                this._tokenList.match();
                expr = new SqlBinaryOpExpr(expr, 20, rightExp);
            }
            expr = this.primaryRest(expr);
            if (this._tokenList.lookup(0).equals(Token.InToken)) {
                expr = this.inRest(expr);
            }
        } else if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
            if (expr.type == 4) {
                SqlIdentifierExpr identExpr = (SqlIdentifierExpr)expr;
                String method_name = identExpr.value;
                this._tokenList.match();
                if (this._tokenList.lexer._keywords.isAggreateFunction(method_name)) {
                    SqlAggregateExpr aggregateExpr;
                    if (this._tokenList.lookup(0).equals(Token.AllToken)) {
                        aggregateExpr = new SqlAggregateExpr(method_name, 1, this._tokenList.lookup(0).getOrgValue());
                        this._tokenList.match();
                    } else if (this._tokenList.lookup(0).equals(Token.DistinctToken)) {
                        aggregateExpr = new SqlAggregateExpr(method_name, 0, this._tokenList.lookup(0).getOrgValue());
                        this._tokenList.match();
                    } else {
                        aggregateExpr = new SqlAggregateExpr(method_name, 1);
                        aggregateExpr.setOptionWord("");
                    }
                    if (!this._tokenList.lookup(0).equals(Token.CloseBraceToken)) {
                        this.exprList(aggregateExpr.paramList);
                    }
                    this._tokenList.match(Token.CloseBraceToken);
                    return aggregateExpr;
                }
                SqlMethodInvokeExpr methodInvokeExpr = new SqlMethodInvokeExpr(method_name);
                if (!this._tokenList.lookup(0).equals(Token.CloseBraceToken)) {
                    boolean flag = false;
                    do {
                        SqlExpr expr2;
                        if (flag) {
                            this._tokenList.match();
                        }
                        if ((expr2 = this.expr()) instanceof SqlMethodInvokeExpr) {
                            SqlMethodInvokeExpr sie = (SqlMethodInvokeExpr)expr2;
                            if (method_name.equalsIgnoreCase("CONVERT") && (sie.methodName.equalsIgnoreCase("VARCHAR") || sie.methodName.equalsIgnoreCase("CHAR") || sie.methodName.equalsIgnoreCase("NVARCHAR") || sie.methodName.equalsIgnoreCase("NCHAR"))) {
                                SqlConvertTypeExpr scte = new SqlConvertTypeExpr(sie.methodName);
                                scte.setLen(Integer.parseInt(sie.parameters.get(0).toString()));
                                expr2 = scte;
                            }
                        }
                        methodInvokeExpr.parameters.add(expr2);
                        flag = true;
                    } while (this._tokenList.lookup(0).equals(Token.CommaToken));
                }
                this._tokenList.match(Token.CloseBraceToken);
                expr = this.primaryRest(methodInvokeExpr);
                if (this._tokenList.lookup(0).equals(Token.InToken)) {
                    expr = this.inRest(expr);
                }
                return expr;
            }
            throw new ParserException("not support token:" + this._tokenList.lookup(0), 0, 0);
        }
        return expr;
    }

    public final SqlExpr equality() throws ParserException {
        SqlExpr expr = this.relational();
        return this.equalityRest(expr);
    }

    public final SqlExpr equalityRest(SqlExpr expr) throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.EqualToken)) {
            this._tokenList.match();
            SqlExpr rightExp = this.relational();
            rightExp = this.equalityRest(rightExp);
            expr = new SqlBinaryOpExpr(expr, 10, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.NotEqualToken)) {
            this._tokenList.match();
            SqlExpr rightExp = this.relational();
            rightExp = this.equalityRest(rightExp);
            expr = new SqlBinaryOpExpr(expr, 23, rightExp);
        }
        return expr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SqlExpr inRest(SqlExpr expr) throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.InToken)) {
            String inWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            this._tokenList.match(Token.OpenBraceToken);
            KeyWord originalKeyword = null;
            if (this.inSubQueryKeyword != null) {
                originalKeyword = this._tokenList.lexer._keywords;
                this._tokenList.lexer._keywords = this.inSubQueryKeyword;
            }
            try {
                if (this._tokenList.lookup((int)0).value.equalsIgnoreCase("SELECT")) {
                    this._tokenList.lookup((int)0).type = 3;
                    SelectParser selectParser = new SelectParser(this._tokenList);
                    SqlSelectBase select = selectParser.select();
                    SqlInSubQueryExpr inExpr = new SqlInSubQueryExpr(expr, select);
                    inExpr.setExprWord(inWord);
                    expr = inExpr;
                } else {
                    SqlInListExpr inListExpr = new SqlInListExpr(expr);
                    this.exprList(inListExpr.targetList);
                    inListExpr.setExprWord(inWord);
                    expr = inListExpr;
                }
            }
            finally {
                if (originalKeyword != null) {
                    this._tokenList.lexer._keywords = originalKeyword;
                }
            }
            this._tokenList.match(Token.CloseBraceToken);
        }
        expr = this.andRest(expr);
        return expr;
    }

    public final SqlExpr additive() throws ParserException {
        SqlExpr expr = this.multiplicative();
        return this.additiveRest(expr);
    }

    public final SqlExpr additiveRest(SqlExpr expr) throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.PlusToken)) {
            this._tokenList.match();
            SqlExpr rightExp = this.multiplicativeNoIn();
            if (!this.allowStringAdditive && (expr instanceof SqlCharExpr || expr instanceof SqlNCharExpr || rightExp instanceof SqlCharExpr || rightExp instanceof SqlNCharExpr)) {
                throw new ParserException("Error. additive operator can not use add Char Or NChar");
            }
            expr = new SqlBinaryOpExpr(expr, 0, rightExp);
            expr = this.additiveRest(expr);
        } else if (this._tokenList.lookup(0).equals(Token.ConcatOpToken)) {
            this._tokenList.match();
            SqlExpr rightExp = this.multiplicativeNoIn();
            expr = new SqlBinaryOpExpr(expr, 42, rightExp);
            expr = this.additiveRest(expr);
        } else if (this._tokenList.lookup(0).equals(Token.MinusToken)) {
            this._tokenList.match();
            SqlExpr rightExp = this.multiplicativeNoIn();
            if (expr instanceof SqlCharExpr || expr instanceof SqlNCharExpr || rightExp instanceof SqlCharExpr || rightExp instanceof SqlNCharExpr) {
                throw new ParserException("Error. minus operator can not use add Char Or NChar");
            }
            expr = new SqlBinaryOpExpr(expr, 26, rightExp);
            expr = this.additiveRest(expr);
        }
        return expr;
    }

    public final SqlExpr multiplicative() throws ParserException {
        SqlExpr expr = this.unary();
        if (this._tokenList.lookup(0).equals(Token.InToken)) {
            expr = this.inRest(expr);
        }
        return this.multiplicativeRest(expr);
    }

    public final SqlExpr multiplicativeNoIn() throws ParserException {
        SqlExpr expr = this.unary();
        return this.multiplicativeRest(expr);
    }

    public final SqlExpr multiplicativeRest(SqlExpr expr) throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.MulToken)) {
            this._tokenList.match();
            SqlExpr rightExp = this.unary();
            expr = new SqlBinaryOpExpr(expr, 22, rightExp);
            expr = this.multiplicativeRest(expr);
        } else if (this._tokenList.lookup(0).equals(Token.DivToken)) {
            this._tokenList.match();
            SqlExpr rightExp = this.unary();
            expr = new SqlBinaryOpExpr(expr, 9, rightExp);
            expr = this.multiplicativeRest(expr);
        } else if (this._tokenList.lookup(0).equals(Token.ModToken)) {
            this._tokenList.match();
            SqlExpr rightExp = this.unary();
            expr = new SqlBinaryOpExpr(expr, 21, rightExp);
            expr = this.multiplicativeRest(expr);
        }
        return expr;
    }

    public final SqlExpr and() throws ParserException {
        SqlExpr expr = this.equality();
        return this.andRest(expr);
    }

    public final SqlExpr andRest(SqlExpr expr) throws ParserException {
        while (this._tokenList.lookup(0).equals(Token.AndToken)) {
            String andWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            SqlExpr rightExp = this.equality();
            expr = new SqlBinaryOpExpr(expr, 7, rightExp);
            expr.setExprWord(andWord);
        }
        return expr;
    }

    public final SqlExpr or() throws ParserException {
        SqlExpr expr = this.and();
        return this.orRest(expr);
    }

    public final SqlExpr orRest(SqlExpr expr) throws ParserException {
        while (this._tokenList.lookup(0).equals(Token.OrToken)) {
            String orWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            SqlExpr rightExp = this.and();
            expr = new SqlBinaryOpExpr(expr, 8, rightExp);
            expr.setExprWord(orWord);
        }
        return expr;
    }

    public final SqlExpr relational() throws ParserException {
        SqlExpr expr = this.additive();
        return this.relationalRest(expr);
    }

    public final SqlExpr relationalRest(SqlExpr expr) throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.LessThanToken)) {
            this._tokenList.match();
            SqlExpr rightExp = this.additive();
            rightExp = this.relationalRest(rightExp);
            expr = new SqlBinaryOpExpr(expr, 14, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.LessThanOrEqualToken)) {
            this._tokenList.match();
            SqlExpr rightExp = this.additive();
            rightExp = this.relationalRest(rightExp);
            expr = new SqlBinaryOpExpr(expr, 15, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.GreaterThanToken)) {
            this._tokenList.match();
            SqlExpr rightExp = this.additive();
            rightExp = this.relationalRest(rightExp);
            expr = new SqlBinaryOpExpr(expr, 11, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.GreaterThanOrEqualToken)) {
            this._tokenList.match();
            SqlExpr rightExp = this.additive();
            rightExp = this.relationalRest(rightExp);
            expr = new SqlBinaryOpExpr(expr, 12, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.NotLessThanToken)) {
            this._tokenList.match();
            SqlExpr rightExp = this.additive();
            rightExp = this.relationalRest(rightExp);
            expr = new SqlBinaryOpExpr(expr, 24, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.NotGreaterThanToken)) {
            this._tokenList.match();
            SqlExpr rightExp = this.additive();
            rightExp = this.relationalRest(rightExp);
            expr = new SqlBinaryOpExpr(expr, 25, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.LessThanOrGreaterThanToken)) {
            this._tokenList.match();
            SqlExpr rightExp = this.additive();
            rightExp = this.relationalRest(rightExp);
            expr = new SqlBinaryOpExpr(expr, 16, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.LikeToken)) {
            String likeWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            SqlExpr rightExp = this.additive();
            rightExp = this.relationalRest(rightExp);
            if (expr instanceof SqlCharExpr || expr instanceof SqlNCharExpr || expr instanceof SqlVarRefExpr) {
                throw new ParserException("invaild like Expr.");
            }
            if (rightExp instanceof SqlBinaryOpExpr) {
                SqlBinaryOpExpr binOpExpr = (SqlBinaryOpExpr)rightExp;
                if (!(binOpExpr.left instanceof SqlCharExpr) && !(binOpExpr.left instanceof SqlNCharExpr) || !(binOpExpr.right instanceof SqlCharExpr) && !(binOpExpr.right instanceof SqlNCharExpr)) {
                    throw new ParserException("invaild like Expr.");
                }
            }
            expr = new SqlBinaryOpExpr(expr, 18, rightExp);
            expr.setExprWord(likeWord);
            if (this._tokenList.lookup(0).equals(Token.EscapeToken)) {
                String escapeWord = this._tokenList.lookup(0).getOrgValue();
                this._tokenList.match();
                rightExp = this.expr();
                expr = new SqlBinaryOpExpr(expr, 43, rightExp);
                expr.setExprWord(escapeWord);
            }
        } else if (this._tokenList.lookup(0).equals(Token.NotToken)) {
            String notWord = this._tokenList.lookup(0).getOrgValue();
            if (!this._tokenList.lookup(1).equals(Token.LikeToken)) {
                if (this._tokenList.lookup(1).equals(Token.InToken) || this._tokenList.lookup((int)1).value.equalsIgnoreCase(Token.InnerToken.value)) {
                    notWord = notWord + " " + this._tokenList.lookup(1).getOrgValue();
                    this._tokenList.match();
                    this._tokenList.match();
                    this._tokenList.match(Token.OpenBraceToken);
                    if (this._tokenList.lookup((int)0).value.equalsIgnoreCase(Token.SelectToken.value)) {
                        this._tokenList.lookup((int)0).type = 3;
                        KeyWord originalKeyword = null;
                        if (this.inSubQueryKeyword != null) {
                            originalKeyword = this._tokenList.lexer._keywords;
                            this._tokenList.lexer._keywords = this.inSubQueryKeyword;
                        }
                        SelectParser selectParser = new SelectParser(this._tokenList);
                        SqlSelectBase select = selectParser.select();
                        SqlInSubQueryExpr inExpr = new SqlInSubQueryExpr(expr, select, true);
                        expr = inExpr;
                        if (originalKeyword != null) {
                            this._tokenList.lexer._keywords = originalKeyword;
                        }
                    } else {
                        SqlInListExpr inListExpr = new SqlInListExpr(expr, true);
                        this.exprList(inListExpr.targetList);
                        expr = inListExpr;
                    }
                    expr.setExprWord(notWord);
                    this._tokenList.match(Token.CloseBraceToken);
                    expr = this.relationalRest(expr);
                    return expr;
                }
                if (this._tokenList.lookup(1).equals(Token.BetweenToken)) {
                    notWord = notWord + " " + this._tokenList.lookup(1).getOrgValue();
                    this._tokenList.match();
                    this._tokenList.match();
                    SqlExpr beginExpr = this.primary();
                    String andWord = this._tokenList.lookup(0).getOrgValue();
                    this._tokenList.match(Token.AndToken);
                    SqlExpr endExpr = this.primary();
                    expr = new SqlBetweenExpr(expr, beginExpr, endExpr, true);
                    expr.setExprWord(notWord);
                    ((SqlBetweenExpr)expr).setAndWord(andWord);
                    expr = this.relationalRest(expr);
                    return expr;
                }
                if (this._tokenList.lookup(1).equals(Token.NullToken)) {
                    notWord = notWord + " " + this._tokenList.lookup(1).getOrgValue();
                    expr.setExprWord(notWord);
                    return expr;
                }
                throw new ParserException("not support token:" + this._tokenList.lookup(1));
            }
            notWord = notWord + " " + this._tokenList.lookup(1).getOrgValue();
            this._tokenList.match();
            this._tokenList.match();
            int opType = 40;
            SqlExpr rightExp = this.additive();
            rightExp = this.relationalRest(rightExp);
            expr = new SqlBinaryOpExpr(expr, opType, rightExp);
            expr.setExprWord(notWord);
            if ((opType == 18 || opType == 40) && this._tokenList.lookup(0).equals(Token.EscapeToken)) {
                this._tokenList.match();
                rightExp = this.expr();
                expr = new SqlBinaryOpExpr(expr, 43, rightExp);
                expr.setExprWord(notWord);
            }
        } else if (this._tokenList.lookup(0).equals(Token.BetweenToken)) {
            String betweenWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            SqlExpr beginExpr = this.primary();
            String andWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(Token.AndToken);
            SqlExpr endExpr = this.primary();
            expr = new SqlBetweenExpr(expr, beginExpr, endExpr);
            ((SqlBetweenExpr)expr).setExprWord(betweenWord);
            ((SqlBetweenExpr)expr).setAndWord(andWord);
        } else if (this._tokenList.lookup(0).equals(Token.IsToken)) {
            int opType;
            String isWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            if (this._tokenList.lookup(0).equals(Token.NotToken)) {
                isWord = isWord + " " + this._tokenList.lookup(0).getOrgValue();
                this._tokenList.match();
                opType = 41;
            } else {
                opType = 13;
            }
            if (this._tokenList.lookup(0).equals(Token.EmptyToken)) {
                SqlEmptyExpr see = new SqlEmptyExpr();
                see.setExprWord(this._tokenList.lookup(0).getOrgValue());
                expr = new SqlBinaryOpExpr(expr, opType, see);
                expr.setExprWord(isWord);
                this._tokenList.match();
            } else {
                SqlNullExpr sne = new SqlNullExpr();
                sne.setExprWord(this._tokenList.lookup(0).getOrgValue());
                this._tokenList.match(Token.NullToken);
                expr = new SqlBinaryOpExpr(expr, opType, sne);
                expr.setExprWord(isWord);
            }
        }
        return expr;
    }

    public KeyWord getInSubQueryKeyword() {
        return this.inSubQueryKeyword;
    }

    public void setInSubQueryKeyword(KeyWord inSubQueryKeyword) {
        this.inSubQueryKeyword = inSubQueryKeyword;
    }
}

