/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.privacy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.privacy.IPrivacyService;
import com.kingdee.bos.privacy.PrivacyData;
import com.kingdee.bos.privacy.PrivacyPropertyInfo;
import com.kingdee.bos.privacy.PrivacyPropertyManager;
import com.kingdee.bos.sql.dom.AbstractUpdateItem;
import com.kingdee.bos.sql.dom.SqlInsert;
import com.kingdee.bos.sql.dom.SqlJoinedTableSource;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlSubQueryTableSource;
import com.kingdee.bos.sql.dom.SqlTableSource;
import com.kingdee.bos.sql.dom.SqlTableSourceBase;
import com.kingdee.bos.sql.dom.SqlUnionSelect;
import com.kingdee.bos.sql.dom.SqlUpdateItem;
import com.kingdee.bos.sql.dom.expr.SqlAggregateExpr;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlDateTimeExpr;
import com.kingdee.bos.sql.dom.expr.SqlDoubleExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlInListExpr;
import com.kingdee.bos.sql.dom.expr.SqlInSubQueryExpr;
import com.kingdee.bos.sql.dom.expr.SqlIntExpr;
import com.kingdee.bos.sql.dom.expr.SqlLongExpr;
import com.kingdee.bos.sql.dom.expr.SqlMethodInvokeExpr;
import com.kingdee.bos.sql.dom.expr.SqlNullExpr;
import com.kingdee.bos.sql.dom.expr.SqlPriorIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlVarRefExpr;
import com.kingdee.bos.sql.dom.stmt.SqlDeleteStmt;
import com.kingdee.bos.sql.dom.stmt.SqlInsertStmt;
import com.kingdee.bos.sql.dom.stmt.SqlSelectStmt;
import com.kingdee.bos.sql.dom.stmt.SqlStmt;
import com.kingdee.bos.sql.dom.stmt.SqlUpdateStmt;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.formater.SQLFormater;
import com.kingdee.bos.sql.shell.KDStatement;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ParamData {
    private int paramIndex = 0;
    private int numOfNormalParam = 0;
    private int numOfSelectColumn = 0;
    private String type = null;
    private String mainTable;
    private boolean isUnionQuery = false;
    private boolean isSubQueryAll = false;
    private boolean isAggregateCount = false;
    private boolean support = false;
    private ParamData subParamData;
    private Map<String, String> tableAliasMap = new HashMap<String, String>(0);
    final Map<Integer, PrivacyPropertyInfo> privateIndexMap = new LinkedHashMap<Integer, PrivacyPropertyInfo>(0);
    final Map<Integer, PrivacyPropertyInfo> conditionIndexMap = new HashMap<Integer, PrivacyPropertyInfo>(0);
    final Map<Integer, PrivacyPropertyInfo> resultPrivateIndexMap = new LinkedHashMap<Integer, PrivacyPropertyInfo>(0);
    final Map<String, PrivacyPropertyInfo> resultPrivateIndexMap2 = new LinkedHashMap<String, PrivacyPropertyInfo>(0);
    final Context ctx;
    private int privacyFieldAliasIndex;

    public ParamData(Context ctx) {
        this.ctx = ctx;
    }

    public String getType() {
        return this.type;
    }

    public int getNumOfSelectColumn() {
        if (this.numOfSelectColumn == 0) {
            throw new RuntimeException("check code,buddy");
        }
        return this.numOfSelectColumn;
    }

    public int getColumnCount() {
        if (this.isSupport() && "select".equals(this.type) && this.resultPrivateIndexMap.size() > 0) {
            return this.numOfSelectColumn;
        }
        return -1;
    }

    public int getRealPrivacyIndex(int privacyIndex) {
        if ("insert".equals(this.type) || "update".equals(this.type)) {
            int padding = 0;
            for (Integer index : this.privateIndexMap.keySet()) {
                ++padding;
                if (privacyIndex == index) break;
                if (!"update".equals(this.type)) continue;
                ++padding;
            }
            return this.privateIndexMap.size() + this.numOfNormalParam + padding;
        }
        throw new RuntimeException("check code,buddy");
    }

    public boolean isConditionIndex(int index) {
        return index > this.numOfNormalParam + this.privateIndexMap.size();
    }

    public int adujstConditionIndex(int index) {
        if ("update".equals(this.type)) {
            return index + this.privateIndexMap.size() * 2;
        }
        return index + this.privateIndexMap.size();
    }

    public boolean numOfParamChanged() {
        if (this.isSupport()) {
            return this.privateIndexMap.size() > 0;
        }
        return false;
    }

    public void addTableAlias(SQLFormater sqlFormater, SqlStmt stmt) throws FormaterException {
        try {
            if (this.ctx == null || !PrivacyPropertyManager.isEnable() || sqlFormater instanceof DrSQLFormater) {
                return;
            }
            if (stmt instanceof SqlSelectStmt) {
                SqlSelectStmt sqlSelectStmt = (SqlSelectStmt)stmt;
                SqlSelectBase select = sqlSelectStmt.select;
                if (select instanceof SqlSelect) {
                    SqlSelectItem item;
                    List selectList = ((SqlSelect)select).selectList;
                    this.numOfSelectColumn = selectList.size();
                    if (this.numOfSelectColumn == 1 && (item = (SqlSelectItem)selectList.get(0)).toString().endsWith("*")) {
                        this.isSubQueryAll = true;
                    }
                    this.mainTable = ParamData.addTableAlias(this, ((SqlSelect)select).tableSource);
                } else if (select instanceof SqlUnionSelect) {
                    SqlSelectBase right;
                    this.isUnionQuery = true;
                    SqlUnionSelect sqlUnionSelect = (SqlUnionSelect)select;
                    SqlSelectBase left = sqlUnionSelect.left;
                    if (left instanceof SqlSelect) {
                        this.numOfSelectColumn = ((SqlSelect)left).selectList.size();
                        this.mainTable = ParamData.addTableAlias(this, ((SqlSelect)left).tableSource);
                    }
                    if ((right = sqlUnionSelect.right) instanceof SqlSelect) {
                        this.mainTable = ParamData.addTableAlias(this, ((SqlSelect)right).tableSource);
                    }
                }
                this.type = "select";
                if (this.mainTable != null || !this.tableAliasMap.isEmpty()) {
                    this.support = true;
                }
            } else if (stmt instanceof SqlDeleteStmt) {
                SqlDeleteStmt sqlDeleteStmt = (SqlDeleteStmt)stmt;
                this.mainTable = ParamData.addTableAlias(this, sqlDeleteStmt.delete.tableSource);
                this.type = "delete";
                if (this.mainTable != null || !this.tableAliasMap.isEmpty()) {
                    this.support = true;
                }
            } else if (stmt instanceof SqlInsertStmt) {
                SqlInsertStmt sqlInsertStmt = (SqlInsertStmt)stmt;
                String tableName = sqlInsertStmt.insert.tableName;
                this.type = "insert";
                if (PrivacyPropertyManager.isPrivacyTable(this.ctx, tableName)) {
                    this.mainTable = tableName.toLowerCase(Locale.ENGLISH);
                    this.support = true;
                    this.checkSelectInsert((SqlInsertStmt)stmt);
                }
            } else if (stmt instanceof SqlUpdateStmt) {
                SqlUpdateStmt sqlUpdateStmt = (SqlUpdateStmt)stmt;
                String tableName = sqlUpdateStmt.update.updateTable.name;
                this.type = "update";
                if (PrivacyPropertyManager.isPrivacyTable(this.ctx, tableName)) {
                    this.mainTable = tableName.toLowerCase(Locale.ENGLISH);
                    this.support = true;
                }
            }
        }
        catch (Exception e) {
            throw new FormaterException(e.getMessage(), e);
        }
    }

    private static String addTableAlias(ParamData paramData, SqlTableSourceBase tableSource) throws BOSException {
        if (tableSource instanceof SqlTableSource) {
            SqlTableSource sqlTableSource = (SqlTableSource)tableSource;
            String tableName = sqlTableSource.name.toLowerCase(Locale.ENGLISH);
            if (PrivacyPropertyManager.isPrivacyTable(paramData.ctx, tableName = ParamData.getRealName(tableName))) {
                if (!StringUtils.isEmpty((String)sqlTableSource.alias)) {
                    paramData.tableAliasMap.put(sqlTableSource.alias.toLowerCase(Locale.ENGLISH), tableName);
                }
                return tableName;
            }
        } else if (tableSource instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource sqlJoinedTableSource = (SqlJoinedTableSource)tableSource;
            ParamData.addTableAlias(paramData, sqlJoinedTableSource.left);
            ParamData.addTableAlias(paramData, sqlJoinedTableSource.right);
        } else if (tableSource instanceof SqlSubQueryTableSource) {
            SqlSubQueryTableSource subQueryTableSource = (SqlSubQueryTableSource)tableSource;
            SqlSelectBase sqlSelectBase = subQueryTableSource.subQuery;
            if (sqlSelectBase instanceof SqlSelect) {
                if (paramData.isSubQueryAll) {
                    paramData.numOfSelectColumn = ((SqlSelect)sqlSelectBase).selectList.size();
                    paramData.isSubQueryAll = false;
                }
                return ParamData.addTableAlias(paramData, ((SqlSelect)sqlSelectBase).tableSource);
            }
        }
        return null;
    }

    private void checkSelectInsert(SqlInsertStmt stmt) throws BOSException {
        if (this.isSupport()) {
            SqlInsert insert = stmt.insert;
            SqlSelectBase subQuery = insert.subQuery;
            if (subQuery instanceof SqlSelect) {
                SqlSelect subSelect = (SqlSelect)subQuery;
                if (subSelect.tableSource instanceof SqlTableSource) {
                    SqlTableSource subTableSource = (SqlTableSource)subSelect.tableSource;
                    String subTable = subTableSource.name;
                    if (this.mainTable.equalsIgnoreCase(subTable)) {
                        ParamData.addTableAlias(this, subTableSource);
                        return;
                    }
                }
            }
            if (insert.valueList == null || insert.valueList.isEmpty()) {
                for (int i = 0; i < insert.columnList.size(); ++i) {
                    Object colItem = insert.columnList.get(i);
                    if (!(colItem instanceof SqlIdentifierExpr)) continue;
                    SqlIdentifierExpr identExpr = (SqlIdentifierExpr)colItem;
                    String sqlField = identExpr.value.toLowerCase(Locale.ENGLISH);
                    PrivacyPropertyInfo privacyPropertyInfo = PrivacyPropertyManager.getPrivacyPropBySqlField(this.ctx, this.mainTable, sqlField = ParamData.getRealName(sqlField));
                    if (privacyPropertyInfo == null) continue;
                    throw new BOSException("Privacy Field[" + sqlField + "] is not support insert select ");
                }
            }
        }
    }

    private static String getRealName(String name) {
        if (name != null && name.indexOf(34) == 0 && name.endsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        return name;
    }

    public void changeSelectColumn(SqlSelect select, SqlSelectItem selectItem) throws FormaterException {
        try {
            ParamData curSubParamData = this.getCurSubParamData();
            if (curSubParamData != null) {
                String matchTable = this.getCurTable();
                SqlExpr privacyExpr = null;
                if (this.isPropExpr(selectItem.expr)) {
                    privacyExpr = (SqlIdentifierExpr)((SqlBinaryOpExpr)selectItem.expr).right;
                    String alias = ((SqlBinaryOpExpr)selectItem.expr).left.toString().toLowerCase(Locale.ENGLISH);
                    String table = this.getCurTableByAlias(alias);
                    if (table != null) {
                        matchTable = table;
                    }
                } else {
                    privacyExpr = selectItem.expr;
                }
                if (matchTable != null && privacyExpr instanceof SqlIdentifierExpr) {
                    String sqlField = privacyExpr.getOrgValue().toLowerCase(Locale.ENGLISH);
                    if (PrivacyPropertyManager.isPrivacyField(this.ctx, matchTable, sqlField = ParamData.getRealName(sqlField))) {
                        ((SqlIdentifierExpr)privacyExpr).value = ParamData.getHashFieldSQLName(((SqlIdentifierExpr)privacyExpr).value);
                    }
                }
            } else if (this.isSupport()) {
                SqlExpr rightExpr;
                List list;
                SqlExpr temp = null;
                boolean warpByMethod = false;
                String method = null;
                if (selectItem.expr instanceof SqlMethodInvokeExpr) {
                    SqlMethodInvokeExpr methodInvokeExpr = (SqlMethodInvokeExpr)selectItem.expr;
                    list = methodInvokeExpr.parameters;
                    if (list != null && list.size() > 0) {
                        temp = (SqlExpr)list.get(0);
                    }
                    warpByMethod = true;
                    method = ((SqlMethodInvokeExpr)selectItem.expr).methodName;
                } else if (selectItem.expr instanceof SqlAggregateExpr) {
                    SqlAggregateExpr sqlAggregateExpr = (SqlAggregateExpr)selectItem.expr;
                    method = sqlAggregateExpr.methodName;
                    if ("count".equalsIgnoreCase(method)) {
                        if (select.groupBy == null || select.groupBy.isEmpty()) {
                            this.isAggregateCount = true;
                        }
                    } else {
                        list = sqlAggregateExpr.paramList;
                        if (list != null && list.size() > 0) {
                            temp = (SqlExpr)list.get(0);
                        }
                        warpByMethod = true;
                    }
                } else {
                    temp = selectItem.expr;
                }
                String matchTable = this.getCurTable();
                if (this.isPropExpr(temp)) {
                    SqlBinaryOpExpr binaryExpr = (SqlBinaryOpExpr)temp;
                    String alias = binaryExpr.left.toString().toLowerCase(Locale.ENGLISH);
                    String table = this.getCurTableByAlias(alias);
                    if (table != null) {
                        matchTable = table;
                    }
                    rightExpr = binaryExpr.right;
                } else {
                    rightExpr = temp;
                }
                if (rightExpr != null && matchTable != null) {
                    String sqlField = rightExpr.getOrgValue().toLowerCase(Locale.ENGLISH);
                    sqlField = ParamData.getRealName(sqlField);
                    PrivacyPropertyInfo privacyPropertyInfo = PrivacyPropertyManager.getPrivacyPropBySqlField(this.ctx, matchTable, sqlField);
                    if (!this.isAggregateCount && privacyPropertyInfo != null && rightExpr instanceof SqlIdentifierExpr) {
                        if (this.isUnionQuery) {
                            throw new BOSException("Privacy Field[" + sqlField + "] is not support in union query");
                        }
                        if (warpByMethod) {
                            throw new BOSException("Privacy Field[" + sqlField + "] is not support method[" + method + "]");
                        }
                        String columnName = ((SqlIdentifierExpr)rightExpr).value;
                        if ("insert".equals(this.type)) {
                            SqlSelectItem privacyItem = selectItem;
                            SqlIdentifierExpr privacyExpr = this.isPropExpr(privacyItem.expr) ? (SqlIdentifierExpr)((SqlBinaryOpExpr)privacyItem.expr).right : (SqlIdentifierExpr)privacyItem.expr;
                            privacyExpr.value = ParamData.getPrivacyFieldSQLName(columnName);
                            privacyExpr.setOrgValue(privacyExpr.value);
                            SqlSelectItem hashItem = (SqlSelectItem)selectItem.clone();
                            SqlIdentifierExpr hashExpr = this.isPropExpr(hashItem.expr) ? (SqlIdentifierExpr)((SqlBinaryOpExpr)hashItem.expr).right : (SqlIdentifierExpr)hashItem.expr;
                            hashExpr.value = ParamData.getHashFieldSQLName(columnName);
                            hashExpr.setOrgValue(hashExpr.value);
                            select.selectList.add(hashItem);
                        } else {
                            if (StringUtils.isEmpty((String)selectItem.alias)) {
                                selectItem.alias = rightExpr.getOrgValue();
                            }
                            int index = ParamData.getColumnIndex(select, selectItem);
                            this.resultPrivateIndexMap.put(index + 1, privacyPropertyInfo);
                            this.resultPrivateIndexMap2.put(selectItem.alias, privacyPropertyInfo);
                            SqlSelectItem privacyItem = (SqlSelectItem)selectItem.clone();
                            SqlIdentifierExpr privacyExpr = this.isPropExpr(privacyItem.expr) ? (SqlIdentifierExpr)((SqlBinaryOpExpr)privacyItem.expr).right : (SqlIdentifierExpr)privacyItem.expr;
                            privacyExpr.value = ParamData.getPrivacyFieldSQLName(columnName);
                            privacyExpr.setOrgValue(privacyExpr.value);
                            privacyItem.alias = this.createPrivacyFieldSelectAlias();
                            select.selectList.add(privacyItem);
                            if (select.distinct == 1 && !privacyPropertyInfo.isSimple() && this.isPropExpr(privacyItem.expr)) {
                                SqlMethodInvokeExpr methodInvokeExpr = new SqlMethodInvokeExpr("TO_CHAR");
                                methodInvokeExpr.parameters.add(privacyItem.expr);
                                selectItem.expr = methodInvokeExpr;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new FormaterException(e.getMessage(), e);
        }
    }

    private String createPrivacyFieldSelectAlias() {
        return "privacy_p" + ++this.privacyFieldAliasIndex;
    }

    public void changeInsertColumn(SqlInsertStmt stmt, Object insertItem) throws FormaterException {
        try {
            if (this.isSupport() && insertItem instanceof SqlIdentifierExpr) {
                PrivacyPropertyInfo privacyPropertyInfo;
                SqlIdentifierExpr item = (SqlIdentifierExpr)insertItem;
                String sqlField = item.value.toLowerCase(Locale.ENGLISH);
                sqlField = ParamData.getRealName(sqlField);
                int index = ParamData.getColumnIndex(stmt, item);
                List columns = stmt.insert.columnList;
                List values = stmt.insert.valueList;
                SqlExpr valueExpr = null;
                if (!values.isEmpty()) {
                    valueExpr = (SqlExpr)values.get(index);
                }
                if ((privacyPropertyInfo = PrivacyPropertyManager.getPrivacyPropBySqlField(this.ctx, this.mainTable, sqlField)) != null) {
                    SqlIdentifierExpr hashCode = new SqlIdentifierExpr(ParamData.getHashFieldSQLName(item.value));
                    if (valueExpr != null) {
                        SqlExpr hashValue;
                        if (valueExpr instanceof SqlVarRefExpr && "?".equals(((SqlVarRefExpr)valueExpr).text)) {
                            this.privateIndexMap.put(++this.paramIndex, privacyPropertyInfo);
                            hashValue = new SqlVarRefExpr("?");
                        } else {
                            IPrivacyService privacyService = PrivacyPropertyManager.getPrivacyService(this.ctx);
                            PrivacyData privacyData = new PrivacyData(privacyPropertyInfo);
                            privacyData.setOriginalValue(ParamData.getValueForUpdateOrInsert(sqlField, valueExpr));
                            privacyService.encrypt(this.ctx, privacyData);
                            values.set(index, ParamData.toSqlExpr(privacyData.getCipherText()));
                            hashValue = ParamData.toSqlExpr(privacyData.getHashCode());
                        }
                        values.add(hashValue);
                    }
                    columns.add(hashCode);
                    item.value = ParamData.getPrivacyFieldSQLName(item.value);
                } else if (valueExpr instanceof SqlVarRefExpr && "?".equals(((SqlVarRefExpr)valueExpr).text)) {
                    String srcSqlField;
                    if ((sqlField.endsWith("_p") || sqlField.endsWith("_h")) && PrivacyPropertyManager.isPrivacyField(this.ctx, this.mainTable, srcSqlField = sqlField.substring(0, sqlField.length() - 2))) {
                        return;
                    }
                    ++this.numOfNormalParam;
                    ++this.paramIndex;
                }
            }
        }
        catch (Exception e) {
            throw new FormaterException(e.getMessage(), e);
        }
    }

    public void changeUpdateColumn(SqlUpdateStmt updateStmt, AbstractUpdateItem updateItem) throws FormaterException {
        try {
            if (this.isSupport() && updateItem instanceof SqlUpdateItem) {
                SqlUpdateItem item = (SqlUpdateItem)updateItem;
                String sqlField = item.name.toLowerCase(Locale.ENGLISH);
                sqlField = ParamData.getRealName(sqlField);
                SqlExpr valueExpr = item.expr;
                List columns = updateStmt.update.updateList;
                PrivacyPropertyInfo privacyPropertyInfo = PrivacyPropertyManager.getPrivacyPropBySqlField(this.ctx, this.mainTable, sqlField);
                if (privacyPropertyInfo != null) {
                    SqlUpdateItem hashCode;
                    SqlUpdateItem privacyField;
                    if (valueExpr instanceof SqlVarRefExpr && "?".equals(((SqlVarRefExpr)valueExpr).text)) {
                        this.privateIndexMap.put(++this.paramIndex, privacyPropertyInfo);
                        privacyField = new SqlUpdateItem(ParamData.getPrivacyFieldSQLName(item.name), new SqlVarRefExpr("?"));
                        hashCode = new SqlUpdateItem(ParamData.getHashFieldSQLName(item.name), new SqlVarRefExpr("?"));
                    } else {
                        IPrivacyService privacyService = PrivacyPropertyManager.getPrivacyService(this.ctx);
                        PrivacyData privacyData = new PrivacyData(privacyPropertyInfo);
                        Object orgValue = ParamData.getValueForUpdateOrInsert(sqlField, valueExpr);
                        privacyData.setOriginalValue(orgValue);
                        privacyService.encrypt(this.ctx, privacyData);
                        item.expr = ParamData.toSqlExpr(privacyPropertyInfo.isString() ? "" : null);
                        privacyField = new SqlUpdateItem(ParamData.getPrivacyFieldSQLName(item.name), ParamData.toSqlExpr(privacyData.getCipherText()));
                        hashCode = new SqlUpdateItem(ParamData.getHashFieldSQLName(item.name), ParamData.toSqlExpr(privacyData.getHashCode()));
                    }
                    columns.add(privacyField);
                    columns.add(hashCode);
                } else if (valueExpr instanceof SqlVarRefExpr && "?".equals(((SqlVarRefExpr)valueExpr).text)) {
                    String srcSqlField;
                    if ((sqlField.endsWith("_p") || sqlField.endsWith("_h")) && PrivacyPropertyManager.isPrivacyField(this.ctx, this.mainTable, srcSqlField = sqlField.substring(0, sqlField.length() - 2))) {
                        return;
                    }
                    ++this.numOfNormalParam;
                    ++this.paramIndex;
                }
            }
        }
        catch (Exception e) {
            throw new FormaterException(e.getMessage(), e);
        }
    }

    public void changeGroupBy(SqlSelect select, SqlExpr groupByItem) throws FormaterException {
        try {
            if ("select".equals(this.type) && this.isSupport()) {
                SqlExpr columnExpr = null;
                String matchTable = this.mainTable;
                if (groupByItem instanceof SqlBinaryOpExpr) {
                    String alias;
                    String table;
                    SqlExpr left = ((SqlBinaryOpExpr)groupByItem).left;
                    if (left instanceof SqlIdentifierExpr && (table = this.tableAliasMap.get(alias = ((SqlIdentifierExpr)left).getOrgValue().toLowerCase(Locale.ENGLISH))) != null) {
                        matchTable = table;
                    }
                    columnExpr = ((SqlBinaryOpExpr)groupByItem).right;
                } else if (groupByItem instanceof SqlIdentifierExpr) {
                    columnExpr = groupByItem;
                }
                if (matchTable != null && columnExpr != null) {
                    String sqlField = columnExpr.getOrgValue().toLowerCase(Locale.ENGLISH);
                    PrivacyPropertyInfo privacyPropertyInfo = PrivacyPropertyManager.getPrivacyPropBySqlField(this.ctx, matchTable, sqlField = ParamData.getRealName(sqlField));
                    if (privacyPropertyInfo != null) {
                        String columnName = ((SqlIdentifierExpr)columnExpr).value;
                        int index = ParamData.getColumnIndex(select, groupByItem);
                        SqlExpr privacyField = (SqlExpr)groupByItem.clone();
                        SqlIdentifierExpr privacyExpr = this.isPropExpr(privacyField) ? (SqlIdentifierExpr)((SqlBinaryOpExpr)privacyField).right : (SqlIdentifierExpr)privacyField;
                        privacyExpr.value = ParamData.getPrivacyFieldSQLName(columnName);
                        privacyExpr.setOrgValue(privacyExpr.value);
                        select.groupBy.add(index + 1, privacyField);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new FormaterException(e.getMessage(), e);
        }
    }

    private static Object getValueForUpdateOrInsert(String sqlField, SqlExpr valueExpr) throws BOSException {
        Object ret = null;
        if (valueExpr instanceof SqlNullExpr) {
            ret = null;
        } else if (valueExpr instanceof SqlIntExpr) {
            ret = ((SqlIntExpr)valueExpr).value;
        } else if (valueExpr instanceof SqlLongExpr) {
            ret = ((SqlLongExpr)valueExpr).value;
        } else if (valueExpr instanceof SqlDoubleExpr) {
            ret = ((SqlDoubleExpr)valueExpr).value;
        } else if (valueExpr instanceof SqlCharExpr) {
            ret = ((SqlCharExpr)valueExpr).text;
        } else if (valueExpr instanceof SqlDateTimeExpr) {
            ret = ((SqlDateTimeExpr)valueExpr).getJavaDate();
        } else {
            throw new BOSException("Privacy Field[" + sqlField + "] value is not support type[" + valueExpr.getClass() + "]");
        }
        return ret;
    }

    public void changeCondition(SqlExpr condition) throws FormaterException {
        try {
            if (condition != null && ("select".equals(this.type) || "delete".equals(this.type) || "update".equals(this.type))) {
                if (condition instanceof SqlBinaryOpExpr) {
                    this.formatBinaryOpExpr((SqlBinaryOpExpr)condition);
                } else if (condition.type == 14) {
                    this.formatInListExpr((SqlInListExpr)condition);
                } else if (condition.type == 13) {
                    SqlInSubQueryExpr subQueryExpr = (SqlInSubQueryExpr)condition;
                    this.formatSQLInSubQueryLeft(subQueryExpr.expr);
                    SqlSelectBase sqlSelectBase = subQueryExpr.subQuery;
                    if (sqlSelectBase instanceof SqlSelect) {
                        SqlSelect sqlSelect = (SqlSelect)sqlSelectBase;
                        ParamData curParamData = this.newSubParamData();
                        curParamData.mainTable = ParamData.addTableAlias(curParamData, sqlSelect.tableSource);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new FormaterException(e.getMessage(), e);
        }
    }

    private void formatSQLInSubQueryLeft(SqlExpr expr) throws BOSException {
        SqlExpr columnExpr = null;
        String matchTable = this.getCurTable();
        if (expr instanceof SqlBinaryOpExpr) {
            String alias;
            String table;
            SqlExpr left = ((SqlBinaryOpExpr)expr).left;
            if (left instanceof SqlIdentifierExpr && (table = this.getCurTableByAlias(alias = ((SqlIdentifierExpr)left).getOrgValue().toLowerCase(Locale.ENGLISH))) != null) {
                matchTable = table;
            }
            columnExpr = ((SqlBinaryOpExpr)expr).right;
        } else if (expr instanceof SqlIdentifierExpr) {
            columnExpr = expr;
        }
        if (columnExpr != null && matchTable != null) {
            String sqlField = columnExpr.getOrgValue().toLowerCase(Locale.ENGLISH);
            sqlField = ParamData.getRealName(sqlField);
            if (columnExpr instanceof SqlIdentifierExpr && PrivacyPropertyManager.isPrivacyField(this.ctx, matchTable, sqlField)) {
                ((SqlIdentifierExpr)columnExpr).value = ParamData.getHashFieldSQLName(((SqlIdentifierExpr)columnExpr).value);
            }
        }
    }

    private void formatBinaryOpExpr(SqlBinaryOpExpr expr) throws FormaterException, BOSException {
        SqlExpr valExpr = expr.right;
        if (10 == expr.operator || 23 == expr.operator || 13 == expr.operator || 41 == expr.operator || 16 == expr.operator) {
            String matchTable = this.getCurTable();
            SqlExpr columnExpr = null;
            if (expr.left instanceof SqlBinaryOpExpr) {
                String alias;
                String table;
                SqlExpr left = ((SqlBinaryOpExpr)expr.left).left;
                if (left instanceof SqlIdentifierExpr && (table = this.getCurTableByAlias(alias = ((SqlIdentifierExpr)left).getOrgValue().toLowerCase(Locale.ENGLISH))) != null) {
                    matchTable = table;
                }
                columnExpr = ((SqlBinaryOpExpr)expr.left).right;
            } else {
                columnExpr = expr.left;
                if (columnExpr instanceof SqlPriorIdentifierExpr) {
                    return;
                }
            }
            if (matchTable != null) {
                String sqlField = columnExpr.getOrgValue().toLowerCase(Locale.ENGLISH);
                PrivacyPropertyInfo privacyPropertyInfo = PrivacyPropertyManager.getPrivacyPropBySqlField(this.ctx, matchTable, sqlField = ParamData.getRealName(sqlField));
                if (privacyPropertyInfo != null && columnExpr instanceof SqlIdentifierExpr) {
                    if (10 == expr.operator || 23 == expr.operator || 16 == expr.operator) {
                        if (valExpr instanceof SqlVarRefExpr && "?".equals(((SqlVarRefExpr)valExpr).text)) {
                            this.conditionIndexMap.put(++this.paramIndex, privacyPropertyInfo);
                        } else {
                            Object val = ParamData.getOriginalValueFromExpr(valExpr);
                            IPrivacyService ps = PrivacyPropertyManager.getPrivacyService(this.ctx);
                            String hashCode = ps.hash(this.ctx, val);
                            expr.right = ParamData.toSqlExpr(hashCode);
                        }
                        ((SqlIdentifierExpr)columnExpr).value = ParamData.getHashFieldSQLName(((SqlIdentifierExpr)columnExpr).value);
                    } else if (13 == expr.operator || 41 == expr.operator) {
                        ((SqlIdentifierExpr)columnExpr).value = ParamData.getHashFieldSQLName(((SqlIdentifierExpr)columnExpr).value);
                    }
                    return;
                }
            }
        }
        if (valExpr instanceof SqlVarRefExpr && "?".equals(((SqlVarRefExpr)valExpr).text)) {
            ++this.paramIndex;
        }
    }

    private void formatInListExpr(SqlInListExpr expr) throws FormaterException, BOSException {
        List targetList = expr.targetList;
        if (targetList == null) {
            return;
        }
        SqlExpr columnExpr = null;
        String matchTable = this.getCurTable();
        if (expr.expr instanceof SqlBinaryOpExpr) {
            String alias;
            String table;
            SqlExpr left = ((SqlBinaryOpExpr)expr.expr).left;
            if (left instanceof SqlIdentifierExpr && (table = this.getCurTableByAlias(alias = ((SqlIdentifierExpr)left).getOrgValue().toLowerCase(Locale.ENGLISH))) != null) {
                matchTable = table;
            }
            columnExpr = ((SqlBinaryOpExpr)expr.expr).right;
        } else {
            columnExpr = expr.expr;
        }
        if (matchTable != null) {
            String sqlField = columnExpr.getOrgValue().toLowerCase(Locale.ENGLISH);
            PrivacyPropertyInfo privacyPropertyInfo = PrivacyPropertyManager.getPrivacyPropBySqlField(this.ctx, matchTable, sqlField = ParamData.getRealName(sqlField));
            if (privacyPropertyInfo != null && columnExpr instanceof SqlIdentifierExpr) {
                IPrivacyService ps = PrivacyPropertyManager.getPrivacyService(this.ctx);
                for (int i = 0; i < targetList.size(); ++i) {
                    SqlExpr item = (SqlExpr)targetList.get(i);
                    if (item instanceof SqlVarRefExpr && "?".equals(((SqlVarRefExpr)item).text)) {
                        this.conditionIndexMap.put(++this.paramIndex, privacyPropertyInfo);
                        continue;
                    }
                    Object val = ParamData.getOriginalValueFromExpr(item);
                    String hashCode = ps.hash(this.ctx, val);
                    targetList.set(i, ParamData.toSqlExpr(hashCode));
                }
                ((SqlIdentifierExpr)columnExpr).value = ParamData.getHashFieldSQLName(((SqlIdentifierExpr)columnExpr).value);
                return;
            }
        }
        for (int i = 0; i < targetList.size(); ++i) {
            SqlExpr item = (SqlExpr)targetList.get(i);
            if (!(item instanceof SqlVarRefExpr) || !"?".equals(((SqlVarRefExpr)item).text)) continue;
            ++this.paramIndex;
        }
    }

    private boolean isSupport(String tableName) {
        if (StringUtils.isEmpty((String)tableName)) {
            return this.support;
        }
        return tableName.equals(this.mainTable) || this.tableAliasMap.containsValue(tableName);
    }

    public boolean isSupport() {
        return this.isSupport(null);
    }

    private boolean isPropExpr(SqlExpr expr) {
        if (expr instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr binaryExpr = (SqlBinaryOpExpr)expr;
            if (binaryExpr.operator == 20) {
                return true;
            }
        }
        return false;
    }

    private static Object getOriginalValueFromExpr(SqlExpr valueExpr) {
        Object ret = null;
        if (valueExpr instanceof SqlNullExpr) {
            return ret;
        }
        ret = valueExpr instanceof SqlIntExpr ? Integer.valueOf(((SqlIntExpr)valueExpr).value) : (valueExpr instanceof SqlLongExpr ? Long.valueOf(((SqlLongExpr)valueExpr).value) : (valueExpr instanceof SqlCharExpr ? ((SqlCharExpr)valueExpr).text : (valueExpr instanceof SqlDateTimeExpr ? ((SqlDateTimeExpr)valueExpr).getJavaDate() : valueExpr.getOrgValue())));
        return ret;
    }

    public static String getPrivacyFieldSQLName(String item) {
        if (item != null && item.indexOf(34) == 0 && item.endsWith("\"")) {
            return "\"" + item.substring(1, item.length() - 1) + "_p\"";
        }
        return item + "_p";
    }

    public static String getHashFieldSQLName(String item) {
        if (item != null && item.indexOf(34) == 0 && item.endsWith("\"")) {
            return "\"" + item.substring(1, item.length() - 1) + "_h\"";
        }
        return item + "_h";
    }

    private static SqlExpr toSqlExpr(String value) {
        SqlExpr expr = value == null ? new SqlNullExpr() : new SqlCharExpr(value);
        return expr;
    }

    private static int getColumnIndex(SqlSelect select, SqlSelectItem selectItem) {
        List columnList = select.selectList;
        for (int i = 0; i < columnList.size(); ++i) {
            if (columnList.get(i) != selectItem) continue;
            return i;
        }
        throw new RuntimeException("check code,buddy");
    }

    private static int getColumnIndex(SqlSelect select, SqlExpr groupByItem) {
        List orderByList = select.groupBy;
        for (int i = 0; i < orderByList.size(); ++i) {
            if (orderByList.get(i) != groupByItem) continue;
            return i;
        }
        throw new RuntimeException("check code,buddy");
    }

    private static int getColumnIndex(SqlInsertStmt insertStmt, SqlIdentifierExpr insertItem) {
        List columnList = insertStmt.insert.columnList;
        for (int i = 0; i < columnList.size(); ++i) {
            if (columnList.get(i) != insertItem) continue;
            return i;
        }
        throw new RuntimeException("check code,buddy");
    }

    public static void setParamDataToStatement(ParamData paramData, PreparedStatement stmt) {
        if (paramData == null) {
            return;
        }
        try {
            KDStatement kdStmt = null;
            if (stmt instanceof KDStatement) {
                kdStmt = (KDStatement)((Object)stmt);
            } else {
                Field privatefiled = stmt.getClass().getSuperclass().getDeclaredField("stmt");
                if (privatefiled != null) {
                    privatefiled.setAccessible(true);
                    kdStmt = (KDStatement)privatefiled.get(stmt);
                }
            }
            if (kdStmt != null) {
                kdStmt.setParamData(paramData);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String getCurTableByAlias(String alias) {
        ParamData curSubParamData = this.getCurSubParamData();
        if (curSubParamData != null) {
            return curSubParamData.tableAliasMap.get(alias.toLowerCase());
        }
        return this.tableAliasMap.get(alias.toLowerCase());
    }

    private String getCurTable() {
        ParamData curSubParamData = this.getCurSubParamData();
        if (curSubParamData != null) {
            return curSubParamData.mainTable;
        }
        return this.mainTable;
    }

    private ParamData getCurSubParamData() {
        ParamData curParamData = this.subParamData;
        while (curParamData != null && curParamData.subParamData != null) {
            curParamData = curParamData.subParamData;
        }
        return curParamData;
    }

    public void resetSubParamData() {
        ParamData curParamData = this.subParamData;
        ParamData parent = this;
        while (curParamData != null) {
            if (curParamData.subParamData == null) {
                parent.subParamData = null;
                break;
            }
            parent = curParamData;
            curParamData = curParamData.subParamData;
        }
    }

    private ParamData newSubParamData() {
        ParamData newSubParamData = new ParamData(this.ctx);
        ParamData curSubParamData = this.getCurSubParamData();
        if (curSubParamData != null) {
            curSubParamData.subParamData = newSubParamData;
        } else {
            this.subParamData = newSubParamData;
        }
        return newSubParamData;
    }
}

