/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.codingrule.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.codingrule.CodingRuleFactory;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleMultiOrgCollection;
import com.kingdee.eas.base.codingrule.CodingRuleMultiOrgFactory;
import com.kingdee.eas.base.codingrule.CodingRuleMultiOrgInfo;
import com.kingdee.eas.base.codingrule.client.AbstractMultiOrgListUI;
import com.kingdee.eas.base.codingrule.client.CodingRuleClientUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.TransportOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewAdminF7;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.basedata.org.client.f7.NewCostCenterF7;
import com.kingdee.eas.basedata.org.client.f7.NewCtrlF7;
import com.kingdee.eas.basedata.org.client.f7.NewHROF7;
import com.kingdee.eas.basedata.org.client.f7.NewProfitCenterF7;
import com.kingdee.eas.basedata.org.client.f7.NewPurchaseF7;
import com.kingdee.eas.basedata.org.client.f7.NewQualityF7;
import com.kingdee.eas.basedata.org.client.f7.NewSaleF7;
import com.kingdee.eas.basedata.org.client.f7.NewStorageF7;
import com.kingdee.eas.basedata.org.client.f7.NewTransportF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MultiOrgListUI
extends AbstractMultiOrgListUI {
    private static final Logger logger = CoreUIObject.getLogger(MultiOrgListUI.class);
    private String orgType = null;
    private Map orgList = new HashMap();
    private String flag = "readonly";
    private String updateLimit = "false";
    private Color[] color = new Color[]{Color.WHITE, new Color(217, 217, 208)};
    private boolean isModifed = false;
    private NewOrgViewF7PromptDialog orgF7 = null;
    private CodingRuleMultiOrgInfo createOrg = null;
    private CodingRuleMultiOrgCollection oldMultiOrgs = null;

    @Override
    public boolean isPrepareActionAddLine() {
        return false;
    }

    @Override
    public boolean isPrepareActionDelLine() {
        return false;
    }

    @Override
    public IUIActionPostman prepareInit() {
        CodingRuleMultiOrgCollection col = ((CodingRuleInfo)this.getUIContext().get("crInfo")).getMultiOrg();
        EntityViewInfo[] evi = new EntityViewInfo[col.size()];
        for (int colIndex = 0; colIndex < col.size(); ++colIndex) {
            CodingRuleMultiOrgInfo multiOrgInfo = col.get(colIndex);
            if (multiOrgInfo.getAppOrgUnit() != null || multiOrgInfo.getId() == null) continue;
            EntityViewInfo tmpevi = new EntityViewInfo();
            tmpevi.getSelector().add("appOrgUnit.*");
            FilterInfo tmpfilter = new FilterInfo();
            tmpfilter.getFilterItems().add(new FilterItemInfo("id", (Object)multiOrgInfo.getId().toString()));
            tmpevi.setFilter(tmpfilter);
            evi[colIndex] = tmpevi;
        }
        this.orgType = (String)this.getUIContext().get("orgType");
        FullOrgUnitInfo fullOrg = CodingRuleClientUtils.getDefaultFullOrgUnitInfo(this.orgType);
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.put("evi", (Object)evi);
            request.put("fullOrg", (Object)fullOrg);
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    public void onLoad() throws Exception {
        this.initContext();
        super.onLoad();
        if (!this.getUIContext().get("flag").toString().equals("addnew") && !this.getUIContext().get("flag").toString().equals("update")) {
            this.btnAddLine.setEnabled(false);
            this.btnDelLine.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnSubmit.setEnabled(false);
        }
        this.kdtMultiOrg.setAutoscrolls(true);
        KDTSortManager sm = new KDTSortManager(this.kdtMultiOrg);
        sm.setSortAuto(true);
        for (int index = 0; index < this.kdtMultiOrg.getColumnCount(); ++index) {
            this.kdtMultiOrg.getColumn(index).setSortable(true);
        }
        this.initAppOrg();
        if (this.updateLimit.equals("true")) {
            this.btnAddLine.setEnabled(true);
            this.btnDelLine.setEnabled(true);
            this.btnSave.setEnabled(true);
            this.btnSubmit.setEnabled(true);
            this.btnSubmit.setVisible(true);
        }
        this.btnSearchLine.setEnabled(true);
    }

    @Override
    public void storeFields() {
        if (!this.isModifed) {
            return;
        }
        while (this.editData.getMultiOrg().size() > 0) {
            this.editData.getMultiOrg().removeObject(0);
        }
        this.createOrg = null;
        for (FullOrgUnitInfo fullOrg : this.orgList.values()) {
            CodingRuleMultiOrgInfo orgInfo = new CodingRuleMultiOrgInfo();
            orgInfo.setIsMainOrg(false);
            orgInfo.setCodingrule(this.editData);
            orgInfo.setAppOrgUnit(fullOrg);
            orgInfo.setOrgName(fullOrg.getName());
            this.editData.getMultiOrg().add(orgInfo);
            if (!this.isAdminOrg(fullOrg)) continue;
            this.createOrg = orgInfo;
        }
    }

    private FullOrgUnitInfo getAdminFullOrgUnit() {
        FullOrgUnitInfo adminOrg = CodingRuleClientUtils.getDefaultFullOrgUnitInfo(this.orgType);
        if (adminOrg == null) {
            adminOrg = CodingRuleClientUtils.getDefaultFullOrgUnitInfo("ControlUnit");
        }
        return adminOrg;
    }

    @Override
    public void loadFields() {
        FullOrgUnitInfo fullOrg;
        String orgName = EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.info_OrgName");
        String orgNumber = EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.info_OrgNumber");
        while (this.kdtMultiOrg.getRowCount() > 0) {
            this.kdtMultiOrg.removeRow(0);
        }
        this.kdtMultiOrg.removeHeadRows();
        this.kdtMultiOrg.removeColumns();
        this.orgList.clear();
        this.kdtMultiOrg.setFormatXml("");
        IRow headRow = this.kdtMultiOrg.addHeadRow();
        int index = 0;
        IColumn numCol = this.kdtMultiOrg.addColumn();
        numCol.setKey("orgNumber");
        numCol.setWidth(150);
        headRow.getCell(index++).setValue((Object)orgNumber);
        IColumn nameCol = this.kdtMultiOrg.addColumn();
        nameCol.setKey("orgName");
        nameCol.setWidth(300);
        headRow.getCell(index++).setValue((Object)orgName);
        IColumn idCol = this.kdtMultiOrg.addColumn();
        idCol.setKey("ID");
        idCol.setWidth(100);
        idCol.getStyleAttributes().setHided(true);
        headRow.getCell(index++).setValue((Object)"ID");
        CodingRuleMultiOrgCollection col = this.editData.getMultiOrg();
        for (int colIndex = 0; colIndex < col.size(); ++colIndex) {
            CodingRuleMultiOrgInfo multiOrgInfo = col.get(colIndex);
            if (multiOrgInfo.getAppOrgUnit() == null && multiOrgInfo.getId() != null) {
                try {
                    EntityViewInfo tmpevi = new EntityViewInfo();
                    tmpevi.getSelector().add("appOrgUnit.*");
                    FilterInfo tmpfilter = new FilterInfo();
                    tmpfilter.getFilterItems().add(new FilterItemInfo("id", (Object)multiOrgInfo.getId().toString()));
                    tmpevi.setFilter(tmpfilter);
                    CodingRuleMultiOrgCollection orgCol = CodingRuleMultiOrgFactory.getRemoteInstance().getCodingRuleMultiOrgCollection(tmpevi);
                    multiOrgInfo = orgCol.get(0);
                }
                catch (BOSException bOSException) {
                    // empty catch block
                }
            }
            if (multiOrgInfo.isIsMainOrg()) {
                this.createOrg = multiOrgInfo;
                continue;
            }
            this.addOrg(multiOrgInfo.getAppOrgUnit());
            this.orgList.put(multiOrgInfo.getAppOrgUnit().getNumber(), multiOrgInfo.getAppOrgUnit());
        }
        if (col.size() == 0 && (fullOrg = CodingRuleClientUtils.getDefaultFullOrgUnitInfo(this.orgType)) != null) {
            this.addOrg(fullOrg);
            this.orgList.put(fullOrg.getNumber(), fullOrg);
        }
    }

    protected void loadData() throws Exception {
        this.setOprtState("ADDNEW");
        super.loadData();
        this.btnSubmit.setEnabled(false);
        this.btnSubmit.setVisible(false);
        if (this.flag.equalsIgnoreCase("readOnly")) {
            this.btnSubmit.setVisible(true);
            this.btnSubmit.setEnabled(true);
            if (!this.getAdminFullOrgUnit().getId().toString().equalsIgnoreCase(this.editData.getAppOrgUnit().getId().toString())) {
                this.actionAddLine.setEnabled(false);
                this.actionDelLine.setEnabled(false);
                this.btnSubmit.setEnabled(false);
            }
        }
    }

    private void initContext() {
        this.orgType = (String)this.getUIContext().get("orgType");
        this.orgType = this.orgType == null ? "" : this.orgType;
        this.flag = (String)this.getUIContext().get("flag");
        this.updateLimit = (String)this.getUIContext().get("update_limited");
        this.flag = this.flag == null ? "" : this.flag;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionDelLine.setEnabled(true);
        this.actionAddLine.setEnabled(true);
        this.actionAddLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAddLine.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_AddNewOrgLine"));
        this.actionDelLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnDelLine.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_DeleteOrgLine"));
    }

    private void initAppOrg() {
        if (this.orgType != null) {
            this.orgF7 = "Admin".equalsIgnoreCase(this.orgType) ? new NewAdminF7() : ("Company".equalsIgnoreCase(this.orgType) ? new NewCompanyF7() : ("Sale".equalsIgnoreCase(this.orgType) ? new NewSaleF7() : ("Purchase".equalsIgnoreCase(this.orgType) ? new NewPurchaseF7() : ("Storage".equalsIgnoreCase(this.orgType) ? new NewStorageF7() : ("CostCenter".equalsIgnoreCase(this.orgType) ? new NewCostCenterF7() : ("ProfitCenter".equalsIgnoreCase(this.orgType) ? new NewProfitCenterF7() : ("ControlUnit".equalsIgnoreCase(this.orgType) ? new NewCtrlF7() : ("HRO".equalsIgnoreCase(this.orgType) ? new NewHROF7() : ("NONE".equalsIgnoreCase(this.orgType) ? new NewCtrlF7() : ("Transport".equalsIgnoreCase(this.orgType) ? new NewTransportF7() : ("Quality".equalsIgnoreCase(this.orgType) ? new NewQualityF7() : new NewCtrlF7())))))))))));
            this.orgF7.setMultiSelect(true);
            this.orgF7.setIsCUFilter(false);
            this.orgF7.setNeedAddOrgRange(false);
            this.orgF7.setSelectedOrgIds(this.getOrgSet());
        }
    }

    private Set getOrgSet() {
        Iterator it = this.orgList.values().iterator();
        HashSet<String> orgs = new HashSet<String>();
        while (it.hasNext()) {
            orgs.add(((FullOrgUnitInfo)it.next()).getId().toString());
        }
        return orgs;
    }

    private FullOrgUnitInfo getFullOrgUnitInfo(Object obj) {
        FullOrgUnitInfo fullOrg = null;
        if (obj != null) {
            if (this.orgType.equalsIgnoreCase(OrgType.Admin.getName())) {
                fullOrg = ((AdminOrgUnitInfo)obj).castToFullOrgUnitInfo();
            } else if (this.orgType.equalsIgnoreCase(OrgType.Company.getName())) {
                fullOrg = ((CompanyOrgUnitInfo)obj).castToFullOrgUnitInfo();
            } else if (this.orgType.equalsIgnoreCase(OrgType.Sale.getName())) {
                fullOrg = ((SaleOrgUnitInfo)obj).castToFullOrgUnitInfo();
            } else if (this.orgType.equalsIgnoreCase(OrgType.Purchase.getName())) {
                fullOrg = ((PurchaseOrgUnitInfo)obj).castToFullOrgUnitInfo();
            } else if (this.orgType.equalsIgnoreCase(OrgType.Storage.getName())) {
                fullOrg = ((StorageOrgUnitInfo)obj).castToFullOrgUnitInfo();
            } else if (this.orgType.equalsIgnoreCase(OrgType.CostCenter.getName())) {
                fullOrg = ((CostCenterOrgUnitInfo)obj).castToFullOrgUnitInfo();
            } else if (this.orgType.equalsIgnoreCase(OrgType.ProfitCenter.getName())) {
                fullOrg = ((ProfitCenterOrgUnitInfo)obj).castToFullOrgUnitInfo();
            } else if (this.orgType.equalsIgnoreCase(OrgType.ControlUnit.getName())) {
                fullOrg = ((CtrlUnitInfo)obj).castToFullOrgUnitInfo();
            } else if (this.orgType.equalsIgnoreCase(OrgType.HRO.getName())) {
                fullOrg = ((HROrgUnitInfo)obj).castToFullOrgUnitInfo();
            } else if (this.orgType.equalsIgnoreCase(OrgType.NONE.getName())) {
                fullOrg = ((CtrlUnitInfo)obj).castToFullOrgUnitInfo();
            } else if (this.orgType.equalsIgnoreCase(OrgType.Transport.getName())) {
                fullOrg = ((TransportOrgUnitInfo)obj).castToFullOrgUnitInfo();
            } else if (this.orgType.equalsIgnoreCase(OrgType.Quality.getName())) {
                fullOrg = ((QualityOrgUnitInfo)obj).castToFullOrgUnitInfo();
            } else if (this.orgType.equalsIgnoreCase("null")) {
                fullOrg = ((CtrlUnitInfo)obj).castToFullOrgUnitInfo();
            }
        }
        return fullOrg;
    }

    private void addOrg(FullOrgUnitInfo fullOrg) {
        if (null != fullOrg) {
            if (StringUtils.isEmpty((String)fullOrg.getNumber())) {
                try {
                    fullOrg = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(fullOrg.getId()));
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                    return;
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                    return;
                }
            }
            if (this.orgList.get(fullOrg.getNumber()) != null) {
                return;
            }
            IRow row = this.kdtMultiOrg.addRow();
            KDBizPromptBox appOrg = new KDBizPromptBox();
            row.getCell("orgNumber").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)appOrg));
            row.getCell("orgNumber").setValue((Object)fullOrg.getNumber());
            row.getCell("orgName").getStyleAttributes().setLocked(true);
            row.getCell("orgName").setValue((Object)fullOrg.getName());
            if (this.isAdminOrg(fullOrg)) {
                row.getStyleAttributes().setLocked(true);
                row.getStyleAttributes().setBackground(this.color[1]);
            }
            row.getStyleAttributes().setLocked(true);
            this.orgList.put(fullOrg.getNumber(), fullOrg);
        }
    }

    private boolean isAdminOrg(FullOrgUnitInfo fullOrg) {
        return fullOrg.getId() != null && CodingRuleClientUtils.getDefaultFullOrgUnitInfo(this.orgType) != null && fullOrg.getId().equals((Object)CodingRuleClientUtils.getDefaultFullOrgUnitInfo(this.orgType).getId());
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.orgList.values().size() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_NeedOneOrgAtLeast"));
            return;
        }
        this.storeFields();
        if (this.editData.isIsEnabled() && !this.checkValid()) {
            return;
        }
        super.actionSubmit_actionPerformed(e);
        this.isModifed = false;
    }

    protected IObjectValue createNewData() {
        CodingRuleInfo info = (CodingRuleInfo)this.getUIContext().get("crInfo");
        if (info != null) {
            this.oldMultiOrgs = (CodingRuleMultiOrgCollection)((Object)info.getMultiOrg().clone());
        }
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CodingRuleFactory.getRemoteInstance();
    }

    @Override
    protected void kdtMultiOrg_editStopped(KDTEditEvent e) throws Exception {
        if (e.getValue() != null && e.getOldValue() != null && e.getValue().toString().equalsIgnoreCase(e.getOldValue().toString())) {
            return;
        }
        KDTable table = (KDTable)e.getSource();
        IRow row = table.getRow(e.getRowIndex());
        Object cellObj = row.getCell("orgNumber").getValue();
        if (cellObj != null) {
            FullOrgUnitInfo fullOrg = this.getFullOrgUnitInfo(cellObj);
            if (fullOrg == null) {
                return;
            }
            if (this.orgList.get(fullOrg.getNumber()) != null) {
                e.setCancel(true);
                row.getCell("orgNumber").setValue(e.getOldValue());
                return;
            }
            if (e.getOldValue() != null && e.getOldValue().toString().trim().length() > 0) {
                this.orgList.remove(e.getOldValue().toString());
            }
            row.getCell("orgName").setValue((Object)fullOrg.getName());
            row.getCell("orgNumber").setValue((Object)fullOrg.getNumber());
            this.orgList.put(fullOrg.getNumber(), fullOrg);
            this.isModifed = true;
        }
    }

    public boolean isModify() {
        this.storeFields();
        if ("readOnly".equalsIgnoreCase(this.flag)) {
            return this.isModifed;
        }
        return false;
    }

    @Override
    public RequestContext prepareActionAddLine(IItemAction itemAction) throws Exception {
        return super.prepareActionAddLine(itemAction);
    }

    private void fullOrgUnitAddLine(FullOrgUnitInfo[] fi) throws Exception {
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = new RequestContext();
        request.setMethodName("_handleFullOrgUnitAddLine");
        request.put("FullOrgUnitInfo", (Object)fi);
        clientHanlder.setRequestContext((Serializable)request);
        clientHanlder.callHandler();
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.orgF7.show();
        Object[] orgs = (Object[])this.orgF7.getData();
        if (orgs == null) {
            return;
        }
        int oldSize = this.orgList.size();
        for (int index = 0; index < orgs.length; ++index) {
            this.addOrg(this.getFullOrgUnitInfo(orgs[index]));
        }
        if (oldSize != this.orgList.size()) {
            this.isModifed = true;
        }
    }

    @Override
    public void actionDelLine_actionPerformed(ActionEvent e) throws Exception {
        int index = -1;
        index = this.kdtMultiOrg.getSelectManager().getActiveRowIndex();
        if (index == -1) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectOrgBeforeDelete"));
            return;
        }
        if (this.orgList.values().size() == 1) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_NeedOneOrgAtLeast"));
            return;
        }
        IRow row = this.kdtMultiOrg.getRow(index);
        Object objNum = row.getCell("orgNumber").getValue();
        if (objNum != null) {
            Object orgValue = this.orgList.get(objNum.toString());
            if (null != orgValue && this.isAdminOrg((FullOrgUnitInfo)orgValue)) {
                if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Confirm_DeleteDefOrg")) == 0) {
                    this.orgList.remove(objNum.toString());
                    this.isModifed = true;
                    this.kdtMultiOrg.removeRow(index);
                } else {
                    return;
                }
            }
            this.orgList.remove(objNum.toString());
            this.isModifed = true;
            this.kdtMultiOrg.removeRow(index);
        }
    }

    protected boolean checkValid() throws Exception {
        StringBuffer strOrgs = new StringBuffer("");
        for (int orgIndex = 0; orgIndex < this.editData.getMultiOrg().size(); ++orgIndex) {
            if (this.editData.getMultiOrg().get(orgIndex).isIsMainOrg()) continue;
            if (strOrgs.length() > 0) {
                strOrgs.append(",");
            }
            strOrgs.append(this.editData.getMultiOrg().get(orgIndex).getAppOrgUnit().getId().toString());
        }
        StringBuffer strMsg = new StringBuffer("");
        CodingRuleMultiOrgCollection orgCol = CodingRuleClientUtils.getMultiOrgCRs(strOrgs.toString());
        for (int orgIndex = 0; orgIndex < orgCol.size(); ++orgIndex) {
            CodingRuleInfo tmpCr = orgCol.get(orgIndex).getCodingrule();
            if (!tmpCr.getBusinessObject().equalsIgnoreCase(this.editData.getBusinessObject()) || !tmpCr.isIsEnabled() || tmpCr.getId().toString().equalsIgnoreCase(this.editData.getId().toString()) || tmpCr.getBindingProperty() != null && !tmpCr.getBindingProperty().equals(this.editData.getBindingProperty())) continue;
            if (strMsg.length() > 0) {
                strMsg.append(" | ");
            }
            strMsg.append(orgCol.get(orgIndex).getAppOrgUnit().getNumber());
        }
        if (strMsg.length() > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_OrgNoAddOrgEnable").replaceAll("ORGNUMBERS", strMsg.toString()));
            return false;
        }
        return true;
    }

    public boolean destroyWindow() {
        super.destroyWindow();
        if (this.flag.equalsIgnoreCase("readOnly") && this.oldMultiOrgs != null && this.oldMultiOrgs.size() > 1) {
            while (this.editData.getMultiOrg().size() > 0) {
                this.editData.getMultiOrg().removeObject(0);
            }
            for (int i = 0; i < this.oldMultiOrgs.size(); ++i) {
                this.editData.getMultiOrg().add(this.oldMultiOrgs.get(i));
            }
        }
        return true;
    }

    @Override
    public void actionSearchLine_actionPerformed(ActionEvent e) throws Exception {
        String searchNum = this.txtSearchLine.getText();
        String orgNum = null;
        if (!StringUtils.isEmpty((String)searchNum)) {
            int i = 0;
            int lineNum = -1;
            for (i = 0; i < this.kdtMultiOrg.getRowCount(); ++i) {
                IRow row = this.kdtMultiOrg.getRow(i);
                orgNum = (String)row.getCell("orgNumber").getValue();
                if (StringUtils.isEmpty((String)orgNum) || !orgNum.equals(searchNum)) continue;
                lineNum = row.getRowIndex();
                break;
            }
            if (lineNum != -1) {
                this.kdtMultiOrg.getSelectManager().select(lineNum, 0);
                this.kdtMultiOrg.getLayoutManager().scrollRowToShow(lineNum);
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_OrgNumberNotExist"));
            }
        }
    }
}

