/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryPanel;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.client.SysContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ClientQueryFieldPermission {
    public static DataObject[] getCanViewField(QueryInfo queryInfo, DataObject[] fields, OrgUnitCollection coll) {
        if (queryInfo == null) {
            return null;
        }
        return ClientQueryFieldPermission.getCanViewField(MetaDataPK.create((String)queryInfo.getFullName()), fields, coll);
    }

    public static DataObject[] getCanViewField(MetaDataPK queryInfo, DataObject[] fields, OrgUnitCollection coll) {
        ArrayList fieldStr = ClientQueryFieldPermission.getFieldValues(fields);
        ArrayList canViewFields = new ArrayList();
        try {
            canViewFields = ClientQueryFieldPermission.getCanViewField(queryInfo, fieldStr, coll);
        }
        catch (Exception e) {
            return fields;
        }
        if (canViewFields == null || canViewFields.size() <= 0) {
            return null;
        }
        DataObject[] canViewFieldObject = new DataObject[canViewFields.size()];
        int index = 0;
        for (int i = 0; i < fields.length; ++i) {
            if (!canViewFields.contains(fields[i].getValue())) continue;
            canViewFieldObject[index] = fields[i];
            ++index;
        }
        return canViewFieldObject;
    }

    private static ArrayList getFieldValues(DataObject[] fields) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < fields.length; ++i) {
            result.add(fields[i].getValue());
        }
        return result;
    }

    private static IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
    }

    public static ArrayList getCanViewField(QueryInfo queryInfo, ArrayList fields, OrgUnitCollection coll) throws Exception {
        if (queryInfo == null) {
            return new ArrayList();
        }
        return ClientQueryFieldPermission.getCanViewField(MetaDataPK.create((String)queryInfo.getFullName()), fields, coll);
    }

    public static ArrayList getCanViewField(MetaDataPK queryInfo, ArrayList fields, OrgUnitCollection coll) throws Exception {
        ArrayList noViewFields = ClientQueryFieldPermission.getCanNotViewField(queryInfo, coll, true);
        fields.removeAll(noViewFields);
        return fields;
    }

    private static IObjectPK getCurrentOrgPK(MetaDataPK queryInfo) throws BOSException {
        return new ObjectUuidPK(Util.getOrgID(queryInfo.getFullName()));
    }

    public static OrgUnitCollection getMainOrgUnits(CommonQueryPanel panel) {
        OrgUnitCollection coll = new OrgUnitCollection();
        if (panel == null) {
            return coll;
        }
        ArrayList panelList = panel.getCustomerQueryPanel();
        if (panelList == null || panelList.size() == 0) {
            return coll;
        }
        for (int i = 0; i < panelList.size(); ++i) {
            Object o = panelList.get(i);
            if (!(o instanceof CustomerQueryPanel)) continue;
            CustomerQueryPanel cqPanel = (CustomerQueryPanel)o;
            coll.addCollection(cqPanel.getMainBizOrgs());
        }
        return coll;
    }

    public static ArrayList getCanNotViewField(QueryInfo queryInfo) throws Exception {
        if (queryInfo == null) {
            return new ArrayList();
        }
        return ClientQueryFieldPermission.getCanNotViewField(MetaDataPK.create((String)queryInfo.getFullName()));
    }

    public static ArrayList getCanNotViewField(MetaDataPK queryPK) throws Exception {
        if (queryPK == null) {
            return new ArrayList(1);
        }
        FieldPermission fieldPerms = null;
        IObjectPK orgPK = ClientQueryFieldPermission.getCurrentOrgPK(queryPK);
        fieldPerms = PermissionHelper.getQueryFieldPermission((IMetaDataPK)queryPK, (IObjectPK)ClientQueryFieldPermission.getCurrentUserPK(), (IObjectPK)orgPK);
        return ClientQueryFieldPermission.getNoViewField(fieldPerms);
    }

    public static ArrayList getCanNotViewField(QueryInfo queryInfo, OrgUnitCollection coll, boolean isCross) throws Exception {
        if (queryInfo == null) {
            return new ArrayList(1);
        }
        return ClientQueryFieldPermission.getCanNotViewField(MetaDataPK.create((String)queryInfo.getFullName()), coll, isCross);
    }

    public static ArrayList getCanNotViewField(MetaDataPK queryPK, OrgUnitCollection coll, boolean isCross) throws Exception {
        if (coll == null || coll.size() == 0) {
            return ClientQueryFieldPermission.getCanNotViewField(queryPK);
        }
        FieldPermission fieldPerms = null;
        Map fieldPermsMap = PermissionHelper.getQueryFieldPermission((IMetaDataPK)queryPK, (IObjectPK)ClientQueryFieldPermission.getCurrentUserPK(), (List)ClientQueryFieldPermission.getOrgIDStrList(coll));
        Iterator it = fieldPermsMap.keySet().iterator();
        ArrayList noViewFields = new ArrayList();
        boolean firstFlag = true;
        while (it.hasNext()) {
            String key = (String)it.next();
            fieldPerms = (FieldPermission)fieldPermsMap.get(key);
            if (fieldPerms != null) {
                ArrayList oneOrgNoViewFields = ClientQueryFieldPermission.getNoViewField(fieldPerms);
                if (isCross) {
                    if (firstFlag) {
                        noViewFields.addAll(oneOrgNoViewFields);
                        firstFlag = false;
                        continue;
                    }
                    for (int i = 0; i < noViewFields.size(); ++i) {
                        String tmpFieldName = (String)noViewFields.get(i);
                        if (oneOrgNoViewFields.contains(tmpFieldName)) continue;
                        noViewFields.remove(tmpFieldName);
                        --i;
                    }
                    continue;
                }
                noViewFields.addAll(oneOrgNoViewFields);
                continue;
            }
            if (!isCross) continue;
            return new ArrayList();
        }
        return noViewFields;
    }

    private static ArrayList getNoViewField(FieldPermission fieldPerms) {
        FieldAccessInfo fieldAccess = null;
        ArrayList<String> notViewField = new ArrayList<String>();
        for (int i = 0; i < fieldPerms.size(); ++i) {
            fieldAccess = fieldPerms.get(i);
            String fieldName = fieldAccess.getFieldName();
            if (!fieldPerms.isEnableFieldPermission(fieldName) || fieldAccess.isViewable()) continue;
            notViewField.add(fieldName);
        }
        return notViewField;
    }

    protected static ArrayList getOrgIDStrList(OrgUnitCollection coll) {
        ArrayList<String> result = new ArrayList<String>();
        if (coll == null) {
            return result;
        }
        for (int i = 0; i < coll.size(); ++i) {
            result.add(coll.get(i).getId().toString());
        }
        return result;
    }
}

