/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.client;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.eas.base.commonquery.BaseCommonQueryClientException;
import com.kingdee.eas.base.commonquery.client.CommonEntityFilterPanel;
import com.kingdee.eas.base.commonquery.client.CommonEntitySorterPanel;
import com.kingdee.eas.base.commonquery.client.CommonEntityUI;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class CommonEntityPanel
extends KDPanel {
    private CommonEntityFilterPanel commonEntityFilterPanel;
    private CommonEntitySorterPanel commonEntitySorterPanel;
    private KDTabbedPane tabbedPanel;
    private KDButton confirmButton;
    private KDButton cancelButton;
    private boolean showFilter;
    private boolean showSorter;
    private EntityViewInfo resultEntityViewInfo;
    private IMetaDataPK entityPK;
    private int width;
    private int height;
    private int closeWindowType = 2;
    private static final String commonEntityPanelRes = "com.kingdee.eas.base.commonquery.client.CommonEntityPanel";
    private static final String commonEntityFilterRes = "com.kingdee.eas.base.commonquery.client.CommonEntityFilter";
    private static final String commonEntitySorterRes = "com.kingdee.eas.base.commonquery.client.CommonEntitySorter";

    public CommonEntityPanel(EntityViewInfo entityViewInfo, IMetaDataPK entityPK, String[] filterProperties, String[] sorterProperties, IProcessor processor, IPromptBoxFactory promptBoxFactory, boolean showFilter, boolean showSorter, int width, int height, boolean extendCondition) throws BaseCommonQueryClientException {
        if (entityViewInfo == null) {
            entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(new FilterInfo());
        } else {
            entityViewInfo = (EntityViewInfo)entityViewInfo.clone();
        }
        if (entityViewInfo.getFilter() == null) {
            entityViewInfo.setFilter(new FilterInfo());
        }
        this.resultEntityViewInfo = entityViewInfo;
        this.entityPK = entityPK;
        this.showFilter = showFilter;
        this.showSorter = showSorter;
        this.width = width;
        this.height = height;
        if (showFilter) {
            this.commonEntityFilterPanel = new CommonEntityFilterPanel(entityPK, entityViewInfo.getFilter(), filterProperties, processor, promptBoxFactory, this.getMainPanelWidth(), this.getMainPanelHeight() - 29 - 8);
        }
        if (showSorter) {
            this.commonEntitySorterPanel = new CommonEntitySorterPanel(entityPK, entityViewInfo.getSorter(), sorterProperties, this.getMainPanelWidth(), this.getMainPanelHeight() - 29 - 8);
        }
        if (processor != null) {
            processor.set("COMMON_ENTITY_PANEL", (Object)this);
        }
        this.jbInit();
    }

    public CommonEntityPanel(EntityViewInfo entityViewInfo, IMetaDataPK entityPK, String[] filterProperties, String[] sorterProperties, IProcessor processor, IPromptBoxFactory promptBoxFactory, boolean showFilter, boolean showSorter, int width, int height) throws BaseCommonQueryClientException {
        this(entityViewInfo, entityPK, filterProperties, sorterProperties, processor, promptBoxFactory, showFilter, showSorter, width, height, false);
    }

    public CommonEntityPanel(EntityViewInfo entityViewInfo, IMetaDataPK entityPK, String[] filterProperties, String[] sorterProperties, IPromptBoxFactory promptBoxFactory, boolean showFilter, boolean showSorter, int width, int height) throws BaseCommonQueryClientException {
        this(entityViewInfo, entityPK, filterProperties, sorterProperties, null, promptBoxFactory, showFilter, showSorter, width, height);
    }

    public CommonEntityPanel(EntityViewInfo entityViewInfo, IMetaDataPK entityPK, String[] filterProperties, String[] sorterProperties, IPromptBoxFactory promptBoxFactory, boolean showFilter, boolean showSorter) throws BaseCommonQueryClientException {
        this(entityViewInfo, entityPK, filterProperties, sorterProperties, promptBoxFactory, showFilter, showSorter, 540, 400);
    }

    public CommonEntityPanel(EntityViewInfo entityViewInfo, IMetaDataPK entityPK, String[] filterProperties, String[] sorterProperties, IPromptBoxFactory promptBoxFactory) throws BaseCommonQueryClientException {
        this(entityViewInfo, entityPK, filterProperties, sorterProperties, promptBoxFactory, true, true);
    }

    private void jbInit() {
        this.initMainPanel();
        this.initRightPanel();
        this.initBottomPanel();
    }

    private void initMainPanel() {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(this.width, this.height));
    }

    private void initRightPanel() {
        this.tabbedPanel = new KDTabbedPane();
        this.initTabbedPanel();
        this.tabbedPanel.setBounds(10, 10, this.width - 10 - 10, this.height - 10 - 51);
        this.add((Component)this.tabbedPanel);
    }

    private void initBottomPanel() {
        this.confirmButton = this.createConfirmButton();
        this.add((Component)this.confirmButton);
        this.confirmButton.setBounds(this.width - 10 - 73 - 3 - 73, this.height - 10 - 21, 73, 21);
        this.createCancelButton();
        this.add((Component)this.cancelButton);
        this.cancelButton.setBounds(this.width - 10 - 73, this.height - 10 - 21, 73, 21);
        KDSeparator separator = new KDSeparator();
        separator.setBounds(0, this.height - 10 - 21 - 9, this.width, 2);
        this.add((Component)separator);
    }

    private KDButton createConfirmButton() {
        this.confirmButton = new KDButton();
        this.confirmButton.setText(EASResource.getString((String)commonEntityPanelRes, (String)"confirm"));
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonEntityPanel.this.confirmButton_actionPerformed(e);
            }
        });
        return this.confirmButton;
    }

    private KDButton createCancelButton() {
        this.cancelButton = new KDButton();
        this.cancelButton.setText(EASResource.getString((String)commonEntityPanelRes, (String)"cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonEntityPanel.this.cancelButton_actionPerformed(e);
            }
        });
        return this.cancelButton;
    }

    protected int getMainPanelWidth() {
        return this.width - 10 - 10;
    }

    protected int getMainPanelHeight() {
        return this.height - 10 - 51;
    }

    private void initTabbedPanel() {
        if (this.showFilter && this.showSorter) {
            this.tabbedPanel.add(EASResource.getString((String)commonEntityFilterRes, (String)"panelName"), (Component)((Object)this.commonEntityFilterPanel));
            this.tabbedPanel.add(EASResource.getString((String)commonEntitySorterRes, (String)"panelName"), (Component)((Object)this.commonEntitySorterPanel));
        } else if (this.showFilter) {
            this.tabbedPanel.add(EASResource.getString((String)commonEntityFilterRes, (String)"panelName"), (Component)((Object)this.commonEntityFilterPanel));
        } else if (this.showSorter) {
            this.tabbedPanel.add(EASResource.getString((String)commonEntitySorterRes, (String)"panelName"), (Component)((Object)this.commonEntitySorterPanel));
        }
    }

    protected void confirmButton_actionPerformed(ActionEvent e) {
        if (this.verify()) {
            this.closeWindowType = 0;
            Util.getWindow((Component)((Object)this)).dispose();
        }
    }

    protected void cancelButton_actionPerformed(ActionEvent e) {
        this.closeWindowType = 1;
        Util.getWindow((Component)((Object)this)).dispose();
    }

    private void setCurrentEntityViewInfo() {
        this.clearEntityViewInfo();
        if (this.isShowFilter()) {
            this.resultEntityViewInfo.setFilter(this.commonEntityFilterPanel.getFilterInfo());
        } else {
            this.resultEntityViewInfo.setFilter(new FilterInfo());
        }
        SorterItemCollection sorterItemCollection = null;
        sorterItemCollection = this.isShowSorter() ? this.commonEntitySorterPanel.getSorterItems() : new SorterItemCollection();
        int size = sorterItemCollection.size();
        for (int i = 0; i < size; ++i) {
            this.resultEntityViewInfo.getSorter().add(sorterItemCollection.get(i));
        }
    }

    private void clearEntityViewInfo() {
        if (this.resultEntityViewInfo.getFilter() != null) {
            this.resultEntityViewInfo.getFilter().setMaskString("");
            this.resultEntityViewInfo.getFilter().getFilterItems().clear();
        }
        this.resultEntityViewInfo.getSorter().clear();
    }

    protected EntityViewInfo getEntityViewInfo() {
        this.setCurrentEntityViewInfo();
        return this.resultEntityViewInfo;
    }

    public CommonEntityFilterPanel getCommonEntityFilterPanel() {
        return this.commonEntityFilterPanel;
    }

    public CommonEntitySorterPanel getCommonEntitySorterPanel() {
        return this.commonEntitySorterPanel;
    }

    protected KDTabbedPane getTabbedPanel() {
        return this.tabbedPanel;
    }

    protected int getCloseWindowType() {
        return this.closeWindowType;
    }

    protected boolean isShowFilter() {
        return this.showFilter;
    }

    protected boolean isShowSorter() {
        return this.showSorter;
    }

    public boolean verify() {
        boolean flag = true;
        if (this.commonEntityFilterPanel != null && !(flag = this.commonEntityFilterPanel.verify())) {
            return flag;
        }
        if (this.commonEntitySorterPanel != null && !(flag = this.commonEntitySorterPanel.verify())) {
            return flag;
        }
        return flag;
    }

    protected Component getParentUI() {
        CommonEntityUI commonEntityUI = (CommonEntityUI)((Object)Util.getComponent((Component)((Object)this), CommonEntityUI.class.getName()));
        return (Component)commonEntityUI.getUIContext().get("Owner");
    }

    public KDButton getConfirmButton() {
        return this.confirmButton;
    }
}

