/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.access.query.SimplePropertyUnit;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class DefaultPromptBoxFactory
implements IPromptBoxFactory {
    private static Logger logger = Logger.getLogger(DefaultPromptBoxFactory.class);

    @Override
    public KDPromptBox create(String f7QueryName, QueryInfo mainQuery, String queryFieldName) {
        return this.create(f7QueryName, MetaDataPK.create((String)mainQuery.getFullName()), queryFieldName, true);
    }

    @Override
    public KDPromptBox create(String f7QueryName, EntityObjectInfo entity, String propertyName) {
        return this.create(f7QueryName, MetaDataPK.create((String)entity.getFullName()), propertyName, false);
    }

    @Override
    public KDPromptBox create(String f7QueryName, MetaDataPK pk, String fieldName, boolean isQuery) {
        try {
            if (isQuery) {
                return this.createWithQuery(f7QueryName, pk, fieldName);
            }
            return this.createWithEntity(f7QueryName, pk, fieldName);
        }
        catch (BOSException e) {
            logger.error((Object)"create errror.", (Throwable)e);
            return null;
        }
    }

    public KDPromptBox createWithQuery(String f7QueryName, MetaDataPK mainQuery, String queryFieldName) throws BOSException {
        String commitFormat;
        String editFormat;
        KDBizPromptBox f7Ctrl = null;
        String displayFormat = Util.getF7DisplayFormat(mainQuery, queryFieldName, true);
        String defaultFormat = "$number$;$name$";
        if (displayFormat == null || displayFormat.trim().equalsIgnoreCase("")) {
            displayFormat = defaultFormat;
        }
        if ((editFormat = Util.getF7EditFormat(mainQuery, queryFieldName, true)) == null || editFormat.trim().equalsIgnoreCase("")) {
            editFormat = "$" + Util.getEntityPropertyName(mainQuery, queryFieldName) + "$";
        }
        if ((commitFormat = Util.getF7CommitFormat(mainQuery, queryFieldName, true)) == null || commitFormat.trim().equalsIgnoreCase("")) {
            commitFormat = defaultFormat;
        }
        f7Ctrl = new KDBizPromptBox();
        ExtendParser parser = new ExtendParser(f7Ctrl);
        f7Ctrl.setCommitParser((IParser)parser);
        f7Ctrl.setDisplayFormat(displayFormat);
        f7Ctrl.setEditFormat(editFormat);
        if (Util.isString(mainQuery, new String[]{queryFieldName}, true)[0]) {
            f7Ctrl.setCommitFormat(commitFormat);
            f7Ctrl.setEditable(true);
        } else {
            f7Ctrl.setEditable(false);
        }
        SimplePropertyUnit queryFieldInfo = Util.getQueryFieldInfo(mainQuery, queryFieldName);
        String defaultF7UI = Util.getDefaultF7UI(queryFieldInfo);
        if (defaultF7UI != null && !defaultF7UI.trim().equalsIgnoreCase("")) {
            f7Ctrl.setDefaultF7UIName(defaultF7UI);
        }
        if (f7QueryName != null && !f7QueryName.trim().equalsIgnoreCase("")) {
            f7Ctrl.setQueryInfo(f7QueryName);
        }
        return f7Ctrl;
    }

    public KDPromptBox createWithEntity(String f7QueryName, MetaDataPK entity, String propertyName) throws BOSException {
        KDBizPromptBox f7Ctrl = null;
        String defaultFormat = "$" + propertyName + "$";
        f7Ctrl = new KDBizPromptBox();
        ExtendParser parser = new ExtendParser(f7Ctrl);
        f7Ctrl.setCommitParser((IParser)parser);
        f7Ctrl.setDisplayFormat(defaultFormat);
        f7Ctrl.setEditFormat(defaultFormat);
        if (Util.isString(entity, new String[]{propertyName}, false)[0]) {
            f7Ctrl.setCommitFormat(defaultFormat);
        }
        f7Ctrl.setEditable(true);
        String defaultF7UI = Util.getDefaultF7UI(Util.getLinkPropertyInfo(propertyName, entity));
        if (defaultF7UI == null || defaultF7UI.trim().equalsIgnoreCase("")) {
            defaultF7UI = Util.getDefaultF7UI(Util.getSimpleEntity(entity.getFullName()));
            if (defaultF7UI == null || defaultF7UI.trim().equalsIgnoreCase("")) {
                if (StringUtils.isEmpty((String)f7QueryName)) {
                    f7Ctrl.setQueryInfo(Util.getDefaultF7Query((IMetaDataPK)entity));
                } else {
                    f7Ctrl.setQueryInfo(f7QueryName);
                }
            } else {
                f7Ctrl.setDefaultF7UIName(defaultF7UI);
                if (StringUtils.isEmpty((String)f7QueryName)) {
                    f7Ctrl.setQueryInfo(Util.getDefaultF7Query((IMetaDataPK)entity));
                } else {
                    f7Ctrl.setQueryInfo(f7QueryName);
                }
            }
        } else {
            f7Ctrl.setDefaultF7UIName(defaultF7UI);
            if (StringUtils.isEmpty((String)f7QueryName)) {
                f7Ctrl.setQueryInfo(Util.getDefaultF7Query((IMetaDataPK)entity));
            } else {
                f7Ctrl.setQueryInfo(f7QueryName);
            }
        }
        return f7Ctrl;
    }

    @Override
    public KDPromptBox create(String extendPropertyValue) {
        return null;
    }
}

