/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.DynQuerySolutionCollection;
import com.kingdee.eas.base.commonquery.DynQuerySolutionInfo;
import com.kingdee.eas.base.commonquery.IUserOrgDynQuery;
import com.kingdee.eas.base.commonquery.UserOrgDynQueryFactory;
import com.kingdee.eas.base.commonquery.client.AbstractDynQueryAccreditUI;
import com.kingdee.eas.base.commonquery.client.DynQueryUtil;
import com.kingdee.eas.base.commonquery.client.UserOrgDynQueryListUI;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.UserPromptBox;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOUUnionF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class DynQueryAccreditUI
extends AbstractDynQueryAccreditUI {
    private static final Logger logger = CoreUIObject.getLogger(DynQueryAccreditUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.commonquery.cqResource";
    private HashSet targetSet = new HashSet();
    private ArrayList sourceDataList = new ArrayList();
    private String parentUIName = null;
    private String queryFullName = null;
    public static final String PARENT_UI_NAME = "parentUIName";
    public static final String QUERY_FULL_NAME = "queryFullName";

    protected ICoreBase getBizInterface() throws Exception {
        return UserOrgDynQueryFactory.getRemoteInstance();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.getParameter();
        this.initSourceList();
        this.initOrgF7();
        this.initWorkButton();
        this.kdlSource.setBounds(new Rectangle(10, 35, 200, 20));
        this.kdlTarget.setBounds(new Rectangle(309, 35, 200, 18));
    }

    private void getParameter() {
        this.parentUIName = (String)this.getUIContext().get(PARENT_UI_NAME);
        this.queryFullName = (String)this.getUIContext().get(QUERY_FULL_NAME);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setText(null);
        Icon addIcon = EASResource.getIcon((String)"imgTbtn_move_right");
        this.btnAdd.setIcon(addIcon);
        Icon addAllIcon = EASResource.getIcon((String)"imgTbtn_moveall_right");
        this.btnAddAll.setText(null);
        this.btnAddAll.setIcon(addAllIcon);
        Icon deleteIcon = EASResource.getIcon((String)"imgTbtn_move_left");
        this.btnDelete.setText(null);
        this.btnDelete.setIcon(deleteIcon);
        Icon deleteAllIcon = EASResource.getIcon((String)"imgTbtn_moveall_left");
        this.btnDeleteAll.setText(null);
        this.btnDeleteAll.setIcon(deleteAllIcon);
        this.btnAccredit.setIcon(EASResource.getIcon((String)"imgTbtn_allotmultipopedom"));
        this.btnDisaccredit.setIcon(EASResource.getIcon((String)"imgTbtn_deletemultipopedom"));
        this.btnAllList.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
    }

    private void initOrgF7() throws EASBizException, BOSException {
        IObjectPK curUserPK = ToolUtils.getCurrentUserPK();
        NewOUUnionF7 orgF7 = new NewOUUnionF7((IUIObject)this);
        orgF7.setShowAssistantOrg(true);
        orgF7.setShowSub(true);
        orgF7.setMultiRootUnitsSQL(PermissionRangeHelper.getBizUserCUOrgRangeSQL(null, (IObjectPK)curUserPK));
        orgF7.disableTheOUWhichIsOnlyAdmin();
        orgF7.setNeedAddSealUp(true);
        if (!Administrator.isCUAdmin(null, (IObjectPK)curUserPK)) {
            String extraSQL = PermissionRangeHelper.getUserOrgIdRangeSQL(null, (IObjectPK)curUserPK, (OrgRangeType)OrgRangeType.BIZ_ORG_TYPE);
            StringBuffer extraTreeFilter = new StringBuffer();
            extraTreeFilter.append("\"BASEUNIT\"").append(".FID IN (").append(extraSQL).append(")");
            orgF7.setExtraTreeFilters(extraTreeFilter.toString());
            try {
                FilterInfo outerFilter = new FilterInfo("unit.id in (" + extraSQL + ")");
                orgF7.setOuterFilterInfo(outerFilter);
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
            orgF7.setNeedConsiderFaultTree(true);
        }
        this.pmtOrg.setSelector((KDPromptSelector)orgF7);
        this.pmtOrg.setEditable(false);
    }

    private void initSourceList() throws Exception {
        DynQuerySolutionCollection col = DynQueryUtil.getOwnDynQuerySolutions(this.parentUIName, this.queryFullName);
        for (int i = 0; i < col.size(); ++i) {
            DynQuerySolutionInfo info = col.get(i);
            this.sourceList.addElement((Object)info);
            this.sourceDataList.add(info);
        }
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        super.actionAdd_actionPerformed(e);
        Object[] selectedList = this.sourceList.getSelectedValues();
        for (int i = 0; i < selectedList.length; ++i) {
            this.targetSet.add(selectedList[i]);
        }
        this.addToTarget();
    }

    @Override
    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddAll_actionPerformed(e);
        this.targetSet.addAll(this.sourceDataList);
        this.addToTarget();
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelete_actionPerformed(e);
        Object[] deleteList = this.targetList.getSelectedValues();
        for (int i = 0; i < deleteList.length; ++i) {
            this.targetSet.remove(deleteList[i]);
            this.targetList.removeElement(deleteList[i]);
        }
    }

    @Override
    public void actionDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteAll_actionPerformed(e);
        this.targetSet.clear();
        this.targetList.removeAllElements();
    }

    private void addToTarget() {
        int i;
        this.targetList.removeAllElements();
        Object[] arr = this.targetSet.toArray();
        ArrayList<Object> list = new ArrayList<Object>();
        for (i = 0; i < arr.length; ++i) {
            list.add(arr[i]);
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                DynQuerySolutionInfo dyn1 = (DynQuerySolutionInfo)obj1;
                DynQuerySolutionInfo dyn2 = (DynQuerySolutionInfo)obj2;
                String name1 = dyn1.getName();
                String name2 = dyn2.getName();
                if (name1 == null) {
                    return -1;
                }
                if (name2 == null) {
                    return 1;
                }
                return name1.compareTo(name2);
            }
        });
        for (i = 0; i < list.size(); ++i) {
            this.targetList.addElement(list.get(i));
        }
    }

    @Override
    public void actionAccredit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAccredit_actionPerformed(e);
        this.checkOrgIsNull();
        this.checkTargetIsNull();
        UserPromptBox pmt = new UserPromptBox((IUIObject)this);
        pmt.setEntityViewInfo(this.getUserFilter());
        pmt.show();
        Object[] users = (Object[])pmt.getData();
        if (!pmt.isCanceled()) {
            this.checkEmpty(users);
            List orgIdList = this.getOrgList();
            List userIdList = this.getUserList(users);
            List dynQueryIdList = this.getDynQueryIdList();
            String cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            IUserOrgDynQuery iUserOrgDynQuery = UserOrgDynQueryFactory.getRemoteInstance();
            iUserOrgDynQuery.addBatch(userIdList, orgIdList, dynQueryIdList, cuId);
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"ACCREDIT_SUCCESS"));
        }
    }

    @Override
    public void actionDisaccredit_actionPerformed(ActionEvent e) throws Exception {
        super.actionDisaccredit_actionPerformed(e);
        this.checkOrgIsNull();
        this.checkTargetIsNull();
        UserPromptBox pmt = new UserPromptBox((IUIObject)this);
        pmt.setEntityViewInfo(this.getUserFilter());
        pmt.show();
        Object[] users = (Object[])pmt.getData();
        if (!pmt.isCanceled()) {
            this.checkEmpty(users);
            List userIdList = this.getUserList(users);
            List orgIdList = this.getOrgList();
            List dynQueryIdList = this.getDynQueryIdList();
            IUserOrgDynQuery iUserOrgDynQuery = UserOrgDynQueryFactory.getRemoteInstance();
            iUserOrgDynQuery.deleteBatch(userIdList, orgIdList, dynQueryIdList);
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"DISACCREDIT_SUCCESS"));
        }
    }

    private EntityViewInfo getUserFilter() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), CompareType.NOTEQUALS));
        FullOrgUnitInfo org = (FullOrgUnitInfo)this.pmtOrg.getData();
        if (org != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getUserWithBizOrgSql(org.getId().toString()), CompareType.INNER));
        }
        evi.setFilter(filter);
        return evi;
    }

    private String getUserWithBizOrgSql(String orgPK) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT OrgRange.FUserID FROM T_PM_OrgRange OrgRange ");
        sql.append(" INNER JOIN T_PM_User U ON U.FID = OrgRange.FUserID ").append(" WHERE U.FIsDelete = 0 ").append(" AND OrgRange.FOrgID = '").append(orgPK).append("' AND OrgRange.FType = 10 ");
        return sql.toString();
    }

    @Override
    public void actionAllList_actionPerformed(ActionEvent e) throws Exception {
        UIContext uictx = new UIContext();
        uictx.put((Object)"Owner", (Object)this);
        uictx.put((Object)PARENT_UI_NAME, (Object)this.parentUIName);
        uictx.put((Object)QUERY_FULL_NAME, (Object)this.queryFullName);
        UITools.showUI((Object)((Object)this), (String)UserOrgDynQueryListUI.class.getName(), (UIContext)uictx);
    }

    private void checkEmpty(Object[] users) {
        if (users == null || users.length == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"USER_NOT_SELECTED"));
            SysUtil.abort();
        }
    }

    private void checkOrgIsNull() {
        if (this.pmtOrg.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"ORG_NOT_SELECTED"));
            SysUtil.abort();
        }
    }

    private void checkTargetIsNull() {
        if (this.targetSet.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"DYNQUERY_NOT_SELECTED"));
            SysUtil.abort();
        }
    }

    private List getDynQueryIdList() {
        ArrayList<String> dynQueryIdList = new ArrayList<String>();
        Iterator ite = this.targetSet.iterator();
        while (ite.hasNext()) {
            dynQueryIdList.add(((DynQuerySolutionInfo)ite.next()).getId().toString());
        }
        return dynQueryIdList;
    }

    private List getUserList(Object[] users) {
        ArrayList<String> userIdList = new ArrayList<String>();
        for (int i = users.length - 1; i >= 0; --i) {
            userIdList.add(((UserInfo)users[i]).getId().toString());
        }
        return userIdList;
    }

    private List getOrgList() {
        FullOrgUnitInfo org = (FullOrgUnitInfo)this.pmtOrg.getData();
        ArrayList<String> orgIdList = new ArrayList<String>();
        orgIdList.add(org.getId().toString());
        return orgIdList;
    }
}

