/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.client;

import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.framework.cache.ActionCache;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.BaseCommonQueryAppException;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionUtils;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.commonquery.ShareCheckEvent;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonLeftPanel;
import com.kingdee.eas.base.commonquery.client.CommonQueryPanel;
import com.kingdee.eas.base.commonquery.client.ICheckerBeforeShare;
import com.kingdee.eas.base.commonquery.client.IQueryInfoPanel;
import com.kingdee.eas.base.commonquery.client.KDCommonQueryList;
import com.kingdee.eas.base.commonquery.client.SolutionRenamePromptUI;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.uiframe.WorkBenchUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class NewSolutionListPanel
extends KDPanel {
    private static final String commonQueryRes = "com.kingdee.eas.base.commonquery.cqResource";
    private static final Logger logger = Logger.getLogger(NewSolutionListPanel.class);
    private KDList solutionList;
    public static final String MY_SOLUTION_LIST = "mysolutionlist";
    public static final String SHARED_SOLUTION_LIST = "sharedsolutionlist";
    private String solutionListType;
    private CommonLeftPanel commonLeftPanel;
    KDScrollPane pane = new KDScrollPane();
    private CommonQueryPanel commonQueryPanel;
    QuerySolutionCollection cols;
    KDTreeNode solutionRootNode;
    KDTreeNode templateRootNode;
    int BUTTON_HEIGHT = 20;
    int SPACE = 3;

    public NewSolutionListPanel(CommonQueryPanel newCommonQueryPanel, String solutionListType) {
        this.commonQueryPanel = newCommonQueryPanel;
        this.solutionListType = solutionListType;
        this.init();
    }

    public boolean isMySolutionList() {
        return MY_SOLUTION_LIST.equals(this.getSolutionListType());
    }

    public CommonQueryPanel getCommonQueryPanel() {
        return this.commonQueryPanel;
    }

    public void setNewCommonQueryPanel(CommonQueryPanel newCommonQueryPanel) {
        this.commonQueryPanel = newCommonQueryPanel;
    }

    public CommonLeftPanel getCommonLeftPanel() {
        return this.commonLeftPanel;
    }

    public void setCommonLeftPanel(CommonLeftPanel commonLeftPanel) {
        this.commonLeftPanel = commonLeftPanel;
    }

    private void init() {
        this.solutionList = new KDCommonQueryList();
        this.solutionList.setFixedCellHeight(20);
        this.solutionList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3 && e.getClickCount() == 1) {
                    QuerySolutionInfo selectedQuerySolutionInfo = NewSolutionListPanel.this.getSelectedQuerySolutionInfo();
                    if (selectedQuerySolutionInfo == null) {
                        return;
                    }
                    if (!SolutionTypeEnum.SYSTEM_SOLUTION.equals((Object)selectedQuerySolutionInfo.getSolutionType())) {
                        NewSolutionListPanel.this.showPopupMenu(e, selectedQuerySolutionInfo);
                    }
                }
            }
        });
        this.refreshSolutionList();
        this.pane.getViewport().add((Component)this.solutionList, null);
        this.solutionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                try {
                    if (!e.getValueIsAdjusting()) {
                        QuerySolutionInfo solutionInfo = (QuerySolutionInfo)NewSolutionListPanel.this.solutionList.getSelectedValue();
                        if (solutionInfo == null) {
                            return;
                        }
                        NewSolutionListPanel.this.loadSolution(solutionInfo);
                    }
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.setLayout(new BorderLayout());
        int height = this.getCommonQueryPanel().getLeftPanelHeight() - 3 * this.BUTTON_HEIGHT - 3 * this.SPACE;
        this.pane.setPreferredSize(new Dimension(240, height));
        this.add((Component)this.pane, "Center");
    }

    public String getSolutionListType() {
        return this.solutionListType;
    }

    private String getResource(String resName) {
        return EASResource.getString((String)commonQueryRes, (String)resName);
    }

    private void showPopupMenu(MouseEvent e, QuerySolutionInfo selectedQuerySolutionInfo) {
        KDPopupMenu rightButtonMenu = new KDPopupMenu();
        KDMenuItem renameMenu = new KDMenuItem(this.getResource("rename"));
        KDMenuItem sendToMainFrameMenu = new KDMenuItem(this.getResource("sendToConsole"));
        KDMenuItem shareMenu = new KDMenuItem(this.getResource("shareSolution"));
        KDMenuItem saveAsMySolutionMenu = new KDMenuItem(this.getResource("saveAsMySolution"));
        renameMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewSolutionListPanel.this.rename(e);
            }
        });
        sendToMainFrameMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewSolutionListPanel.this.sendToMainFrame(e);
            }
        });
        shareMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewSolutionListPanel.this.shareSolution(e);
            }
        });
        saveAsMySolutionMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewSolutionListPanel.this.saveAsMySolution(e);
            }
        });
        if (this.isMySolution(selectedQuerySolutionInfo)) {
            rightButtonMenu.add((JMenuItem)renameMenu);
        }
        if (MY_SOLUTION_LIST.equals(this.solutionListType)) {
            rightButtonMenu.add((JMenuItem)shareMenu);
        } else if (this.isSaveAsVisible()) {
            rightButtonMenu.add((JMenuItem)saveAsMySolutionMenu);
        }
        rightButtonMenu.show((Component)this.solutionList, e.getX(), e.getY());
    }

    private boolean isSaveAsVisible() {
        return this.getCommonQueryPanel().getCommonQueryUI().getCommonQueryParam().isSaveAsVisible();
    }

    private boolean isMySolution(QuerySolutionInfo solutionInfo) {
        String currentUserId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        return StringUtils.equals((String)currentUserId, (String)solutionInfo.getOwner().toString());
    }

    public void rename(ActionEvent e) {
        ActionCache.clear();
        this.showSolutionDialog();
    }

    public void saveAsMySolution(ActionEvent e) {
        boolean ret;
        ActionCache.clear();
        QuerySolutionInfo querySolutionInfo = this.getSelectedQuerySolutionInfo();
        ShareTypeEnum shareType = ShareTypeEnum.USER_NOORG_LEVEL;
        if (querySolutionInfo.getOrgID() != null) {
            shareType = ShareTypeEnum.USER_LEVEL;
        }
        if (ret = this.saveSolutionToShareType(shareType)) {
            this.getCommonQueryPanel().showInfo(this.getResource("saveAsMySolution") + this.getResource("success"), "info");
        }
        this.getCommonLeftPanel().refreshSolutionList(MY_SOLUTION_LIST);
    }

    private boolean saveSolutionToShareType(ShareTypeEnum toShareType) {
        boolean ret = true;
        QuerySolutionInfo querySolutionInfo = this.getSelectedQuerySolutionInfo();
        QuerySolutionInfo newQuerySolutionInfo = (QuerySolutionInfo)querySolutionInfo.clone();
        try {
            newQuerySolutionInfo.setId(null);
            if (ShareTypeEnum.ORG_LEVEL.equals((Object)toShareType) && ShareTypeEnum.USER_NOORG_LEVEL.equals((Object)newQuerySolutionInfo.getShareType())) {
                newQuerySolutionInfo.setOrgID(null);
            } else {
                newQuerySolutionInfo.setOrgID(QueryUtils.getOrgID(querySolutionInfo.getQueryObjectName(), null));
            }
            newQuerySolutionInfo.setShareType(toShareType);
            newQuerySolutionInfo.setIsUserDefaultSolu(false);
            newQuerySolutionInfo.setOwner(SysContext.getSysContext().getCurrentUserInfo().getId());
            QueryPanelCollection queryPanelCol = newQuerySolutionInfo.getQueryPanelInfo();
            int size = queryPanelCol.size();
            for (int i = 0; i < size; ++i) {
                QueryPanelInfo panelInfo = queryPanelCol.get(i);
                panelInfo.setId(null);
            }
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            iQuerySolution.addnew(newQuerySolutionInfo);
        }
        catch (BaseCommonQueryAppException commException) {
            logger.error((Object)"", (Throwable)((Object)commException));
            ExceptionHandler.handle((Throwable)((Object)commException));
            ret = this.showRenameAfterSameNameDialog(newQuerySolutionInfo);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            ExceptionHandler.handle((Throwable)ex);
            ret = false;
        }
        return ret;
    }

    private boolean showSolutionDialog() {
        boolean isConfirm = false;
        UIContext uiContext = new UIContext();
        uiContext.put((Object)"current_solution", (Object)this.getCommonQueryPanel().getCurrentSolution());
        uiContext.put((Object)"commonquerypanel", (Object)this.getCommonQueryPanel());
        uiContext.put((Object)"newsolutionlistpanel", (Object)this);
        IUIWindow window = null;
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            window = uiFactory.create(SolutionRenamePromptUI.class.getName(), (Map)uiContext, null, "");
            window.show();
            return isConfirm;
        }
        catch (UIException e) {
            logger.error((Object)"", (Throwable)e);
            return isConfirm;
        }
    }

    private boolean showRenameAfterSameNameDialog(QuerySolutionInfo querySolution) {
        boolean isConfirm = false;
        UIContext uiContext = new UIContext();
        uiContext.put((Object)"current_solution", (Object)querySolution);
        uiContext.put((Object)"commonquerypanel", (Object)this.getCommonQueryPanel());
        uiContext.put((Object)"newsolutionlistpanel", (Object)this);
        IUIWindow window = null;
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            window = uiFactory.create(SolutionRenamePromptUI.class.getName(), (Map)uiContext, null, "");
            window.show();
            return isConfirm;
        }
        catch (UIException e) {
            logger.error((Object)"", (Throwable)e);
            return isConfirm;
        }
    }

    public void sendToMainFrame(ActionEvent e) {
        boolean success;
        String uiTitle = this.getCommonQueryPanel().getCommonQueryUI().getUITitle();
        int index = uiTitle.indexOf(" - ");
        if (index > -1) {
            uiTitle = uiTitle.substring(0, index);
        }
        if (success = WorkBenchUtil.publish2WorkBench((QuerySolutionInfo)this.getSelectedQuerySolutionInfo(), (String)uiTitle)) {
            this.getCommonQueryPanel().showInfo(this.getResource("sendToConsole") + this.getResource("success"), "info");
        }
    }

    private boolean checkBeforeShare() {
        ICheckerBeforeShare checker = this.commonQueryPanel.getCommonQueryUI().getCommonQueryParam().getChecker();
        ShareCheckEvent shareCheckEvent = new ShareCheckEvent();
        shareCheckEvent.setQuerySolutionInfo(this.getSelectedQuerySolutionInfo());
        boolean isCheckSuccess = true;
        if (checker != null) {
            isCheckSuccess = checker.checkBeforeShare(shareCheckEvent);
        }
        return isCheckSuccess;
    }

    public void shareSolution(ActionEvent e) {
        if (!this.checkBeforeShare()) {
            return;
        }
        boolean ret = this.saveSolutionToShareType(ShareTypeEnum.ORG_LEVEL);
        if (ret) {
            this.getCommonQueryPanel().showInfo(this.getResource("shareSolution") + this.getResource("success"), "info");
        }
        this.getCommonLeftPanel().refreshSolutionList(SHARED_SOLUTION_LIST);
    }

    public void setSelected(QuerySolutionInfo info) {
        if (info != null) {
            ListModel model = this.solutionList.getModel();
            int size = model.getSize();
            for (int i = 0; i < size; ++i) {
                QuerySolutionInfo solutionInfo = (QuerySolutionInfo)model.getElementAt(i);
                if (!StringUtils.equals((String)StringUtils.cnulls((Object)solutionInfo.getId()), (String)StringUtils.cnulls((Object)info.getId()))) continue;
                this.solutionList.setSelectedIndex(i);
                this.solutionList.ensureIndexIsVisible(i);
            }
        }
    }

    private void resetTablePanels() {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        if (commonQueryPanel.getCommonTablePanel() != null) {
            commonQueryPanel.getCommonTablePanel().clear();
        }
    }

    private void resetUserPanels() {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        Collection panels = commonQueryPanel.getPanels().values();
        for (KDPanel tempPanel : panels) {
            if (!(tempPanel instanceof IQueryInfoPanel)) continue;
            ((IQueryInfoPanel)tempPanel).clear();
        }
    }

    private void resetFilterPanel() {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        if (commonQueryPanel.isShowFilter() && commonQueryPanel.getCommonFilterPanel() != null) {
            commonQueryPanel.getCommonFilterPanel().clear();
        }
    }

    private void resetSorterPanel() {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        if (commonQueryPanel.isShowSorter() && commonQueryPanel.getCommonSorterPanel() != null) {
            commonQueryPanel.getCommonSorterPanel().clear();
        }
    }

    private void initAllowSystemSolution(boolean allow) {
        if (this.commonQueryPanel != null) {
            this.commonQueryPanel.setDefaultViewSelectEnable(allow);
        }
    }

    public void loadSolution(QuerySolutionInfo querySolutionInfo) throws Exception {
        if (querySolutionInfo == null) {
            return;
        }
        if (querySolutionInfo.getId() != null && SolutionTypeEnum.SYSTEM_SOLUTION != querySolutionInfo.getSolutionType() && (querySolutionInfo = QuerySolutionUtils.getFullQuerySolution(null, querySolutionInfo.getId().toString())) == null) {
            this.refreshSolutionList();
            this.selectDefaultSolution();
            return;
        }
        this.solutionList.setElement((Object)querySolutionInfo, this.solutionList.getSelectedIndex());
        if (this.commonQueryPanel.getCurrentSolution() != null && ToolUtils.equalObject((Object)querySolutionInfo.getId(), (Object)this.commonQueryPanel.getCurrentSolution().getId())) {
            return;
        }
        this.resetSorterPanel();
        if (SolutionTypeEnum.SYSTEM_SOLUTION.equals((Object)querySolutionInfo.getSolutionType())) {
            this.resetUserPanels();
            this.resetFilterPanel();
            this.resetTablePanels();
            this.initAllowSystemSolution(this.commonQueryPanel.isAllowSystemSolutionAsDefaultFilter());
        } else {
            this.initAllowSystemSolution(true);
        }
        if (querySolutionInfo != null) {
            this.getCommonQueryPanel().loadSolutionInfo(querySolutionInfo);
            this.changeUIStatusByOwner(querySolutionInfo);
        }
        this.commonQueryPanel.getCommonQueryUI().handleSysDynQuerySolution();
    }

    private void changeUIStatusByOwner(QuerySolutionInfo querySolutionInfo) {
        String userid = querySolutionInfo.getOwner().toString();
        boolean isOwned = userid.equals(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        if (this.isMySolutionList()) {
            this.commonQueryPanel.setDefaultViewSelected(isOwned && querySolutionInfo.isIsUserDefaultSolu());
            this.commonQueryPanel.setDefaultViewSelectEnable(isOwned);
        }
        boolean isSystemSolution = SolutionTypeEnum.SYSTEM_SOLUTION.equals((Object)querySolutionInfo.getSolutionType());
        this.getCommonLeftPanel().setDeleteButtonEnable(!isSystemSolution);
    }

    private QuerySolutionCollection getQuerySolutionCol() {
        if (!this.isMySolutionList()) {
            return this.getSharedQuerySolutions();
        }
        QuerySolutionCollection ret = new QuerySolutionCollection();
        QuerySolutionInfo setedSolution = this.getCommonQueryPanel().getCommonQueryUI().getQSolutionInfo();
        if (setedSolution != null) {
            ret = new QuerySolutionCollection();
            ret.add(setedSolution);
            return ret;
        }
        ret = this.getMyQuerySolutions();
        QuerySolutionInfo defaultSolution = this.getDefaultSolution(ret = QuerySolutionUtils.justOneDefaultSolutionVisible(ret));
        if (defaultSolution == null) {
            try {
                defaultSolution = this.createSysDefaultSolutionInfo();
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                ExceptionHandler.handle((Throwable)e);
            }
            ret.add(defaultSolution);
        }
        ret = QuerySolutionUtils.getSortedSolutionCol(null, ret);
        return ret;
    }

    protected void refreshSolutionList() {
        this.solutionList.removeAllElements();
        this.cols = this.getQuerySolutionCol();
        this.addQuerySolutionCol(this.cols);
    }

    public void reloadSolutionList(QuerySolutionCollection querySolutionCol, QuerySolutionInfo solutionInfo) {
        if (querySolutionCol == null || querySolutionCol.size() < 1) {
            return;
        }
        this.solutionList.removeAllElements();
        this.cols = querySolutionCol;
        this.addQuerySolutionCol(querySolutionCol);
        QuerySolutionInfo defaultSelectSolution = solutionInfo != null ? solutionInfo : QuerySolutionUtils.getDefaultSelectSolution(null, this.cols);
        if (defaultSelectSolution != null) {
            this.setSelected(defaultSelectSolution);
        }
    }

    public void selectDefaultSolution() {
        QuerySolutionInfo defaultSelectSolution = QuerySolutionUtils.getDefaultSelectSolution(null, this.cols);
        this.setSelected(defaultSelectSolution);
    }

    public void setSelectedDefaultSolution() {
        QuerySolutionInfo info = this.commonQueryPanel.getCommonQueryUI().getCommonQueryParam().getCurrentSolutionInfo();
        QuerySolutionInfo defaultSelectSolution = info != null ? info : QuerySolutionUtils.getDefaultSelectSolution(null, this.cols);
        this.setSelected(defaultSelectSolution);
    }

    private void addQuerySolutionCol(QuerySolutionCollection querySolutionCol) {
        Icon icon = EASResource.getIcon((String)"imgTree_public");
        Icon managedSolutionIcon = EASResource.getIcon((String)"imgTbtn_userview");
        Icon userIcon = EASResource.getIcon((String)"imgTbtn_distribute");
        int size = querySolutionCol.size();
        for (int i = 0; i < size; ++i) {
            QuerySolutionInfo info = querySolutionCol.get(i);
            this.solutionList.addElement((Object)info);
            if (this.isMySolutionList() && !this.isMySolution(info)) {
                this.solutionList.setElementIcon(managedSolutionIcon, (Object)info);
                continue;
            }
            if (info.getShareType() == ShareTypeEnum.USER_NOORG_LEVEL || info.getShareType() == ShareTypeEnum.PUBLIC_LEVEL) {
                this.solutionList.setElementIcon(icon, (Object)info);
                continue;
            }
            this.solutionList.setElementIcon(userIcon, (Object)info);
        }
    }

    private QuerySolutionInfo createSysDefaultSolutionInfo() throws Exception {
        String queryName = this.commonQueryPanel.getQueryInfo().getFullName();
        String parentUIName = this.commonQueryPanel.getParentUIClassName();
        return QuerySolutionUtils.createSysDefaultSolutionInfo(null, parentUIName, queryName);
    }

    private QuerySolutionInfo getDefaultSolution(QuerySolutionCollection coll) {
        if (coll == null) {
            return null;
        }
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            QuerySolutionInfo info = coll.get(i);
            if (!SolutionTypeEnum.SYSTEM_SOLUTION.equals((Object)info.getSolutionType())) continue;
            return coll.get(i);
        }
        return null;
    }

    protected QuerySolutionCollection getMyQuerySolutions() {
        String queryName = this.commonQueryPanel.getQueryPK().getFullName();
        String parentUI = this.commonQueryPanel.getParentUIClassName();
        QuerySolutionCollection ret = null;
        try {
            ret = QuerySolutionUtils.getUserAndUserOrgQuerySolutions(null, parentUI, queryName);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            ret = new QuerySolutionCollection();
            ExceptionHandler.handle((Throwable)e);
        }
        return ret;
    }

    protected QuerySolutionCollection getSharedQuerySolutions() {
        String queryName = this.commonQueryPanel.getQueryInfo().getFullName();
        String parentUI = this.commonQueryPanel.getParentUIClassName();
        QuerySolutionCollection ret = null;
        try {
            ret = QuerySolutionUtils.getOrgSharedQuerySolutions(null, parentUI, queryName);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            ret = new QuerySolutionCollection();
            ExceptionHandler.handle((Throwable)e);
        }
        return ret;
    }

    protected QuerySolutionInfo getSelectedQuerySolutionInfo() {
        return (QuerySolutionInfo)this.solutionList.getSelectedValue();
    }

    public QuerySolutionCollection getAllSolutionCollection() {
        QuerySolutionCollection coll = new QuerySolutionCollection();
        ListModel model = this.solutionList.getModel();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            QuerySolutionInfo solutionInfo = (QuerySolutionInfo)model.getElementAt(i);
            coll.add(solutionInfo);
        }
        return coll;
    }
}

