/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.PermissionChecker;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryPanel;
import com.kingdee.eas.base.commonquery.client.CommonQueryUI;
import com.kingdee.eas.base.commonquery.client.IQueryInfoPanel;
import com.kingdee.eas.base.commonquery.client.KDCommonQueryList;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SolutionListPanel
extends KDPanel {
    private static final String commonQueryRes = "com.kingdee.eas.base.commonquery.client.CommonQueryPanel";
    private KDList solutionList;
    private static HashMap userNumbers = new HashMap(2);

    public SolutionListPanel() {
        this.init();
    }

    private void init() {
        KDScrollPane pane = new KDScrollPane();
        this.solutionList = new KDCommonQueryList();
        pane.getViewport().add((Component)this.solutionList, null);
        this.setLayout(new BorderLayout());
        this.add((Component)pane, "Center");
        this.solutionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                try {
                    if (!e.getValueIsAdjusting()) {
                        SolutionListPanel.this.solutionListClicked(e);
                    }
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
    }

    private void setDefaultSolutionAsCurrentSolution() {
        if (this.getCommonQueryPanel().getCustomerQueryPanel().size() == 0) {
            this.getCommonQueryPanel().getSolutionListPanel().refreshSolutionList();
            this.solutionList.setSelectedIndex(0);
            this.solutionList.repaint();
        }
    }

    private void solutionListClicked(ListSelectionEvent e) throws Exception {
        if (this.solutionList.getSelectedValue() != null && ((QuerySolutionInfo)this.solutionList.getSelectedValue()).getName() != null) {
            this.resetSorterPanel();
            if (this.solutionList.getSelectedValue().toString().equals(EASResource.getString((String)commonQueryRes, (String)"sysDefaultRule"))) {
                this.resetToolBar();
                this.resetUserPanels();
                this.resetFilterPanel();
                this.resetTablePanels();
            }
        }
        this.loadSolution(e);
        CommonQueryUI commonQueryUI = (CommonQueryUI)((Object)Util.getComponent((Component)((Object)this), CommonQueryUI.class.getName()));
        if (commonQueryUI != null) {
            commonQueryUI.handleSysDynQuerySolution();
        }
    }

    private void resetToolBar() {
    }

    private void resetTablePanels() {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        if (commonQueryPanel.getCommonTablePanel() != null) {
            commonQueryPanel.getCommonTablePanel().clear();
        }
    }

    private void resetUserPanels() {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        Collection panels = commonQueryPanel.getPanels().values();
        for (KDPanel tempPanel : panels) {
            if (!(tempPanel instanceof IQueryInfoPanel)) continue;
            ((IQueryInfoPanel)tempPanel).clear();
        }
    }

    private void resetFilterPanel() {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        if (commonQueryPanel.isShowFilter() && commonQueryPanel.getCommonFilterPanel() != null) {
            commonQueryPanel.getCommonFilterPanel().clear();
        }
    }

    private void resetSorterPanel() {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        if (commonQueryPanel.isShowSorter() && commonQueryPanel.getCommonSorterPanel() != null) {
            commonQueryPanel.getCommonSorterPanel().clear();
        }
    }

    private void loadSolution(ListSelectionEvent e) throws Exception {
        QuerySolutionInfo querySolutionInfo = (QuerySolutionInfo)this.solutionList.getSelectedValue();
        if (querySolutionInfo != null) {
            this.getCommonQueryPanel().loadSolutionInfo(querySolutionInfo);
            this.changeUIStatusByOwner(querySolutionInfo);
        }
    }

    private void changeUIStatusByOwner(QuerySolutionInfo querySolutionInfo) {
        boolean hasQueryManagePerm = PermissionChecker.hasEditOtherCQSolutionPerm(null);
        boolean isSystemSolution = SolutionTypeEnum.SYSTEM_SOLUTION.equals((Object)querySolutionInfo.getSolutionType());
        ShareTypeEnum shareType = querySolutionInfo.getShareType();
        String userid = querySolutionInfo.getOwner().toString();
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        boolean isOwned = userid.equals(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        if (ShareTypeEnum.ORG_LEVEL.equals((Object)shareType)) {
            commonQueryPanel.getConfirmButton().setEnabled(true);
        } else {
            commonQueryPanel.getConfirmButton().setEnabled(isOwned);
        }
        commonQueryPanel.setDefaultViewSelected(isOwned && querySolutionInfo.isIsUserDefaultSolu());
        commonQueryPanel.setDefaultViewSelectEnable(isOwned);
    }

    public QuerySolutionInfo getQuerySolutionInfo(QuerySolutionInfo querySolutionInfo) throws BOSException, EASBizException {
        if (querySolutionInfo != null) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)querySolutionInfo.getId().toString()));
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            SelectorItemCollection coll = new SelectorItemCollection();
            coll.add(new SelectorItemInfo("*"));
            coll.add(new SelectorItemInfo("dynQuery.id"));
            coll.add(new SelectorItemInfo("dynQuery.number"));
            coll.add(new SelectorItemInfo("dynQuery.name"));
            coll.add(new SelectorItemInfo("dynQuery.deletedStatus"));
            coll.add(new SelectorItemInfo("QueryPanelInfo.*"));
            coll.add(new SelectorItemInfo("QueryPanelInfo.id"));
            coll.add(new SelectorItemInfo("QueryPanelInfo.queryPanelType"));
            return iQuerySolution.getQuerySolutionInfo((IObjectPK)pk, coll);
        }
        return null;
    }

    protected void setSelected(QuerySolutionInfo info) {
        if (info != null) {
            ListModel model = this.solutionList.getModel();
            int size = model.getSize();
            for (int i = 0; i < size; ++i) {
                QuerySolutionInfo solutionInfo = (QuerySolutionInfo)model.getElementAt(i);
                if (!solutionInfo.getId().equals((Object)info.getId())) continue;
                this.solutionList.setSelectedIndex(i);
            }
        }
    }

    public QuerySolutionCollection getAllSolutionCollection() {
        QuerySolutionCollection coll = new QuerySolutionCollection();
        ListModel model = this.solutionList.getModel();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            QuerySolutionInfo solutionInfo = (QuerySolutionInfo)model.getElementAt(i);
            coll.add(solutionInfo);
        }
        return coll;
    }

    protected QuerySolutionInfo getSelectedQuerySolutionInfo() {
        return (QuerySolutionInfo)this.solutionList.getSelectedValue();
    }

    protected void refreshSolutionList() {
    }

    protected void refreshSolutionList(QuerySolutionCollection querySolutionCollection) {
        this.solutionList.removeAllElements();
        Icon icon = EASResource.getIcon((String)"imgTree_public");
        Iterator it = querySolutionCollection.iterator();
        QuerySolutionInfo qsinfo = null;
        while (it.hasNext()) {
            qsinfo = (QuerySolutionInfo)it.next();
            if ("10".equals(qsinfo.getSolutionType().getValue())) {
                this.solutionList.insertElement((Object)qsinfo, 0);
            } else {
                this.solutionList.addElement((Object)qsinfo);
            }
            this.solutionList.setElementIcon(icon, (Object)qsinfo);
        }
    }

    private CommonQueryPanel getCommonQueryPanel() {
        return (CommonQueryPanel)((Object)Util.getComponent((Component)((Object)this), CommonQueryPanel.class.getName()));
    }
}

