/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.upgrade;

import com.kingdee.eas.base.commonquery.upgrade.ClassPathNoWin;
import com.kingdee.eas.base.commonquery.upgrade.CreateClassPathJar;
import com.kingdee.eas.base.commonquery.upgrade.DBConnection;
import com.kingdee.eas.base.commonquery.upgrade.StreamPumper;
import com.kingdee.eas.base.commonquery.upgrade.UpgradeSolution;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class UpgradeUtil {
    private static final Logger logger = Logger.getLogger((String)UpgradeUtil.class.getName());

    public static void upgradeSolution(String eas_home, DBConnection dbconn) {
        Runtime runtime = Runtime.getRuntime();
        StringBuffer c = new StringBuffer();
        String java_home = System.getProperty("java.home");
        c.append(java_home + "/bin/java -classpath ");
        if ("\\".equals(File.separator)) {
            CreateClassPathJar.create(eas_home);
            c.append(eas_home + "/upgrade1_classpath.jar;");
            c.append(eas_home + "/upgrade2_classpath.jar;");
            c.append(eas_home + "/upgrade3_classpath.jar");
        } else {
            c.append(ClassPathNoWin.getJarPath(eas_home));
        }
        if ("MS SqlServer".equals(dbconn.getDbType())) {
            dbconn.setDbType("SqlServer");
        }
        c.append(" ").append(UpgradeSolution.class.getName());
        c.append(" ").append(dbconn.getDbType()).append(" ").append(dbconn.getHost()).append(" ").append(String.valueOf(dbconn.getPort())).append(" ").append(dbconn.getDbName()).append(" ").append(dbconn.getUser()).append(" ").append(dbconn.getPassword()).append(" ").append(eas_home);
        logger.info((Object)("java command:--" + c));
        try {
            String os = System.getProperty("os.name");
            logger.info((Object)("---current OS---" + os));
            if (os != null && os.toLowerCase(Locale.ENGLISH).startsWith("aix")) {
                String ncargs = UpgradeUtil.getResultWithAIX(runtime, UpgradeUtil.getQueryCommand());
                if (ncargs == null) {
                    logger.error((Object)"---arg is null,upgrade fail---");
                    return;
                }
                String size = null;
                String[] arg = ncargs.split("\\s{1,}");
                if (arg.length > 1) {
                    size = arg[1];
                }
                if (size == null) {
                    logger.error((Object)"----size is null ,upgrade fail ---");
                    return;
                }
                if (30 >= Integer.parseInt(size)) {
                    UpgradeUtil.getResultWithAIX(runtime, UpgradeUtil.getUpdateCommand("30"));
                    runtime.exec(c.toString());
                    UpgradeUtil.getResultWithAIX(runtime, UpgradeUtil.getUpdateCommand(size));
                } else {
                    runtime.exec(c.toString());
                }
            } else {
                runtime.exec(c.toString());
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    private static String[] getQueryCommand() {
        return "/usr/sbin/lsattr -E -l sys0 -a ncargs".split("\\s{1,}");
    }

    private static String[] getUpdateCommand(String arg) {
        return ("chdev -l sys0 -a ncargs=" + arg).split("\\s{1,}");
    }

    private static String getResultWithAIX(Runtime runtime, String[] command) throws IOException {
        String result = null;
        Process process = runtime.exec(command);
        for (int i = 0; i < command.length; ++i) {
            logger.info((Object)("----change buffer command:" + command[i]));
        }
        StreamPumper ssperr = new StreamPumper(process.getErrorStream(), true);
        StreamPumper ssp = new StreamPumper(process.getInputStream(), false);
        ssperr.start();
        ssp.start();
        while (ssp.isPumping()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        result = ssp.getResult();
        if (result == null || "".equals(result)) {
            result = ssperr.getResult();
        }
        logger.info((Object)("----result---" + result));
        return result;
    }
}

