/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.xbrlBuild.assembler.voucher;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.base.evs.app.elcertificate.InvoiceVoucherEntryCollection;
import com.kingdee.eas.base.evs.app.elcertificate.InvoiceVoucherEntryInfo;
import com.kingdee.eas.base.evs.app.elcertificate.TlfInvoiceCollection;
import com.kingdee.eas.base.evs.app.elcertificate.TlfInvoiceFactory;
import com.kingdee.eas.base.evs.app.elcertificate.TlfInvoiceInfo;
import com.kingdee.eas.base.evs.util.AS;
import com.kingdee.eas.base.evs.util.HttpClientUtil;
import com.kingdee.eas.base.evs.util.OfdUtil;
import com.kingdee.eas.base.evs.util.SQLUtils;
import com.kingdee.eas.base.evs.util.XbrlAssemblerUtil;
import com.kingdee.eas.base.evs.xbrlBuild.AbstractEVSInfo;
import com.kingdee.eas.base.evs.xbrlBuild.EVSInfo;
import com.kingdee.eas.base.evs.xbrlBuild.IssuerXbrl;
import com.kingdee.eas.base.evs.xbrlBuild.ReceiverJson;
import com.kingdee.eas.base.evs.xbrlBuild.ReceiverXbrl;
import com.kingdee.eas.base.evs.xbrlBuild.assembler.ICompanyAssembler;
import com.kingdee.eas.base.evs.xbrlBuild.assembler.IssureInputStreamFactory;
import com.kingdee.eas.base.evs.xbrlBuild.assembler.IssureInputStreamable;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TlfXbrlAssembler
implements ICompanyAssembler,
IssureInputStreamable {
    private static Logger logger = Logger.getLogger((String)TlfXbrlAssembler.class.getName());

    @Override
    public IObjectCollection getOriDataCollection(Context ctx, String companyPk, int year, int month, Map<String, Object> otherParam) throws BOSException, EASBizException {
        String oql = "select *,voucherEntry.voucherId where periodYear = " + year + " and periodNumber = " + month + " and creditCode = '" + companyPk + "'";
        TlfInvoiceCollection tlfInvoiceCollection = TlfInvoiceFactory.getLocalInstance((Context)ctx).getTlfInvoiceCollection(oql);
        if (otherParam.containsKey("voucherIds") && otherParam.get("voucherIds") instanceof List) {
            List list = (List)otherParam.get("voucherIds");
            for (int i = 0; i < tlfInvoiceCollection.size(); ++i) {
                TlfInvoiceInfo info = tlfInvoiceCollection.get(i);
                InvoiceVoucherEntryCollection voucherEntry = info.getVoucherEntry();
                boolean isContains = false;
                for (int j = 0; j < voucherEntry.size(); ++j) {
                    if (!list.contains(voucherEntry.get(j).getVoucherId())) continue;
                    isContains = true;
                    break;
                }
                if (isContains) continue;
                tlfInvoiceCollection.removeObject(i);
                --i;
            }
        }
        return tlfInvoiceCollection;
    }

    public IObjectCollection getOriDataCollection(Context ctx, List<String> uniqueCodes) throws Exception {
        return TlfInvoiceFactory.getLocalInstance((Context)ctx).getTlfInvoiceCollection("where uniqueCode in (" + SQLUtils.getSQL(uniqueCodes) + "");
    }

    @Override
    public Map<String, Map<String, Map<String, List<EVSInfo>>>> createEVSInfo(Context ctx, IObjectCollection colls, Map<String, Object> otherParam) throws EASBizException {
        HashMap<String, Map<String, Map<String, List<EVSInfo>>>> result = new HashMap<String, Map<String, Map<String, List<EVSInfo>>>>();
        TlfInvoiceCollection tlfs = (TlfInvoiceCollection)colls;
        List fileTypes = new ArrayList();
        List voucherLists = new ArrayList();
        if (otherParam.containsKey("voucherIds") && otherParam.get("voucherIds") instanceof List) {
            voucherLists = (List)otherParam.get("voucherIds");
        }
        if (otherParam.containsKey("fileTypes") && otherParam.get("fileTypes") instanceof List) {
            fileTypes = (List)otherParam.get("fileTypes");
        }
        for (int i = 0; i < tlfs.size(); ++i) {
            TlfInvoiceInfo info = tlfs.get(i);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("UniqueCodeOfInvoice", (Object)info.getUniqueCode());
            jsonObject.put("NameOfSeller", (Object)info.getNameOfSeller());
            jsonObject.put("TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller", (Object)info.getCreditCodeOfSeller());
            jsonObject.put("TotalAmountExcludingTax", (Object)info.getAmountExTax());
            jsonObject.put("TotalTaxAmount", (Object)info.getTaxAmount());
            jsonObject.put("TaxIncludedAmountInFigures", (Object)info.getTaxAmoInfigures());
            jsonObject.put("DateOfIssue", (Object)info.getDateOfIssue());
            jsonObject.put("WhetherInvoiceIsRedInvoice", (Object)info.getRedInvoice());
            jsonObject.put("WhetherInvoiceHasBeenChecked", (Object)info.getHasBeenChecked());
            jsonObject.put("WhetherInvoiceUsageHasBeenConfirmed", (Object)AS.valueOf(info.getConfirmedUse(), "false"));
            jsonObject.put("UsageConfirmation", (Object)AS.valueOf(info.getUsage(), ""));
            jsonObject.put("PeriodOfUsageConfirmation", (Object)AS.valueOf(info.getUsagePeriod(), ""));
            jsonObject.put("WhetherInvoiceHasBeenBooked", (Object)AS.valueOf(info.getHasBeenBooked(), "true"));
            jsonObject.put("WhetherInvoiceHasBeenPaid", (Object)info.getPaid());
            jsonObject.put("NumberOfBankElectronicReceipt", (Object)info.getBankEleReceiptNum());
            jsonObject.put("WhetherInputVatHasBeenTransferredOut", (Object)AS.valueOf(info.getIsInputVatTransOut(), "false"));
            jsonObject.put("AmountOfTransferredOutInputVat", (Object)AS.valueOf(info.getTranOutInputVat(), ""));
            jsonObject.put("BeginningOfExpenditurePeriodUnderAccrualBasis", (Object)info.getExpPeriodBegin());
            jsonObject.put("EndOfExpenditurePeriodUnderAccrualBasis", (Object)info.getExpPeriodEnd());
            jsonObject.put("WhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted", (Object)info.getPreTaxDeduction());
            jsonObject.put("BeginningOfPreTaxDeductionYearOfIncomeTax", (Object)info.getPretaxdudectBeginyear());
            jsonObject.put("EndOfPreTaxDeductionYearOfIncomeTax", (Object)info.getPretaxdudectEndyear());
            jsonObject.put("UnifiedSocialCreditCodeOfAccountingEntity", (Object)info.getCreditCode());
            jsonObject.put("NameOfAccountingEntity", (Object)info.getAccountName());
            JSONArray voucherArrInfo = JSONArray.parseArray((String)info.getVoucher());
            for (Map.Entry entry : jsonObject.entrySet()) {
                if (entry.getValue() != null) continue;
                entry.setValue("");
            }
            InvoiceVoucherEntryCollection voucherEntry = info.getVoucherEntry();
            String issuerDate = info.getDateOfIssue().replace("-", "");
            for (int j = 0; j < voucherEntry.size(); ++j) {
                InvoiceVoucherEntryInfo entryInfo = voucherEntry.get(j);
                String voucherId = entryInfo.getVoucherId();
                if (!voucherLists.contains(voucherId)) continue;
                if (!result.containsKey(voucherId)) {
                    HashMap map = new HashMap();
                    map.put("inv_tlf", new HashMap());
                    result.put(voucherId, map);
                }
                Map typeMap = (Map)((Map)result.get(voucherId)).get("inv_tlf");
                ArrayList<AbstractEVSInfo> evsInfos = new ArrayList<AbstractEVSInfo>();
                typeMap.put(info.getUniqueCode(), evsInfos);
                jsonObject.put("InformationOfAccountingDocumentsTuple", (Object)voucherArrInfo.getJSONObject(j));
                String postDate = XbrlAssemblerUtil.getPostDate(voucherArrInfo.getJSONObject(j));
                if (fileTypes.contains("receiverJson")) {
                    ReceiverJson receiverJson = new ReceiverJson("inv_tlf_receiver_" + postDate + "_" + info.getUniqueCode() + ".json", new ByteArrayInputStream(jsonObject.toJSONString().getBytes()), "inv_tlf", postDate, jsonObject.toJSONString());
                    evsInfos.add(receiverJson);
                }
                if (fileTypes.contains("receiverXbrl")) {
                    ReceiverXbrl receiverXbrl = new ReceiverXbrl("inv_tlf_receiver_" + postDate + "_" + info.getUniqueCode() + ".xml", new ByteArrayInputStream(OfdUtil.json2Xbrl(jsonObject, this.getCinfigId()).getBytes()), "inv_tlf", postDate);
                    evsInfos.add(receiverXbrl);
                }
                if (!fileTypes.contains("issuerXbrl")) continue;
                ArrayList<String> urls = new ArrayList<String>(1);
                urls.add(info.getIssureXbrlUrl());
                Map<String, Object> is = IssureInputStreamFactory.getInstance(ctx, "inv_tlf").getIs(ctx, urls);
                IssuerXbrl issuerXbrl = new IssuerXbrl(StringUtils.isEmpty((String)info.getIssureXbrlName()) ? "inv_tlf_issuer_" + issuerDate + "_" + info.getUniqueCode() + ".xml" : info.getIssureXbrlName(), is == null ? null : (InputStream)is.get(info.getIssureXbrlUrl()), "inv_tlf", issuerDate);
                evsInfos.add(issuerXbrl);
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> getIs(Context ctx, List<String> url) {
        if (url.isEmpty() || !HttpClientUtil.checkUrl(url.get(0))) {
            return null;
        }
        try {
            URLConnection connection = new URL(url.get(0)).openConnection();
            connection.setConnectTimeout(2000);
            connection.setReadTimeout(2000);
            InputStream in = connection.getInputStream();
            HashMap<String, Object> result = new HashMap<String, Object>(1);
            result.put(url.get(0), in);
            return result;
        }
        catch (Exception e) {
            logger.error((Object)("\u62ff\u4e0d\u5230\u6587\u4ef6\u4fe1\u606f\uff1a" + url), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getCinfigId() {
        return "inv_tlf_receiver";
    }
}

