/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.rpa.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.eas.base.rpa.util.WebUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class OapiTest {
    private static final SimpleDateFormat SDF = new SimpleDateFormat("ss mm HH dd MM ? yyyy");
    private static final int DELAY_MINUTE = 1;

    public static void main(String[] args) throws Exception {
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        String accesstoken = OapiTest.getYsqToken();
        String[] sing = OapiTest.buildSing(accesstoken, params);
        String signature = null;
        String timestamp = null;
        if (sing.length > 0) {
            signature = sing[1];
            timestamp = sing[0];
        }
        String url = "https://127.0.0.1/oapi/v1/process";
        String response = WebUtil.sendGetRequest(url, accesstoken, timestamp, signature);
        System.out.println(response);
    }

    private static String getYsqToken() throws Exception {
        String url = "https://127.0.0.1/oapi/v1/token?accessKey=ad7e4f2b-c207-41f1-9445-a5c978d0357b&secretKey=28349292-d844-4348-9bb8-771c78a5dc92";
        String result = WebUtil.sendGetRequest(url, null, null, null);
        JSONObject resultJson = (JSONObject)JSON.parse((String)result);
        return resultJson.getJSONObject("result").getString("access_token");
    }

    private static String specialUrlEncode(String url) throws UnsupportedEncodingException {
        return URLEncoder.encode(url, "UTF8").replace("+", "%20").replace("*", "%2A").replace("~", "%7E");
    }

    private static String buildQueryString(SortedMap<String, Object> parameters) {
        if (!parameters.isEmpty()) {
            Iterator<String> it = parameters.keySet().iterator();
            StringBuilder queryString = new StringBuilder();
            while (it.hasNext()) {
                String name = it.next();
                queryString.append("&").append(name).append('=').append(parameters.get(name));
            }
            return queryString.substring(1);
        }
        return "";
    }

    public static String[] buildSing(String accesstoken, TreeMap<String, Object> params) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(OapiTest.buildQueryString(params));
        if (sb.length() > 0) {
            sb.append("&");
        }
        long c = Calendar.getInstance().getTimeInMillis();
        sb.append("timestamp=").append(c);
        System.out.println("timestamp=" + c);
        System.out.println("\u6e90\u4e32:" + sb.toString());
        String splice = OapiTest.specialUrlEncode(sb.toString());
        System.out.println("splice:::: " + splice);
        String key256 = accesstoken;
        splice = OapiTest.HMACSHA256StrByKey(splice, key256);
        System.out.println("splice hmac:::: " + splice);
        String signature = Base64.encodeBase64String((byte[])splice.getBytes("UTF-8"));
        signature = signature.replaceAll("\r|\n", "");
        System.out.println("signature:" + signature);
        String[] str = new String[]{String.valueOf(c), signature};
        return str;
    }

    public static String HMACSHA256StrByKey(String data, String key) throws Exception {
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
        sha256_HMAC.init(secret_key);
        byte[] array = sha256_HMAC.doFinal(data.getBytes("UTF-8"));
        StringBuilder sb = new StringBuilder();
        byte[] var6 = array;
        int var7 = array.length;
        for (int var8 = 0; var8 < var7; ++var8) {
            byte item = var6[var8];
            sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString();
    }

    public static String scheduleExpre() {
        Date date = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(12, 1);
        date = c.getTime();
        return SDF.format(date);
    }
}

