/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.client;

import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.uiframe.client.BodyUI;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.wssc.PiaoFacadeFactory;
import com.kingdee.eas.base.wssc.client.AbstractInvoiceBillViewUI;
import com.kingdee.eas.base.wssc.client.SWTSwitchUtil;
import com.kingdee.eas.base.wssc.piao.pojo.PiaoBillInfo;
import com.kingdee.eas.base.wssc.piao.pwy.PwyConnectUtil;
import com.kingdee.eas.base.wssc.piao.pwy.PwyMessage;
import com.kingdee.eas.base.wssc.piao.pwy.PwyMessageEvent;
import com.kingdee.eas.base.wssc.piao.pwy.PwyMessageListener;
import com.kingdee.eas.base.wssc.piao.util.InvoiceGuiUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public class InvoiceBillViewUI
extends AbstractInvoiceBillViewUI {
    private static final long serialVersionUID = 3245691206893729340L;
    private static final Logger logger = CoreUIObject.getLogger(InvoiceBillViewUI.class);
    public JWebBrowser browser;
    private String url;
    public UIContext uiContext;
    private static String tokenStr;
    private static String keyStr;
    private static String apiPiaoZoneUrl;
    private Thread invoiceRecThread = null;
    private static PwyConnectUtil connectUtil;
    private static PiaoBillInfo baseInfo;

    public InvoiceBillViewUI() throws Exception {
        InvoiceGuiUtil.loadComponent();
    }

    public UIContext getUIContext() {
        if (this.uiContext == null) {
            this.uiContext = new UIContext((Object)this);
            this.uiContext.putAll(super.getUIContext());
        }
        return this.uiContext;
    }

    @Override
    public void initUIContentLayout() {
        this.browser = new JWebBrowser(SWTSwitchUtil.getNSOptions());
        this.browser.setJavascriptEnabled(true);
        this.browser.setEnabled(true);
        this.browser.setBarsVisible(false);
        this.browser.setDefaultPopupMenuRegistered(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.browser);
    }

    public static InvoiceBillViewUI getCurrentUI(UIContext uiContext) {
        if (uiContext == null) {
            return null;
        }
        if (uiContext.get((Object)"Owner") instanceof NewMainFrame) {
            NewMainFrame frame = (NewMainFrame)uiContext.get((Object)"Owner");
            BodyUI bodyUI = frame.getMainUI().getBodyUI();
            return (InvoiceBillViewUI)((Object)bodyUI.getMessageComponent(bodyUI.getCurTabIndex()));
        }
        return null;
    }

    public static void hideCurrentUIBrowser(UIContext uiContext) {
        InvoiceBillViewUI.hideBrowser(InvoiceBillViewUI.getCurrentUI(uiContext));
    }

    public static void hideBrowser(InvoiceBillViewUI UI) {
        if (UI != null) {
            UI.browser.setVisible(false);
        }
    }

    public static void showBrowser(InvoiceBillViewUI UI) {
        if (UI != null) {
            UI.browser.setVisible(true);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionPrint.setVisible(false);
        this.actionPrintPreView.setVisible(false);
        this.actionSelected.setVisible(false);
        this.actionSelected.setEnabled(false);
        String actionType = (String)this.getUIContext().get((Object)"action");
        Object bill = this.getUIContext().get((Object)"bill");
        if (bill instanceof CoreBillBaseInfo) {
            PiaoBillInfo piaoInfo = new PiaoBillInfo();
            piaoInfo.setCoreBillBaseInfo((CoreBillBaseInfo)bill);
            baseInfo = piaoInfo;
        } else if (bill instanceof PiaoBillInfo) {
            baseInfo = (PiaoBillInfo)this.getUIContext().get((Object)"bill");
        } else if (bill instanceof Map) {
            Map billMap = (Map)bill;
            PiaoBillInfo piaoInfo = new PiaoBillInfo();
            piaoInfo.setId(billMap.get("id") + "").setNumber(billMap.get("number") + "").setCreatorId(billMap.get("creatorId") + "").setCompanyId(billMap.get("companyId") + "");
            baseInfo = piaoInfo;
        } else {
            logger.error((Object)"\u53c2\u6570 bill \u9519\u8bef");
            MsgBox.showError((String)"\u53c2\u6570 bill \u9519\u8bef");
            SysUtil.abort();
        }
        HashMap spareMap = new HashMap(10);
        Map returnObject = PiaoFacadeFactory.getRemoteInstance().getUserKey(baseInfo, spareMap);
        String userKeyJson = (String)returnObject.get("userKeyJson");
        String userkey = JSONObject.parseObject((String)userKeyJson).getJSONObject("data").get((Object)"userKey").toString();
        if ("selectCloudInvoice".equals(actionType)) {
            this.selectCloudInvoiceHandler(userkey, baseInfo);
        } else if ("showCloudInvoice".equals(actionType)) {
            this.showCloudInvoiceHandler(userkey);
        }
    }

    private void selectCloudInvoiceHandler(String userKey, PiaoBillInfo baseInfo) throws Exception {
        this.viewAddress.setVisible(false);
        this.viewAddress.setEnabled(false);
        String uuid = UUID.randomUUID().toString();
        uuid = uuid.replace("-", "");
        HashMap spareMap = new HashMap(10);
        Map baseInvoiceUrl = PiaoFacadeFactory.getRemoteInstance().getBaseInvoiceUrl(spareMap);
        String invoiceUrl = (String)baseInvoiceUrl.get("invoiceUrl");
        String apiPiaoZone = (String)baseInvoiceUrl.get("apiPiaoZone");
        this.buildLongLink(apiPiaoZone, uuid);
        this.url = invoiceUrl + "/m4-web/fpzs/index?userKey=" + userKey + "&linkKey=" + uuid + "&optMode=1&gridParam=1100&sourceType=polling";
        logger.error((Object)("\u5355\u636e\uff1a" + baseInfo.getNumber() + "\u9009\u62e9\u53d1\u7968\u7684url\u662f\uff1a" + this.url));
        this.browser.navigate(this.url);
    }

    private void buildLongLink(String apiPiaoZone, String uuid) throws Exception {
        HashMap spareMap = new HashMap(10);
        Map returnObject = PiaoFacadeFactory.getRemoteInstance().getAccessToken(baseInfo, spareMap);
        String token = (String)returnObject.get("token");
        this.pollingInvoiceInfo(token, uuid, apiPiaoZone);
    }

    private void pollingInvoiceInfo(String token, String linkKey, String apiPiaoZone) throws EASBizException, BOSException, Exception {
        tokenStr = token;
        keyStr = linkKey;
        apiPiaoZoneUrl = apiPiaoZone;
        this.invoiceRecThread = new Thread(new Runnable(){

            @Override
            public synchronized void run() {
                PwyMessage message = new PwyMessage();
                message.setMessageListener(new PwyMessageListener(){

                    @Override
                    public void handleEvent(PwyMessageEvent message) {
                        System.out.println("\u6d88\u606f:" + message.getResult());
                        JSONObject returnData = JSONObject.parseObject((String)message.getResult());
                        if ("0000".equals(returnData.get((Object)"errcode").toString()) && returnData.get((Object)"data") != null) {
                            JSONObject invoiceData = returnData.getJSONObject("data").getJSONObject("data").getJSONObject("data");
                            try {
                                System.out.println("\u6d88\u606f:" + invoiceData);
                                InvoiceBillViewUI.this.invoiceHandler(invoiceData);
                            }
                            catch (Exception e) {
                                InvoiceBillViewUI.this.handleException(e);
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                            if (null != connectUtil) {
                                connectUtil.closeConnect();
                            }
                            InvoiceBillViewUI.this.closeCurrWindow();
                            InvoiceBillViewUI.this.invoiceRecThread.interrupt();
                        }
                    }
                });
                connectUtil = new PwyConnectUtil(message);
                try {
                    connectUtil.receiveMessage(apiPiaoZoneUrl, tokenStr, keyStr);
                }
                catch (Exception e) {
                    if (null != connectUtil) {
                        connectUtil.closeConnect();
                    }
                    InvoiceBillViewUI.this.handleException(e);
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        });
        this.invoiceRecThread.start();
    }

    private void closeCurrWindow() {
        this.getUIWindow().close();
    }

    private void invoiceHandler(JSONObject piaoData) throws EASBizException, BOSException {
        try {
            PiaoFacadeFactory.getRemoteInstance().saveTicketBill(baseInfo, null);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void showCloudInvoiceHandler(String userKey) throws EASBizException, BOSException {
        this.actionSelected.setVisible(false);
        this.actionSelected.setEnabled(false);
        this.viewAddress.setVisible(true);
        this.viewAddress.setEnabled(true);
        HashMap spareMap = new HashMap(10);
        Map baseInvoiceUrl = PiaoFacadeFactory.getRemoteInstance().getBaseInvoiceUrl(spareMap);
        String invoiceUrl = (String)baseInvoiceUrl.get("invoiceUrl");
        this.url = invoiceUrl + "/m4-web/fpzs/expense/invoice/list?userKey=" + userKey;
        logger.error((Object)("\u5355\u636e\uff1a" + baseInfo.getNumber() + "\u67e5\u770b\u53d1\u7968\u7684url\u662f\uff1a" + this.url));
        this.browser.navigate(this.url);
    }

    @Override
    public void actionViewAddress_actionPerformed(ActionEvent e) throws Exception {
        MsgBox.showDetailAndOK((Component)((Object)this), (String)"\u67e5\u770b\u53d1\u7968\u5730\u5740", (String)this.url, (int)1);
    }

    static {
        baseInfo = null;
    }
}

