/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.client;

import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.NSPanelComponent;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.ReflectUtil;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.eas.util.AbortException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;

public class SWTSwitchUtil {
    private static final String[] SWT_KEYS = new String[]{"org/eclipse/swt/browser"};
    private static final String[] SWT_X86_JAR_PATH = new String[]{"/lib/common/trd/swt-3.6M3-win32-win32-x86.jar", "/lib/client/trd/org.eclipse.swt.win32.win32.x86_3.3.0.v3346.jar", "/lib/common/trd/org.eclipse.swt.win32.win32.x86-4.3.jar"};
    private static final String[] SWT_X64_JAR_PATH = new String[]{"/lib/common/trd/swt-3.6M3-win32-win32-i64.jar", "/lib/client/trd/org.eclipse.swt.win32.win32.i64_3.3.0.v3346.jar", "/lib/common/trd/swt-3.6M3-win32-win32-i64.jar"};
    private static final String ALERT_IE_VERSION_JS = "var sysObj = {};var browserInfo = navigator.userAgent.toLowerCase();var regular = /(msie|firefox|chrome|opera|version).*?([\\d.]+)/;var vsMsg = browserInfo.match(regular);sysObj.browserName = vsMsg[1].replace(/version/, \"'safari\");sysObj.versionInfo = vsMsg[2];if(sysObj.browserName === 'msie' && sysObj.versionInfo.substr(0,2) <= 8) {alert('\u5f53\u524dIE\u6d4f\u89c8\u5668\u7248\u672c\u8fc7\u4f4e\u8bf7\u5347\u7ea7\u5230IE9\u4ee5\u4e0a\u7248\u672c\u83b7\u5f97\u66f4\u597d\u4f53\u9a8c\u3002');}";

    private SWTSwitchUtil() {
    }

    public static boolean isUsing64SWTLib() {
        try {
            Class<?> cls = Class.forName("org.eclipse.swt.internal.Library");
            Constructor<?> constructor = cls.getConstructor(new Class[0]);
            Object object = constructor.newInstance(new Object[0]);
            Field filed = cls.getDeclaredField("IS_64");
            ReflectUtil.makeAccessible((Field)filed);
            return filed.getBoolean(object);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean switchSWTLib(String detail, boolean isShowTip, boolean change2Win64) {
        boolean isYes;
        if (isShowTip && !(isYes = MessageUtil.msgboxYesNo(null, (Object)("\u5f53\u524d\u73af\u5883" + (change2Win64 ? "\uff0832bit SWT\uff09" : "\uff0864bit SWT\uff09") + "\u65e0\u6cd5\u4f7f\u7528\u8be5\u529f\u80fd, \u662f\u5426\u8fdb\u884c\u5207\u6362\uff1f\n\u9009\u62e9\u3010\u662f\u3011\u5c06\u4f1a\u81ea\u52a8\u5207\u6362, \u4e0b\u6b21\u542f\u52a8\u5ba2\u6237\u7aef\u751f\u6548"), (String)detail))) {
            return true;
        }
        String easHome = System.getProperty("EAS_HOME");
        String filePath = easHome + "/client/classloader/pkmap.lst";
        FileReader reader = null;
        Writer writer = null;
        try {
            reader = new FileReader(filePath);
            Properties properties = new Properties();
            properties.load(reader);
            ((Reader)reader).close();
            String path = properties.getProperty(SWT_KEYS[0]);
            String replacePath = null;
            boolean isCurrent32Value = true;
            int index = -1;
            if (change2Win64 && -1 != (index = SWTSwitchUtil.matchStringIndex(SWT_X86_JAR_PATH, path))) {
                replacePath = SWT_X64_JAR_PATH[index];
            } else if (!change2Win64 && -1 != (index = SWTSwitchUtil.matchStringIndex(SWT_X64_JAR_PATH, path))) {
                isCurrent32Value = false;
                replacePath = SWT_X86_JAR_PATH[index];
            }
            if (null != replacePath) {
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String classPath = (String)entry.getValue();
                    String needReplacePath = SWTSwitchUtil.getCurrentSWTPath(classPath, isCurrent32Value, SWT_X86_JAR_PATH[index], SWT_X64_JAR_PATH[index]);
                    if (null == needReplacePath) continue;
                    classPath = classPath.replace(needReplacePath, replacePath);
                    entry.setValue(classPath);
                }
                writer = new FileWriter(filePath);
                properties.store(writer, "change swt platfrom to " + (change2Win64 ? "x64" : "x86"));
            }
            properties.clear();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != reader) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != writer) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public static void switchSWTLibSilently() {
        if (SWTSwitchUtil.is64BitJVM() && !SWTSwitchUtil.isUsing64SWTLib()) {
            SWTSwitchUtil.switchSWTLib(null, false, true);
        } else if (!SWTSwitchUtil.is64BitJVM() && SWTSwitchUtil.isUsing64SWTLib()) {
            SWTSwitchUtil.switchSWTLib(null, false, false);
        }
    }

    public static void switchSWTLib(boolean isShowInfo, boolean isAbort) {
        if (isShowInfo && !CtrlUtil.isWinOS()) {
            MessageUtil.msgboxInfo(null, (String)("\u5f53\u524d" + CtrlUtil.getOSName() + "\u7cfb\u7edf\u4e0d\u652f\u6301\u90e8\u5206\u529f\u80fd\uff1a\u9ad8\u7ea7\u56fe\u8868\u3001\u8f7b\u5206\u6790\u3001\u4e91\u62a5\u8868\u4e2d\u5fc3\u3002"));
            if (isAbort) {
                throw new AbortException();
            }
        }
        SWTSwitchUtil.switchSWTLibSilently();
    }

    private static String getCurrentSWTPath(String currentPath, boolean is32Plathform, String x86SWTPath, String x64SWTPath) {
        if (is32Plathform && currentPath.contains(x86SWTPath)) {
            return x86SWTPath;
        }
        if (!is32Plathform && currentPath.contains(x64SWTPath)) {
            return x64SWTPath;
        }
        return null;
    }

    private static int matchStringIndex(String[] keywords, String key) {
        if (null != keywords) {
            for (int i = 0; i < keywords.length; ++i) {
                if (key.indexOf(keywords[i]) == -1) continue;
                return i;
            }
        }
        return -1;
    }

    public static final String getAlertIEJS() {
        return ALERT_IE_VERSION_JS;
    }

    public static final boolean is64BitJVM() {
        String prop = System.getProperty("sun.arch.data.model");
        if (null == prop) {
            prop = System.getProperty("com.ibm.vm.bitmode");
        }
        return "64".equals(prop);
    }

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static boolean isWinOS() {
        return SWTSwitchUtil.getOSName().startsWith("Win");
    }

    public static boolean isLinuxOS() {
        return SWTSwitchUtil.getOSName().equals("Linux");
    }

    public static final NSOption[] getNSOptions() {
        if (SWTSwitchUtil.is64BitJVM()) {
            if (SWTSwitchUtil.isWinOS()) {
                return new NSOption[]{NSPanelComponent.destroyOnFinalization(), NSPanelComponent.constrainVisibility()};
            }
            if (SWTSwitchUtil.isLinuxOS()) {
                return new NSOption[]{JWebBrowser.useXULRunnerRuntime(), NSPanelComponent.destroyOnFinalization(), NSPanelComponent.constrainVisibility()};
            }
        }
        return new NSOption[]{JWebBrowser.useWebkitRuntime(), NSPanelComponent.destroyOnFinalization(), NSPanelComponent.constrainVisibility()};
    }
}

