/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.image.helper;

import com.siit.image.wscommon.obj.base.Params;
import com.siit.image.wscommon.obj.base.Safety;
import com.siit.image.wscommon.obj.base.Serverbody;
import com.siit.image.wscommon.obj.base.Service;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class ObjToXmlSiit {
    public static String toXml(Params params) throws Exception {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("params");
        Element safetyElement = root.addElement("safety");
        Safety safety = params.getSafety();
        safetyElement.addElement("clientcode").setText(safety.getClientcode());
        safetyElement.addElement("servicecode").setText(safety.getServicecode());
        safetyElement.addElement("time").setText(safety.getTime());
        safetyElement.addElement("ticket").setText(safety.getTicket());
        Element serverbodyElement = root.addElement("serverbody");
        Serverbody serverbody = params.getServerbody();
        serverbodyElement.addElement("servername").setText(serverbody.getServername());
        serverbodyElement.addElement("servertype").setText(serverbody.getServertype());
        Element servicesElement = serverbodyElement.addElement("services");
        List serviceList = serverbody.getServices();
        ObjToXmlSiit.reflectXml(servicesElement, serviceList);
        OutputFormat format = OutputFormat.createCompactFormat();
        StringWriter writer = new StringWriter();
        XMLWriter output = new XMLWriter((Writer)writer, format);
        try {
            output.write(doc);
            writer.close();
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return writer.toString();
    }

    private static void reflectXml(Element servernameElement, List serviceList) {
        if (serviceList == null || serviceList.size() <= 0) {
            return;
        }
        for (Service service : serviceList) {
            Element serviceElement = servernameElement.addElement("service");
            Field[] fields = service.getClass().getFields();
            for (int i = 0; i < fields.length; ++i) {
                String fieldName = fields[i].getName();
                try {
                    Object fieldValue = fields[i].get(service);
                    if (fieldValue != null) {
                        serviceElement.addElement(fieldName).setText(fieldValue.toString());
                        continue;
                    }
                    serviceElement.addElement(fieldName).setText("");
                    continue;
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

