/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.common.url.service.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaToken;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;

public class UrlServiceUtil {
    public static void invokeSetPropertyMethod(Object instance, String propName, String propVal) {
        if (instance == null) {
            throw new NullPointerException("instance can not be null!");
        }
        Method method = null;
        try {
            method = instance.getClass().getMethod(UrlServiceUtil.constructPropMethodName(propName), String.class);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        try {
            method.invoke(instance, propVal);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static String constructPropMethodName(String propName) {
        String prefix = propName.substring(0, 1);
        String suffix = propName.substring(1, propName.length());
        return "set" + prefix.toUpperCase() + suffix;
    }

    public static Object initBindBean(Class beanClass) {
        try {
            return beanClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static URL doForUrlCtrlService(String className, URL url, String serviceID, Context ctx) throws SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, InvocationTargetException {
        Class<?> cls = Class.forName(className);
        Method method = cls.getMethod("urlTransformService", URL.class, String.class, Context.class);
        Object obj = cls.newInstance();
        Object result = method.invoke(obj, url, serviceID, ctx);
        return (URL)result;
    }

    public static String getDsessionID(Context ctx) {
        String username = ctx.getUserName();
        String tempStr = System.getProperty("portal.config");
        int index = tempStr.lastIndexOf("/");
        String fileFullPath = tempStr.substring(0, index + 1) + "LtpaToken.properties";
        LtpaToken token = LtpaTokenManager.generate((String)username, (String)fileFullPath);
        return token.toString();
    }

    public static String constructCtrlUrl(String serviceID, String url, String portalContextPath) {
        String result = "";
        String servletPath = portalContextPath + "/UrlServiceServlet?";
        if (serviceID == null || serviceID.equals("")) {
            serviceID = UrlServiceUtil.getDefaultServiceID();
        }
        String redirectTo = "";
        if (url.indexOf("http://") == -1 && url.indexOf("https://") == -1 && url.indexOf("ftp://") == -1 && url.indexOf("mailto:") == -1) {
            redirectTo = "redirectTo=http://" + url;
            result = servletPath + "serviceID=" + serviceID + "&" + redirectTo;
        } else if (url.indexOf("ftp://") >= 0 || url.indexOf("mailto:") >= 0) {
            result = url;
        } else {
            redirectTo = "redirectTo=" + url;
            result = servletPath + "serviceID=" + serviceID + "&" + redirectTo;
        }
        return result;
    }

    private static String getDefaultServiceID() {
        return "urlCtrl";
    }
}

