/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.common.url.service.web;

import com.kingdee.bos.Context;
import com.kingdee.eas.cp.common.url.service.config.ConfigFileMrg;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UrlServiceServlet
extends HttpServlet {
    private static final long serialVersionUID = -4600178052502460186L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String urlStr = req.getParameter("redirectTo");
        URL url = null;
        url = urlStr.equals("/") ? new URL(this.getDefaultURL(req), urlStr) : this.extractParamURL(req.getQueryString());
        String serviceID = req.getParameter("serviceID");
        String fileName = req.getParameter("fileName");
        Context ctx = WebContextUtil.getEasContext(req);
        ConfigFileMrg cfm = new ConfigFileMrg(url, serviceID, ctx);
        URL newUrl = null;
        try {
            newUrl = cfm.processConfigFile(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        resp.sendRedirect(newUrl.toString());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private URL getDefaultURL(HttpServletRequest req) throws MalformedURLException {
        String protocal = req.getScheme();
        String serverIP = req.getServerName();
        int port = req.getServerPort();
        return new URL(protocal + "://" + serverIP + ":" + port);
    }

    private URL extractParamURL(String query) throws MalformedURLException {
        if (query.startsWith("redirectTo")) {
            int lastIndex = query.indexOf("&serviceID");
            int beginIndex = query.indexOf("http");
            return new URL(query.substring(beginIndex, lastIndex));
        }
        int beginIndex = query.indexOf("http");
        return new URL(query.substring(beginIndex));
    }
}

